<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$module_path         = $args['module_path'] ?? '';
$address             = $args['address'] ?? [];
$address_type        = $args['address_type'] ?? '';
$countries           = $args['countries'] ?? [];
$default_country_iso = $args['default_country_iso'] ?? '';
$img_url             = simplyin()->get_plugin_url() . 'public/img/';

?>
<div class="simplyin-popup-overlay"></div>
<div class="simplyin-popup">
	<div class="simplyin-popup-header">
		<img src="<?php echo esc_url( $img_url . 'logo_smalln.svg' ); ?>"
			 width="32" height="32">
		<span class="popup-add-address-label-header">
			<?php echo $address_type === 'shippingAddresses' ? esc_html( __( 'Delivery details',
				'simplyin' ) ) : esc_html( __( 'Billing details',
				'simplyin' ) ); ?>
		</span>
		<div class="simplyin-popup-close-button">
			<img src="<?php echo esc_url( $img_url . 'close_icon.svg' ); ?>"
				 width="20" height="21">
		</div>
	</div>
	<div class="simplyin-popup-container">
		<form class="simplyin-popup-addres-form" method="post"
			  action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>">
			<div class="simplyin-popup-content">
				<?php wp_nonce_field( 'simplyin_ajax', 'ajax_token' ); ?>
				<input type="hidden" name="action"
					   value="simplyin_submit_address">
				<input type="hidden" name="_id"
					   value="<?php echo esc_attr( $address['_id'] ?? '' ); ?>">
				<input type="hidden" name="address_type"
					   value="<?php echo esc_attr( $address_type ); ?>">
				<div class="form-row">
					<div class="form-group">
						<input required type="text" id="first-name" name="name"
							   value="<?php echo esc_attr( $address['name'] ?? '' ); ?>"
							   placeholder="<?php esc_attr_e( 'First name',
								   'simplyin' ); ?>">
						<div
							class="error-message"><?php esc_html_e( 'First name is required',
								'simplyin' ); ?></div>
					</div>
					<div class="form-group">
						<input required type="text" id="last-name"
							   name="surname"
							   value="<?php echo esc_attr( $address['surname'] ?? '' ); ?>"
							   placeholder="<?php esc_attr_e( 'Last name',
								   'simplyin' ); ?>">
						<div
							class="error-message"><?php esc_html_e( 'Last name is required',
								'simplyin' ); ?></div>
					</div>
				</div>
				<div class="form-group">
					<input required type="text" id="street" name="street"
						   value="<?php echo esc_attr( $address['street'] ?? '' ); ?>"
						   placeholder="<?php esc_attr_e( 'Street and house number',
							   'simplyin' ); ?>">
					<div
						class="error-message"><?php esc_html_e( 'Street is required',
							'simplyin' ); ?></div>
				</div>
				<div class="form-group">
					<input type="text" id="apartment" name="appartmentNumber"
						   value="<?php echo esc_attr( $address['appartmentNumber'] ?? '' ); ?>"
						   placeholder="<?php esc_attr_e( 'Apartment number (optional)',
							   'simplyin' ); ?>">
				</div>
				<div class="form-row">
					<div class="form-group">
						<input required type="text" id="postalCode"
							   name="postalCode"
							   value="<?php echo esc_attr( $address['postalCode'] ?? '' ); ?>"
							   placeholder="<?php esc_attr_e( 'Postal code',
								   'simplyin' ); ?>">
						<div
							class="error-message"><?php esc_html_e( 'Postal code is required',
								'simplyin' ); ?></div>
					</div>
					<div class="form-group">
						<input required type="text" id="city" name="city"
							   value="<?php echo esc_attr( $address['city'] ?? '' ); ?>"
							   placeholder="<?php esc_attr_e( 'City',
								   'simplyin' ); ?>">
						<div
							class="error-message"><?php esc_html_e( 'City is required',
								'simplyin' ); ?></div>
					</div>
				</div>
				<div class="form-group">
					<select id="country" name="country" autocomplete="country">
						<option value="" disabled
								selected><?php esc_html_e( 'Country',
								'simplyin' ); ?></option>
						<?php foreach ( $countries as $code => $name ) : ?>
							<option
								value="<?php echo esc_attr( $code ); ?>" <?php selected( $address['country'] ?? $default_country_iso,
								$code ); ?>>
								<?php echo esc_html( $name ); ?>
							</option>
						<?php endforeach; ?>
					</select>
				</div>
				<div
					class="pickup-details-header"><?php esc_html_e( 'Company details (optional)',
						'simplyin' ); ?></div>
				<div class="form-group">
					<input type="text" id="taxId" name="taxId"
						   value="<?php echo esc_attr( $address['taxId'] ?? '' ); ?>"
						   placeholder="<?php esc_attr_e( 'Tax ID (optional)',
							   'simplyin' ); ?>">
					<div class="error-message"></div>
				</div>
				<div class="form-group">
					<input type="text" id="company" name="companyName"
						   value="<?php echo esc_attr( $address['companyName'] ?? '' ); ?>"
						   placeholder="<?php esc_attr_e( 'Company name (optional)',
							   'simplyin' ); ?>">
				</div>
				<div
					class="pickup-details-header"><?php esc_html_e( 'Address name',
						'simplyin' ); ?></div>
				<div
					class="pickup-details-description"><?php esc_html_e( 'A personalised name will help you find or associate the address on your list more quickly.',
						'simplyin' ); ?></div>
				<div class="form-group">
					<input type="text" id="addressName" name="addressName"
						   value="<?php echo esc_attr( $address['addressName'] ?? '' ); ?>"
						   placeholder="<?php esc_attr_e( 'Address name',
							   'simplyin' ); ?>">
					<div class="error-message"></div>
				</div>
			</div>
			<div
				class="popup-buttons-footer popup-buttons-footer-add-addres">
				<button type="button"
						class="popup-button simplyin-cancel"><?php esc_html_e( 'Cancel',
						'simplyin' ); ?></button>
				<button type="submit" class="popup-button simplyin-submit">
					<?php echo esc_html( empty( $address['_id'] ) ? __( 'Add',
						'simplyin' ) : __( 'Save', 'simplyin' ) ); ?>
				</button>
			</div>
		</form>
	</div>
</div>
