<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$billing_addresses = $args['billing_addresses'] ?? [];
$shipping_addresses = $args['shipping_addresses'] ?? [];
$parcel_lockers = $args['parcel_lockers'] ?? [];
$carriers_cost = $args['carriers_cost'] ?? [];
$service_type = $args['service_type'] ?? false;
$delivery_address = $args['delivery_address'] ?? '';
$billing_address = $args['billing_address'] ?? '';
$img_url = simplyin()->get_plugin_url() . 'public/img';
?>
<div class="simplyin-popup-overlay"></div>
<div class="simplyin-popup">
	<div class="simplyin-popup-header">
		<img width="32" height="32"
			 src="<?php echo esc_url( "$img_url/logo_smalln.svg" ); ?>"
			 alt="SimplyIn">
		<div class="popup-header-strong">
			<?php echo esc_html__( 'Choose your data', 'simplyin' ); ?>
		</div>
		<div class="simplyin-popup-close-button">
			<img width="24" height="24"
				 src="<?php echo esc_url( "$img_url/close_icon.svg" ); ?>?v=1"
				 alt="<?php esc_attr_e( 'Close', 'simplyin' ); ?>">
		</div>
	</div>
	<div class="simplyin-popup-container">
		<div class="simplyin-popup-content">
			<div class="popup-address-label-header">
				<span><?php echo esc_html__( 'Billing', 'simplyin' ); ?></span>
				<button type="button" class="popup-address-actions-add"
						data-type="billingAddresses">
					<img width="18" height="18"
						 src="<?php echo esc_url( "$img_url/add_icon.svg" ); ?>?v=1"
						 alt="+">
					<div
						class="popup-address-actions-label"><?php echo esc_html__( 'Add new address',
							'simplyin' ); ?></div>
				</button>
				<span class="popup-button-expand expanded"
					  data-target="popup-invoice-address">
					<button type="button">
						<img width="24" height="24"
							 src="<?php echo esc_url( "$img_url/expand_icon.svg" ); ?>"
							 alt="<?php esc_attr_e( 'Toggle', 'simplyin' ); ?>">
						<span class="popup-muitouch-ripple-root"></span>
					</button>
				</span>
			</div>

			<div id="popup-invoice-address" class="popup-address-selector"
				 data-edit="1" data-delete="1" data-force-delete="0">
				<?php if ( $billing_addresses ) : ?>
					<?php foreach ( $billing_addresses as $address ) : ?>
						<?php if ( ! empty( $address['selected'] ) ) : ?>
							<div class="popup-selected-address-group">
								<div class="popup-selected-address">
									<span
										class="popup-selected-address-line-1"><?php echo esc_html( $address['addressName'] ); ?></span>
									<span
										class="popup-selected-address-line-2"><?php echo esc_html( $address['street'] ); ?><?php if ( $address['appartmentNumber'] ) {
											echo '/' . esc_html( $address['appartmentNumber'] );
										} ?>, <?php echo esc_html( $address['city'] ); ?></span>
								</div>
							</div>
						<?php endif; ?>
					<?php endforeach; ?>

					<?php foreach ( $billing_addresses as $address ) : ?>
						<div
							class="popup-address-select-group popup-address-select-group-invoice">
							<div class="popup-address-select"
								 data-id="<?php echo esc_attr( $address['_id'] ); ?>">
								<label class="popup-address-select-label-group">
									<span class="popup-address-checkbox">
										<input type="radio"
											   name="simplyin-invoice-address"
											   data-id="<?php echo esc_attr( $address['_id'] ); ?>"
											   data-address-1="<?php echo esc_attr( $address['addressName'] ); ?>"
											   data-address-2="<?php echo esc_attr( $address['street'] . ( $address['appartmentNumber'] ? '/' . $address['appartmentNumber'] : '' ) . ', ' . $address['city'] ); ?>"
										       <?php checked( ! empty( $address['selected'] ) ); ?>>
									</span>
									<span class="popup-image-max-width">
										<span
											class="icon"><?php echo wp_kses_post( $address['icon'] ); ?></span>
									</span>
									<span class="popup-address-label">
										<span
											class="popup-address-label-line-1"><?php echo esc_html( $address['addressName'] ); ?></span>
										<span
											class="popup-address-label-line-2"><?php echo esc_html( $address['street'] ); ?><?php if ( $address['appartmentNumber'] ) {
												echo '/' . esc_html( $address['appartmentNumber'] );
											} ?>, <?php echo esc_html( $address['city'] ); ?></span>
									</span>
								</label>
								<span class="popup-address-actions">
									<img width="24" height="24"
										 src="<?php echo esc_url( "$img_url/dots_icon.svg" ); ?>"
										 alt="<?php esc_attr_e( 'Edit',
											 'simplyin' ); ?>">
								</span>
							</div>
						</div>
					<?php endforeach; ?>
				<?php endif; ?>
			</div>

			<div class="popup-address-label-header to-hide-1">
				<span><?php echo esc_html__( 'Delivery', 'simplyin' ); ?></span>
			</div>

			<div class="popup-address-selector popup-type-delivery-selector">
				<div class="popup-address-select-group">
					<div class="popup-address-select">
						<label class="popup-address-select-label-group">
							<span class="popup-address-checkbox">
								<input type="radio"
									   name="simplyin-delivery-type"
									   class="simplyin-delivery-type"
									   value="address" <?php checked( $service_type === false ); ?>>
							</span>
							<span class="popup-address-label">
								<span
									class="popup-address-label-line-3"><?php echo esc_html__( 'Courier',
										'simplyin' ); ?> <span
										id="simplyin-delivery-type-address"></span></span>
                                <span
									class="popup-address-label-line-4"><?php esc_html_e( 'Delivery to your door',
										'simplyin' ); ?></span>
							</span>
						</label>
					</div>

					<div class="popup-address-select popup-address-select-parcel-locker">
						<label class="popup-address-select-label-group">
							<span class="popup-address-checkbox">
								<input type="radio"
									   name="simplyin-delivery-type"
									   class="simplyin-delivery-type"
									   value="parcel_locker" <?php checked( $service_type !== false ); ?>>
							</span>
							<span class="popup-address-label">
								<span
									class="popup-address-label-line-3"
									id="simplyin-delivery-type-parcel-locker"><?php echo esc_html__( 'Delivery to a parcel locker',
										'simplyin' ); ?></span>
                                <span
									class="popup-address-label-line-4"><?php esc_html_e( 'or pickup point',
										'simplyin' ); ?></span>
							</span>
						</label>
					</div>
				</div>
			</div>

			<div class="popup-delivery-address-box"
				 style="display: <?php echo esc_attr( $service_type === false ? 'block' : 'none' ); ?>;">
				<div class="popup-address-label-header to-hide-2">
					<span><?php esc_html_e( 'Delivery data',
							'simplyin' ); ?></span>
					<span
						class="popup-button-expand<?php echo $delivery_address !== $billing_address ? ' expanded' : ''; ?>"
						data-target="popup-delivery-address">
						<button type="button">
                            <img width="24" height="24"
								 src="<?php echo esc_url( "$img_url/expand_icon.svg" ); ?>"
								 alt="<?php esc_attr_e( 'Toggle',
									 'simplyin' ); ?>">
							<span class="popup-muitouch-ripple-root"></span>
						</button>
					</span>
				</div>

				<div id="popup-delivery-address" class="popup-address-selector"
					 data-edit="1" data-delete="1" data-force-delete="0">
					<div class="popup-address-checkbox">
						<label id="simplyin-the-same-address"
							   class="popup-address-select-label-group"
							   data-target="popup-delivery-address">
							<span class="popup-address-checkbox">
								<input
									type="checkbox" checked>
							</span>
							<span
								class="popup-address-checkbox-label"><?php echo esc_html__( 'Billing data is the same as delivery data',
									'simplyin' ); ?></span>
						</label>
					</div>

					<div class="popup-selected-address-group">
						<?php foreach ( $shipping_addresses as $address ) : ?>
							<?php if ( ! empty( $address['selected'] ) ) : ?>
								<div class="popup-selected-address">
									<span
										class="popup-selected-address-line-1"><?php echo esc_html( $address['addressName'] ); ?></span>
									<span
										class="popup-selected-address-line-2"><?php echo esc_html( $address['street'] ); ?><?php if ( $address['appartmentNumber'] ) {
											echo '/' . esc_html( $address['appartmentNumber'] );
										} ?>, <?php echo esc_html( $address['city'] ); ?></span>
								</div>
							<?php endif; ?>
						<?php endforeach; ?>
					</div>

					<div class="popup-address-select-group"
						 style="display: <?php echo esc_attr( $delivery_address !== $billing_address ? 'block' : 'none' ); ?>;">
						<?php foreach ( $shipping_addresses as $address ) : ?>
							<div class="popup-address-select"
								 data-id="<?php echo esc_attr( $address['_id'] ); ?>">
								<label class="popup-address-select-label-group">
									<span class="popup-address-checkbox">
										<input type="radio"
											   name="simplyin-delivery-address"
											   data-id="<?php echo esc_attr( $address['_id'] ); ?>"
											   data-address-1="<?php echo esc_attr( $address['addressName'] ); ?>"
											   data-address-2="<?php echo esc_attr( $address['street'] . ( $address['appartmentNumber'] ? '/' . $address['appartmentNumber'] : '' ) . ', ' . $address['city'] ); ?>"
										       <?php checked( ! empty( $address['selected'] ) ); ?>>
									</span>
									<span class="popup-image-max-width">
										<span
											class="icon"><?php echo wp_kses_post( $address['icon'] ); ?></span>
									</span>
									<span class="popup-address-label">
										<span
											class="popup-address-label-line-1"><?php echo esc_html( $address['addressName'] ); ?></span>
										<span
											class="popup-address-label-line-2"><?php echo esc_html( $address['street'] ); ?><?php if ( $address['appartmentNumber'] ) {
												echo '/' . esc_html( $address['appartmentNumber'] );
											} ?>, <?php echo esc_html( $address['city'] ); ?></span>
									</span>
								</label>
								<span class="popup-address-actions">
									<img width="24" height="24"
										 src="<?php echo esc_url( "$img_url/dots_icon.svg" ); ?>"
										 alt="<?php esc_attr_e( 'Edit',
											 'simplyin' ); ?>">
								</span>
							</div>
						<?php endforeach; ?>
					</div>

					<button type="button" class="popup-address-actions-add last"
							data-type="shippingAddresses">
						<img width="18" height="18"
							 src="<?php echo esc_url( "$img_url/add_icon.svg" ); ?>?v=1"
							 alt="+">
						<div
							class="popup-address-actions-label"><?php echo esc_html__( 'Add new address',
								'simplyin' ); ?></div>
					</button>
				</div>
			</div>

			<div class="popup-delivery-parcel-locker-box"
				 style="display: <?php echo esc_attr( $service_type !== false ? 'block' : 'none' ); ?>;">
				<div class="popup-address-label-header to-hide-3">
					<span><?php echo esc_html__( 'Choose a parcel locker or pickup point',
							'simplyin' ); ?></span>
					<span class="popup-button-expand expanded"
						  data-target="popup-delivery-parcel-locker-address">
                        <button type="button">
                            <img width="24" height="24"
								 src="<?php echo esc_url( "$img_url/expand_icon.svg" ); ?>"
								 alt="<?php esc_attr_e( 'Toggle',
									 'simplyin' ); ?>">
							<span class="popup-muitouch-ripple-root"></span>
						</button>
					</span>
				</div>

				<div class="popup-address-selector-header">
					<button type="button"
							class="<?php echo ( $service_type === 'parcel' || $service_type === false ) ? 'active' : ''; ?>"
							data-target="simplyin-parcel-lockers"><?php echo esc_html__( 'Parcel lockers',
							'simplyin' ); ?></button>
					<button type="button"
							class="<?php echo $service_type === 'delivery' ? 'active' : ''; ?>"
							data-target="simplyin-delivery-points"><?php echo esc_html__( 'Pickup points',
							'simplyin' ); ?></button>
				</div>

				<div id="popup-delivery-parcel-locker-address"
					 class="popup-address-selector" data-delete="1"
					 data-edit="0" data-force-delete="1">
					<?php foreach ( $parcel_lockers as $locker ) : ?>
						<?php if ( ! empty( $locker['selected'] ) ) : ?>
							<div class="popup-selected-address-group"
								 style="display:none;">
								<div class="popup-selected-address">
									<span class="popup-selected-address-line-1"><span
											class="popup-address-label-line-1"><?php echo esc_html( $locker['addressName'] ); ?></span></span>
								</div>
							</div>
							<?php break; ?>
						<?php endif; ?>
					<?php endforeach; ?>

					<div id="simplyin-parcel-lockers"
						 class="popup-address-select-group"
						 style="display: <?php echo esc_attr( ( $service_type === 'parcel' || $service_type === false ) ? 'block' : 'none' ); ?>;">
						<?php foreach ( $parcel_lockers as $locker ) : ?>
							<?php if ( $locker['service_type'] === 'parcel_machine' ) : ?>
								<div class="popup-address-select"
									 data-id="<?php echo esc_attr( $locker['_id'] ); ?>"
									 data-provider="<?php echo esc_attr( $locker['providerName'] ); ?>">
									<label
										class="popup-address-select-label-group">
										<span class="popup-address-checkbox">
											<input type="radio"
												   name="simplyin-parcel-locker-selected"
												   data-id="<?php echo esc_attr( $locker['_id'] ); ?>"
												   data-address-1="<?php echo esc_attr( $locker['addressName'] ); ?>"
											       <?php checked( ! empty( $locker['selected'] ) ); ?>>
										</span>
										<span class="popup-image-max-width"><img
												src="<?php echo esc_url( $locker['logoUrl'] ); ?>"
												alt="logo"></span>
										<span
											class="popup-address-label-max-width">
											<span
												class="popup-address-label-line-1"><?php echo esc_html( $locker['addressName'] ); ?></span>
											<span
												class="popup-address-label-line-2"><?php echo esc_html( $locker['address'] ); ?></span>
											<span class="popup-cost"></span>
										</span>
										<span class="popup-image-max-width"><div
												class="popup-icon"><?php echo wp_kses_post( $locker['icon'] ); ?></div></span>
									</label>
									<span class="popup-address-actions"><img
											width="24" height="24"
											src="<?php echo esc_url( "$img_url/dots_icon.svg" ); ?>"
											alt="<?php esc_attr_e( 'Edit',
												'simplyin' ); ?>"></span>
								</div>
							<?php endif; ?>
						<?php endforeach; ?>
					</div>

					<div id="simplyin-delivery-points"
						 class="popup-address-select-group"
						 style="display: <?php echo esc_attr( $service_type === 'delivery' ? 'block' : 'none' ); ?>;">
						<?php foreach ( $parcel_lockers as $locker ) : ?>
							<?php if ( $locker['service_type'] !== 'parcel_machine' ) : ?>
								<div class="popup-address-select"
									 data-id="<?php echo esc_attr( $locker['_id'] ); ?>"
									 data-provider="<?php echo esc_attr( $locker['providerName'] ); ?>">
									<label
										class="popup-address-select-label-group">
										<span class="popup-address-checkbox">
											<input type="radio"
												   name="simplyin-delivery-point-selected"
												   data-id="<?php echo esc_attr( $locker['_id'] ); ?>"
												   data-address-1="<?php echo esc_attr( $locker['addressName'] ); ?>"
											       <?php checked( ! empty( $locker['selected'] ) ); ?>>
										</span>
										<span class="popup-image-max-width"><img
												src="<?php echo esc_url( $locker['logoUrl'] ); ?>"
												alt="logo"></span>
										<span
											class="popup-address-label-max-width">
											<span
												class="popup-address-label-line-1"><?php echo esc_html( $locker['addressName'] ); ?></span>
											<span
												class="popup-address-label-line-2"><?php echo esc_html( $locker['address'] ); ?></span>
											<span class="popup-cost"></span>
										</span>
										<span class="popup-image-max-width"><div
												class="popup-icon"><?php echo wp_kses_post( $locker['icon'] ); ?></div></span>
									</label>
									<span class="popup-address-actions"><img
											width="24" height="24"
											src="<?php echo esc_url( "$img_url/dots_icon.svg" ); ?>"
											alt="<?php esc_attr_e( 'Edit',
												'simplyin' ); ?>"></span>
								</div>
							<?php endif; ?>
						<?php endforeach; ?>
					</div>
				</div>

				<button type="button" class="popup-address-actions-add last"
						data-type="parcel">
					<img width="18" height="18"
						 src="<?php echo esc_url( "$img_url/add_icon.svg" ); ?>?v=1"
						 alt="+">
					<div
						class="popup-address-actions-label"><?php echo esc_html__( 'Add',
							'simplyin' ); ?></div>
				</button>
			</div>
		</div>

		<div class="popup-buttons-footer">
			<button type="button"
					class="popup-select-address"><?php echo esc_html__( 'Select data',
					'simplyin' ); ?></button>
		</div>
	</div>
</div>
