<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
/** create_account.php */
if ( isset( $args ) && is_array( $args ) ) {
	extract( $args, EXTR_SKIP );
}
?>
<div class="form-row" style="float: unset;">
	<div id="simplyin-phone-checkbox">
		<div class="simplyin-checkbox-row <?php if ( $checked ) {
			echo 'show';
		} ?>">
			<label class="simplyin-checkbox">
				<input type="checkbox"
					   id="simply-save-checkbox" <?php echo( $checked ? 'checked' : '' ); ?>
					   name="simply-save-checkbox" class="ps-shown-by-js"/>
				<input type="hidden" name="simplyin_create_account_token"
					   value="<?php echo esc_attr( wp_create_nonce( 'simplyin_create_account_nonce' ) ) ?>">
				<span class="simplyin-checkbox-text">
					<strong><?php esc_html_e( 'Save your details to shop faster',
							'simplyin' ); ?></strong><span
						class="simplyin-badge-new"><?php esc_html_e( 'New',
							'simplyin' ); ?></span>
				</span>
			</label>
			<ul class="simplyin-benefits-list">
				<li><?php esc_html_e( 'Do you want to shop with one click in this and other stores?',
						'simplyin' ); ?></li>
				<li><?php esc_html_e( 'Are you looking for a way to track the status of your orders from one place?',
						'simplyin' ); ?></li>
				<li><?php esc_html_e( 'Do you want to conveniently manage your data?',
						'simplyin' ); ?></li>
			</ul>
		</div>
		<div class="simplyin-phone-input" <?php if ( ! $checked ) {
			echo 'style="display: none;"';
		} ?>>
			<div class="simplyin-logo">
				<img
					src="<?php echo esc_url( plugin_dir_url( __FILE__ ) . '../../../public/img/logo_medium.svg' ); ?>?v=1.0"
					alt="<?php esc_attr_e( 'Simply.IN', 'simplyin' ); ?>"/>
			</div>
			<div class="phone-input-container">
				<div class="phone-country-select">
					<select id="simplyin-phone-country"
							name="simplyin-phone-country"
							aria-label="<?php esc_attr_e( 'Select country',
								'simplyin' ); ?>">
						<?php foreach ( $countries as $country_item ) : ?>
							<option <?php if ( $country_item['dial_code'] == $selected_prefix ) {
								echo ' selected';
							} ?>
								value="<?php echo esc_attr( $country_item['code'] ); ?>"
								data-flag="<?php echo esc_attr( $country_item['code'] ); ?>"
								data-prefix="<?php echo esc_attr( $country_item['dial_code'] ); ?>">
								<?php echo esc_attr( $country_item['name'] ); ?>
							</option>
						<?php endforeach; ?>
					</select>
					<div class="simplyin-flag-display">
						<img
							src="<?php echo esc_url( plugin_dir_url( __FILE__ ) . '../../../public/img/poland.svg' ); ?>"
							alt="" width="24" height="16"/>
					</div>
					<span
						class="prefix"><?php echo esc_html( $selected_prefix ); ?></span>
				</div>
				<div class="phone-input">
					<input type="tel" id="simplyin-phone-input"
						   name="simplyin-phone"
						   placeholder="<?php esc_attr_e( 'Phone number',
							   'simplyin' ); ?>"
						   autocomplete="off"
						   value="<?php echo esc_attr( $phone ); ?>"/>
				</div>
				<input type="hidden" name="simplyin-phone-prefix"
					   value="<?php echo esc_attr( $selected_prefix ); ?>">
			</div>
			<div class="phone-input-warning"
				 data-invalid="<?php esc_attr_e( 'The phone number is invalid.',
					 'simplyin' ); ?>"
				 data-empty="<?php esc_attr_e( 'The phone number is required.',
					 'simplyin' ); ?>">
				<?php esc_html_e( 'The phone number is required.',
					'simplyin' ); ?>
			</div>
			<div class="simplyin-description">
				<svg width="20" height="20" viewBox="0 0 20 20" fill="none"
					 xmlns="http://www.w3.org/2000/svg">
					<path
						d="M10 17.5C14.1421 17.5 17.5 14.1421 17.5 10C17.5 5.85786 14.1421 2.5 10 2.5C5.85786 2.5 2.5 5.85786 2.5 10C2.5 14.1421 5.85786 17.5 10 17.5Z"
						fill="#2196F3"/>
					<path
						d="M10.0007 7.4974C10.5759 7.4974 11.0423 7.03103 11.0423 6.45573C11.0423 5.88043 10.5759 5.41406 10.0007 5.41406C9.42535 5.41406 8.95898 5.88043 8.95898 6.45573C8.95898 7.03103 9.42535 7.4974 10.0007 7.4974Z"
						fill="white"/>
					<path d="M9.16797 8.75H10.8346V14.5833H9.16797V8.75Z"
						  fill="white"/>
				</svg>
				<p>
					<?php esc_html_e( 'Next time you enter your email address in the cart, we will send you an SMS code for verification - after confirmation, the data will be filled in automatically.',
						'simplyin' ); ?>
				</p>
			</div>
		</div>
		<div class="simplyin-terms" <?php if ( ! $checked ) {
			echo 'style="display: none;"';
		} ?>>
			<div class="simplyin-terms-inner">
				<?php esc_html_e( 'By clicking the "Order" button or similar, I confirm that I have read and accept',
					'simplyin' ); ?> <a
					href="<?php echo esc_url( $terms_link ); ?>"
					target="_blank"><?php esc_html_e( 'Simply.IN Terms and Conditions',
						'simplyin' ); ?></a> <?php esc_html_e( 'Simply.IN is the administrator of your personal data. Read more in',
					'simplyin' ); ?> <a
					href="<?php echo esc_url( $privacy_link ); ?>"
					target="_blank"><?php esc_html_e( 'Privacy Policy',
						'simplyin' ); ?></a>.
			</div>
		</div>
	</div>
</div>
