<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>
<div class="simplyin-popup-overlay"></div>
<div class="simplyin-popup" id="simplyin-popup-confirmation-form">
	<div class="simplyin-popup-header">
		<img width="32" height="32"
			 src="<?php echo esc_url( simplyin()->get_plugin_url() . 'public/img/logo_smalln.svg' ); ?>"
			 alt="<?php esc_attr_e( 'SimplyIn', 'simplyin' ); ?>"/>
		<div class="popup-header-strong">
			<?php esc_html_e( 'Confirm it’s you', 'simplyin' ); ?>
		</div>
		<div class="simplyin-popup-close-button">
			<img width="20" height="21"
				 src="<?php echo esc_url( simplyin()->get_plugin_url() . 'public/img/close_icon.svg' ); ?>"
				 alt="<?php esc_attr_e( 'Close', 'simplyin' ); ?>"/>
		</div>
	</div>
	<div class="simplyin-popup-container">
		<div class="simplyin-popup-content">
			<div class="popup-caption">
				<?php echo esc_html__( "We've sent you a notification - accept it and the data will be filled in automatically.",
					'simplyin' ); ?>
			</div>
			<div class="simplyin-popup-divider"></div>
		</div>
		<div class="simplyin-popup-footer">
			<div class="popup-text popup-text-footer">
				<?php echo esc_html__( "Don't have access to the application?",
					'simplyin' ); ?>
			</div>
			<div class="popup-text popup-buttons">
				<button id="simplyin-button-send-sms">
					<?php esc_html_e( 'Send SMS code', 'simplyin' ); ?>
				</button>&nbsp;&nbsp; <?php esc_html_e( 'or', 'simplyin' ); ?>
				&nbsp;&nbsp;
				<button id="simplyin-button-send-email" value="mail">
					<?php esc_html_e( 'Send by email', 'simplyin' ); ?>
				</button>
			</div>
		</div>
	</div>
</div>
