<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
/**
 * @var string $message ;
 */

$message = $args['message'] ?? '';

?>

<div class="simplyin-popup-overlay"></div>
<div class="simplyin-popup">
	<div class="simplyin-popup-header">
		<img width="32" height="32"
			 src="<?php echo esc_url( simplyin()->get_plugin_url() . 'public/img/logo_smalln.svg' ); ?>"
			 alt="<?php esc_attr_e( 'SimplyIn', 'simplyin' ); ?>"/>
		<div
			class="popup-header-strong"><?php echo esc_html( __( 'Confirm it’s you',
				'simplyin' ) ); ?></div>
		<div class="simplyin-popup-close-button">
			<img width="24" height="24"
				 src="<?php echo esc_url( simplyin()->get_plugin_url() . 'public/img/close_icon.svg' ); ?>"
				 alt="<?php esc_attr_e( 'Close', 'simplyin' ); ?>"/>
		</div>
	</div>
	<div class="simplyin-popup-container">
		<div class="simplyin-popup-content mobile-pb-0">
			<div
				class="popup-caption custom-spaces"><?php echo wp_kses_post( nl2br( $message ) ); ?></div>
			<div class="popup-input-code">
				<div>
					<form id="simplyin-input-code">
						<div>
							<input
								aria-label="<?php echo esc_attr( __( 'Please enter verification code.',
										'simplyin' ) . ' ' . __( 'Digit',
										'simplyin' ) . ' 1' ); ?>"
								autocomplete="one-time-code" placeholder=""
								type="text"
								value="">
							<input
								aria-label="<?php echo esc_attr( __( 'Please enter verification code.',
										'simplyin' ) . ' ' . __( 'Digit',
										'simplyin' ) . ' 2' ); ?>"
								autocomplete="one-time-code" placeholder=""
								type="text"
								value="">
							<input
								aria-label="<?php echo esc_attr( __( 'Please enter verification code.',
										'simplyin' ) . ' ' . __( 'Digit',
										'simplyin' ) . ' 3' ); ?>"
								autocomplete="one-time-code" placeholder=""
								type="text"
								value="">
							<input
								aria-label="<?php echo esc_attr( __( 'Please enter verification code.',
										'simplyin' ) . ' ' . __( 'Digit',
										'simplyin' ) . ' 4' ); ?>"
								autocomplete="one-time-code" placeholder=""
								type="text"
								value="">
						</div>
					</form>
				</div>
			</div>
			<div
				class="code-error-message"><?php echo esc_html( __( 'Incorrect verification code',
					'simplyin' ) ); ?></div>
		</div>
		<div class="simplyin-popup-footer">
			<div class="sent-messages">
				<span><?php echo esc_html( __( 'The code has been resent',
						'simplyin' ) ); ?></span>
				<span class="time">00:30</span>
			</div>
			<div class="buttons">
				<div
					class="popup-text popup-text-footer popup-text-footer-code"><?php echo esc_html( __( 'Didn’t receive the code?',
						'simplyin' ) ); ?></div>
				<div class="popup-text popup-buttons">
					<button
						id="simplyin-button-send-sms"><?php esc_attr_e( 'Send SMS',
							'simplyin' ); ?></button>
					&nbsp;&nbsp; <?php esc_html_e( 'or', 'simplyin' ); ?> &nbsp;&nbsp;
					<button
						id="simplyin-button-send-email"><?php esc_attr_e( 'Send Email',
							'simplyin' ); ?></button>
				</div>
			</div>
		</div>
		<div class="simplyin-popup-divider"></div>
		<div class="simplyin-popup-apps">
			<div class="simplyin-popup-apps-top">
				<div class="simplyin-popup-apps-header">
					<?php echo esc_html( __( 'Log in via the app',
						'simplyin' ) ); ?>
				</div>
				<img
					src="<?php echo esc_url( simplyin()->get_plugin_url() . 'public/img/simplyin_app_logo.svg' ); ?>"
					alt="<?php esc_attr_e( 'SimplyIn Logo', 'simplyin' ); ?>"/>
				<div class="simplyin-popup-apps-description">
					<?php echo esc_html( __( 'Install the app right now',
						'simplyin' ) ); ?>
				</div>
			</div>
			<div class="simplyin-popup-apps-buttons">
				<a href="https://play.google.com/store/apps/details?id=simplyin.app&hl=pl&pli=1"
				   target="_blank" class="simplyin-popup-apps-button">
					<img
						src="<?php echo esc_url( simplyin()->get_plugin_url() . 'public/img/simplyin_google_play.svg' ); ?>"
						alt="<?php esc_attr_e( 'SimplyIn Logo',
							'simplyin' ); ?>"/>
				</a>
				<a href="https://apps.apple.com/pl/app/simply-in/id6476778468"
				   target="_blank" class="simplyin-popup-apps-button">
					<img
						src="<?php echo esc_url( simplyin()->get_plugin_url() . 'public/img/simplyin_app_store.svg' ); ?>"
						alt="<?php esc_attr_e( 'SimplyIn Logo',
							'simplyin' ); ?>"/>
				</a>
			</div>
		</div>
	</div>
</div>
