<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$module_path = $args['module_path'] ?? '';
$img_url     = simplyin()->get_plugin_url() . 'public/img/';
?>
<div class="simplyin-popup-overlay"></div>
<div class="simplyin-popup simplyin-autocomplete">
	<div class="simplyin-popup-header">
    <img width="32" height="32"
         src="<?php echo esc_url( $img_url . 'logo_smalln.svg' ); ?>" alt="<?php esc_attr_e( 'SimplyIn', 'simplyin' ); ?>"/>
		<div
		class="popup-add-address-label-header"><?php esc_html_e( 'Add a pickup point',
			'simplyin' ); ?></div>
		<div class="simplyin-popup-close-button">
			<img width="20" height="21"
				 src="<?php echo esc_url( $img_url . 'close_icon.svg' ); ?>"/>
		</div>
	</div>
	<div class="simplyin-popup-container simplyin-autocomplete">
		<div class="simplyin-popup-content">
			<div class="form-group">
				<input type="text" id="pickup-search" placeholder="<?php esc_attr_e( 'Wyszukaj',
						'simplyin' ); ?>" autocomplete="off">
			</div>
			<div class="pickup-placeholder">
				<img
					src="<?php echo esc_url( $img_url . 'point.svg' ); ?>"
					alt="" width="112" height="112">
				<div><?php esc_html_e( 'No pickup points found near the provided address',
						'simplyin' ); ?></div>
			</div>
			<div class="pickup-list-container" style="display: none"></div>
			<div class="pickup-details-selected">
				<div class="pickup-details-header mb-half"><?php esc_html_e( 'Address details',
						'simplyin' ); ?></div>
				<div><?php esc_html_e( 'Number:', 'simplyin' ); ?> <span
						id="simplyin-pickup-number"></span></div>
				<div><?php esc_html_e( 'Address:', 'simplyin' ); ?> <span
						id="simplyin-pickup-address"></span></div>
				<div><?php esc_html_e( 'Additional information:',
						'simplyin' ); ?> <span id="simplyin-pickup-info"></span>
				</div>
			</div>
			<div class="pickup-details-header"><?php esc_html_e( 'Address name',
						'simplyin' ); ?></div>
			<div class="pickup-details-description"><?php esc_html_e( 'A personalised name will help you find or associate the address on your list more quickly.',
					'simplyin' ); ?></div>
			<div class="form-group">
				<input type="text" id="pickup-name" placeholder="<?php esc_attr_e( 'Enter name',
						'simplyin' ); ?>">
			</div>
		</div>
		<div class="popup-buttons-footer">
			<button type="button"
					class="popup-button simplyin-cancel"><?php esc_html_e( 'Cancel',
					'simplyin' ); ?></button>
			<button type="submit"
					class="popup-button simplyin-submit"><?php esc_html_e( 'Add',
					'simplyin' ); ?></button>
		</div>
	</div>
</div>
