<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Simplyin;

class Simplyin_Method_Factory {

	static protected array $methods_cache = [];


	/**
	 * @return Simplyin_Method_Interface[]
	 */
	public function get_available_simply_methods(): array {

		if ( empty( self::$methods_cache ) ) {
			self::$methods_cache = [
				$this->create_inpost_parcel_locker(),
				$this->create_dpd_point(),
				$this->create_dhl_parcelshop(),
				$this->create_orlen_parcel_locker(),
				$this->create_ups_parcel_locker(),
				$this->create_door_delivery(),
			];
		}

		return self::$methods_cache;
	}

	public function create_inpost_parcel_locker(): Simplyin_Method {
		return new Simplyin_Method(
			'inpost_parcel_locker',
			__( 'Inpost parcel locker', 'simplyin' ),
			'inpost',
		);
	}

	public function create_dpd_point(): Simplyin_Method {
		return new Simplyin_Method(
			'dpd_point',
			__( 'DPD Point', 'simplyin' ),
			'dpd',
		);
	}

	public function create_dhl_parcelshop(): Simplyin_Method {
		return new Simplyin_Method(
			'dhl_parcelshop',
			__( 'DHL Parcelshop', 'simplyin' ),
			'dhl',
		);
	}

	public function create_orlen_parcel_locker(): Simplyin_Method {
		return new Simplyin_Method(
			'orlen_parcel_locker',
			__( 'Orlen parcel locker', 'simplyin' ),
			'orlen',
		);
	}

	public function create_ups_parcel_locker(): Simplyin_Method {
		return new Simplyin_Method(
			'ups_access_point',
			__( 'UPS parcel locker', 'simplyin' ),
			'ups',
		);
	}

	public function create_door_delivery(): Simplyin_Method {
		return new Simplyin_Method(
			'door_delivery',
			__( 'Delivery to your door', 'simplyin' ),
			'door_delivery',
		);
	}


}
