<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Simplyin;

use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Door_Delivery_Integration;
use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Integration_Interface;
use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Multi_Integration_Interface;

class Simplyin_Method implements Simplyin_Method_Interface {

	protected string $id;
	protected string $title;
	protected string $logistic_provider;

	public function to_array(): array {
		return [
			'id'               => $this->get_id(),
			'title'            => $this->get_title(),
			'logisticProvider' => $this->get_logistic_provider(),
		];
	}


	/**
	 * @param string $id
	 * @param string $title
	 * @param string $logistic_provider
	 */
	public function __construct(
		string $id,
		string $title,
		string $logistic_provider
	) {
		$this->id                = $id;
		$this->title             = $title;
		$this->logistic_provider = $logistic_provider;
	}

	public function is_integration_supported( Integration_Interface $integration
	): bool {
		if ( $integration instanceof Multi_Integration_Interface ) {
			return in_array( $this->logistic_provider,
				$integration->get_logistic_providers() );
		}

		return $this->logistic_provider === (string) $integration->get_logistic_provider();
	}

	public function get_id(): string {
		return $this->id;
	}

	public function get_title(): string {
		return $this->title;
	}

	public function get_logistic_provider(): string {
		return $this->logistic_provider;
	}
}
