<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Inpost_Plugin;

use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Abstract_Integration_Factory;
use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Integration_Factory_Interface;
use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Integration_Interface;
use WC_Shipping_Method;

class Inpost_Plugin_Integration_Factory extends Abstract_Integration_Factory implements Integration_Factory_Interface {

	public function create( WC_Shipping_Method $method
	): ?Integration_Interface {

		$method_id = $this->get_method_id_by_rate_id( $method->get_rate_id() );

		if ( ! $this->is_easypack( $method_id ) ) {
			return null;
		}

		return $this->create_integration_by_method_id(
			$method_id,
			$method->get_instance_id(),
			$method->get_title() );
	}


	private function is_easypack( string $method_id ): bool {
		return strpos( $method_id, 'easypack_' ) !== false;
	}

	public function create_integration_by_method_id(
		string $easypack_method_id,
		int $instance_id,
		string $title

	): ?Integration_Interface {


		if ( in_array( $easypack_method_id, [
			'easypack_parcel_machines',
			'easypack_parcel_machines_cod',
			'easypack_parcel_machines_economy_cod',
			'easypack_parcel_machines_economy',
			'easypack_parcel_machines_weekend',
			'easypack_parcel_machines_weekend_cod',
		] ) ) {
			return new Inpost_Plugin_Parcel_locker_Integration(
				$easypack_method_id,
				$instance_id,
				$title );
		}

		return null;

	}
}
