<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Fs;

use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Abstract_Integration_Factory;
use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Inpost_Plugin\Inpost_Plugin_Integration_Factory;
use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Integration_Factory_Interface;
use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Integration_Interface;
use WC_Shipping_Method;

class Fs_Integration_Factory extends Abstract_Integration_Factory implements Integration_Factory_Interface {

	public function create( WC_Shipping_Method $method
	): ?Integration_Interface {


		$method_id = $this->get_method_id_by_rate_id( $method->get_rate_id() );
		$is_fs     = $this->is_fs( $method_id );


		if ( ! $is_fs ) {
			return null;
		}

		/*simplyin_w_plugin()->get_simplyin_logger()->log(
			sprintf( "[Fs_Integration_Factory] [create] %s",
				print_r( [
					'title'       => $method->get_title(),
					'instance_id' => $method->get_instance_id(),
					'rate_id'     => $method->get_rate_id(),
					'method_id'   => $method_id,
					'method'      => $method,
				], true ),
			),
			'shipping_mapping' );*/

		$inpost_plugin_integration = $this->create_inpost_plugin_integration( $method,
			$method->get_instance_id() );

		if ( $inpost_plugin_integration ) {
			$fs_integration = $this->create_fs_integration( $method_id,
				$method->get_instance_id(),
				$method->get_title(),
				$inpost_plugin_integration );

			return $fs_integration;
		}

		return $this->find_fs_method_integration( $method, $method_id );


		/*$is_fs_dpd = $this->is_fs_dpd( $method );

		if ( $is_fs_dpd ) {
			$fs_integration = $this->create_fs_integration( $method_id,
				$method->get_instance_id(),
				$method->get_title(),
				null,
				'dpd' );

			return $fs_integration;
		}

		return null;*/
	}


	private function is_fs( string $method_id ): bool {
		return strpos( $method_id, 'flexible_shipping_' ) !== false;
	}

	private function find_wrapped_inpost_plugin_method_id(
		WC_Shipping_Method $method
	): ?string {

		if ( property_exists( $method, 'instance_settings' ) ) {
			$instance_settings = $method->instance_settings;
		}

		if ( isset( $instance_settings['method_integration'] ) && $instance_settings['method_integration'] !== '' ) {
			return null;
		}

		$result = $instance_settings['fs_inpost_pl_method'] ?? null;

		return $result ? (string) $result : null;
	}

	protected function get_instance_settings(
		WC_Shipping_Method $method
	): ?array {

		if ( property_exists( $method, 'instance_settings' ) ) {
			$instance_settings = $method->instance_settings;
		} else {
			return null;
		}

		return $instance_settings;
	}

	private function find_fs_method_integration(
		WC_Shipping_Method $method,
		string $fs_method_id

	): ?Integration_Interface {

		$instance_settings = $this->get_instance_settings( $method );

		if ( isset( $instance_settings['method_integration'] ) ) {
			if ( isset( $instance_settings['id_for_shipping'] ) && '' !== (string) $instance_settings['id_for_shipping'] ) {

				switch ( true ) {
					case $this->is_fs_dpd( $instance_settings ):

						return $this->create_fs_integration(
							$fs_method_id,
							$method->get_instance_id(),
							$method->get_title(),
							null,
							'dpd');


					case $this->is_fs_dhl( $instance_settings ):
						return $this->create_fs_integration(
							$fs_method_id,
							$method->get_instance_id(),
							$method->get_title(),
							null,
							'dhl' );

					default:
						return null;
				}
			}
		}

		return null;
	}





	//$instance_settings["dhl_product"] = parcelshop
	//$instance_settings['method_integration']  = dhl
	private function is_fs_dpd(
		array $instance_settings
	): bool {

		$method_integration = '';
		$dpd_pickup         = '';

		if ( isset( $instance_settings['method_integration'] ) ) {
			$method_integration = (string) $instance_settings['method_integration'] ?? null;
		}

		if ( isset( $instance_settings['dpd_pickup'] ) ) {
			$dpd_pickup = (string) $instance_settings['dpd_pickup'] ?? null;
		}


		if ( 'dpd' === $method_integration
		     && 'yes' === $dpd_pickup ) {

			return true;
		}

		return false;
	}

	private function is_fs_dhl(
		array $instance_settings
	): bool {

		$method_integration = '';
		$dhl_product        = '';

		if ( isset( $instance_settings['method_integration'] ) ) {
			$method_integration = (string) $instance_settings['method_integration'] ?? null;
		}

		if ( isset( $instance_settings['dhl_product'] ) ) {
			$dhl_product = (string) $instance_settings['dhl_product'] ?? null;
		}


		if ( 'dhl' === $method_integration
		     && 'parcelshop' === $dhl_product ) {

			return true;
		}

		return false;
	}


	private function create_fs_integration(
		string $fs_method_id,
		int $fs_instance_id,
		string $title,
		?Integration_Interface $wrapped_integration = null,
		?string $logistic_provider = null
	): Fs_Integration {
		if ( $wrapped_integration ) {
			$instance = new Fs_Integration( $fs_method_id,
				$fs_instance_id,
				$wrapped_integration->get_title(),
				$wrapped_integration->get_logistic_plugin(),
				$wrapped_integration->get_method(),
				$wrapped_integration->get_logistic_provider()
			);
		} else {
			$instance = new Fs_Integration(
				$fs_method_id,
				$fs_instance_id,
				$title,
				'wp-desk',
				null,
				$logistic_provider );
		}

		return $instance;
	}

	private function create_inpost_plugin_integration(
		WC_Shipping_Method $method,
		int $instance_id
	): ?Integration_Interface {

		$easypack_method_id = $this->find_wrapped_inpost_plugin_method_id( $method );

		if ( $easypack_method_id ) {
			$factory = new Inpost_Plugin_Integration_Factory();

			return $factory->create_integration_by_method_id(
				$easypack_method_id,
				$instance_id,
				$method->get_title() );
		}

		return null;
	}


	public function create_integration_by_method_id(
		string $method_id,
		int $instance_id,
		string $title
	): ?Integration_Interface {

		return null;
	}
}


/*if ( $is_fs ) {
			simplyin_w_plugin()->get_simplyin_logger()->log(
				sprintf( "[Fs_Integration_Factory] [settings] %s",
					print_r( $method->instance_settings, true ),
				),
				'shipping_mapping' );


		}*/
