<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Fs;

class Fs_Integration extends Abstract_Fs_Integration {

	protected string $method_id;
	protected int $instance_id;
	protected string $title;
	protected ?string $paired_logistic_plugin = null;
	protected ?string $paired_method = null;
	protected ?string $logistic_provider = null;

	public function to_array(): array {
		return [
			'methodId'             => $this->get_method(),
			'instanceId'           => $this->get_instance_id(),
			'title'                => $this->get_title(),
			'pairedMethod'         => $this->get_paired_method(),
			'logisticProvider'     => $this->get_logistic_provider(),
			'logisticPlugin'       => $this->get_paired_logistic_plugin()
		];
	}


	public function __construct(
		string $method_id,
		int $instance_id,
		string $title,
		?string $logistic_paired_plugin = null,
		?string $paired_method = null,
		?string $logistic_provider = null
	) {
		$this->method_id              = $method_id;
		$this->instance_id            = $instance_id;
		$this->title                  = $title;
		$this->paired_logistic_plugin = $logistic_paired_plugin;
		$this->paired_method          = $paired_method;
		$this->logistic_provider      = $logistic_provider;

	}

	public function get_method(): string {
		return $this->method_id;
	}

	public function get_paired_logistic_plugin(): ?string {
		return $this->paired_logistic_plugin;
	}

	public function get_paired_method(): ?string {
		return $this->paired_method;
	}

	public function get_logistic_provider(): ?string {
		return $this->logistic_provider;
	}

	public function get_title(): string {
		return $this->title;
	}

	public function get_instance_id(): int {
		return $this->instance_id;
	}
}
