<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration;

use WC_Shipping_Method;

class Door_Delivery_Integration_Factory extends Abstract_Integration_Factory implements Integration_Factory_Interface {

	public function create( WC_Shipping_Method $method
	): ?Integration_Interface {
		$method_id = $this->get_method_id_by_rate_id( $method->get_rate_id() );


		return $this->create_integration_by_method_id(
			$method_id,
			$method->get_instance_id(),
			$method->get_title() );
	}

	public function create_integration_by_method_id(
		string $method_id,
		int $instance_id,
		string $title
	): ?Integration_Interface {

		return new Door_Delivery_Integration(
			$method_id,
			$instance_id,
			$title );

	}


}
