<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration;

class Door_Delivery_Integration implements Integration_Interface {

	protected string $method_id;
	protected int $instance_id;
	protected string $title;
	protected ?string $logistic_provider = 'door_delivery';
	protected ?string $logistic_plugin = '';

	public function to_array(): array {
		return [
			'methodId'         => $this->get_method(),
			'instanceId'       => $this->get_instance_id(),
			'logisticProvider' => $this->get_logistic_provider(),
			'logisticPlugin'   => $this->get_logistic_plugin(),
		];
	}

	public function __construct(
		string $method_id,
		int $instance_id,
		string $title
	) {
		$this->method_id   = $method_id;
		$this->title       = $title;
		$this->instance_id = $instance_id;
	}

	public function get_logistic_plugin(): string {
		return $this->logistic_plugin;
	}

	public function get_method(): string {
		return $this->method_id;
	}

	public function get_paired_logistic_plugin(): ?string {
		return null;
	}

	public function get_paired_method(): ?string {
		return null;
	}

	public function get_logistic_provider(): ?string {
		return $this->logistic_provider;
	}

	public function get_title(): string {
		return $this->title;
	}

	public function get_instance_id(): int {
		return $this->instance_id;
	}


}
