<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Apaczka;

use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Multi_Integration_Interface;

class Apaczka_Multi_Integration extends Apaczka_Integration implements Multi_Integration_Interface {

	protected array $logistic_providers;


	public function __construct(
		string $method_id,
		int $instance_id,
		string $title,
		array $logistic_providers
	) {

		parent::__construct( $method_id,
			$instance_id,
			$title,
			'' );

		$this->logistic_providers = $logistic_providers;
	}


	public function get_logistic_providers(): array {
		return $this->logistic_providers;
	}

	public function to_array(): array {
		return [
			'multiIntegration'     => true,
			'methodId'             => $this->get_method(),
			'instanceId'           => $this->get_instance_id(),
			'title'                => $this->get_title(),
			'pairedMethod'         => $this->get_paired_method(),
			'logisticProvider'     => $this->get_logistic_provider(),
			'logisticProviders'    => $this->get_logistic_providers(),
			'logisticPlugin'       => $this->logistic_plugin,
		];
	}

}
