<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Apaczka;

use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Abstract_Integration_Factory;
use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Integration_Factory_Interface;
use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Integration_Interface;
use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Multi_Integration_Interface;
use WC_Shipping_Method;

class Apaczka_Integration_Factory extends Abstract_Integration_Factory implements Integration_Factory_Interface {

	public function create( WC_Shipping_Method $method
	): ?Integration_Interface {
		$method_id = $this->get_method_id_by_rate_id( $method->get_rate_id() );

		$instance_settings = $this->get_instance_settings( $method );

		if ( ! $instance_settings || ! $provider = $this->find_apaczka_provider( $instance_settings ) ) {
			return null;
		}

		if ( 'all' === $provider ) {
			$multi_integration = $this->create_multi_integration_by_method_id(
				$method_id,
				$method->get_instance_id(),
				$method->get_title(),
				array_values( $this->get_supported_providers_map() ) );

			return $multi_integration;
		}

		return $this->create_integration_by_method_id(
			$method_id,
			$method->get_instance_id(),
			$method->get_title(),
			$provider );


		/*
		 * 'RUCH',
                            'INPOST',
                            'INPOST_INTERNATIONAL',
                            'POCZTA',
                            'DPD',
                            'UPS',
                            'DHL',
                            'GLS',
                            'FEDEX'
		 */

	}

	private function find_apaczka_provider( array $instance_settings
	): ?string {

		if ( isset( $instance_settings["display_apaczka_map"] )
		     && 'yes' === $instance_settings["display_apaczka_map"] ) {

			if ( ! empty( $instance_settings['supplier_apaczka_map'] ) ) {
				if ( 'all' === $instance_settings['supplier_apaczka_map'] ) {
					return 'all';
				}

				$provider = $this->normalize_apaczka_provider_name( $instance_settings['supplier_apaczka_map'] );

				return $provider ?: null;
			}


			return null;
		}

		return null;
	}

	private function get_supported_providers_map(): array {
		return [
			'UPS'        => 'ups',
			'POCZTA'     => 'poczta',
			'PWR'        => 'orlen',
			'DPD'        => 'dpd',
			'DHL_PARCEL' => 'dhl',
			'INPOST'     => 'inpost',
		];
	}

	private function normalize_apaczka_provider_name( string $name ): ?string {
		$map = $this->get_supported_providers_map();

		if ( key_exists( $name, $map ) ) {
			return $map[ $name ];
		}

		return null;
	}

	public function create_integration_by_method_id(
		string $method_id,
		int $instance_id,
		string $title,
		?string $provider = null
	): ?Integration_Interface {

		$title = sprintf( '%s (%s - %s)',
			$title,
			__( 'Apaczka', 'simplyin' ),
			$provider,
		);

		return new Apaczka_Integration(
			$method_id,
			$instance_id,
			$title,
			$provider
		);

	}

	public function create_multi_integration_by_method_id(
		string $method_id,
		int $instance_id,
		string $title,
		array $providers
	): ?Multi_Integration_Interface {

		$title = sprintf( '%s (%s - %s)',
			$title,
			__( 'Apaczka', 'simplyin' ),
			__( 'All providers', 'simplyin' )
		);

		return new Apaczka_Multi_Integration(
			$method_id,
			$instance_id,
			$title,
			$providers
		);

	}

}
