<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Apaczka;

use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration\Integration_Interface;

class Apaczka_Integration implements Integration_Interface {

	protected string $method_id;
	protected int $instance_id;
	protected string $title;
	protected string $logistic_provider;
	protected string $logistic_plugin = 'apaczka';

	public function to_array(): array {
		return [
			'methodId'             => $this->get_method(),
			'instanceId'           => $this->get_instance_id(),
			'title'                => $this->get_title(),
			'pairedMethod'         => $this->get_paired_method(),
			'logisticProvider'     => $this->get_logistic_provider(),
			'logisticPlugin'       => $this->logistic_plugin,
		];
	}

	public function __construct(
		string $method_id,
		int $instance_id,
		string $title,
		string $logistic_provider
	) {
		$this->method_id         = $method_id;
		$this->title             = $title;
		$this->instance_id       = $instance_id;
		$this->logistic_provider = $logistic_provider;
	}

	public function get_method(): string {
		return $this->method_id;
	}

	public function get_paired_logistic_plugin(): ?string {
		return null;
	}

	public function get_paired_method(): ?string {
		return null;
	}

	public function get_logistic_provider(): ?string {
		return $this->logistic_provider;
	}

	public function get_title(): string {
		return $this->title;
	}

	public function get_instance_id(): int {
		return $this->instance_id;
	}

	public function get_logistic_plugin(): string {

	}
}
