<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Integration;

use WC_Shipping_Method;

abstract class Abstract_Integration_Factory {


	protected function get_method_id_by_rate_id( string $rate_id ): string {
		$method_id = null;
		if ( strpos( $rate_id, ':' ) !== false ) {
			$method_id = explode( ':',
				esc_attr( $rate_id ) )[0] ?: $rate_id;
		}


		return $method_id ?: $rate_id;
	}

	protected function get_instance_settings(
		WC_Shipping_Method $method
	): ?array {

		if ( property_exists( $method, 'instance_settings' ) ) {
			$instance_settings = $method->instance_settings;
		} else {
			return null;
		}

		return $instance_settings;
	}
}
