<?php

namespace Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Checkout;

class Cart_Delivery {

	/**
	 * @var Cart_Delivery_Item[]
	 */
	private array $items = [];


	public function add( Cart_Delivery_Item $cart_delivery_item ) {
		$this->items[ $cart_delivery_item->get_rate_method_id() ] = $cart_delivery_item;
	}

	public function get_item( string $rate_method_id ): ?Cart_Delivery_Item {
		if ( key_exists( $rate_method_id, $this->items ) ) {
			return $this->items[ $rate_method_id ];
		}

		return null;
	}

	public function get_items(): array {
		return $this->items;
	}
}
