<?php
declare(strict_types=1);

namespace Simplyin\Simplyin_W_Plugin\Service\Order;

use Simplyin\Simplyin_W_Plugin\Dto\Order\Order_DTO_Factory;
use WC_Order;

class Order_Data_Handler {

	/**
	 * Build payload for "create order AND account" flow.
	 *
	 * @param WC_Order $order
	 * @param array    $params Expected keys:
	 *                        - payment_method_data (array)
	 *                        - plugin_version (string)
	 *                        - woocommerce_version (string)
	 *                        - tax_id (string)
	 *                        - language_code (string)
	 *                        - parcel_machine_id (string)
	 *                        - parcel_provider_name (string)
	 *                        - phone_app_input_field (string)
	 *                        - simply_billing_id (string)
	 *                        - simply_shipping_id (string)
	 *                        - shop_user_email (string, optional)
	 */
	public function build_create_order_and_account_payload( WC_Order $order, array $params ): array {
		return Order_DTO_Factory::build_create_order_and_account_body_data_dto(
			$order,
			$params['payment_method_data'] ?? [],
			(string) ( $params['plugin_version'] ?? '' ),
			(string) ( $params['woocommerce_version'] ?? '' ),
			$params['tax_id'] ?? '',
			(string) ( $params['language_code'] ?? '' ),
			(string) ( $params['parcel_machine_id'] ?? '' ),
			(string) ( $params['parcel_provider_name'] ?? '' ),
			(string) ( $params['phone_app_input_field'] ?? '' ),
			(string) ( $params['simply_billing_id'] ?? '' ),
			(string) ( $params['simply_shipping_id'] ?? '' ),
			(string) ( $params['shop_user_email'] ?? '' )
		)->toArray();
	}

	/**
	 * Build payload for "create order WITHOUT account" flow.
	 *
	 * @param WC_Order $order
	 * @param array    $params See build_create_order_and_account_payload for expected keys
	 */
	public function build_create_order_without_account_payload( WC_Order $order, array $params ): array {
		return Order_DTO_Factory::build_create_order_without_account_body_data_dto(
			$order,
			$params['payment_method_data'] ?? [],
			(string) ( $params['plugin_version'] ?? '' ),
			(string) ( $params['woocommerce_version'] ?? '' ),
			$params['tax_id'] ?? '',
			(string) ( $params['language_code'] ?? '' ),
			(string) ( $params['parcel_machine_id'] ?? '' ),
			(string) ( $params['parcel_provider_name'] ?? '' ),
			(string) ( $params['phone_app_input_field'] ?? '' ),
			(string) ( $params['simply_billing_id'] ?? '' ),
			(string) ( $params['simply_shipping_id'] ?? '' ),
			(string) ( $params['shop_user_email'] ?? '' )
		)->toArray();
	}
}



