<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * @var \Simplyin\Simplyin_W_Plugin\Payments\Gateway\Model\Payment_Type_Blik $blik_payment
 */



if ( ! isset( $blik_payment ) ) {
	return;
}
?>

<div id="simplyin-blik-status-modal" data-is-card-payment="false"
	 class="simplyin-blik-modal simplyin-blik-pending"
	 data-payment-processing="<?php echo esc_attr__( 'Waiting for confirmation...',
		 'simplyin' ); ?>"
	 data-payment-pending="<?php echo esc_attr__( 'Processing payment...',
		 'simplyin' ); ?>"
	 data-payment-success="<?php echo esc_attr__( 'Payment completed successfully!',
		 'simplyin' ); ?>"
	 data-payment-rejected="<?php echo esc_attr__( 'Payment rejected',
		 'simplyin' ); ?>"
	 data-payment-timeout="<?php echo esc_attr__( 'Time limit exceeded.',
		 'simplyin' ); ?>"
	 data-status-check-error="<?php echo esc_attr__( 'Status check error:',
		 'simplyin' ); ?>"
	 data-network-error="<?php echo esc_attr__( 'Network error:',
		 'simplyin' ); ?>"
	 data-main-message-processing="<?php echo esc_attr__( 'Confirm payment in your mobile banking app.',
		 'simplyin' ); ?>"
	 data-main-message-pending="<?php echo esc_attr__( 'Please wait for confirmation',
		 'simplyin' ); ?>"
	 data-main-message-success="<?php echo esc_attr__( 'Payment successful!',
		 'simplyin' ); ?>"
	 data-main-message-error="<?php echo esc_attr__( 'Payment failed',
		 'simplyin' ); ?>"
	 data-main-message-timeout="<?php echo esc_attr__( 'Payment timed out',
		 'simplyin' ); ?>"
	data-accept-payment-message="<?php echo esc_attr__( 'Accept payment in your mobile banking app.',
		 'simplyin' ); ?>">
	<div class="simplyin-blik-content">
		<div class="simplyin-blik-header">
			<h3 class="simplyin-blik-title"><?php echo esc_html__( 'Payment processing by',
					'simplyin' ); ?></h3>
			<div class="simplyin-status-logo">
				<img class="simplyin"
					 src="<?php echo esc_url( simplyin()->get_plugin_url() . 'public/img/logo_smalln.svg' ); ?>"
					 alt="SimplyIn">&nbsp;&amp;&nbsp;<img class="payu"
														  src="<?php echo esc_url( $blik_payment->get_provider_logo_url() ); ?>"
														  alt="<?php echo esc_url( $blik_payment->get_provider_name() ); ?>">
			</div>
		</div>

		<div class="simplyin-blik-payment-method">
			<div class="simplyin-blik-method-info">
				<input type="radio" id="blik-method" name="payment-method"
					   checked>
				<label for="blik-method" class="simplyin-blik-label">
					<img
						src="<?php echo esc_url( $blik_payment->get_logo_url() ); ?>"
						alt="<?php echo esc_attr__( 'BLIK',
							'simplyin' ); ?>"
						class="simplyin-blik-logo">
					<span
						class="simplyin-blik-text"><?php echo esc_html__( 'BLIK',
							'simplyin' ); ?></span>
				</label>
				<span class="simplyin-blik-checkmark">✓</span>
			</div>
		</div>

		<div class="simplyin-blik-status-container">
			<div class="simplyin-blik-icon">
				<svg width="24" height="24" viewBox="0 0 24 24" fill="none">
					<path
						d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z"
						fill="#FF9800"/>
				</svg>
			</div>
			<div class="simplyin-blik-status-text">
				<div class="simplyin-blik-main-message">
					<?php echo esc_html__( 'Please wait for confirmation',
						'simplyin' ); ?>
				</div>
				<div class="simplyin-blik-sub-message" id="blik-status-message">
					<?php echo esc_html__( 'Processing payment...',
						'simplyin' ); ?>
				</div>
			</div>
		</div>

		<div class="simplyin-blik-loader" id="blik-loader">
			<div class="simplyin-blik-spinner"></div>
		</div>
	</div>
</div>
