<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * @var Payment_Method_Item_Provider $provider
 */

use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Item_Provider;


?>

<div class="simplyin-payment-provider-footer">
	<span><?php esc_html_e( 'By paying, I accept the',
			'simplyin' ); ?></span>
	<a
		target="_blank"
		class="simplyin-payment-provider-url"
		href="<?php echo esc_url( (string) $provider->get_regulations_url() ); ?>"><?php esc_html_e( 'terms and conditions',
			'simplyin' ); ?>
	</a>
	<span><?php esc_html_e( 'and', 'simplyin' ); ?></span>

	<a
		target="_blank"
		class="simplyin-payment-provider-url"
		href="<?php echo esc_url( (string) $provider->get_gdpr_url() ); ?>"><?php esc_html_e( 'privacy policy',
			'simplyin' ); ?></a>
	<span><?php echo esc_html( trim( ( ( $str = __( 'of',
			'simplyin' ) ) === '\0' ? '' : $str . ' ' ) ) ); ?> </span>
	<span><?php echo esc_html( (string) $provider->get_name() ); ?></span>
</div>
