<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * @var Payment_Method_Group $main_group
 */

use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Expandable_Group;
use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Group;
use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Provider_Group;



?>


<div class="payment_box payment_method_bacs">
	<input type="hidden" name="simplyin_checkout_token"
		   value="<?php echo esc_attr( wp_create_nonce( 'simplyin_checkout_nonce' ) ) ?>">
	<div class="simplyin-payment-methods-wrapper"
		 data-loading-iframe="<?php echo esc_attr( __( 'Loading custom iframe:',
			 'simplyin' ) ); ?>"
		 data-iframe-loaded="<?php echo esc_attr( __( 'Iframe loaded',
			 'simplyin' ) ); ?>"
		 data-iframe-error="<?php echo esc_attr( __( 'Iframe loading error',
			 'simplyin' ) ); ?>"
		 data-loading-error="<?php echo esc_attr( __( 'Iframe loading error',
			 'simplyin' ) ); ?>"
		 data-missing-data="<?php echo esc_attr( __( 'Missing URL or integrator ID',
			 'simplyin' ) ); ?>"
		 data-message-received="<?php echo esc_attr( __( 'Received message from iframe:',
			 'simplyin' ) ); ?>"
		 data-saved-card-data="<?php echo esc_attr( __( 'Saved card data for itemId:',
			 'simplyin' ) ); ?>"
		 data-iframe-ready="<?php echo esc_attr( __( 'Iframe ready for itemId:',
			 'simplyin' ) ); ?>"
		 data-card-name="<?php echo esc_attr( __( 'Card name',
			 'simplyin' ) ); ?>"
		 data-card-name-placeholder="<?php echo esc_attr( __( 'My card',
			 'simplyin' ) ); ?>"
		 data-card-holder-name="<?php echo esc_attr( __( 'Card holder name',
			 'simplyin' ) ); ?>"
		 data-card-number="<?php echo esc_attr( __( 'Card number',
			 'simplyin' ) ); ?>"
		 data-expiry-date="<?php echo esc_attr( __( 'Expiry date',
			 'simplyin' ) ); ?>"
		 data-security-code="<?php echo esc_attr( __( 'Code CVV/CVC',
			 'simplyin' ) ); ?>"
		 data-confirm-button="<?php echo esc_attr( __( 'Confirm',
			 'simplyin' ) ); ?>"
		 data-edit-button="<?php echo esc_attr( __( 'Edit',
			 'simplyin' ) ); ?>"
		 data-card-data-valid="<?php echo esc_attr( __( 'Card data is valid. You can place the order.',
			 'simplyin' ) ); ?>"
		 data-processing="<?php echo esc_attr( __( 'Processing...',
			 'simplyin' ) ); ?>"
		 data-enter-card-name="<?php echo esc_attr( __( 'Enter card name',
			 'simplyin' ) ); ?>"
		 data-card-processing-error="<?php echo esc_attr( __( 'Card data processing error. Check entered data.',
			 'simplyin' ) ); ?>"
		 data-card-processing-error-retry="<?php echo esc_attr( __( 'Card data processing error. Try again.',
			 'simplyin' ) ); ?>"
		 data-invalid-card-data="<?php echo esc_attr( __( 'Invalid card data. Check entered information.',
			 'simplyin' ) ); ?>"
		 data-connection-problem="<?php echo esc_attr( __( 'Connection problem. Check internet and try again.',
			 'simplyin' ) ); ?>"
		 data-save-card="<?php echo esc_attr( __( 'Save card for future payments',
			 'simplyin' ) ); ?>">
		<div
			class="simplyin-group-main">

			<ul>
				<?php foreach (
					$main_group->get_items()

					as $item_or_group
				) : ?>
					<?php $inner_group = null ?>
					<?php if ( $item_or_group instanceof Payment_Method_Expandable_Group ) : ?>
						<?php $test = $item_or_group->get_slug() ?>
						<?php if ( empty( $item_or_group->get_items() ) ) {
							continue;
						} ?>
						<?php $inner_group = $item_or_group ?>
						<li class="simplyin-payment-option-group-item">
						<label for="simplyin-gateway-bank-group">
							<input type="radio"
								   name="simplyin-inner-group"
								   id="simplyin-inner-group-<?php echo esc_attr( $inner_group->get_slug() ) ?>">
							<span
								class="simplyin-inner-group-name"><?php echo esc_html( $inner_group->get_name() ); ?></span>
						</label>
						<span
							class="simplyin-inner-group-desc">
                                        <span>
                                            <span><?php echo esc_html( $inner_group->get_subtitle() ); ?></span>
                                        </span>
                                    </span>


						<ul class="simplyin-inner-group-wrapper">
					<?php endif; ?>


					<?php $items = $inner_group ? $inner_group->get_items() : [ $item_or_group ] ?>

					<?php foreach ( $items as $item ) : ?>
						<?php simplyin()->locate_template( $item->get_template_name(),
							[
								'item'             => $item,
								'inner_group'      => $inner_group,
								'payment_provider' => $item->get_provider(),
								'card'             => $item->get_card(),
								'add_card'         => $item->get_add_card(),
							],
							'src/Payments/views/classic_checkout' ); ?>
					<?php endforeach; ?>

					<?php if ( $inner_group ): ?>
						</ul>
						</li>
					<?php endif; ?>

				<?php endforeach; ?>

				<?php if ( $main_group instanceof Payment_Method_Provider_Group ) : ?>
					<?php simplyin()->locate_template( 'provider_footer.php',
						[
							'provider' => $main_group->get_provider(),
						],
						'src/Payments/views/classic_checkout' ); ?>
				<?php endif; ?>

			</ul>
		</div>
	</div>
</div>
