<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * @var Payment_Method_Item $item
 * @var Payment_Method_Item_Provider $payment_provider
 * @var Payment_Method_Expandable_Group | null $inner_group
 */

use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Expandable_Group;
use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Item;
use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Item_Provider;



?>

<li class="simplyin-payment-option-item <?php if ( $inner_group ) : ?>inner-group-item<?php endif; ?>">
	<label
		class="simplyin-payment-option-label"
		for="simplyin-payment-option-<?php echo esc_attr( $item->get_short_id() ); ?>">
		<input type="radio"
			   name="simplyin-payment-option"
			   data-index="0"
			   id="simplyin-payment-option-<?php echo esc_attr( $item->get_short_id() ); ?>"
			   value="<?php echo esc_attr( $item->get_id() ); ?>"
			   class="<?php echo $inner_group ? 'inside-inner-group' : ''; ?>">
		<input type="hidden" name="simplyin_blik_code" value="">
		<img
			src="<?php echo esc_url( $item->get_icon() ); ?>"
			class="simplyin-payment-option-logo">
		<span
			class="simplyin-payment-option-name"><?php echo esc_html( $item->get_label() );
			?>
		</span>
	</label>
	<span
		class="simplyin-payment-option-desc"><?php echo esc_html( $item->get_description() ); ?></span>

	<div class="simplyin-blik-field-container active"
		 data-payment-id="<?php echo esc_attr( $item->get_id() ); ?>">
		<div class="simplyin-blik-input-wrapper">
			<div class="simplyin-blik-inputs-grid">
				<?php for ( $i = 1; $i <= 6; $i ++ ) : ?>
					<input
						type="tel"
						class="simplyin-blik-digit-input"
						maxlength="1"
						autocomplete="off"
						inputmode="numeric"
						pattern="[0-9]"
						data-digit="<?php echo esc_attr( $i ); ?>"
						data-payment-id="<?php echo esc_attr( $item->get_id() ); ?>"
						aria-label="Cyfra <?php echo esc_attr( $i ); ?> kodu BLIK">
				<?php endfor; ?>
			</div>
			<div class="simplyin-blik-error" style="display: none;">
				<?php esc_html_e( 'Blik code must be 6 digits', 'simplyin' ); ?>
			</div>
		</div>
	</div>
</li>
