<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * @var Payment_Method_Item $item
 * @var Payment_Method_Item_Provider $payment_provider
 * @var Payment_Method_Expandable_Group | null $inner_group
 * @var Payment_Method_Item_Add_Card $add_card
 */

use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Expandable_Group;
use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Item_Add_Card;
use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Item;
use Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout\Payment_Method_Item_Provider;

?>

<li id="simplyin-add-card-payment-method"
	class="simplyin-payment-option-item <?php if ( $inner_group ) : ?>inner-group-item<?php endif; ?>">
	<label
		class="simplyin-payment-option-label simplyin-add-card-label"
		for="simplyin-payment-option-<?php echo esc_attr( $item->get_short_id() ); ?>">
		<input type="radio"
			   name="simplyin-payment-option"
			   onclick="addCurrentClass(this)"
			   data-index="0"
			   data-integrator-id="<?php echo esc_attr( $add_card->get_integrator_id() ); ?>"
			   data-iframe-url="<?php echo esc_attr( $add_card->get_iframe_url() ); ?>"
			   data-ajax-url="<?php echo esc_attr( admin_url( 'admin-ajax.php' ) ); ?>"
			   data-toggle-add-card="true"
			   data-item-id="<?php echo esc_attr( $item->get_short_id() ); ?>"
			   id="simplyin-payment-option-<?php echo esc_attr( $item->get_short_id() ); ?>"
			   value="<?php echo esc_attr( $item->get_id() ); ?>"
			   class="<?php echo $inner_group ? 'inside-inner-group' : ''; ?> simplyin-hidden-radio">
		<span class="simplyin-plus-icon">
			<svg width="18" height="18" viewBox="0 0 18 18" fill="none">
				<path d="M9 4.5V13.5" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
				<path d="M4.5 9H13.5" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
			</svg>
		</span>
		<span
			class="simplyin-payment-option-name"><?php echo esc_html( $item->get_label() ); ?></span>
	</label>
	<span
		class="simplyin-payment-option-desc"><?php echo esc_html( $item->get_description() ); ?></span>

	<div
		id="simplyin-add-card-iframe-container-<?php echo esc_attr( $item->get_short_id() ); ?>"
		class="simplyin-add-card-iframe-container" style="display: none;">

		<div class="simplyin-iframe-wrapper">
			<form
				id="simplyin-add-card-<?php echo esc_attr( $item->get_short_id() ); ?>"
				class="simplyin-add-card-iframe"
				style="width: 100%;">
			</form>
		</div>

		<div class="simplyin-iframe-loading"
			 id="simplyin-iframe-loading-<?php echo esc_attr( $item->get_short_id() ); ?>"
			 style="display: none;">
			<p><?php esc_html_e( 'Loading form...',
					'simplyin' ); ?></p>
		</div>
	</div>
</li>

<input type="hidden" name="simplyin_ott" value=""/>
<input type="hidden" name="simplyin_first_digits" value=""/>
<input type="hidden" name="simplyin_last_digits" value=""/>
<input type="hidden" name="simplyin_organization" value=""/>
<input type="hidden" name="simplyin_card_name" value=""/>
<input type="hidden" name="simplyin_card_save_checkbox" value="false"/>
