<?php if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
} ?>

<div class="simplyin-gateway-config-page">
	<div class="simplyin-header">
		<img src="<?php echo esc_url( plugins_url('../public/img/logo_medium.svg', dirname(dirname(dirname(__FILE__)))) ); ?>" alt="<?php echo esc_attr__( 'Simply.IN Logo', 'simplyin' ); ?>" class="simplyin-logo">
	</div>

	<div class="simplyin-config-container">
		<div class="simplyin-settings-section">
			<div class="simplyin-section-header">
				<span class="simplyin-section-icon">🔧</span>
				<h2><?php echo esc_html__( 'Available Settings', 'simplyin' ); ?></h2>
			</div>

			<div class="simplyin-settings-grid">
				<div class="simplyin-setting-card">
					<div class="simplyin-card-icon">⚙️</div>
					<div class="simplyin-card-content">
						<h3><?php echo esc_html__( 'Payment Provider Configuration', 'simplyin' ); ?></h3>
						<p><?php echo esc_html__( 'Set up and configure your preferred payment providers', 'simplyin' ); ?></p>
					</div>
				</div>

				<div class="simplyin-setting-card">
					<div class="simplyin-card-icon">🔑</div>
					<div class="simplyin-card-content">
						<h3><?php echo esc_html__( 'API Keys Management', 'simplyin' ); ?></h3>
						<p><?php echo esc_html__( 'Enter and manage your API keys securely', 'simplyin' ); ?></p>
					</div>
				</div>

				<div class="simplyin-setting-card">
					<div class="simplyin-card-icon">🌍</div>
					<div class="simplyin-card-content">
						<h3><?php echo esc_html__( 'Environment Selection', 'simplyin' ); ?></h3>
						<p><?php echo esc_html__( 'Choose between test or production environments', 'simplyin' ); ?></p>
					</div>
				</div>

				<div class="simplyin-setting-card">
					<div class="simplyin-card-icon">🔗</div>
					<div class="simplyin-card-content">
						<h3><?php echo esc_html__( 'Integration Options', 'simplyin' ); ?></h3>
						<p><?php echo esc_html__( 'Additional integration options and configurations', 'simplyin' ); ?></p>
					</div>
				</div>
			</div>
		</div>

		<div class="simplyin-merchant-section">
			<div class="simplyin-merchant-card">
				<div class="simplyin-merchant-header">
					<span class="simplyin-merchant-icon">🏢</span>
					<h3><?php echo esc_html__( 'Merchant Panel Access', 'simplyin' ); ?></h3>
				</div>
				<p class="simplyin-merchant-description">
					<?php echo esc_html__( 'You can find all these settings in our Merchant Panel:', 'simplyin' ); ?>
				</p>
				<div class="simplyin-merchant-link-container">
					<span class="simplyin-pointer">👉</span>
					<a href="<?php echo esc_url( 'https://merchant.simply.in' ); ?>" target="_blank" rel="noopener noreferrer" class="simplyin-merchant-link">
						<?php echo esc_html( 'https://merchant.simply.in' ); ?>
					</a>
				</div>
			</div>
		</div>

		<div class="simplyin-instructions-section">
			<div class="simplyin-instructions-card">
				<div class="simplyin-instruction-step">
					<div class="simplyin-step-number">1</div>
					<div class="simplyin-step-content">
						<h4><?php echo esc_html__( 'Login to Merchant Panel', 'simplyin' ); ?></h4>
						<p><?php echo esc_html__( 'Access your merchant account', 'simplyin' ); ?></p>
					</div>
				</div>

				<div class="simplyin-instruction-step">
					<div class="simplyin-step-number">2</div>
					<div class="simplyin-step-content">
						<h4><?php echo esc_html__( 'Navigate to Integrations', 'simplyin' ); ?></h4>
						<p><?php echo esc_html__( 'Go to the menu on the left-hand side', 'simplyin' ); ?></p>
					</div>
				</div>

				<div class="simplyin-instruction-step">
					<div class="simplyin-step-number">3</div>
					<div class="simplyin-step-content">
						<h4><?php echo esc_html__( 'Select Integrations', 'simplyin' ); ?></h4>
						<p class="mb"><?php echo esc_html__( 'Try to find the icon like one below', 'simplyin' ); ?></p>
						<img src="<?php echo esc_url( plugins_url('../public/img/int.jpg', dirname(dirname(dirname(__FILE__)))) ); ?>" alt="<?php echo esc_attr__( 'Integration icon', 'simplyin' ); ?>" class="simplyin-logo">
					</div>
				</div>
				<div class="simplyin-instruction-step">
					<div class="simplyin-step-number">4</div>
					<div class="simplyin-step-content">
						<h4><?php echo esc_html__( 'Change settings', 'simplyin' ); ?></h4>
						<p><?php echo esc_html__( 'In this section you can change the settings of the integration', 'simplyin' ); ?></p>
					</div>
				</div>
			</div>
		</div>

		<div class="simplyin-support-section">
			<div class="simplyin-support-card">
				<div class="simplyin-support-header">
					<span class="simplyin-support-icon">📞</span>
					<h3><?php echo esc_html__( 'Need Help?', 'simplyin' ); ?></h3>
				</div>
				<p class="simplyin-support-description">
					<?php echo esc_html__( 'If you encounter any issues during configuration, our support team is here to assist you:', 'simplyin' ); ?>
				</p>
				<div class="simplyin-support-contact">
					<a href="<?php echo esc_url( 'mailto:support@simply.in' ); ?>" class="simplyin-support-email">
						<?php echo esc_html( 'support@simply.in' ); ?>
					</a>
				</div>
			</div>
		</div>
	</div>
</div>
