<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout;

class Payment_Method_Item_Provider {

	/**
	 * @var string
	 */
	public $id;

	/**
	 * @var string
	 */
	public $name;

	/**
	 * @var string
	 */
	public $logo_url;

	/**
	 * @var string
	 */
	public ?string $regulations_url;

	/**
	 * @var string
	 */
	public ?string $gdpr_url;


	/**
	 * @param string $id
	 * @param string $name
	 * @param string $logo_url
	 * @param string | null $regulations_url
	 * @param string|null $gdpr_url
	 */
	public function __construct(
		string $id,
		string $name,
		string $logo_url,
		?string $regulations_url,
		?string $gdpr_url

	) {
		$this->id              = $id;
		$this->name            = $name;
		$this->logo_url        = $logo_url;
		$this->regulations_url = $regulations_url;
		$this->gdpr_url        = $gdpr_url;
	}

	public function get_id(): string {
		return $this->id;
	}

	public function set_id( string $id ): void {
		$this->id = $id;
	}

	public function get_name(): string {
		return $this->name;
	}

	public function set_name( string $name ): void {
		$this->name = $name;
	}

	public function get_logo_url(): string {
		return $this->logo_url;
	}

	public function set_logo_url( string $logo_url ): void {
		$this->logo_url = $logo_url;
	}

	public function get_regulations_url(): ?string {
		return $this->regulations_url;
	}

	public function set_regulations_url( ?string $regulations_url ): void {
		$this->regulations_url = $regulations_url;
	}

	public function get_gdpr_url(): ?string {
		return $this->gdpr_url;
	}

	public function set_gdpr_url( ?string $gdpr_url ): void {
		$this->gdpr_url = $gdpr_url;
	}
}
