<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout;

class Payment_Method_Item extends Abstract_Payment_Method_Item {

	/**
	 * @var string
	 */
	private $label;

	/**
	 * @var string
	 */
	private $id;

	/**
	 * @var string
	 */
	private $type_name;

	/**
	 * @var string
	 */
	private $slug;

	/**
	 * @var string | null
	 */
	private $icon;

	/**
	 * @var string
	 */
	private $class;

	/**
	 * @var string | null
	 */
	private $description;

	/**
	 * @var string | null
	 */
	private $block_description;

	/**
	 * @var Payment_Method_Item_Provider
	 */
	private Payment_Method_Item_Provider $provider;


	private ?Payment_Method_Item_Card $card;
	private ?Payment_Method_Item_Add_Card $add_card;


	public function __construct(
		string $name,
		string $id,
		string $type,
		string $type_name,
		string $slug,
		?string $icon,
		?string $extra_class,
		?string $description,
		?string $block_description,
		Payment_Method_Item_Provider $provider,
		?Payment_Method_Item_Card $card,
		?Payment_Method_Item_Add_Card $add_card

	) {
		$this->label             = $name;
		$this->id                = $id;
		$this->type              = $type;
		$this->type_name         = $type_name;
		$this->slug              = $slug;
		$this->icon              = $icon;
		$this->class             = $extra_class;
		$this->description       = $description;
		$this->block_description = $block_description;
		$this->provider          = $provider;
		$this->card              = $card;
		$this->add_card          = $add_card;

		/*simplyin_w_plugin()->get_simplyin_logger()->log(
			sprintf( "[Payment_Method_Item] [construct] %s",
				print_r( [
					'this' => $this,
				], true ),
			),
			'payments' );
*/

	}

	public function get_short_id(): string {
		return substr( $this->id, - 7 );
	}

	/**
	 * @return string
	 */
	public function get_label(): string {
		return $this->label;
	}

	/**
	 * @param string $label
	 */
	public function set_label( string $label ): void {
		$this->label = $label;
	}

	/**
	 * @return string
	 */
	public function get_id(): string {
		return $this->id;
	}

	/**
	 * @param string $id
	 */
	public function set_id( string $id ): void {
		$this->id = $id;
	}


	/**
	 * @return string
	 */
	public function get_class(): ?string {
		return $this->class;
	}

	/**
	 * @param string|null $class
	 */
	public function set_class( ?string $class ): void {
		$this->class = $class;
	}

	/**
	 * @return string
	 */
	public function get_icon(): string {
		return (string) $this->icon;
	}

	/**
	 * @param string|null $icon
	 */
	public function set_icon( ?string $icon ): void {
		$this->icon = $icon;
	}

	/**
	 * @return string
	 */
	public function get_description(): string {
		return $this->description ?: "";
	}

	/**
	 * @param string $description
	 */
	public function set_description( string $description ): void {
		$this->description = $description;
	}

	public function get_block_description(): ?string {
		return $this->block_description;
	}

	public function set_block_description( ?string $block_description ): void {
		$this->block_description = $block_description;
	}

	public function get_data(): ?array {
		return $this->data;
	}

	public function get_slug(): string {
		return $this->slug;
	}

	public function set_slug( string $slug ): void {
		$this->slug = $slug;
	}

	public function get_provider(): Payment_Method_Item_Provider {
		return $this->provider;
	}

	public function set_provider( Payment_Method_Item_Provider $provider
	): void {
		$this->provider = $provider;
	}

	public function get_type_name(): string {
		return $this->type_name;
	}

	public function set_type_name( string $type_name ): void {
		$this->type_name = $type_name;
	}

	public function get_type(): string {
		return $this->type;
	}

	public function set_type( string $type ): void {
		$this->type = $type;
	}

	public function get_card(): ?Payment_Method_Item_Card {
		return $this->card;
	}

	public function set_card( ?Payment_Method_Item_Card $card ): void {
		$this->card = $card;
	}

	public function get_add_card(): ?Payment_Method_Item_Add_Card {
		return $this->add_card;
	}

	public function set_add_card( ?Payment_Method_Item_Add_Card $add_card
	): void {
		$this->add_card = $add_card;
	}
}
