<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout;

class Payment_Method_Group {

	/**
	 * @var array<Payment_Method_Item,Payment_Method_Expandable_Group>
	 */
	private $items;

	/**
	 * @var string
	 */
	private $title;

	/**
	 * @var string
	 */
	private $slug;


	/**
	 * @param Payment_Method_Item[] $items
	 * @param string $title
	 * @param string $slug
	 */
	public function __construct(
		array $items,
		string $title,
		string $slug = ''
	) {
		$this->items = $items;
		$this->title = $title;
		$this->slug  = $slug;
	}

	/**
	 * @return array<Payment_Method_Item,Payment_Method_Expandable_Group>
	 */
	public function get_items(): array {
		return $this->items;
	}

	/**
	 * @param Payment_Method_Item[] $items
	 */
	public function set_items( array $items ): void {
		$this->items = $items;
	}

	/**
	 * @return string
	 */
	public function get_title(): string {
		return $this->title;
	}

	/**
	 * @param string $title
	 */
	public function set_title( string $title ): void {
		$this->title = $title;
	}

	/**
	 * @return string
	 */
	public function get_slug(): string {
		return $this->slug;
	}

	/**
	 * @param string $slug
	 */
	public function set_slug( string $slug ): void {
		$this->slug = $slug;
	}

	public function push_item( Payment_Method_Item $item ) {
		$items       = $this->items;
		$items[]     = $item;
		$this->items = $items;
	}

	public function push_group( Payment_Method_Expandable_Group $group ) {
		$items       = $this->items;
		$items[]     = $group;
		$this->items = $items;
	}
}
