<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\View_Model\Classic_Checkout;

class Payment_Method_Expandable_Group {

	/**
	 * @var Payment_Method_Item[]
	 */
	private $items;

	/**
	 * @var string
	 */
	private $name;

	/**
	 * @var string
	 */
	private $slug;

	/**
	 * @var string
	 */
	private $icon;

	/**
	 * @var string
	 */
	private $subtitle;

	/**
	 * @param Payment_Method_Item[] $items
	 * @param string $name
	 * @param string $slug
	 * @param string $icon
	 * @param string $subtitle
	 */
	public function __construct(
		array $items,
		string $name,
		string $slug,
		string $icon,
		string $subtitle
	) {
		$this->items    = $items;
		$this->name     = $name;
		$this->slug     = $slug;
		$this->icon     = $icon;
		$this->subtitle = $subtitle;
	}

	/**
	 * @return string
	 */
	public function get_title(): string {
		return $this->title;
	}

	/**
	 * @return string
	 */
	public function get_icon(): string {
		return $this->icon;
	}

	/**
	 * @return string
	 */
	public function get_subtitle(): string {
		return $this->subtitle;
	}

	/**
	 * @return Payment_Method_Item[]
	 */
	public function get_items(): array {
		return $this->items;
	}

	/**
	 * @return string
	 */
	public function get_name(): string {
		return $this->name;
	}

	/**
	 * @return string
	 */
	public function get_slug(): string {
		return $this->slug;
	}

	public function push_item( Payment_Method_Item $item ) {
		$items       = $this->items;
		$items[]     = $item;
		$this->items = $items;
	}


}
