<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\Gateway\Woocommerce_Blocks;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use Exception;
use Simplyin\Simplyin_W_Plugin\Payments\Gateway\Model\Session_Data;
use Simplyin\Simplyin_W_Plugin\Payments\Gateway\Payment_Fields\Payment_Fields;
use Simplyin\Simplyin_W_Plugin\Payments\Gateway\Simplyin_Gateway;


/**
 *
 * @since 1.0.3
 */
final class Payment_Blocks_Support extends AbstractPaymentMethodType {

	/**
	 * @var string
	 */
	protected $name = 'simplyin';

	private Simplyin_Gateway $gateway;

	/**
	 *
	 * @var array
	 */
	protected $settings = [];

	public function initialize() {
		$gateways = WC()->payment_gateways->payment_gateways();

		if ( ! isset( $gateways[ $this->name ] ) ) {
			return;
		}

		$this->gateway = $gateways[ $this->name ];
	}

	/**
	 * @return boolean
	 */
	public function is_active(): bool {
		if ( ! $this->gateway ) {
			return false;
		}

		return $this->gateway->is_available();
	}

	/**
	 * @return array
	 * @throws Exception
	 */
	public function get_payment_method_script_handles() {
		$script_path       = 'blocks/payments/assets/js/frontend/blocks.js';
		$script_path_css   = 'blocks/payments/assets/js/frontend/blocks-styles.css';
		$script_asset_path = simplyin()->get_plugin_dir() . '/blocks/payments/assets/js/frontend/blocks.asset.php';
		$script_asset      = file_exists( $script_asset_path )
			? require( $script_asset_path )
			: [
				'dependencies' => [],
				'version'      => '5.0.3',
			];
		$script_url        = simplyin()->get_plugin_url() . $script_path;
		$script_url_css    = simplyin()->get_plugin_url() . $script_path_css;

		wp_register_script(
			'simplyin-payments-blocks',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);

		wp_enqueue_style(
			'simplyin-payments-blocks-css',
			$script_url_css,
			[],
			time()
		);

		if ( function_exists( 'wp_set_script_translations' ) ) {
			$result = wp_set_script_translations( 'simplyin-payments-blocks',
				simplyin()->get_text_domain(),
				simplyin()->get_plugin_dir() . simplyin()->get_from_config( 'lang_dir' ) );
		}

		return [ 'simplyin-payments-blocks' ];
	}

	public function get_payment_method_data(): array {
		try {

			$payment_fields = new Payment_Fields();
			$payment_fields->reload();
			$session_data = new Session_Data();
			$provider     = $session_data->get_payment_provider();

			return [
				'title'                    => $this->gateway->get_title(),
				'description'              => $this->gateway->get_method_description(),
				'icon_src'                 => simplyin()->get_plugin_images_url() . "/../../public/img/logo_smalln.svg",
				'place_order_button_label' => __( 'Simple and Safe payments',
					'simplyin' ),
				'supports'                 => array_filter( $this->gateway->supports,
					[ $this->gateway, 'supports' ] ),
				'channels'                 => [],
				'payment_provider'         => $provider,
				'messages'                 => [
					'no_payment_selected'         => __( 'No payment channel selected.',
						'simplyin' ),
					'blik_code_is_invalid'        => __( 'BLIK code is invalid.',
						'simplyin' ),
					/* translators: %s: last 4 digits of the card number. */
					'saved_card_description'      => __( 'Saved card ending with %s',
						'simplyin' ),
					'loading_iframe'              => __( 'Loading form...',
						'simplyin' ),
					'iframe_loaded'               => __( 'Form loaded',
						'simplyin' ),
					'iframe_error'                => __( 'Form loading error',
						'simplyin' ),
					'loading_error'               => __( 'Form loading error',
						'simplyin' ),
					'card_name'                   => __( 'Card name',
						'simplyin' ),
					'card_name_placeholder'       => __( 'My card',
						'simplyin' ),
					'card_holder_name'            => __( 'Card holder name',
						'simplyin' ),
					'card_number'                 => __( 'Card number',
						'simplyin' ),
					'expiry_date'                 => __( 'Expiry date',
						'simplyin' ),
					'code_cvv_cvc'                => __( 'Code CVV/CVC',
						'simplyin' ),
					'card_data_valid'             => __( 'Card data is valid. You can place the order.',
						'simplyin' ),
					'card_processing_error'       => __( 'Card data processing error. Check entered data.',
						'simplyin' ),
					'card_processing_error_retry' => __( 'Card data processing error. Try again.',
						'simplyin' ),
					'invalid_card_data'           => __( 'Invalid card data. Check entered information.',
						'simplyin' ),
					'connection_problem'          => __( 'Connection problem. Check internet and try again.',
						'simplyin' ),
					'save_card'                   => __( 'Save card for future payments',
						'simplyin' ),

					'provider' => [
						'by_paying_i_accept_the' => __( 'By paying, I accept the',
							'simplyin' ),
						'terms_and_conditions'   => __( 'terms and conditions',
							'simplyin' ),
						'and'                    => __( 'and',
							'simplyin' ),
						'privacy_policy'         => __( 'privacy policy',
							'simplyin' ),
						'of'                     => ( ( $str = __( 'of',
							'simplyin' ) ) === '\0' ? '' : $str ),
					],

				],
				'adminAjaxUrl'             => esc_url( admin_url( 'admin-ajax.php' ) ),
				'nonce'                    => wp_create_nonce( 'simplyin_blocks_nonce' ),
			];


		} catch ( Exception $exception ) {
			return [
				'title'                    => $this->gateway->get_title(),
				'description'              => $this->gateway->get_method_description(),
				'icon_src'                 => simplyin()->get_plugin_images_url() . "/../../public/img/logo_smalln.svg",
				'place_order_button_label' => __( 'Simple and Safe payments',
					'simplyin' ),
				'supports'                 => array_filter( $this->gateway->supports,
					[ $this->gateway, 'supports' ] ),
				'channels'                 => [],
				'messages'                 => [
					'no_payment_selected'    => __( 'No payment channel selected.',
						'simplyin' ),
					'blik_code_is_invalid'   => __( 'BLIK code is invalid.',
						'simplyin' ),
					/* translators: %s: last 4 digits of the card number. */
					'saved_card_description' => __( 'Saved card ending with %s',
						'simplyin' ),
				],
				'adminAjaxUrl'             => esc_url( admin_url( 'admin-ajax.php' ) ),
			];
		}
	}


	public static function get_channels_for_blocks(): array {
		try {
			$payment_fields = new Payment_Fields();

			return (array) $payment_fields->get_blocks_payment_fields();
		} catch ( Exception $exception ) {
			return [];
		}

	}
}
