<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\Gateway\Model;

class Payment_Method {


	/**
	 * @var string
	 */
	public $id;


	/**
	 * @var string
	 */
	public $slug;

	/**
	 * @var string
	 */
	public $type;

	/**
	 * @var string
	 */
	public $name;


	/**
	 * @var string
	 */
	public ?string $logo_url;


	/**
	 * @var string
	 */
	public $provider_id;

	/**
	 * @var string
	 */
	public $provider_name;

	/**
	 * @var string
	 */
	public ?string $provider_logo_url;

	/**
	 * @param string $id
	 * @param string $slug
	 * @param string $type
	 * @param string $name
	 * @param string|null $logo_url
	 * @param string $provider_id
	 * @param string $provider_name
	 * @param string|null $provider_logo_url
	 */
	public function __construct(
		string $id,
		string $slug,
		string $type,
		string $name,
		?string $logo_url,
		string $provider_id,
		string $provider_name,
		?string $provider_logo_url
	) {
		$this->id                = $id;
		$this->slug              = $slug;
		$this->type              = $type;
		$this->name              = $name;
		$this->logo_url          = $logo_url;
		$this->provider_id       = $provider_id;
		$this->provider_name     = $provider_name;
		$this->provider_logo_url = $provider_logo_url;
	}


	public function get_id(): string {
		return $this->id;
	}

	public function get_slug(): string {
		return $this->slug;
	}

	public function get_type(): string {
		return $this->type;
	}

	public function get_name(): string {
		return $this->name;
	}

	public function get_logo_url(): ?string {
		return $this->logo_url;
	}

	public function get_provider_id(): string {
		return $this->provider_id;
	}

	public function get_provider_name(): string {
		return $this->provider_name;
	}

	public function get_provider_logo_url(): ?string {
		return $this->provider_logo_url;
	}

}
