<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\Gateway\Model;

use Simplyin\Simplyin_W_Plugin\Lib\Session\Simplyin_Session;

abstract class Abstract_Payment extends Payment_Method {

	protected ?string $payment_uuid = null;
	protected int $order_id;
	protected ?string $payment_status = null;
	protected ?string $provider_payment_id = null;
	protected ?string $registered_at = null;
	protected ?string $redirect_url = null;
	protected ?string $customer_error_message = null;


	protected function generate_random_uuid( $data = null ) {
		$data = $data ?? random_bytes( 16 );
		assert( strlen( $data ) == 16 );
		$data[6] = chr( ord( $data[6] ) & 0x0f | 0x40 );
		$data[8] = chr( ord( $data[8] ) & 0x3f | 0x80 );

		return vsprintf( '%s%s-%s-%s-%s-%s%s%s',
			str_split( bin2hex( $data ), 4 ) );
	}


	protected function is_simplyin_user_logged(): bool {
		$token = ( new Simplyin_Session() )->get( 'simplyin_auth_token' );

		return ! empty( $token );
	}

	public function get_payment_uuid(): ?string {
		return $this->payment_uuid;
	}

	public function get_order_id(): int {
		return $this->order_id;
	}

	public function get_payment_status(): ?string {
		return $this->payment_status;
	}

	public function get_provider_payment_id(): ?string {
		return $this->provider_payment_id;
	}

	public function get_registered_at(): ?string {
		return $this->registered_at;
	}

	public function get_redirect_url(): ?string {
		return $this->redirect_url;
	}

	public function get_customer_error_message(): ?string {
		return $this->customer_error_message;
	}
}
