<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\Gateway;

use Exception;
use WC_Order;

class Gateway_Helper {

	public static function normalize_price( $price ): float {
		$optionPrice = wc_format_decimal( $price,
			2 );

		return abs( ( floatval( $optionPrice ) ) );
	}

	public static function get_webhook_url( WC_Order $order ): string {
		$site_url  = get_site_url() . '/';
		$order_key = $order->get_order_key();

		return add_query_arg( [
			'wc-api'    => 'wc_gateway_simplyin',
			'order'     => $order->get_id(),
			'order_key' => $order_key,
		],
			$site_url );
	}

	public static function get_current_url(): string {
		global $wp;

		return add_query_arg( $wp->query_vars,
			home_url( $wp->request ) );
	}
}
