<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\Ajax\Card;


use Simplyin\Simplyin_W_Plugin\Payments\Ajax\Abstract_Ajax_Response;

class Card_Get_Status_Ajax_Response extends Abstract_Ajax_Response {

	private const PAYMENT_STATUS_SUCCESS = 'SUCCESS';

	private const PAYMENT_STATUS_FAILURE = 'FAILURE';

	private const PAYMENT_STATUS_PENDING = 'PENDING';

	protected string $payment_status = '';

	public function set_payment_status_success() {
		$this->payment_status = self::PAYMENT_STATUS_SUCCESS;

	}

	public function set_payment_status_failure() {
		$this->payment_status = self::PAYMENT_STATUS_FAILURE;

	}


	public function set_payment_status_pending() {
		$this->payment_status = self::PAYMENT_STATUS_PENDING;

	}

	protected function get_array(): array {
		$to_return = [
			'payment_status' => $this->payment_status,
		];

		if ( $this->customer_error_message ) {
			$to_return = array_merge( $to_return, [
				'customer_error_message' => $this->customer_error_message,
			] );
		}

		return $to_return;
	}
}
