<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\Ajax;

class Ajax_Helper {

	public static function get_fields( array $data, array $keys ): array {
		$result = [];

		foreach ( $keys as $key_data ) {
			if ( $key_data['required'] ) {
				if ( ! key_exists( $key_data['name'], $data ) ) {

					throw new \Exception( 'Bad request' );
				} else {
					switch ( $key_data['type'] ) {

						case 'text':
							$result[ $key_data['name'] ] = sanitize_text_field( $data[ $key_data['name'] ] );
							break;
						case 'int':
							$result[ $key_data['name'] ] = (int) ( $data[ $key_data['name'] ] );
							break;
						case 'bool':
							$result[ $key_data['name'] ] = 'true' === (string) $data[ $key_data['name'] ];
							break;
					}

				}

			} else {
				$result[ $key_data['name'] ] = $key_data['default'];
			}


		}

		return $result;
	}
}
