<?php

namespace Simplyin\Simplyin_W_Plugin\Payments\Ajax;

abstract class Abstract_Ajax_Response {

	protected bool $is_error = false;
	protected ?string $customer_error_message = null;

	abstract protected function get_array(): array;

	public function get_customer_error_message(): ?string {
		return $this->customer_error_message;
	}

	public function set_customer_error_message( ?string $customer_error_message
	): void {
		$this->customer_error_message = $customer_error_message;
	}

	public function to_array() {

		$to_return = $this->get_array();
		$to_return = array_merge( $to_return, [
			'is_error' => $this->is_error,
		] );

		return $to_return;
	}

	public function send_json_exit() {
		$response_arr = $this->to_array();

		wp_send_json( $response_arr );
		die;
	}

	public function is_error(): bool {
		return $this->is_error;
	}

	public function set_is_error( bool $is_error ): void {
		$this->is_error = $is_error;
	}
}
