<?php
/**
 * PaymentsPay200Response
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Simplyin\Simplyin_W_Plugin\Lib\Remote\SimplyInApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Simply.in API
 *
 * Swagger documentation for SIMPLY.IN
 *
 * The version of the OpenAPI document: 1.99.21 (preprod)
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Simplyin\Simplyin_W_Plugin\Lib\Remote\SimplyInApi\Model;

use \ArrayAccess;
use \Simplyin\Simplyin_W_Plugin\Lib\Remote\SimplyInApi\ObjectSerializer;

/**
 * PaymentsPay200Response Class Doc Comment
 *
 * @category Class
 * @package  Simplyin\Simplyin_W_Plugin\Lib\Remote\SimplyInApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentsPay200Response implements ModelInterface, ArrayAccess, \JsonSerializable {

	public const DISCRIMINATOR = null;

	/**
	 * The original name of the model.
	 *
	 * @var string
	 */
	protected static $openAPIModelName = 'payments_pay_200_response';

	/**
	 * Array of property to type mappings. Used for (de)serialization
	 *
	 * @var string[]
	 */
	protected static $openAPITypes = [
		'status'                  => 'string',
		'payment_id'              => 'string',
		'provider_payment_id'     => 'string',
		'registered_at'           => 'string',
		'redirect_url'            => 'string',
		'redirect_iframe_allowed' => 'bool',
	];

	/**
	 * Array of property to format mappings. Used for (de)serialization
	 *
	 * @var string[]
	 * @phpstan-var array<string, string|null>
	 * @psalm-var array<string, string|null>
	 */
	protected static $openAPIFormats = [
		'status'                  => null,
		'payment_id'              => null,
		'provider_payment_id'     => null,
		'registered_at'           => null,
		'redirect_url'            => 'uri',
		'redirect_iframe_allowed' => null,
	];

	/**
	 * Array of nullable properties. Used for (de)serialization
	 *
	 * @var boolean[]
	 */
	protected static array $openAPINullables = [
		'status'                  => false,
		'payment_id'              => false,
		'provider_payment_id'     => false,
		'registered_at'           => false,
		'redirect_url'            => false,
		'redirect_iframe_allowed' => false,
	];

	/**
	 * If a nullable field gets set to null, insert it here
	 *
	 * @var boolean[]
	 */
	protected array $openAPINullablesSetToNull = [];

	/**
	 * Array of property to type mappings. Used for (de)serialization
	 *
	 * @return array
	 */
	public static function openAPITypes() {
		return self::$openAPITypes;
	}

	/**
	 * Array of property to format mappings. Used for (de)serialization
	 *
	 * @return array
	 */
	public static function openAPIFormats() {
		return self::$openAPIFormats;
	}

	/**
	 * Array of nullable properties
	 *
	 * @return array
	 */
	protected static function openAPINullables(): array {
		return self::$openAPINullables;
	}

	/**
	 * Array of nullable field names deliberately set to null
	 *
	 * @return boolean[]
	 */
	private function getOpenAPINullablesSetToNull(): array {
		return $this->openAPINullablesSetToNull;
	}

	/**
	 * Setter - Array of nullable field names deliberately set to null
	 *
	 * @param boolean[] $openAPINullablesSetToNull
	 */
	private function setOpenAPINullablesSetToNull(
		array $openAPINullablesSetToNull
	): void {
		$this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
	}

	/**
	 * Checks if a property is nullable
	 *
	 * @param string $property
	 *
	 * @return bool
	 */
	public static function isNullable( string $property ): bool {
		return self::openAPINullables()[ $property ] ?? false;
	}

	/**
	 * Checks if a nullable property is set to null.
	 *
	 * @param string $property
	 *
	 * @return bool
	 */
	public function isNullableSetToNull( string $property ): bool {
		return in_array( $property,
			$this->getOpenAPINullablesSetToNull(),
			true );
	}

	/**
	 * Array of attributes where the key is the local name,
	 * and the value is the original name
	 *
	 * @var string[]
	 */
	protected static $attributeMap = [
		'status'                  => 'status',
		'payment_id'              => 'paymentId',
		'provider_payment_id'     => 'providerPaymentId',
		'registered_at'           => 'registeredAt',
		'redirect_url'            => 'redirectUrl',
		'redirect_iframe_allowed' => 'redirectIframeAllowed',
	];

	/**
	 * Array of attributes to setter functions (for deserialization of responses)
	 *
	 * @var string[]
	 */
	protected static $setters = [
		'status'                  => 'setStatus',
		'payment_id'              => 'setPaymentId',
		'provider_payment_id'     => 'setProviderPaymentId',
		'registered_at'           => 'setRegisteredAt',
		'redirect_url'            => 'setRedirectUrl',
		'redirect_iframe_allowed' => 'setRedirectIframeAllowed',
	];

	/**
	 * Array of attributes to getter functions (for serialization of requests)
	 *
	 * @var string[]
	 */
	protected static $getters = [
		'status'                  => 'getStatus',
		'payment_id'              => 'getPaymentId',
		'provider_payment_id'     => 'getProviderPaymentId',
		'registered_at'           => 'getRegisteredAt',
		'redirect_url'            => 'getRedirectUrl',
		'redirect_iframe_allowed' => 'getRedirectIframeAllowed',
	];

	/**
	 * Array of attributes where the key is the local name,
	 * and the value is the original name
	 *
	 * @return array
	 */
	public static function attributeMap() {
		return self::$attributeMap;
	}

	/**
	 * Array of attributes to setter functions (for deserialization of responses)
	 *
	 * @return array
	 */
	public static function setters() {
		return self::$setters;
	}

	/**
	 * Array of attributes to getter functions (for serialization of requests)
	 *
	 * @return array
	 */
	public static function getters() {
		return self::$getters;
	}

	/**
	 * The original name of the model.
	 *
	 * @return string
	 */
	public function getModelName() {
		return self::$openAPIModelName;
	}

	public const STATUS_PENDING = 'PENDING';

	public const STATUS_PAID = 'PAID';

	public const STATUS_CANCELED = 'CANCELED';

	public const STATUS_REJECTED = 'REJECTED';

	public const STATUS_REFUNDED = 'REFUNDED';

	/**
	 * Gets allowable values of the enum
	 *
	 * @return string[]
	 */
	public function getStatusAllowableValues() {
		return [
			self::STATUS_PENDING,
			self::STATUS_PAID,
			self::STATUS_CANCELED,
			self::STATUS_REJECTED,
			self::STATUS_REFUNDED,
		];
	}

	/**
	 * Associative array for storing property values
	 *
	 * @var mixed[]
	 */
	protected $container = [];

	/**
	 * Constructor
	 *
	 * @param mixed[]|null $data Associated array of property values
	 *                      initializing the model
	 */
	public function __construct( ?array $data = null ) {
		$this->setIfExists( 'status', $data ?? [], null );
		$this->setIfExists( 'payment_id', $data ?? [], null );
		$this->setIfExists( 'provider_payment_id', $data ?? [], null );
		$this->setIfExists( 'registered_at', $data ?? [], null );
		$this->setIfExists( 'redirect_url', $data ?? [], null );
		$this->setIfExists( 'redirect_iframe_allowed', $data ?? [], null );
	}

	/**
	 * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
	 * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
	 * $this->openAPINullablesSetToNull array
	 *
	 * @param string $variableName
	 * @param array $fields
	 * @param mixed $defaultValue
	 */
	private function setIfExists(
		string $variableName,
		array $fields,
		$defaultValue
	): void {
		if ( self::isNullable( $variableName ) && array_key_exists( $variableName,
				$fields ) && is_null( $fields[ $variableName ] ) ) {
			$this->openAPINullablesSetToNull[] = $variableName;
		}

		$this->container[ $variableName ] = $fields[ $variableName ] ?? $defaultValue;
	}

	/**
	 * Show all the invalid properties with reasons.
	 *
	 * @return array invalid properties with reasons
	 */
	public function listInvalidProperties() {
		$invalidProperties = [];

		if ( $this->container['status'] === null ) {
			$invalidProperties[] = "'status' can't be null";
		}
		$allowedValues = $this->getStatusAllowableValues();
		if ( ! is_null( $this->container['status'] ) && ! in_array( $this->container['status'],
				$allowedValues,
				true ) ) {
			$invalidProperties[] = sprintf(
				"invalid value '%s' for 'status', must be one of '%s'",
				$this->container['status'],
				implode( "', '", $allowedValues )
			);
		}

		if ( $this->container['payment_id'] === null ) {
			$invalidProperties[] = "'payment_id' can't be null";
		}
		if ( $this->container['provider_payment_id'] === null ) {
			$invalidProperties[] = "'provider_payment_id' can't be null";
		}
		if ( $this->container['registered_at'] === null ) {
			$invalidProperties[] = "'registered_at' can't be null";
		}

		return $invalidProperties;
	}

	/**
	 * Validate all the properties in the model
	 * return true if all passed
	 *
	 * @return bool True if all properties are valid
	 */
	public function valid() {
		return count( $this->listInvalidProperties() ) === 0;
	}


	/**
	 * Gets status
	 *
	 * @return string
	 */
	public function getStatus() {
		return $this->container['status'];
	}

	/**
	 * Sets status
	 *
	 * @param string $status status
	 *
	 * @return self
	 */
	public function setStatus( $status ) {
		if ( is_null( $status ) ) {
			throw new \InvalidArgumentException( 'non-nullable status cannot be null' );
		}
		$allowedValues = $this->getStatusAllowableValues();
		if ( ! in_array( $status, $allowedValues, true ) ) {
			throw new \InvalidArgumentException(
				esc_html( sprintf(
					"Invalid value '%s' for 'status', must be one of '%s'",
					$status,
					implode( "', '", $allowedValues )
				) )
			);
		}
		$this->container['status'] = $status;

		return $this;
	}

	/**
	 * Gets payment_id
	 *
	 * @return string
	 */
	public function getPaymentId() {
		return $this->container['payment_id'];
	}

	/**
	 * Sets payment_id
	 *
	 * @param string $payment_id payment_id
	 *
	 * @return self
	 */
	public function setPaymentId( $payment_id ) {
		if ( is_null( $payment_id ) ) {
			throw new \InvalidArgumentException( 'non-nullable payment_id cannot be null' );
		}
		$this->container['payment_id'] = $payment_id;

		return $this;
	}

	/**
	 * Gets provider_payment_id
	 *
	 * @return string
	 */
	public function getProviderPaymentId() {
		return $this->container['provider_payment_id'];
	}

	/**
	 * Sets provider_payment_id
	 *
	 * @param string $provider_payment_id provider_payment_id
	 *
	 * @return self
	 */
	public function setProviderPaymentId( $provider_payment_id ) {
		if ( is_null( $provider_payment_id ) ) {
			throw new \InvalidArgumentException( 'non-nullable provider_payment_id cannot be null' );
		}
		$this->container['provider_payment_id'] = $provider_payment_id;

		return $this;
	}

	/**
	 * Gets registered_at
	 *
	 * @return string
	 */
	public function getRegisteredAt() {
		return $this->container['registered_at'];
	}

	/**
	 * Sets registered_at
	 *
	 * @param string $registered_at registered_at
	 *
	 * @return self
	 */
	public function setRegisteredAt( $registered_at ) {
		if ( is_null( $registered_at ) ) {
			throw new \InvalidArgumentException( 'non-nullable registered_at cannot be null' );
		}
		$this->container['registered_at'] = $registered_at;

		return $this;
	}

	/**
	 * Gets redirect_url
	 *
	 * @return string|null
	 */
	public function getRedirectUrl() {
		return $this->container['redirect_url'];
	}

	/**
	 * Sets redirect_url
	 *
	 * @param string|null $redirect_url redirect_url
	 *
	 * @return self
	 */
	public function setRedirectUrl( $redirect_url ) {
		if ( is_null( $redirect_url ) ) {
			throw new \InvalidArgumentException( 'non-nullable redirect_url cannot be null' );
		}
		$this->container['redirect_url'] = $redirect_url;

		return $this;
	}

	/**
	 * Gets redirect_iframe_allowed
	 *
	 * @return bool|null
	 */
	public function getRedirectIframeAllowed() {
		return $this->container['redirect_iframe_allowed'];
	}

	/**
	 * Sets redirect_iframe_allowed
	 *
	 * @param bool|null $redirect_iframe_allowed redirect_iframe_allowed
	 *
	 * @return self
	 */
	public function setRedirectIframeAllowed( $redirect_iframe_allowed ) {
		if ( is_null( $redirect_iframe_allowed ) ) {
			throw new \InvalidArgumentException( 'non-nullable redirect_iframe_allowed cannot be null' );
		}
		$this->container['redirect_iframe_allowed'] = $redirect_iframe_allowed;

		return $this;
	}

	/**
	 * Returns true if offset exists. False otherwise.
	 *
	 * @param integer $offset Offset
	 *
	 * @return boolean
	 */
	public function offsetExists( $offset ): bool {
		return isset( $this->container[ $offset ] );
	}

	/**
	 * Gets offset.
	 *
	 * @param integer $offset Offset
	 *
	 * @return mixed|null
	 */
	#[\ReturnTypeWillChange]
	public function offsetGet( $offset ) {
		return $this->container[ $offset ] ?? null;
	}

	/**
	 * Sets value based on offset.
	 *
	 * @param int|null $offset Offset
	 * @param mixed $value Value to be set
	 *
	 * @return void
	 */
	public function offsetSet( $offset, $value ): void {
		if ( is_null( $offset ) ) {
			$this->container[] = $value;
		} else {
			$this->container[ $offset ] = $value;
		}
	}

	/**
	 * Unsets offset.
	 *
	 * @param integer $offset Offset
	 *
	 * @return void
	 */
	public function offsetUnset( $offset ): void {
		unset( $this->container[ $offset ] );
	}

	/**
	 * Serializes the object to a value that can be serialized natively by json_encode().
	 *
	 * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
	 *
	 * @return mixed Returns data which can be serialized by json_encode(), which is a value
	 * of any type other than a resource.
	 */
	#[\ReturnTypeWillChange]
	public function jsonSerialize() {
		return ObjectSerializer::sanitizeForSerialization( $this );
	}

	/**
	 * Gets the string presentation of the object
	 *
	 * @return string
	 */
	public function __toString() {
		return json_encode(
			ObjectSerializer::sanitizeForSerialization( $this ),
			JSON_PRETTY_PRINT
		);
	}

	/**
	 * Gets a header-safe presentation of the object
	 *
	 * @return string
	 */
	public function toHeaderValue() {
		return json_encode( ObjectSerializer::sanitizeForSerialization( $this ) );
	}
}
