<?php

namespace Simplyin\Simplyin_W_Plugin;

use Simplyin\Simplyin_W_Plugin\Admin\SimplyIn_Admin;
use Simplyin\Simplyin_W_Plugin\Sync\Simplyin_Sync;


class Legacy_App {

	/**
	 * The loader that's responsible for maintaining and registering all hooks
	 * that power the plugin.
	 *
	 * @var      SimplyIn_Loader $loader Maintains and registers all hooks for
	 *     the plugin.
	 * @since    1.0.0
	 * @access   protected
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @var      string $plugin_name The string used to uniquely identify this
	 *     plugin.
	 * @since    1.0.0
	 * @access   protected
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @var      string $version The current version of the plugin.
	 * @since    1.0.0
	 * @access   protected
	 */
	protected $version;

	public function __construct() {
		if ( defined( 'SIMPLYIN_VERSION' ) ) {
			$this->version = SIMPLYIN_VERSION;
		} else {
			$this->version = '1.0.0';
		}

		$this->plugin_name = 'simplyin';

		$this->load_dependencies();

		$this->defineAdminHooks();
		$this->defineSyncHooks();

	}

	/**
	 * @var Simplyin_Sync
	 */
	public $sync;

	private function load_dependencies() {

		$this->loader = new SimplyIn_Loader();
	}

	private function defineAdminHooks() {

		$plugin_admin = new SimplyIn_Admin( $this->get_plugin_name(),
			$this->get_version() );
	}

	private function defineSyncHooks() {
		$this->sync = new Simplyin_Sync( $this->get_plugin_name(),
			$this->get_version() );
	}

	public function run() {
		$this->loader->run();
	}


	public function get_plugin_name() {
		return $this->plugin_name;
	}

	public function get_version() {
		return $this->version;
	}
}
