<?php

namespace Simplyin\Simplyin_W_Plugin\Hooks;

use Simplyin\Simplyin_W_Plugin\Shipping_Mapping\Mapping;
use Simplyin\Simplyin_W_Plugin\Tracking_Numbers;
use WC_Cart;
use WC_Order;

class Hooks {

	public function init() {
		add_action( 'woocommerce_checkout_order_created',
			[ $this, 'woocommerce_checkout_order_created' ],
			10,
			1 );

		add_action( 'woocommerce_store_api_checkout_order_processed',
			[ $this, 'woocommerce_checkout_order_created_in_blocks' ],
			10,
			1 );

		add_action( 'woocommerce_review_order_after_order_total',
			[ $this, 'woocommerce_checkout_init' ],
			10,
			0 );

		add_action( 'woocommerce_store_api_cart_update_order_from_request',
			[ $this, 'woocommerce_checkout_init' ],
			10,
			0 );


		add_action( 'flexible_shipping_shipment_confirmed',
			[ $this, 'flexible_shipping_shipment_confirmed' ],
			10,
			1 );


	}

	public function woocommerce_checkout_init() {
		$shipping_mapping = new Mapping();
		$shipping_mapping->handle_checkout();

	}

	public function woocommerce_checkout_order_created( WC_Order $order ) {
		( new simplyInOnOrderCreate() )->run( $order );
	}

	public function woocommerce_checkout_order_created_in_blocks(
		WC_Order $order
	) {
		( new simplyInOnOrderCreate() )->run( $order );
	}

	public function flexible_shipping_shipment_confirmed(
		$flexible_shipping_shipment
	) {

		( new Fs_Shipment() )->handle_shipment_confirmed( $flexible_shipping_shipment );

	}


}
