<?php

namespace Simplyin\Simplyin_W_Plugin\Hooks;

use Simplyin\Simplyin_W_Plugin\Tracking_Numbers;
use WC_Order;

class Fs_Shipment {

	public function handle_shipment_confirmed( $flexible_shipping_shipment ) {
		$log = simplyin()
			->get_simplyin_logger();

		if ( $flexible_shipping_shipment instanceof \WPDesk_Flexible_Shipping_Shipment_Interface ) {
			$order = $flexible_shipping_shipment->get_order();

			if ( $order instanceof WC_Order ) {
				$simplyin_order_id = $order->get_meta( 'SimplyInOrderId' );
				if ( empty( $simplyin_order_id ) ) {
					return;//skip no-simplyin order
				}

				$tracking_number = $flexible_shipping_shipment->get_tracking_number();

				( new Tracking_Numbers() )->update_tracking_numbers(
					[ $tracking_number ],
					$flexible_shipping_shipment->get_integration(),
					$order );

				$log->log_if_wpdebug_on( sprintf( "[Fs_Shipment] [handle_shipment_confirmed] action hooks done [%s]",
					wp_json_encode( [
						'class passed to callback' => get_class( $flexible_shipping_shipment ),
						'order_id'                 => $order->get_id(),
					] )

				) );


			} else {
				$log->log_if_wpdebug_on( sprintf( "[Fs_Shipment] [handle_shipment_confirmed] Failure [%s]",
					wp_json_encode( [
						'reason' => 'order is not wc_order',
						'order'  => $order,

					] )

				) );
			}

		} else {
			$log->log_if_wpdebug_on( sprintf( "[Fs_Shipment] [handle_shipment_confirmed] Failure [%s]",
				wp_json_encode( [
					'reason'    => 'invalid type of passed flexible_shipping_shipment',
					'classname' => get_class( $flexible_shipping_shipment ),

				] ) ) );
		}
	}
}
