<?php

namespace Simplyin\Simplyin_W_Plugin\Dto\Order;

class Shipping_Data_DTO {

	protected ?string $id = null;
	protected string $icon;
	protected string $address_name;
	protected string $name;
	protected string $surname;
	protected string $street;
	protected string $appartment_number;
	protected string $city;
	protected string $postal_code;
	protected string $country;
	protected string $state;
	protected string $company_name;

	public function to_array(): array {
		$return = [
			"icon"             => $this->icon,
			"addressName"      => $this->address_name,
			"name"             => $this->name,
			"surname"          => $this->surname,
			"street"           => $this->street,
			"appartmentNumber" => $this->appartment_number,
			"city"             => $this->city,
			"postalCode"       => $this->postal_code,
			"country"          => $this->country,
			"state"            => $this->state,
			"companyName"      => $this->company_name,
		];

		if ( $this->id ) {
			$return['_id'] = $this->id;
		}

		return $return;

	}

	public function set_icon( string $icon ): void {
		$this->icon = $icon;
	}

	public function set_address_name( string $address_name ): void {
		$this->address_name = $address_name;
	}

	public function set_name( string $name ): void {
		$this->name = $name;
	}

	public function set_surname( string $surname ): void {
		$this->surname = $surname;
	}

	public function set_street( string $street ): void {
		$this->street = $street;
	}

	public function set_appartment_number( string $appartment_number ): void {
		$this->appartment_number = $appartment_number;
	}

	public function set_city( string $city ): void {
		$this->city = $city;
	}

	public function set_postal_code( string $postal_code ): void {
		$this->postal_code = $postal_code;
	}

	public function set_country( string $country ): void {
		$this->country = $country;
	}

	public function set_state( string $state ): void {
		$this->state = $state;
	}

	public function set_company_name( string $company_name ): void {
		$this->company_name = $company_name;
	}

	public function set_id( ?string $id ): void {
		$this->id = $id;
	}
}
