<?php

namespace Simplyin\Simplyin_W_Plugin\Dto\Order;

class Parcel_Locker_Data_DTO {

	protected ?string $id;
	protected ?string $provider_id;
	protected ?string $service_type;
	protected ?string $logo_url;
	protected ?string $icon;
	protected ?string $address_name;
	protected ?string $coordinates_lat;
	protected ?string $coordinates_long;
	protected string $label;
	protected string $locker_id;
	protected string $address;
	protected ?string $desc;




	public function to_array() {
		$return = [
			'label'     => $this->label,
			'lockerId' => $this->locker_id,
			'address'   => $this->address,
		];

		if ( $this->id ) {
			$return['_id'] = $this->id;
		}

		if ( $this->provider_id ) {
			$return['providerId'] = $this->provider_id;
		}

		if ( $this->service_type ) {
			$return['service_type'] = $this->service_type;
		}

		if ( $this->logo_url ) {
			$return['logoUrl'] = $this->logo_url;
		}

		if ( $this->icon ) {
			$return['icon'] = $this->icon;
		}

		if ( $this->address_name ) {
			$return['addressName'] = $this->address_name;
		}

		if ( $this->coordinates_long && $this->coordinates_lat ) {
			$return['coordinates'] = [
				'latitude'  => $this->coordinates_lat,
				'longitude' => $this->coordinates_long,
			];
		}

		if ( $this->desc ) {
			$return['desc'] = $this->desc;
		}

		return $return;

	}

	public function set_id( ?string $id ): void {
		$this->id = $id;
	}

	public function set_provider_id( ?string $provider_id ): void {
		$this->provider_id = $provider_id;
	}

	public function set_service_type( ?string $service_type ): void {
		$this->service_type = $service_type;
	}

	public function set_logo_url( ?string $logo_url ): void {
		$this->logo_url = $logo_url;
	}

	public function set_icon( ?string $icon ): void {
		$this->icon = $icon;
	}

	public function set_address_name( ?string $address_name ): void {
		$this->address_name = $address_name;
	}

	public function set_coordinates_lat( ?string $coordinates_lat ): void {
		$this->coordinates_lat = $coordinates_lat;
	}

	public function set_coordinates_long( ?string $coordinates_long ): void {
		$this->coordinates_long = $coordinates_long;
	}

	public function set_label( string $label ): void {
		$this->label = $label;
	}

	public function set_locker_id( string $locker_id ): void {
		$this->locker_id = $locker_id;
	}

	public function set_address( string $address ): void {
		$this->address = $address;
	}

	public function set_desc( ?string $desc ): void {
		$this->desc = $desc;
	}
}
