<?php

namespace Simplyin\Simplyin_W_Plugin\Dto\Order;

use Simplyin\Simplyin_W_Plugin\Dto\Abstract_Item_DTO;

class Order_Items_DTO extends Abstract_Item_DTO {

	/**
	 * @var Order_Item_DTO[]
	 */
	protected array $order_items = [];

	public function push( Order_Item_DTO $order_item ) {
		$this->order_items[] = $order_item;
	}

	public function to_array(): array {

		$return = [];

		foreach ( $this->order_items as $item ) {
			$return[] = $item->to_array();
		}

		return $return;
	}

	/**
	 * @return Order_Item_DTO[]
	 */
	public function get_order_items(): array {
		return $this->order_items;
	}
}
