<?php

namespace Simplyin\Simplyin_W_Plugin\Dto\Order;

use Simplyin\Simplyin_W_Plugin\Dto\Abstract_Item_DTO;

class Order_Item_DTO extends Abstract_Item_DTO {

	protected string $name;
	protected string $url;
	protected float $price_net;
	protected float $price;
	protected float $tax_amount;
	protected float $tax_rate;
	protected int $quantity;
	protected string $thumbnail_url;
	protected string $currency;

	public function to_array(): array {
		return [
			'name'         => $this->name,
			'url'          => $this->url,
			'price_net'    => $this->price_net,
			'price'        => $this->price,
			'quantity'     => $this->quantity,
			'tax_amount'   => $this->tax_amount,
			'tax_rate'     => $this->tax_rate,
			'thumbnailUrl' => $this->thumbnail_url,
			'currency'     => $this->currency,
		];
	}

	public function set_name( string $name ): void {
		$this->name = $name;
	}

	public function set_url( string $url ): void {
		$this->url = $url;
	}

	public function set_price( float $price ): void {
		$this->price = $price;
	}

	public function set_quantity( int $quantity ): void {
		$this->quantity = $quantity;
	}

	public function set_thumbnail_url( string $thumbnail_url ): void {
		$this->thumbnail_url = $thumbnail_url;
	}

	public function set_currency( string $currency ): void {
		$this->currency = $currency;
	}

	public function set_price_net( float $price_net ): void {
		$this->price_net = $price_net;
	}

	public function set_tax_amount( float $tax_amount ): void {
		$this->tax_amount = $tax_amount;
	}

	public function set_tax_rate( float $tax_rate ): void {
		$this->tax_rate = $tax_rate;
	}
}
