<?php

namespace Simplyin\Simplyin_W_Plugin\Dto\Order;

class Order_Data_DTO {

	protected string $payment_method;
	protected string $payment_method_title;
	protected string $shop_order_number;
	protected float $price;
	protected string $currency;
	protected float $shipping_price;

	/**
	 * @var Order_Items_DTO
	 */
	protected Order_Items_DTO $items;

	protected bool $placed_during_account_creation;
	protected Billing_Data_DTO $billing_data;
	protected string $shop_name;
	protected string $plugin_version;
	protected string $shop_version;
	protected string $shop_user_email;
	protected string $user_ip;
	protected string $shop_ip;

	protected ?Parcel_Locker_Minimal_Info_DTO $parcel_locker_minimal_info_DTO = null;
	protected ?Shipping_Data_DTO $shipping_data_dto = null;
	protected ?Parcel_Locker_Data_DTO $parcel_locker_data_DTO = null;


	public function to_array(): array {
		$return = [
			"price"                       => $this->price,
			"shippingPrice"               => $this->shipping_price,
			"currency"                    => $this->currency,
			"items"                       => $this->items->to_array(),
			"placedDuringAccountCreation" => $this->placed_during_account_creation,
			"shopName"                    => $this->shop_name,
			"payment_method"              => $this->payment_method,
			"payment_method_title"        => $this->payment_method_title,
			"shopOrderNumber"             => $this->shop_order_number,
			"shopUserEmail"               => $this->shop_user_email,
			"shopVersion"                 => $this->shop_version,
			"billingData"                 => $this->billing_data->to_array(),
			"userIp"                      => $this->user_ip,
			"shopIp"                      => $this->shop_ip,
		];

		if ( $this->parcel_locker_minimal_info_DTO ) {
			$return['parcelLockerMinimalInfo'] = $this->parcel_locker_minimal_info_DTO->to_array();
		} else {
			if ( $this->shipping_data_dto ) {
				$return['shippingData'] = $this->shipping_data_dto->to_array();
			}
		}

		return $return;
	}

	public function set_payment_method( string $payment_method ): void {
		$this->payment_method = $payment_method;
	}

	public function set_payment_method_title( string $payment_method_title
	): void {
		$this->payment_method_title = $payment_method_title;
	}

	public function set_shop_order_number( string $shop_order_number ): void {
		$this->shop_order_number = $shop_order_number;
	}

	public function set_price( float $price ): void {
		$this->price = $price;
	}

	public function set_currency( string $currency ): void {
		$this->currency = $currency;
	}

	public function set_shipping_price( float $shipping_price ): void {
		$this->shipping_price = $shipping_price;
	}

	public function set_items( Order_Items_DTO $items ): void {
		$this->items = $items;
	}

	public function set_placed_during_account_creation(
		bool $placed_during_account_creation
	): void {
		$this->placed_during_account_creation = $placed_during_account_creation;
	}

	public function set_billing_data( Billing_Data_DTO $billing_data ): void {
		$this->billing_data = $billing_data;
	}

	public function set_shop_name( string $shop_name ): void {
		$this->shop_name = $shop_name;
	}

	public function set_plugin_version( string $plugin_version ): void {
		$this->plugin_version = $plugin_version;
	}

	public function set_shop_version( string $shop_version ): void {
		$this->shop_version = $shop_version;
	}

	public function set_shop_user_email( string $shop_user_email ): void {
		$this->shop_user_email = $shop_user_email;
	}

	public function set_user_ip( string $user_ip ): void {
		$this->user_ip = $user_ip;
	}

	public function set_shop_ip( string $shop_ip ): void {
		$this->shop_ip = $shop_ip;
	}

	public function set_parcel_locker_minimal_info_DTO(
		?Parcel_Locker_Minimal_Info_DTO $parcel_locker_minimal_info_DTO
	): void {
		$this->parcel_locker_minimal_info_DTO = $parcel_locker_minimal_info_DTO;
	}

	public function set_shipping_data_dto( ?Shipping_Data_DTO $shipping_data_dto
	): void {
		$this->shipping_data_dto = $shipping_data_dto;
	}

	public function set_parcel_locker_data_DTO(
		?Parcel_Locker_Data_DTO $parcel_locker_data_DTO
	): void {
		$this->parcel_locker_data_DTO = $parcel_locker_data_DTO;
	}
}
