<?php
declare(strict_types=1);

namespace Simplyin\Simplyin_W_Plugin\Controller\Ajax;

abstract class Abstract_Response {

	protected bool $success;
	protected ?string $error = null;

	abstract protected function get_array(): array;

	public function to_array() {
		$return['success'] = $this->success;

		if ( $this->error ) {
			$return['error'] = $this->error;

			return $return;
		}

		return array_merge( $return, $this->get_array() );
	}


	public function set_is_success( bool $success ): void {
		$this->success = $success;
	}

	public function set_error( ?string $error ): void {
		$this->error = $error;
	}

	public function is_success(): bool {
		return $this->success;
	}

	public function get_error(): ?string {
		return $this->error;
	}
}
