<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * @var array $args
 */

use Simplyin\Simplyin_W_Plugin\Admin\Shipping_Mapping_Options;
use Simplyin\Simplyin_W_Plugin\Admin\Template_Components\Select;

if ( isset ( $args['mapping_config'] ) ) {
	/**
	 * @var Shipping_Mapping_Options $mapping_config
	 */
	$mapping_config = $args['mapping_config'];
	$mapping_fields = $mapping_config->get_shipping_mapping_fields();
} else {
	return;
}

?>

<div class="shipping_mapping" id="simply_shipping_mapping">
	<h2>
		<?php esc_html_e( 'Shipping mapping', 'simplyin' ) ?>
	</h2>
	<p>
		<?php esc_html_e( 'Map your shipping methods to your SimplyIn shipping methods.',
			'simplyin' ) ?>
	</p>
	<ul>
		<?php foreach ( $mapping_fields as $select ): ?>
			<li>
				<?php


				$select->print_label_html();
				$select->print_html()

				?>
			</li>

		<?php endforeach; ?>
	</ul>
</div>
