window.$ = window.$ || window.jQuery;
const simplyin = window.simplyin;
const isBlockCheckout = simplyin.is_block_checkout === "true";

$(function () {
  window.simplyin_apaczka_change_react_input = function (input, value) {
    if (typeof input != "undefined" && input !== null) {
      var nativeInputValueSetter = Object.getOwnPropertyDescriptor(
        window.HTMLInputElement.prototype,
        "value"
      ).set;
      nativeInputValueSetter.call(input, value);
      var inputEvent = new Event("input", { bubbles: true });
      input.dispatchEvent(inputEvent);
    }
  };

  window.simplyin_apaczka_mp_map_callback = function (point) {
    let point_brand = "";
    if ("brand" in point) {
      point_brand = point.brand + " " + point.code;
    } else {
      point_brand = point.code;
    }

    let visible_point_desc = point_brand;
    if ("description" in point) {
      visible_point_desc += "<br>" + point.description;
    }
    if ("street" in point) {
      visible_point_desc += "<br>" + point.street;
    }
    if ("city" in point) {
      visible_point_desc += "<br>" + point.city;
    }
    if ("postalCode" in point) {
      visible_point_desc += "<br>" + point.postalCode;
    }

    $("#apm_name").val(point.description);
    $("#apm_city").val(point.city);
    $("#apm_street").val(point.street);
    $("#apm_postal_code").val(point.postalCode);
    $("#apm_country_code").val("PL");
    $("#apm_supplier").val(point.operator);
    $("#apm_access_point_id").val(point.code);
    $("#apm_foreign_access_point_id").val(point.code);

    $("#amp-delivery-point-desc").html(
      apaczka_points_map.translation.delivery_point + " : " + visible_point_desc
    );
    $("#amp-delivery-point-desc").show();

    let map_modal = document.getElementById(
      "apaczka_mp_geowidget_modal_dynamic"
    );
    if (typeof map_modal != "undefined" && map_modal !== null) {
      map_modal.style.display = "none";
    }
  };

  window.simplyin_apaczka_mp_map_callback_blocks = function (record) {
    let visible_point_id = "";
    let visible_point_desc = "";
    let apaczka_point_data = {};

    if ("code" in record) {
      if ("brand" in record) {
        apaczka_point_data.apm_access_point_id = record.code;
        visible_point_id =
          '<div id="selected-parcel-machine-id">' +
          record.brand +
          ": " +
          record.code +
          "</div>\n";
      } else {
        apaczka_point_data.apm_access_point_id = record.code;
        visible_point_id =
          '<div id="selected-parcel-machine-id">' + record.code + "</div>\n";
      }
    }

    if ("operator" in record) {
      apaczka_point_data.apm_supplier = record.operator;
    }

    if ("description" in record) {
      apaczka_point_data.apm_name = record.description;
      visible_point_desc += record.description;
    }

    if ("code" in record) {
      apaczka_point_data.apm_foreign_access_point_id = record.code;
    }

    if ("street" in record) {
      apaczka_point_data.apm_street = record.street;
      visible_point_desc += "<br>" + record.street;
    }

    if ("city" in record) {
      apaczka_point_data.apm_city = record.city;
      visible_point_desc += "<br>" + record.city;
    }

    if ("postalCode" in record) {
      apaczka_point_data.apm_postal_code = record.postalCode;
      visible_point_desc += "<br>" + record.postalCode;
    }

    if ("country_code" in record) {
      apaczka_point_data.apm_country_code = record.country_code;
    } else {
      apaczka_point_data.apm_country_code = "PL";
    }

    let shipping_country = $("#shipping-country");
    if (typeof shipping_country != "undefined" && shipping_country !== null) {
      shipping_country_code = $(shipping_country).val();
      if (
        typeof shipping_country_code != "undefined" &&
        shipping_country_code !== null
      ) {
        apaczka_point_data.apm_country_code = shipping_country_code;
      }
    }

    simplyin_apaczka_change_react_input(
      document.getElementById("apaczka-point"),
      JSON.stringify(apaczka_point_data)
    );

    $("#apaczka_pl_geowidget_block").text(apaczka_block.button_text2);

    let point_desc =
      '<span id="selected-parcel-machine-desc">' +
      visible_point_desc +
      "</span>";

    let apaczka_point =
      '<div class="apaczka_selected_point_data" id="apaczka_selected_point_data">\n' +
      visible_point_id +
      point_desc +
      "</div>";

    $("#apaczka_selected_point_data_wrap").html(apaczka_point);
    $("#apaczka_selected_point_data_wrap").show();

    $("#shipping-phone").prop("required", true);
    $('label[for="shipping-phone"]').text("Telefon (wymagany)");
  };

  window.SimplyIn = {
    ajax: "",
    phones: false,
    email_field: false,
    email_login_field: false,
    customer_email: null,
    is_login: false,
    last_code: false,
    is_login_page: false,

    on_close_refresh_page: false,
    counting_interval: false,
    counting_message_interval: false,
    push_notification_interval: false,
    autocomplete_interval: false,

    validate_code_timeout: false,
    validate_code_sended: false,

    last_popup: "",
    delivery_popup: "",
    delivery_popup_scroll: 0,
    popup: null,

    counting_value: 0,
    counting_value_message: 0,

    saveCheckboxState: window.simplyin.save_checkbox === "1" ? true : false,

    select_customer_privacy: false,
    select_psgdpr: false,
    submit_guest_form: false,
    init: async function (config = {}) {
      this.ajax = simplyin.controllers.ajax;
      this.select_customer_privacy = simplyin.select_customer_privacy;
      this.select_psgdpr = simplyin.select_psgdpr;
      this.submit_guest_form = simplyin.submit_guest_form;

      this.push_notification_controller = null;

      if (typeof simplyin.order != "undefined") {
        this.placeOrder();
      } else {
        await this.preloadImages();
        await this.initOpcStandard();
        this.initEventListeners();
        this.initEventListenersPin();
        this.initEventListenersDelivery();
        this.initEventListenersEditAddress();
        this.initEventListenersAddParcelLocker();
        await this.checkSessionStatus();

        if (isBlockCheckout) {
          await this.getBlocksPaymentMethods();
        }

        if (!this.is_login) {
          await this.initEventListenersNewAccount();
        }

        this.checkoutUpdateListener();

        if (!this.is_login && !this.last_popup) {
          $(this.email_field).trigger("input");
        }
      }
    },
    checkSessionStatus: async function () {
      const self = this;

      if (this.customer_email || this.is_login) {
        return;
      }

      var params = {
        action: "simplyin_session_status",
        ajax: 1,
        ajax_token: simplyin.ajax_token,
      };

      return new Promise((resolve) => {
        $.post(self.ajax, params).done(function (data) {
          if (data.success) {
            const email = data.login_result.email;
            self.loginCustomer(email);
            self.showIcon();

            if (isBlockCheckout) {
              const emailEl = document.querySelector(self.email_field);
              self.setNativeValue(emailEl, email);
            } else {
              $(self.email_field).val(email);
            }

            if (data?.invoice_address?._id) {
              self.insertFormData(
                {
                  ...data,
                  delivery_address: data.invoice_address,
                },
                true
              );
            }

            if (!data?.invoice_address?._id) {
              self.filterAvailableProvidersInPopup();
            }

            self.last_popup = data.html;

            if (isBlockCheckout) {
              document
                .querySelector(".wc-block-components-address-form__email")
                .classList.add("simplyin-display-flex");
            }

            self.updateDeliveryCosts();
            resolve();
            return;
          }

          self.hideIcon();

          if ($(this.email_field).length) {
            setTimeout(() => {
              $(this.email_field).trigger("input");
            }, 1000);
          }

          resolve();
        });
      });
    },
    preloadImages() {
      const base = simplyin.files_url + "/public/img/";
      const images = [
        "logo_smalln.svg",
        "edit_icon.svg",
        "trash_icon.svg",
        "close_icon.svg",
        "NoData.svg",
        "expand_icon.svg",
        "dots_icon.svg",
        "add_icon.svg",
      ];

      return Promise.all(
        images.map(
          (src) =>
            new Promise((resolve) => {
              const img = new Image();
              img.onload = resolve;
              img.onerror = resolve;
              img.src = base + src;
            })
        )
      );
    },
    waitForShippingPhone: async function () {
      return new Promise((resolve) => {
        let attempts = 0;
        const maxAttempts = 50;

        const checkInterval = setInterval(() => {
          attempts++;

          const shippingPhone = document.getElementById("shipping-phone");
          const checkboxBilling = document.querySelector(
            ".wc-block-checkout__use-address-for-billing input[type='checkbox']"
          );
          const editShippingButtons = document.querySelectorAll(
            ".wc-block-components-address-card__edit"
          );
          const billingPhone = document.getElementById("billing-phone");

          if (editShippingButtons && editShippingButtons.length > 0) {
            for (const button of Array.from(editShippingButtons)) {
              try {
                button.click();
              } catch (error) {
                console.error("Błąd przy klikaniu:", error);
              }
            }
          }

          if (shippingPhone && checkboxBilling) {
            try {
              checkboxBilling.click();
              if (checkboxBilling.checked) {
                checkboxBilling.click();
              }
            } catch (error) {
              console.error("Błąd przy obsłudze checkboxa:", error);
            }
          }

          if (billingPhone) {
            clearInterval(checkInterval);
            resolve(true);
            return;
          }

          if (attempts >= maxAttempts) {
            clearInterval(checkInterval);
            resolve(false);
            return;
          }
        }, 200);

        setTimeout(() => {
          clearInterval(checkInterval);
          resolve(false);
        }, 10000);
      });
    },
    placeEmailField: function () {
      const container = document.querySelector(
        ".woocommerce-billing-fields__field-wrapper"
      );

      const elementToMove = document.getElementById("billing_email_field");

      if (!elementToMove || !container) {
        return;
      }

      const firstChild = container.children[0];
      if (
        firstChild === elementToMove ||
        (container.children[0].classList.contains("billing_first_name_field") &&
          container.children[1] === elementToMove)
      ) {
        return;
      }

      const indexOfEmailFieldInContainer = Array.from(
        container.children
      )?.indexOf(elementToMove);

      if (elementToMove.classList.contains("form-row-last")) {
        container.children[indexOfEmailFieldInContainer - 1].classList.remove(
          "form-row-first"
        );
        container.children[indexOfEmailFieldInContainer - 1].classList.add(
          "form-row-wide"
        );
      }

      if (elementToMove.classList.contains("form-row-first")) {
        container.children[indexOfEmailFieldInContainer + 1].classList.remove(
          "form-row-last"
        );
        container.children[indexOfEmailFieldInContainer + 1].classList.add(
          "form-row-wide"
        );
      }

      elementToMove.classList.remove("form-row-first");
      elementToMove.classList.remove("form-row-last");
      elementToMove.classList.add("form-row-wide");

      if (
        container.children[0].classList.contains("billing_first_name_field")
      ) {
        container.insertBefore(elementToMove, container.children[0]);
        elementToMove.setAttribute("data-priority", "1");
      } else {
        container.insertBefore(elementToMove, container.children[1]);
        elementToMove.setAttribute("data-priority", `1`);
      }
    },
    getBlocksPaymentMethods: async function () {
      var params = {
        action: "simplyin_get_blocks_payment_methods",
        ajax: 1,
        ajax_token: simplyin.controllers.blocks_nonce,
      };

      fetch(simplyin.controllers.ajax, {
        method: "POST",
        headers: {
          "Content-Type": "application/x-www-form-urlencoded",
        },
        body: new URLSearchParams(params),
      })
        .then((response) => response.json())
        .then((data) => {
          if (data.payment_methods) {
            window.SimplyinPaymentMethodsCallback(data.payment_methods);
          }
        })
        .catch(() => {
          if (window.SimplyinPaymentMethodsCallback) {
            window.SimplyinPaymentMethodsCallback([]);
          }
        });
    },
    initOpcStandard: async function () {
      const self = this;
      this.email_field = isBlockCheckout ? "#email" : "#billing_email";

      if (isBlockCheckout) {
        await self.waitForShippingPhone();
        self.createBlockCheckoutFields();
      }

      self.placeEmailField();

      if ($(this.email_field).length) {
        var email_field = $(this.email_field);
        var form_group = isBlockCheckout
          ? email_field.closest(".wc-block-components-address-form__email")
          : email_field.closest(".form-row");
        var customer_form = isBlockCheckout
          ? $("#contact")
          : $("#customer_details");
        if (form_group.length || customer_form.length) {
          if (isBlockCheckout) {
            customer_form.prepend(form_group);
          }

          if (simplyin.customer_email != "") {
            email_field.parent().append(
              `<div class="simplyin-show-popup">
              <div class="simplyin-show-popup-icon">
                <img width="30" height="30" src="${simplyin.files_url}/public/img/logo_smalln.svg"/>
                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <rect y="0.5" width="12" height="12" rx="6" fill="#33CC40"/>
                  <path d="M3.23096 6.54276L5.07711 8.38892L8.76942 4.38892" stroke="white" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
              </div>
              <div class="simplyin-show-popup-edit">
                <span>${window.simplyin.labels.data_saved}</span>
                <div class="simplyin-show-popup-edit-bottom">
                  <span>${window.simplyin.labels.change}</span>
                  <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M8.41604 2.74719L8.97217 2.19107C9.89359 1.26964 11.3875 1.26964 12.3089 2.19107C13.2304 3.11249 13.2304 4.60641 12.3089 5.52783L11.7528 6.08396M8.41604 2.74719C8.41604 2.74719 8.48556 3.92897 9.5283 4.97171C10.571 6.01445 11.7528 6.08396 11.7528 6.08396M8.41604 2.74719L3.30329 7.85994C2.957 8.20624 2.78385 8.37939 2.63494 8.5703C2.45928 8.79551 2.30868 9.03919 2.18581 9.29701C2.08164 9.51558 2.00421 9.74789 1.84934 10.2125L1.3535 11.7M11.7528 6.08396L6.64006 11.1967C6.29376 11.543 6.12061 11.7162 5.9297 11.8651C5.70449 12.0407 5.46082 12.1913 5.20299 12.3142C4.98442 12.4184 4.75211 12.4958 4.28751 12.6507L2.8 13.1465M2.8 13.1465L1.8375 13.4673C1.60887 13.5435 1.35679 13.484 1.18638 13.3136C1.01596 13.1432 0.956457 12.8911 1.03267 12.6625L1.3535 11.7M2.8 13.1465L1.3535 11.7" stroke="#2D40F6" stroke-width="1.6"/>
                  </svg>
                </div>
              </div>
            </div>`
            );
            $(email_field).val(simplyin.customer_email);
          } else {
            email_field.parent().append(
              `<div class="simplyin-show-popup">
              <div class="simplyin-show-popup-icon">
                <img width="30" height="30" src="${simplyin.files_url}/public/img/logo_smalln.svg"/>
                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <rect y="0.5" width="12" height="12" rx="6" fill="#33CC40"/>
                  <path d="M3.23096 6.54276L5.07711 8.38892L8.76942 4.38892" stroke="white" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
              </div>
              <div class="simplyin-show-popup-edit">
                <span>${window.simplyin.labels.data_saved}</span>
                <div class="simplyin-show-popup-edit-bottom">
                  <span>${window.simplyin.labels.change}</span>
                  <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M8.41604 2.74719L8.97217 2.19107C9.89359 1.26964 11.3875 1.26964 12.3089 2.19107C13.2304 3.11249 13.2304 4.60641 12.3089 5.52783L11.7528 6.08396M8.41604 2.74719C8.41604 2.74719 8.48556 3.92897 9.5283 4.97171C10.571 6.01445 11.7528 6.08396 11.7528 6.08396M8.41604 2.74719L3.30329 7.85994C2.957 8.20624 2.78385 8.37939 2.63494 8.5703C2.45928 8.79551 2.30868 9.03919 2.18581 9.29701C2.08164 9.51558 2.00421 9.74789 1.84934 10.2125L1.3535 11.7M11.7528 6.08396L6.64006 11.1967C6.29376 11.543 6.12061 11.7162 5.9297 11.8651C5.70449 12.0407 5.46082 12.1913 5.20299 12.3142C4.98442 12.4184 4.75211 12.4958 4.28751 12.6507L2.8 13.1465M2.8 13.1465L1.8375 13.4673C1.60887 13.5435 1.35679 13.484 1.18638 13.3136C1.01596 13.1432 0.956457 12.8911 1.03267 12.6625L1.3535 11.7M2.8 13.1465L1.3535 11.7" stroke="#2D40F6" stroke-width="1.6"/>
                  </svg>
                </div>
              </div>
            </div>`
            );
            this.hideIcon();
          }
          email_field.parent().addClass("simplyin-display-flex");

          if (isBlockCheckout) {
            $(".wc-block-components-address-form__email").addClass(
              "simplyin-display-flex"
            );
          }
        }
      } else {
        let identity = $(".identity");
        identity.parent().prepend(
          `<div class="simplyin-show-popup">
            <div class="simplyin-show-popup-icon">
              <img width="30" height="30" src="${simplyin.files_url}/public/img/logo_smalln.svg"/>
              <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                <rect y="0.5" width="12" height="12" rx="6" fill="#33CC40"/>
                <path d="M3.23096 6.54276L5.07711 8.38892L8.76942 4.38892" stroke="white" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"/>
              </svg>
            </div>
            <div class="simplyin-show-popup-edit">
              <span>${window.simplyin.labels.data_saved}</span>
              <div class="simplyin-show-popup-edit-bottom">
                <span>${window.simplyin.labels.change}</span>
                <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M8.41604 2.74719L8.97217 2.19107C9.89359 1.26964 11.3875 1.26964 12.3089 2.19107C13.2304 3.11249 13.2304 4.60641 12.3089 5.52783L11.7528 6.08396M8.41604 2.74719C8.41604 2.74719 8.48556 3.92897 9.5283 4.97171C10.571 6.01445 11.7528 6.08396 11.7528 6.08396M8.41604 2.74719L3.30329 7.85994C2.957 8.20624 2.78385 8.37939 2.63494 8.5703C2.45928 8.79551 2.30868 9.03919 2.18581 9.29701C2.08164 9.51558 2.00421 9.74789 1.84934 10.2125L1.3535 11.7M11.7528 6.08396L6.64006 11.1967C6.29376 11.543 6.12061 11.7162 5.9297 11.8651C5.70449 12.0407 5.46082 12.1913 5.20299 12.3142C4.98442 12.4184 4.75211 12.4958 4.28751 12.6507L2.8 13.1465M2.8 13.1465L1.8375 13.4673C1.60887 13.5435 1.35679 13.484 1.18638 13.3136C1.01596 13.1432 0.956457 12.8911 1.03267 12.6625L1.3535 11.7M2.8 13.1465L1.3535 11.7" stroke="#2D40F6" stroke-width="1.6"/>
                </svg>
              </div>
            </div>
          </div>`
        );
      }

      const logoBigEl = `
      <div class="simplyin-banner-logo-container">
      <div class="simplyin-banner-logo-before"></div>
      <div class="simplyin-banner-text">${window.simplyin.labels.banner_text}</div>
      <svg class="simplyin-banner-logo" width="80" height="19" viewBox="0 0 80 19" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M73.2764 13.9352V6.99607H75.0847V7.75938C75.332 7.43556 75.6373 7.18883 76.0005 7.01921C76.3637 6.84958 76.754 6.76477 77.1713 6.76477C77.6659 6.76477 78.1258 6.88428 78.5508 7.12329C78.9836 7.3546 79.3313 7.6977 79.5941 8.1526C79.8646 8.59979 79.9998 9.14336 79.9998 9.7833V13.9352H77.9828V10.0493C77.9828 9.6638 77.8669 9.32069 77.635 9.02C77.4032 8.7193 77.0709 8.56895 76.6381 8.56895C76.2903 8.56895 75.9773 8.68846 75.6991 8.92747C75.4286 9.15878 75.2934 9.52501 75.2934 10.0262V13.9352H73.2764Z" fill="black"/>
      <path d="M69.7131 13.9347V6.99557H71.7301V13.9347H69.7131ZM70.7216 5.9894C70.4202 5.9894 70.1652 5.88531 69.9565 5.67713C69.7479 5.46896 69.6436 5.21452 69.6436 4.91383C69.6436 4.60542 69.7479 4.35098 69.9565 4.15052C70.1652 3.94234 70.4202 3.83826 70.7216 3.83826C71.0307 3.83826 71.2858 3.94234 71.4867 4.15052C71.6954 4.35098 71.7997 4.60542 71.7997 4.91383C71.7997 5.21452 71.6954 5.46896 71.4867 5.67713C71.2858 5.88531 71.0307 5.9894 70.7216 5.9894Z" fill="black"/>
      <path d="M67.1919 14.1661C66.8364 14.1661 66.5389 14.0466 66.2993 13.8075C66.0597 13.5685 65.9399 13.2717 65.9399 12.917C65.9399 12.5623 66.0597 12.2655 66.2993 12.0265C66.5389 11.7875 66.8364 11.668 67.1919 11.668C67.5551 11.668 67.8526 11.7875 68.0845 12.0265C68.3241 12.2655 68.4439 12.5623 68.4439 12.917C68.4439 13.2717 68.3241 13.5685 68.0845 13.8075C67.8526 14.0466 67.5551 14.1661 67.1919 14.1661Z" fill="black"/>
      <path d="M59.3595 17.4041L61.678 12.7549L58.8379 6.99536H61.0636L62.2924 9.53972C62.4005 9.77103 62.4933 9.98306 62.5706 10.1758C62.6556 10.3609 62.7251 10.542 62.7792 10.7194C62.8411 10.542 62.9145 10.3609 62.9995 10.1758C63.0845 9.98306 63.185 9.77103 63.3009 9.53972L64.5528 6.99536H66.6974L61.5273 17.4041H59.3595Z" fill="black"/>
      <path d="M55.9702 13.9346V2.83191H57.9873V13.9346H55.9702Z" fill="black"/>
      <path d="M47.3721 17.4047V6.99596H49.1109V7.67831C49.3814 7.40845 49.6982 7.19642 50.0615 7.04222C50.4324 6.88802 50.8381 6.81091 51.2786 6.81091C51.9278 6.81091 52.5151 6.97668 53.0406 7.30822C53.5661 7.63205 53.9835 8.07153 54.2926 8.62666C54.6094 9.18179 54.7679 9.79475 54.7679 10.4655C54.7679 11.1363 54.6094 11.7493 54.2926 12.3044C53.9835 12.8518 53.5661 13.2913 53.0406 13.6229C52.5151 13.9544 51.9278 14.1202 51.2786 14.1202C50.9077 14.1202 50.5638 14.0623 50.2469 13.9467C49.9301 13.8387 49.6441 13.6884 49.3891 13.4956V17.4047H47.3721ZM51.0468 12.3507C51.3868 12.3507 51.6959 12.2659 51.9742 12.0962C52.2524 11.9266 52.4726 11.6992 52.6349 11.4139C52.8049 11.1286 52.8899 10.8125 52.8899 10.4655C52.8899 10.1186 52.8049 9.80246 52.6349 9.51719C52.4726 9.23191 52.2524 9.00446 51.9742 8.83484C51.6959 8.66521 51.3868 8.5804 51.0468 8.5804C50.7067 8.5804 50.3976 8.66521 50.1194 8.83484C49.8412 9.00446 49.6171 9.23191 49.4471 9.51719C49.2848 9.80246 49.2036 10.1186 49.2036 10.4655C49.2036 10.8125 49.2848 11.1286 49.4471 11.4139C49.6171 11.6992 49.8412 11.9266 50.1194 12.0962C50.3976 12.2659 50.7067 12.3507 51.0468 12.3507Z" fill="black"/>
      <path d="M34.8535 13.9349V6.99571H36.6619V7.75902C36.9092 7.43519 37.2145 7.18846 37.5777 7.01884C37.9486 6.84922 38.335 6.7644 38.7369 6.7644C39.1465 6.7644 39.5329 6.84922 39.8961 7.01884C40.2593 7.18846 40.5646 7.43519 40.8119 7.75902C41.0824 7.43519 41.4185 7.18846 41.8204 7.01884C42.2223 6.84922 42.6589 6.7644 43.1303 6.7644C43.6249 6.7644 44.0886 6.88006 44.5214 7.11136C44.9542 7.33496 45.3058 7.66649 45.5763 8.10598C45.8468 8.53775 45.982 9.06589 45.982 9.69042V13.9349H43.965V9.97955C43.965 9.60946 43.8568 9.28178 43.6404 8.9965C43.424 8.71122 43.111 8.56859 42.7014 8.56859C42.485 8.56859 42.2764 8.62256 42.0754 8.7305C41.8822 8.83073 41.7238 8.98494 41.6002 9.19311C41.4842 9.39357 41.4263 9.64801 41.4263 9.95642V13.9349H39.4092V9.97955C39.4092 9.73282 39.359 9.50152 39.2585 9.28563C39.1658 9.06975 39.0228 8.89627 38.8296 8.76519C38.6442 8.63412 38.4162 8.56859 38.1457 8.56859C37.9293 8.56859 37.7206 8.62256 37.5197 8.7305C37.3265 8.83073 37.1681 8.98494 37.0444 9.19311C36.9285 9.39357 36.8706 9.64801 36.8706 9.95642V13.9349H34.8535Z" fill="black"/>
      <path d="M31.2893 13.9344V6.99521H33.3063V13.9344H31.2893ZM32.2978 5.98903C31.9964 5.98903 31.7414 5.88494 31.5327 5.67677C31.3241 5.46859 31.2197 5.21416 31.2197 4.91346C31.2197 4.60505 31.3241 4.35062 31.5327 4.15015C31.7414 3.94198 31.9964 3.83789 32.2978 3.83789C32.6069 3.83789 32.8619 3.94198 33.0629 4.15015C33.2715 4.35062 33.3759 4.60505 33.3759 4.91346C33.3759 5.21416 33.2715 5.46859 33.0629 5.67677C32.8619 5.88494 32.6069 5.98903 32.2978 5.98903Z" fill="black"/>
      <path d="M27.4046 14.1662C26.9332 14.1662 26.4541 14.0891 25.9672 13.9349C25.4881 13.7807 25.1133 13.5725 24.8428 13.3103L25.3412 11.4136C25.5654 11.722 25.8745 11.9919 26.2686 12.2232C26.6705 12.4545 27.0839 12.5702 27.509 12.5702C27.7949 12.5702 27.9997 12.5162 28.1234 12.4083C28.2547 12.3003 28.3204 12.1692 28.3204 12.015C28.3204 11.8377 28.2547 11.7105 28.1234 11.6334C27.992 11.5486 27.8567 11.4792 27.7176 11.4252L26.7439 11.0551C26.5275 10.9703 26.2802 10.8547 26.002 10.7082C25.7238 10.5617 25.4803 10.3535 25.2717 10.0836C25.0708 9.81378 24.9703 9.45911 24.9703 9.01963C24.9703 8.6187 25.0708 8.24861 25.2717 7.90936C25.4726 7.57012 25.7624 7.29641 26.1411 7.08823C26.5275 6.87235 26.9912 6.7644 27.5322 6.7644C28.0345 6.7644 28.502 6.84922 28.9348 7.01884C29.3753 7.18846 29.696 7.37736 29.897 7.58554L29.4333 9.41285C29.1705 9.0736 28.8575 8.81531 28.4943 8.63798C28.1388 8.45293 27.7988 8.36041 27.4742 8.36041C27.2269 8.36041 27.0453 8.41053 26.9294 8.51076C26.8134 8.61099 26.7555 8.72664 26.7555 8.85772C26.7555 8.95795 26.7941 9.05818 26.8714 9.15841C26.9564 9.25094 27.0955 9.33575 27.2887 9.41285L28.1929 9.74824C28.4557 9.84076 28.7339 9.96413 29.0275 10.1183C29.3289 10.2725 29.584 10.4884 29.7926 10.766C30.0013 11.0358 30.1056 11.4098 30.1056 11.8878C30.1056 12.5586 29.8545 13.106 29.3521 13.5301C28.8575 13.9541 28.2084 14.1662 27.4046 14.1662Z" fill="black"/>
      <g clip-path="url(#clip0_3224_199596)">
      <path d="M15.3375 5.38893C16.7954 5.38893 17.9772 4.20982 17.9772 2.75532C17.9772 1.30081 16.7954 0.121704 15.3375 0.121704C13.8796 0.121704 12.6978 1.30081 12.6978 2.75532C12.6978 4.20982 13.8796 5.38893 15.3375 5.38893Z" fill="#BE21F9"/>
      <path d="M15.3375 5.41786C16.7954 5.41786 17.9772 4.23875 17.9772 2.78425C17.9772 1.32974 16.7954 0.150635 15.3375 0.150635C13.8796 0.150635 12.6978 1.32974 12.6978 2.78425C12.6978 4.23875 13.8796 5.41786 15.3375 5.41786Z" fill="#BE21F9"/>
      <path d="M15.3375 5.44911C16.7954 5.44911 17.9772 4.27 17.9772 2.8155C17.9772 1.36099 16.7954 0.181885 15.3375 0.181885C13.8796 0.181885 12.6978 1.36099 12.6978 2.8155C12.6978 4.27 13.8796 5.44911 15.3375 5.44911Z" fill="#BD21F9"/>
      <path d="M15.3375 5.46364C16.7954 5.46364 17.9772 4.28453 17.9772 2.83002C17.9772 1.37552 16.7954 0.196411 15.3375 0.196411C13.8796 0.196411 12.6978 1.37552 12.6978 2.83002C12.6978 4.28453 13.8796 5.46364 15.3375 5.46364Z" fill="#BD21F9"/>
      <path d="M15.3375 5.49489C16.7954 5.49489 17.9772 4.31578 17.9772 2.86127C17.9772 1.40677 16.7954 0.227661 15.3375 0.227661C13.8796 0.227661 12.6978 1.40677 12.6978 2.86127C12.6978 4.31578 13.8796 5.49489 15.3375 5.49489Z" fill="#BD21F9"/>
      <path d="M15.3375 5.52443C16.7954 5.52443 17.9772 4.34532 17.9772 2.89082C17.9772 1.43631 16.7954 0.257202 15.3375 0.257202C13.8796 0.257202 12.6978 1.43631 12.6978 2.89082C12.6978 4.34532 13.8796 5.52443 15.3375 5.52443Z" fill="#BD21F9"/>
      <path d="M15.3375 5.53956C16.7954 5.53956 17.9772 4.36046 17.9772 2.90595C17.9772 1.45145 16.7954 0.272339 15.3375 0.272339C13.8796 0.272339 12.6978 1.45145 12.6978 2.90595C12.6978 4.36046 13.8796 5.53956 15.3375 5.53956Z" fill="#BC21F9"/>
      <path d="M15.3375 5.57082C16.7954 5.57082 17.9772 4.39171 17.9772 2.9372C17.9772 1.4827 16.7954 0.303589 15.3375 0.303589C13.8796 0.303589 12.6978 1.4827 12.6978 2.9372C12.6978 4.39171 13.8796 5.57082 15.3375 5.57082Z" fill="#BC21F9"/>
      <path d="M15.3375 5.59999C16.7954 5.59999 17.9772 4.42088 17.9772 2.96638C17.9772 1.51187 16.7954 0.332764 15.3375 0.332764C13.8796 0.332764 12.6978 1.51187 12.6978 2.96638C12.6978 4.42088 13.8796 5.59999 15.3375 5.59999Z" fill="#BC22F9"/>
      <path d="M15.3375 5.631C16.7954 5.631 17.9772 4.45189 17.9772 2.99738C17.9772 1.54288 16.7954 0.36377 15.3375 0.36377C13.8796 0.36377 12.6978 1.54288 12.6978 2.99738C12.6978 4.45189 13.8796 5.631 15.3375 5.631Z" fill="#BB22F9"/>
      <path d="M15.3375 5.64552C16.7954 5.64552 17.9772 4.46641 17.9772 3.01191C17.9772 1.5574 16.7954 0.378296 15.3375 0.378296C13.8796 0.378296 12.6978 1.5574 12.6978 3.01191C12.6978 4.46641 13.8796 5.64552 15.3375 5.64552Z" fill="#BB22F9"/>
      <path d="M15.3375 5.67653C16.7954 5.67653 17.9772 4.49742 17.9772 3.04291C17.9772 1.58841 16.7954 0.409302 15.3375 0.409302C13.8796 0.409302 12.6978 1.58841 12.6978 3.04291C12.6978 4.49742 13.8796 5.67653 15.3375 5.67653Z" fill="#BB22F9"/>
      <path d="M15.3375 5.70656C16.7954 5.70656 17.9772 4.52745 17.9772 3.07294C17.9772 1.61844 16.7954 0.439331 15.3375 0.439331C13.8796 0.439331 12.6978 1.61844 12.6978 3.07294C12.6978 4.52745 13.8796 5.70656 15.3375 5.70656Z" fill="#BA22F9"/>
      <path d="M15.3375 5.72169C16.7954 5.72169 17.9772 4.54259 17.9772 3.08808C17.9772 1.63358 16.7954 0.454468 15.3375 0.454468C13.8796 0.454468 12.6978 1.63358 12.6978 3.08808C12.6978 4.54259 13.8796 5.72169 15.3375 5.72169Z" fill="#BA22F9"/>
      <path d="M15.3375 5.7527C16.7954 5.7527 17.9772 4.57359 17.9772 3.11909C17.9772 1.66458 16.7954 0.485474 15.3375 0.485474C13.8796 0.485474 12.6978 1.66458 12.6978 3.11909C12.6978 4.57359 13.8796 5.7527 15.3375 5.7527Z" fill="#BA22F9"/>
      <path d="M15.3375 5.78187C16.7954 5.78187 17.9772 4.60277 17.9772 3.14826C17.9772 1.69376 16.7954 0.514648 15.3375 0.514648C13.8796 0.514648 12.6978 1.69376 12.6978 3.14826C12.6978 4.60277 13.8796 5.78187 15.3375 5.78187Z" fill="#BA22F9"/>
      <path d="M15.3375 5.81288C16.7954 5.81288 17.9772 4.63377 17.9772 3.17927C17.9772 1.72476 16.7954 0.545654 15.3375 0.545654C13.8796 0.545654 12.6978 1.72476 12.6978 3.17927C12.6978 4.63377 13.8796 5.81288 15.3375 5.81288Z" fill="#B922F9"/>
      <path d="M15.3375 5.82741C16.7954 5.82741 17.9772 4.6483 17.9772 3.19379C17.9772 1.73929 16.7954 0.560181 15.3375 0.560181C13.8796 0.560181 12.6978 1.73929 12.6978 3.19379C12.6978 4.6483 13.8796 5.82741 15.3375 5.82741Z" fill="#B922F9"/>
      <path d="M15.3375 5.85719C16.7954 5.85719 17.9772 4.67808 17.9772 3.22358C17.9772 1.76907 16.7954 0.589966 15.3375 0.589966C13.8796 0.589966 12.6978 1.76907 12.6978 3.22358C12.6978 4.67808 13.8796 5.85719 15.3375 5.85719Z" fill="#B922F9"/>
      <path d="M15.3375 5.88844C16.7954 5.88844 17.9772 4.70933 17.9772 3.25483C17.9772 1.80032 16.7954 0.621216 15.3375 0.621216C13.8796 0.621216 12.6978 1.80032 12.6978 3.25483C12.6978 4.70933 13.8796 5.88844 15.3375 5.88844Z" fill="#B822F9"/>
      <path d="M15.3375 5.90272C16.7954 5.90272 17.9772 4.72362 17.9772 3.26911C17.9772 1.81461 16.7954 0.635498 15.3375 0.635498C13.8796 0.635498 12.6978 1.81461 12.6978 3.26911C12.6978 4.72362 13.8796 5.90272 15.3375 5.90272Z" fill="#B822F9"/>
      <path d="M15.3375 5.93397C16.7954 5.93397 17.9772 4.75487 17.9772 3.30036C17.9772 1.84586 16.7954 0.666748 15.3375 0.666748C13.8796 0.666748 12.6978 1.84586 12.6978 3.30036C12.6978 4.75487 13.8796 5.93397 15.3375 5.93397Z" fill="#B822F9"/>
      <path d="M15.3375 5.96376C16.7954 5.96376 17.9772 4.78465 17.9772 3.33015C17.9772 1.87564 16.7954 0.696533 15.3375 0.696533C13.8796 0.696533 12.6978 1.87564 12.6978 3.33015C12.6978 4.78465 13.8796 5.96376 15.3375 5.96376Z" fill="#B722F9"/>
      <path d="M15.3375 5.99501C16.7954 5.99501 17.9772 4.8159 17.9772 3.3614C17.9772 1.90689 16.7954 0.727783 15.3375 0.727783C13.8796 0.727783 12.6978 1.90689 12.6978 3.3614C12.6978 4.8159 13.8796 5.99501 15.3375 5.99501Z" fill="#B722F9"/>
      <path d="M15.3375 6.00929C16.7954 6.00929 17.9772 4.83018 17.9772 3.37568C17.9772 1.92117 16.7954 0.742065 15.3375 0.742065C13.8796 0.742065 12.6978 1.92117 12.6978 3.37568C12.6978 4.83018 13.8796 6.00929 15.3375 6.00929Z" fill="#B723F9"/>
      <path d="M15.3375 6.03908C16.7954 6.03908 17.9772 4.85997 17.9772 3.40546C17.9772 1.95096 16.7954 0.771851 15.3375 0.771851C13.8796 0.771851 12.6978 1.95096 12.6978 3.40546C12.6978 4.85997 13.8796 6.03908 15.3375 6.03908Z" fill="#B723F9"/>
      <path d="M15.3375 6.07033C16.7954 6.07033 17.9772 4.89122 17.9772 3.43671C17.9772 1.98221 16.7954 0.803101 15.3375 0.803101C13.8796 0.803101 12.6978 1.98221 12.6978 3.43671C12.6978 4.89122 13.8796 6.07033 15.3375 6.07033Z" fill="#B623F9"/>
      <path d="M15.3375 6.08485C16.7954 6.08485 17.9772 4.90574 17.9772 3.45124C17.9772 1.99674 16.7954 0.817627 15.3375 0.817627C13.8796 0.817627 12.6978 1.99674 12.6978 3.45124C12.6978 4.90574 13.8796 6.08485 15.3375 6.08485Z" fill="#B623F9"/>
      <path d="M15.3375 6.11586C16.7954 6.11586 17.9772 4.93675 17.9772 3.48225C17.9772 2.02774 16.7954 0.848633 15.3375 0.848633C13.8796 0.848633 12.6978 2.02774 12.6978 3.48225C12.6978 4.93675 13.8796 6.11586 15.3375 6.11586Z" fill="#B623F9"/>
      <path d="M15.3375 6.14564C16.7954 6.14564 17.9772 4.96654 17.9772 3.51203C17.9772 2.05753 16.7954 0.878418 15.3375 0.878418C13.8796 0.878418 12.6978 2.05753 12.6978 3.51203C12.6978 4.96654 13.8796 6.14564 15.3375 6.14564Z" fill="#B523F9"/>
      <path d="M15.3375 6.17482C16.7954 6.17482 17.9772 4.99571 17.9772 3.54121C17.9772 2.0867 16.7954 0.907593 15.3375 0.907593C13.8796 0.907593 12.6978 2.0867 12.6978 3.54121C12.6978 4.99571 13.8796 6.17482 15.3375 6.17482Z" fill="#B523F9"/>
      <path d="M15.3375 6.19142C16.7954 6.19142 17.9772 5.01231 17.9772 3.55781C17.9772 2.1033 16.7954 0.924194 15.3375 0.924194C13.8796 0.924194 12.6978 2.1033 12.6978 3.55781C12.6978 5.01231 13.8796 6.19142 15.3375 6.19142Z" fill="#B523F9"/>
      <path d="M15.3375 6.22096C16.7954 6.22096 17.9772 5.04185 17.9772 3.58735C17.9772 2.13284 16.7954 0.953735 15.3375 0.953735C13.8796 0.953735 12.6978 2.13284 12.6978 3.58735C12.6978 5.04185 13.8796 6.22096 15.3375 6.22096Z" fill="#B423F9"/>
      <path d="M15.3375 6.25221C16.7954 6.25221 17.9772 5.0731 17.9772 3.6186C17.9772 2.16409 16.7954 0.984985 15.3375 0.984985C13.8796 0.984985 12.6978 2.16409 12.6978 3.6186C12.6978 5.0731 13.8796 6.25221 15.3375 6.25221Z" fill="#B423F9"/>
      <path d="M15.3375 6.26674C16.7954 6.26674 17.9772 5.08763 17.9772 3.63312C17.9772 2.17862 16.7954 0.999512 15.3375 0.999512C13.8796 0.999512 12.6978 2.17862 12.6978 3.63312C12.6978 5.08763 13.8796 6.26674 15.3375 6.26674Z" fill="#B423F9"/>
      <path d="M15.3375 6.29652C16.7954 6.29652 17.9772 5.11741 17.9772 3.66291C17.9772 2.20841 16.7954 1.0293 15.3375 1.0293C13.8796 1.0293 12.6978 2.20841 12.6978 3.66291C12.6978 5.11741 13.8796 6.29652 15.3375 6.29652Z" fill="#B423F9"/>
      <path d="M15.3375 6.32753C16.7954 6.32753 17.9772 5.14842 17.9772 3.69392C17.9772 2.23941 16.7954 1.0603 15.3375 1.0603C13.8796 1.0603 12.6978 2.23941 12.6978 3.69392C12.6978 5.14842 13.8796 6.32753 15.3375 6.32753Z" fill="#B323F9"/>
      <path d="M15.3375 6.3567C16.7954 6.3567 17.9772 5.1776 17.9772 3.72309C17.9772 2.26859 16.7954 1.08948 15.3375 1.08948C13.8796 1.08948 12.6978 2.26859 12.6978 3.72309C12.6978 5.1776 13.8796 6.3567 15.3375 6.3567Z" fill="#B323F9"/>
      <path d="M15.3375 6.37331C16.7954 6.37331 17.9772 5.1942 17.9772 3.73969C17.9772 2.28519 16.7954 1.10608 15.3375 1.10608C13.8796 1.10608 12.6978 2.28519 12.6978 3.73969C12.6978 5.1942 13.8796 6.37331 15.3375 6.37331Z" fill="#B323F9"/>
      <path d="M15.3375 6.40248C16.7954 6.40248 17.9772 5.22337 17.9772 3.76887C17.9772 2.31436 16.7954 1.13525 15.3375 1.13525C13.8796 1.13525 12.6978 2.31436 12.6978 3.76887C12.6978 5.22337 13.8796 6.40248 15.3375 6.40248Z" fill="#B223F9"/>
      <path d="M15.3375 6.43349C16.7954 6.43349 17.9772 5.25438 17.9772 3.79987C17.9772 2.34537 16.7954 1.16626 15.3375 1.16626C13.8796 1.16626 12.6978 2.34537 12.6978 3.79987C12.6978 5.25438 13.8796 6.43349 15.3375 6.43349Z" fill="#B224F9"/>
      <path d="M15.3375 6.44862C16.7954 6.44862 17.9772 5.26951 17.9772 3.81501C17.9772 2.36051 16.7954 1.1814 15.3375 1.1814C13.8796 1.1814 12.6978 2.36051 12.6978 3.81501C12.6978 5.26951 13.8796 6.44862 15.3375 6.44862Z" fill="#B224F9"/>
      <path d="M15.3375 6.47841C16.7954 6.47841 17.9772 5.2993 17.9772 3.84479C17.9772 2.39029 16.7954 1.21118 15.3375 1.21118C13.8796 1.21118 12.6978 2.39029 12.6978 3.84479C12.6978 5.2993 13.8796 6.47841 15.3375 6.47841Z" fill="#B124F9"/>
      <path d="M15.3375 6.50966C16.7954 6.50966 17.9772 5.33055 17.9772 3.87604C17.9772 2.42154 16.7954 1.24243 15.3375 1.24243C13.8796 1.24243 12.6978 2.42154 12.6978 3.87604C12.6978 5.33055 13.8796 6.50966 15.3375 6.50966Z" fill="#B124F9"/>
      <path d="M15.3375 6.53859C16.7954 6.53859 17.9772 5.35948 17.9772 3.90498C17.9772 2.45047 16.7954 1.27136 15.3375 1.27136C13.8796 1.27136 12.6978 2.45047 12.6978 3.90498C12.6978 5.35948 13.8796 6.53859 15.3375 6.53859Z" fill="#B124F9"/>
      <path d="M15.3375 6.55311C16.7954 6.55311 17.9772 5.37401 17.9772 3.9195C17.9772 2.465 16.7954 1.28589 15.3375 1.28589C13.8796 1.28589 12.6978 2.465 12.6978 3.9195C12.6978 5.37401 13.8796 6.55311 15.3375 6.55311Z" fill="#B124F9"/>
      <path d="M15.3375 6.58412C16.7954 6.58412 17.9772 5.40501 17.9772 3.95051C17.9772 2.496 16.7954 1.31689 15.3375 1.31689C13.8796 1.31689 12.6978 2.496 12.6978 3.95051C12.6978 5.40501 13.8796 6.58412 15.3375 6.58412Z" fill="#B024F9"/>
      <path d="M15.3375 6.61415C16.7954 6.61415 17.9772 5.43504 17.9772 3.98054C17.9772 2.52603 16.7954 1.34692 15.3375 1.34692C13.8796 1.34692 12.6978 2.52603 12.6978 3.98054C12.6978 5.43504 13.8796 6.61415 15.3375 6.61415Z" fill="#B024F9"/>
      <path d="M15.3375 6.64516C16.7954 6.64516 17.9772 5.46605 17.9772 4.01154C17.9772 2.55704 16.7954 1.37793 15.3375 1.37793C13.8796 1.37793 12.6978 2.55704 12.6978 4.01154C12.6978 5.46605 13.8796 6.64516 15.3375 6.64516Z" fill="#B024F9"/>
      <path d="M15.3375 6.65968C16.7954 6.65968 17.9772 5.48057 17.9772 4.02607C17.9772 2.57156 16.7954 1.39246 15.3375 1.39246C13.8796 1.39246 12.6978 2.57156 12.6978 4.02607C12.6978 5.48057 13.8796 6.65968 15.3375 6.65968Z" fill="#AF24F9"/>
      <path d="M15.3375 6.69069C16.7954 6.69069 17.9772 5.51158 17.9772 4.05708C17.9772 2.60257 16.7954 1.42346 15.3375 1.42346C13.8796 1.42346 12.6978 2.60257 12.6978 4.05708C12.6978 5.51158 13.8796 6.69069 15.3375 6.69069Z" fill="#AF24F9"/>
      <path d="M15.3375 6.72047C16.7954 6.72047 17.9772 5.54136 17.9772 4.08686C17.9772 2.63236 16.7954 1.45325 15.3375 1.45325C13.8796 1.45325 12.6978 2.63236 12.6978 4.08686C12.6978 5.54136 13.8796 6.72047 15.3375 6.72047Z" fill="#AF24F9"/>
      <path d="M15.3375 6.735C16.7954 6.735 17.9772 5.55589 17.9772 4.10139C17.9772 2.64688 16.7954 1.46777 15.3375 1.46777C13.8796 1.46777 12.6978 2.64688 12.6978 4.10139C12.6978 5.55589 13.8796 6.735 15.3375 6.735Z" fill="#AF24F9"/>
      <path d="M15.3375 6.76625C16.7954 6.76625 17.9772 5.58714 17.9772 4.13264C17.9772 2.67813 16.7954 1.49902 15.3375 1.49902C13.8796 1.49902 12.6978 2.67813 12.6978 4.13264C12.6978 5.58714 13.8796 6.76625 15.3375 6.76625Z" fill="#AE24F9"/>
      <path d="M15.3375 6.79603C16.7954 6.79603 17.9772 5.61693 17.9772 4.16242C17.9772 2.70792 16.7954 1.52881 15.3375 1.52881C13.8796 1.52881 12.6978 2.70792 12.6978 4.16242C12.6978 5.61693 13.8796 6.79603 15.3375 6.79603Z" fill="#AE24F9"/>
      <path d="M15.3375 6.82692C16.7954 6.82692 17.9772 5.64781 17.9772 4.19331C17.9772 2.7388 16.7954 1.55969 15.3375 1.55969C13.8796 1.55969 12.6978 2.7388 12.6978 4.19331C12.6978 5.64781 13.8796 6.82692 15.3375 6.82692Z" fill="#AE25F9"/>
      <path d="M15.3375 6.84157C16.7954 6.84157 17.9772 5.66246 17.9772 4.20795C17.9772 2.75345 16.7954 1.57434 15.3375 1.57434C13.8796 1.57434 12.6978 2.75345 12.6978 4.20795C12.6978 5.66246 13.8796 6.84157 15.3375 6.84157Z" fill="#AD25F9"/>
      <path d="M15.3375 6.87282C16.7954 6.87282 17.9772 5.69371 17.9772 4.2392C17.9772 2.7847 16.7954 1.60559 15.3375 1.60559C13.8796 1.60559 12.6978 2.7847 12.6978 4.2392C12.6978 5.69371 13.8796 6.87282 15.3375 6.87282Z" fill="#AD25F9"/>
      <path d="M15.3375 6.90224C16.7954 6.90224 17.9772 5.72313 17.9772 4.26862C17.9772 2.81412 16.7954 1.63501 15.3375 1.63501C13.8796 1.63501 12.6978 2.81412 12.6978 4.26862C12.6978 5.72313 13.8796 6.90224 15.3375 6.90224Z" fill="#AD25F9"/>
      <path d="M15.3375 6.91688C16.7954 6.91688 17.9772 5.73778 17.9772 4.28327C17.9772 2.82877 16.7954 1.64966 15.3375 1.64966C13.8796 1.64966 12.6978 2.82877 12.6978 4.28327C12.6978 5.73778 13.8796 6.91688 15.3375 6.91688Z" fill="#AC25F9"/>
      <path d="M15.3375 6.94813C16.7954 6.94813 17.9772 5.76903 17.9772 4.31452C17.9772 2.86002 16.7954 1.68091 15.3375 1.68091C13.8796 1.68091 12.6978 2.86002 12.6978 4.31452C12.6978 5.76903 13.8796 6.94813 15.3375 6.94813Z" fill="#AC25F9"/>
      <path d="M15.3375 6.97792C16.7954 6.97792 17.9772 5.79881 17.9772 4.34431C17.9772 2.8898 16.7954 1.71069 15.3375 1.71069C13.8796 1.71069 12.6978 2.8898 12.6978 4.34431C12.6978 5.79881 13.8796 6.97792 15.3375 6.97792Z" fill="#AC25F9"/>
      <path d="M15.3375 7.0088C16.7954 7.0088 17.9772 5.82969 17.9772 4.37519C17.9772 2.92069 16.7954 1.74158 15.3375 1.74158C13.8796 1.74158 12.6978 2.92069 12.6978 4.37519C12.6978 5.82969 13.8796 7.0088 15.3375 7.0088Z" fill="#AC25F9"/>
      <path d="M15.3375 7.02345C16.7954 7.02345 17.9772 5.84434 17.9772 4.38984C17.9772 2.93533 16.7954 1.75623 15.3375 1.75623C13.8796 1.75623 12.6978 2.93533 12.6978 4.38984C12.6978 5.84434 13.8796 7.02345 15.3375 7.02345Z" fill="#AB25F9"/>
      <path d="M15.3375 7.05324C16.7954 7.05324 17.9772 5.87413 17.9772 4.41962C17.9772 2.96512 16.7954 1.78601 15.3375 1.78601C13.8796 1.78601 12.6978 2.96512 12.6978 4.41962C12.6978 5.87413 13.8796 7.05324 15.3375 7.05324Z" fill="#AB25F9"/>
      <path d="M15.3375 7.08388C16.7954 7.08388 17.9772 5.90477 17.9772 4.45026C17.9772 2.99576 16.7954 1.81665 15.3375 1.81665C13.8796 1.81665 12.6978 2.99576 12.6978 4.45026C12.6978 5.90477 13.8796 7.08388 15.3375 7.08388Z" fill="#AB25F9"/>
      <path d="M15.3375 7.09901C16.7954 7.09901 17.9772 5.9199 17.9772 4.4654C17.9772 3.0109 16.7954 1.83179 15.3375 1.83179C13.8796 1.83179 12.6978 3.0109 12.6978 4.4654C12.6978 5.9199 13.8796 7.09901 15.3375 7.09901Z" fill="#AA25F9"/>
      <path d="M15.3375 7.13002C16.7954 7.13002 17.9772 5.95091 17.9772 4.49641C17.9772 3.0419 16.7954 1.86279 15.3375 1.86279C13.8796 1.86279 12.6978 3.0419 12.6978 4.49641C12.6978 5.95091 13.8796 7.13002 15.3375 7.13002Z" fill="#AA25F9"/>
      <path d="M15.3375 7.15919C16.7954 7.15919 17.9772 5.98009 17.9772 4.52558C17.9772 3.07108 16.7954 1.89197 15.3375 1.89197C13.8796 1.89197 12.6978 3.07108 12.6978 4.52558C12.6978 5.98009 13.8796 7.15919 15.3375 7.15919Z" fill="#AA25F9"/>
      <path d="M15.3375 7.19105C16.7954 7.19105 17.9772 6.01195 17.9772 4.55744C17.9772 3.10294 16.7954 1.92383 15.3375 1.92383C13.8796 1.92383 12.6978 3.10294 12.6978 4.55744C12.6978 6.01195 13.8796 7.19105 15.3375 7.19105Z" fill="#A925F9"/>
      <path d="M15.3375 7.20558C16.7954 7.20558 17.9772 6.02647 17.9772 4.57197C17.9772 3.11746 16.7954 1.93835 15.3375 1.93835C13.8796 1.93835 12.6978 3.11746 12.6978 4.57197C12.6978 6.02647 13.8796 7.20558 15.3375 7.20558Z" fill="#A925F9"/>
      <path d="M15.3375 7.23451C16.7954 7.23451 17.9772 6.0554 17.9772 4.6009C17.9772 3.14639 16.7954 1.96729 15.3375 1.96729C13.8796 1.96729 12.6978 3.14639 12.6978 4.6009C12.6978 6.0554 13.8796 7.23451 15.3375 7.23451Z" fill="#A926F9"/>
      <path d="M15.3375 7.26539C16.7954 7.26539 17.9772 6.08629 17.9772 4.63178C17.9772 3.17728 16.7954 1.99817 15.3375 1.99817C13.8796 1.99817 12.6978 3.17728 12.6978 4.63178C12.6978 6.08629 13.8796 7.26539 15.3375 7.26539Z" fill="#A926F9"/>
      <path d="M15.3375 7.2809C16.7954 7.2809 17.9772 6.10179 17.9772 4.64728C17.9772 3.19278 16.7954 2.01367 15.3375 2.01367C13.8796 2.01367 12.6978 3.19278 12.6978 4.64728C12.6978 6.10179 13.8796 7.2809 15.3375 7.2809Z" fill="#A826F9"/>
      <path d="M15.3375 7.31007C16.7954 7.31007 17.9772 6.13096 17.9772 4.67646C17.9772 3.22196 16.7954 2.04285 15.3375 2.04285C13.8796 2.04285 12.6978 3.22196 12.6978 4.67646C12.6978 6.13096 13.8796 7.31007 15.3375 7.31007Z" fill="#A826F9"/>
      <path d="M15.3375 7.34108C16.7954 7.34108 17.9772 6.16197 17.9772 4.70747C17.9772 3.25296 16.7954 2.07385 15.3375 2.07385C13.8796 2.07385 12.6978 3.25296 12.6978 4.70747C12.6978 6.16197 13.8796 7.34108 15.3375 7.34108Z" fill="#A826F9"/>
      <path d="M15.3375 7.37086C16.7954 7.37086 17.9772 6.19176 17.9772 4.73725C17.9772 3.28275 16.7954 2.10364 15.3375 2.10364C13.8796 2.10364 12.6978 3.28275 12.6978 4.73725C12.6978 6.19176 13.8796 7.37086 15.3375 7.37086Z" fill="#A726F9"/>
      <path d="M15.3375 7.38722C16.7954 7.38722 17.9772 6.20811 17.9772 4.75361C17.9772 3.2991 16.7954 2.12 15.3375 2.12C13.8796 2.12 12.6978 3.2991 12.6978 4.75361C12.6978 6.20811 13.8796 7.38722 15.3375 7.38722Z" fill="#A726F9"/>
      <path d="M15.3375 7.41664C16.7954 7.41664 17.9772 6.23753 17.9772 4.78303C17.9772 3.32852 16.7954 2.14941 15.3375 2.14941C13.8796 2.14941 12.6978 3.32852 12.6978 4.78303C12.6978 6.23753 13.8796 7.41664 15.3375 7.41664Z" fill="#A726F9"/>
      <path d="M15.3375 7.44765C16.7954 7.44765 17.9772 6.26854 17.9772 4.81403C17.9772 3.35953 16.7954 2.18042 15.3375 2.18042C13.8796 2.18042 12.6978 3.35953 12.6978 4.81403C12.6978 6.26854 13.8796 7.44765 15.3375 7.44765Z" fill="#A626F9"/>
      <path d="M15.3375 7.46217C16.7954 7.46217 17.9772 6.28306 17.9772 4.82856C17.9772 3.37405 16.7954 2.19495 15.3375 2.19495C13.8796 2.19495 12.6978 3.37405 12.6978 4.82856C12.6978 6.28306 13.8796 7.46217 15.3375 7.46217Z" fill="#A626F9"/>
      <path d="M15.3375 7.49196C16.7954 7.49196 17.9772 6.31285 17.9772 4.85834C17.9772 3.40384 16.7954 2.22473 15.3375 2.22473C13.8796 2.22473 12.6978 3.40384 12.6978 4.85834C12.6978 6.31285 13.8796 7.49196 15.3375 7.49196Z" fill="#A626F9"/>
      <path d="M15.3375 7.52296C16.7954 7.52296 17.9772 6.34385 17.9772 4.88935C17.9772 3.43485 16.7954 2.25574 15.3375 2.25574C13.8796 2.25574 12.6978 3.43485 12.6978 4.88935C12.6978 6.34385 13.8796 7.52296 15.3375 7.52296Z" fill="#A626F8"/>
      <path d="M15.3375 7.55275C16.7954 7.55275 17.9772 6.37364 17.9772 4.91914C17.9772 3.46463 16.7954 2.28552 15.3375 2.28552C13.8796 2.28552 12.6978 3.46463 12.6978 4.91914C12.6978 6.37364 13.8796 7.55275 15.3375 7.55275Z" fill="#A526F8"/>
      <path d="M15.3375 7.56935C16.7954 7.56935 17.9772 6.39024 17.9772 4.93574C17.9772 3.48123 16.7954 2.30212 15.3375 2.30212C13.8796 2.30212 12.6978 3.48123 12.6978 4.93574C12.6978 6.39024 13.8796 7.56935 15.3375 7.56935Z" fill="#A526F8"/>
      <path d="M15.3375 7.59828C16.7954 7.59828 17.9772 6.41917 17.9772 4.96467C17.9772 3.51016 16.7954 2.33105 15.3375 2.33105C13.8796 2.33105 12.6978 3.51016 12.6978 4.96467C12.6978 6.41917 13.8796 7.59828 15.3375 7.59828Z" fill="#A526F8"/>
      <path d="M15.3375 7.62953C16.7954 7.62953 17.9772 6.45042 17.9772 4.99592C17.9772 3.54141 16.7954 2.3623 15.3375 2.3623C13.8796 2.3623 12.6978 3.54141 12.6978 4.99592C12.6978 6.45042 13.8796 7.62953 15.3375 7.62953Z" fill="#A426F8"/>
      <path d="M15.3375 7.64406C16.7954 7.64406 17.9772 6.46495 17.9772 5.01044C17.9772 3.55594 16.7954 2.37683 15.3375 2.37683C13.8796 2.37683 12.6978 3.55594 12.6978 5.01044C12.6978 6.46495 13.8796 7.64406 15.3375 7.64406Z" fill="#A427F8"/>
      <path d="M15.3375 7.67384C16.7954 7.67384 17.9772 6.49473 17.9772 5.04023C17.9772 3.58572 16.7954 2.40662 15.3375 2.40662C13.8796 2.40662 12.6978 3.58572 12.6978 5.04023C12.6978 6.49473 13.8796 7.67384 15.3375 7.67384Z" fill="#A427F8"/>
      <path d="M15.3375 7.70485C16.7954 7.70485 17.9772 6.52574 17.9772 5.07123C17.9772 3.61673 16.7954 2.43762 15.3375 2.43762C13.8796 2.43762 12.6978 3.61673 12.6978 5.07123C12.6978 6.52574 13.8796 7.70485 15.3375 7.70485Z" fill="#A427F8"/>
      <path d="M15.3375 7.73451C16.7954 7.73451 17.9772 6.5554 17.9772 5.1009C17.9772 3.64639 16.7954 2.46729 15.3375 2.46729C13.8796 2.46729 12.6978 3.64639 12.6978 5.1009C12.6978 6.5554 13.8796 7.73451 15.3375 7.73451Z" fill="#A327F8"/>
      <path d="M15.3375 7.74916C16.7954 7.74916 17.9772 6.57005 17.9772 5.11555C17.9772 3.66104 16.7954 2.48193 15.3375 2.48193C13.8796 2.48193 12.6978 3.66104 12.6978 5.11555C12.6978 6.57005 13.8796 7.74916 15.3375 7.74916Z" fill="#A327F8"/>
      <path d="M15.3375 7.78041C16.7954 7.78041 17.9772 6.6013 17.9772 5.1468C17.9772 3.69229 16.7954 2.51318 15.3375 2.51318C13.8796 2.51318 12.6978 3.69229 12.6978 5.1468C12.6978 6.6013 13.8796 7.78041 15.3375 7.78041Z" fill="#A327F8"/>
      <path d="M15.3375 7.80934C16.7954 7.80934 17.9772 6.63023 17.9772 5.17573C17.9772 3.72122 16.7954 2.54211 15.3375 2.54211C13.8796 2.54211 12.6978 3.72122 12.6978 5.17573C12.6978 6.63023 13.8796 7.80934 15.3375 7.80934Z" fill="#A227F8"/>
      <path d="M15.3375 7.82594C16.7954 7.82594 17.9772 6.64683 17.9772 5.19233C17.9772 3.73782 16.7954 2.55872 15.3375 2.55872C13.8796 2.55872 12.6978 3.73782 12.6978 5.19233C12.6978 6.64683 13.8796 7.82594 15.3375 7.82594Z" fill="#A227F8"/>
      <path d="M15.3375 7.85573C16.7954 7.85573 17.9772 6.67662 17.9772 5.22211C17.9772 3.76761 16.7954 2.5885 15.3375 2.5885C13.8796 2.5885 12.6978 3.76761 12.6978 5.22211C12.6978 6.67662 13.8796 7.85573 15.3375 7.85573Z" fill="#A227F8"/>
      <path d="M15.3375 7.88698C16.7954 7.88698 17.9772 6.70787 17.9772 5.25336C17.9772 3.79886 16.7954 2.61975 15.3375 2.61975C13.8796 2.61975 12.6978 3.79886 12.6978 5.25336C12.6978 6.70787 13.8796 7.88698 15.3375 7.88698Z" fill="#A127F8"/>
      <path d="M15.3375 7.9164C16.7954 7.9164 17.9772 6.73729 17.9772 5.28278C17.9772 3.82828 16.7954 2.64917 15.3375 2.64917C13.8796 2.64917 12.6978 3.82828 12.6978 5.28278C12.6978 6.73729 13.8796 7.9164 15.3375 7.9164Z" fill="#A127F8"/>
      <path d="M15.3375 7.93104C16.7954 7.93104 17.9772 6.75194 17.9772 5.29743C17.9772 3.84293 16.7954 2.66382 15.3375 2.66382C13.8796 2.66382 12.6978 3.84293 12.6978 5.29743C12.6978 6.75194 13.8796 7.93104 15.3375 7.93104Z" fill="#A127F8"/>
      <path d="M15.3375 7.96229C16.7954 7.96229 17.9772 6.78319 17.9772 5.32868C17.9772 3.87418 16.7954 2.69507 15.3375 2.69507C13.8796 2.69507 12.6978 3.87418 12.6978 5.32868C12.6978 6.78319 13.8796 7.96229 15.3375 7.96229Z" fill="#A127F8"/>
      <path d="M15.3375 7.99147C16.7954 7.99147 17.9772 6.81236 17.9772 5.35786C17.9772 3.90335 16.7954 2.72424 15.3375 2.72424C13.8796 2.72424 12.6978 3.90335 12.6978 5.35786C12.6978 6.81236 13.8796 7.99147 15.3375 7.99147Z" fill="#A027F8"/>
      <path d="M15.3375 8.00783C16.7954 8.00783 17.9772 6.82872 17.9772 5.37421C17.9772 3.91971 16.7954 2.7406 15.3375 2.7406C13.8796 2.7406 12.6978 3.91971 12.6978 5.37421C12.6978 6.82872 13.8796 8.00783 15.3375 8.00783Z" fill="#A027F8"/>
      <path d="M15.3375 8.037C16.7954 8.037 17.9772 6.85789 17.9772 5.40339C17.9772 3.94888 16.7954 2.76978 15.3375 2.76978C13.8796 2.76978 12.6978 3.94888 12.6978 5.40339C12.6978 6.85789 13.8796 8.037 15.3375 8.037Z" fill="#A027F8"/>
      <path d="M15.3375 8.06679C16.7954 8.06679 17.9772 6.88768 17.9772 5.43317C17.9772 3.97867 16.7954 2.79956 15.3375 2.79956C13.8796 2.79956 12.6978 3.97867 12.6978 5.43317C12.6978 6.88768 13.8796 8.06679 15.3375 8.06679Z" fill="#9F28F8"/>
      <path d="M15.3375 8.09804C16.7954 8.09804 17.9772 6.91893 17.9772 5.46442C17.9772 4.00992 16.7954 2.83081 15.3375 2.83081C13.8796 2.83081 12.6978 4.00992 12.6978 5.46442C12.6978 6.91893 13.8796 8.09804 15.3375 8.09804Z" fill="#9F28F8"/>
      <path d="M15.3375 8.11317C16.7954 8.11317 17.9772 6.93406 17.9772 5.47956C17.9772 4.02506 16.7954 2.84595 15.3375 2.84595C13.8796 2.84595 12.6978 4.02506 12.6978 5.47956C12.6978 6.93406 13.8796 8.11317 15.3375 8.11317Z" fill="#9F28F8"/>
      <path d="M15.3375 8.14418C16.7954 8.14418 17.9772 6.96507 17.9772 5.51057C17.9772 4.05606 16.7954 2.87695 15.3375 2.87695C13.8796 2.87695 12.6978 4.05606 12.6978 5.51057C12.6978 6.96507 13.8796 8.14418 15.3375 8.14418Z" fill="#9E28F8"/>
      <path d="M15.3375 8.17335C16.7954 8.17335 17.9772 6.99425 17.9772 5.53974C17.9772 4.08524 16.7954 2.90613 15.3375 2.90613C13.8796 2.90613 12.6978 4.08524 12.6978 5.53974C12.6978 6.99425 13.8796 8.17335 15.3375 8.17335Z" fill="#9E28F8"/>
      <path d="M15.3375 8.20424C16.7954 8.20424 17.9772 7.02513 17.9772 5.57062C17.9772 4.11612 16.7954 2.93701 15.3375 2.93701C13.8796 2.93701 12.6978 4.11612 12.6978 5.57062C12.6978 7.02513 13.8796 8.20424 15.3375 8.20424Z" fill="#9E28F8"/>
      <path d="M15.3375 8.21889C16.7954 8.21889 17.9772 7.03978 17.9772 5.58527C17.9772 4.13077 16.7954 2.95166 15.3375 2.95166C13.8796 2.95166 12.6978 4.13077 12.6978 5.58527C12.6978 7.03978 13.8796 8.21889 15.3375 8.21889Z" fill="#9E28F8"/>
      <path d="M15.3375 8.24867C16.7954 8.24867 17.9772 7.06956 17.9772 5.61506C17.9772 4.16055 16.7954 2.98145 15.3375 2.98145C13.8796 2.98145 12.6978 4.16055 12.6978 5.61506C12.6978 7.06956 13.8796 8.24867 15.3375 8.24867Z" fill="#9D28F8"/>
      <path d="M15.3375 8.27956C16.7954 8.27956 17.9772 7.10045 17.9772 5.64594C17.9772 4.19144 16.7954 3.01233 15.3375 3.01233C13.8796 3.01233 12.6978 4.19144 12.6978 5.64594C12.6978 7.10045 13.8796 8.27956 15.3375 8.27956Z" fill="#9D28F8"/>
      <path d="M15.3375 8.29506C16.7954 8.29506 17.9772 7.11595 17.9772 5.66145C17.9772 4.20694 16.7954 3.02783 15.3375 3.02783C13.8796 3.02783 12.6978 4.20694 12.6978 5.66145C12.6978 7.11595 13.8796 8.29506 15.3375 8.29506Z" fill="#9D28F8"/>
      <path d="M15.3375 8.32606C16.7954 8.32606 17.9772 7.14696 17.9772 5.69245C17.9772 4.23795 16.7954 3.05884 15.3375 3.05884C13.8796 3.05884 12.6978 4.23795 12.6978 5.69245C12.6978 7.14696 13.8796 8.32606 15.3375 8.32606Z" fill="#9C28F8"/>
      <path d="M15.3375 8.35524C16.7954 8.35524 17.9772 7.17613 17.9772 5.72163C17.9772 4.26712 16.7954 3.08801 15.3375 3.08801C13.8796 3.08801 12.6978 4.26712 12.6978 5.72163C12.6978 7.17613 13.8796 8.35524 15.3375 8.35524Z" fill="#9C28F8"/>
      <path d="M15.3375 8.38612C16.7954 8.38612 17.9772 7.20701 17.9772 5.75251C17.9772 4.29801 16.7954 3.1189 15.3375 3.1189C13.8796 3.1189 12.6978 4.29801 12.6978 5.75251C12.6978 7.20701 13.8796 8.38612 15.3375 8.38612Z" fill="#9C28F8"/>
      <path d="M15.3375 8.40077C16.7954 8.40077 17.9772 7.22166 17.9772 5.76716C17.9772 4.31265 16.7954 3.13354 15.3375 3.13354C13.8796 3.13354 12.6978 4.31265 12.6978 5.76716C12.6978 7.22166 13.8796 8.40077 15.3375 8.40077Z" fill="#9B28F8"/>
      <path d="M15.3375 8.43056C16.7954 8.43056 17.9772 7.25145 17.9772 5.79694C17.9772 4.34244 16.7954 3.16333 15.3375 3.16333C13.8796 3.16333 12.6978 4.34244 12.6978 5.79694C12.6978 7.25145 13.8796 8.43056 15.3375 8.43056Z" fill="#9B28F8"/>
      <path d="M15.3375 8.46181C16.7954 8.46181 17.9772 7.2827 17.9772 5.82819C17.9772 4.37369 16.7954 3.19458 15.3375 3.19458C13.8796 3.19458 12.6978 4.37369 12.6978 5.82819C12.6978 7.2827 13.8796 8.46181 15.3375 8.46181Z" fill="#9B29F8"/>
      <path d="M15.3375 8.47694C16.7954 8.47694 17.9772 7.29783 17.9772 5.84333C17.9772 4.38883 16.7954 3.20972 15.3375 3.20972C13.8796 3.20972 12.6978 4.38883 12.6978 5.84333C12.6978 7.29783 13.8796 8.47694 15.3375 8.47694Z" fill="#9B29F8"/>
      <path d="M15.3375 8.50612C16.7954 8.50612 17.9772 7.32701 17.9772 5.8725C17.9772 4.418 16.7954 3.23889 15.3375 3.23889C13.8796 3.23889 12.6978 4.418 12.6978 5.8725C12.6978 7.32701 13.8796 8.50612 15.3375 8.50612Z" fill="#9A29F8"/>
      <path d="M15.3375 8.53712C16.7954 8.53712 17.9772 7.35801 17.9772 5.90351C17.9772 4.44901 16.7954 3.2699 15.3375 3.2699C13.8796 3.2699 12.6978 4.44901 12.6978 5.90351C12.6978 7.35801 13.8796 8.53712 15.3375 8.53712Z" fill="#9A29F8"/>
      <path d="M15.3375 8.5663C16.7954 8.5663 17.9772 7.38719 17.9772 5.93269C17.9772 4.47818 16.7954 3.29907 15.3375 3.29907C13.8796 3.29907 12.6978 4.47818 12.6978 5.93269C12.6978 7.38719 13.8796 8.5663 15.3375 8.5663Z" fill="#9A29F8"/>
      <path d="M15.3375 8.58266C16.7954 8.58266 17.9772 7.40355 17.9772 5.94904C17.9772 4.49454 16.7954 3.31543 15.3375 3.31543C13.8796 3.31543 12.6978 4.49454 12.6978 5.94904C12.6978 7.40355 13.8796 8.58266 15.3375 8.58266Z" fill="#9929F8"/>
      <path d="M15.3375 8.61244C16.7954 8.61244 17.9772 7.43333 17.9772 5.97883C17.9772 4.52432 16.7954 3.34521 15.3375 3.34521C13.8796 3.34521 12.6978 4.52432 12.6978 5.97883C12.6978 7.43333 13.8796 8.61244 15.3375 8.61244Z" fill="#9929F8"/>
      <path d="M15.3375 8.64357C16.7954 8.64357 17.9772 7.46446 17.9772 6.00996C17.9772 4.55545 16.7954 3.37634 15.3375 3.37634C13.8796 3.37634 12.6978 4.55545 12.6978 6.00996C12.6978 7.46446 13.8796 8.64357 15.3375 8.64357Z" fill="#9929F8"/>
      <path d="M15.3375 8.65822C16.7954 8.65822 17.9772 7.47911 17.9772 6.0246C17.9772 4.5701 16.7954 3.39099 15.3375 3.39099C13.8796 3.39099 12.6978 4.5701 12.6978 6.0246C12.6978 7.47911 13.8796 8.65822 15.3375 8.65822Z" fill="#9829F8"/>
      <path d="M15.3375 8.688C16.7954 8.688 17.9772 7.50889 17.9772 6.05439C17.9772 4.59988 16.7954 3.42078 15.3375 3.42078C13.8796 3.42078 12.6978 4.59988 12.6978 6.05439C12.6978 7.50889 13.8796 8.688 15.3375 8.688Z" fill="#9829F8"/>
      <path d="M15.3375 8.71889C16.7954 8.71889 17.9772 7.53978 17.9772 6.08527C17.9772 4.63077 16.7954 3.45166 15.3375 3.45166C13.8796 3.45166 12.6978 4.63077 12.6978 6.08527C12.6978 7.53978 13.8796 8.71889 15.3375 8.71889Z" fill="#9829F8"/>
      <path d="M15.3375 8.74818C16.7954 8.74818 17.9772 7.56907 17.9772 6.11457C17.9772 4.66007 16.7954 3.48096 15.3375 3.48096C13.8796 3.48096 12.6978 4.66007 12.6978 6.11457C12.6978 7.56907 13.8796 8.74818 15.3375 8.74818Z" fill="#9829F8"/>
      <path d="M15.3375 8.76478C16.7954 8.76478 17.9772 7.58568 17.9772 6.13117C17.9772 4.67667 16.7954 3.49756 15.3375 3.49756C13.8796 3.49756 12.6978 4.67667 12.6978 6.13117C12.6978 7.58568 13.8796 8.76478 15.3375 8.76478Z" fill="#9729F8"/>
      <path d="M15.3375 8.79457C16.7954 8.79457 17.9772 7.61546 17.9772 6.16096C17.9772 4.70645 16.7954 3.52734 15.3375 3.52734C13.8796 3.52734 12.6978 4.70645 12.6978 6.16096C12.6978 7.61546 13.8796 8.79457 15.3375 8.79457Z" fill="#9729F8"/>
      <path d="M15.3375 8.82399C16.7954 8.82399 17.9772 7.64488 17.9772 6.19038C17.9772 4.73587 16.7954 3.55676 15.3375 3.55676C13.8796 3.55676 12.6978 4.73587 12.6978 6.19038C12.6978 7.64488 13.8796 8.82399 15.3375 8.82399Z" fill="#9729F8"/>
      <path d="M15.3375 8.8401C16.7954 8.8401 17.9772 7.66099 17.9772 6.20649C17.9772 4.75198 16.7954 3.57288 15.3375 3.57288C13.8796 3.57288 12.6978 4.75198 12.6978 6.20649C12.6978 7.66099 13.8796 8.8401 15.3375 8.8401Z" fill="#9629F8"/>
      <path d="M15.3375 8.86989C16.7954 8.86989 17.9772 7.69078 17.9772 6.23627C17.9772 4.78177 16.7954 3.60266 15.3375 3.60266C13.8796 3.60266 12.6978 4.78177 12.6978 6.23627C12.6978 7.69078 13.8796 8.86989 15.3375 8.86989Z" fill="#962AF8"/>
      <path d="M15.3375 8.90114C16.7954 8.90114 17.9772 7.72203 17.9772 6.26752C17.9772 4.81302 16.7954 3.63391 15.3375 3.63391C13.8796 3.63391 12.6978 4.81302 12.6978 6.26752C12.6978 7.72203 13.8796 8.90114 15.3375 8.90114Z" fill="#962AF8"/>
      <path d="M15.3375 8.92995C16.7954 8.92995 17.9772 7.75084 17.9772 6.29633C17.9772 4.84183 16.7954 3.66272 15.3375 3.66272C13.8796 3.66272 12.6978 4.84183 12.6978 6.29633C12.6978 7.75084 13.8796 8.92995 15.3375 8.92995Z" fill="#962AF8"/>
      <path d="M15.3375 8.9452C16.7954 8.9452 17.9772 7.7661 17.9772 6.31159C17.9772 4.85709 16.7954 3.67798 15.3375 3.67798C13.8796 3.67798 12.6978 4.85709 12.6978 6.31159C12.6978 7.7661 13.8796 8.9452 15.3375 8.9452Z" fill="#952AF8"/>
      <path d="M15.3375 8.97548C16.7954 8.97548 17.9772 7.79637 17.9772 6.34187C17.9772 4.88736 16.7954 3.70825 15.3375 3.70825C13.8796 3.70825 12.6978 4.88736 12.6978 6.34187C12.6978 7.79637 13.8796 8.97548 15.3375 8.97548Z" fill="#952AF8"/>
      <path d="M15.3375 9.00526C16.7954 9.00526 17.9772 7.82615 17.9772 6.37165C17.9772 4.91715 16.7954 3.73804 15.3375 3.73804C13.8796 3.73804 12.6978 4.91715 12.6978 6.37165C12.6978 7.82615 13.8796 9.00526 15.3375 9.00526Z" fill="#952AF8"/>
      <path d="M15.3375 9.02199C16.7954 9.02199 17.9772 7.84288 17.9772 6.38837C17.9772 4.93387 16.7954 3.75476 15.3375 3.75476C13.8796 3.75476 12.6978 4.93387 12.6978 6.38837C12.6978 7.84288 13.8796 9.02199 15.3375 9.02199Z" fill="#942AF8"/>
      <path d="M15.3375 9.05177C16.7954 9.05177 17.9772 7.87266 17.9772 6.41816C17.9772 4.96365 16.7954 3.78455 15.3375 3.78455C13.8796 3.78455 12.6978 4.96365 12.6978 6.41816C12.6978 7.87266 13.8796 9.05177 15.3375 9.05177Z" fill="#942AF8"/>
      <path d="M15.3375 9.08205C16.7954 9.08205 17.9772 7.90294 17.9772 6.44843C17.9772 4.99393 16.7954 3.81482 15.3375 3.81482C13.8796 3.81482 12.6978 4.99393 12.6978 6.44843C12.6978 7.90294 13.8796 9.08205 15.3375 9.08205Z" fill="#942AF8"/>
      <path d="M15.3375 9.11183C16.7954 9.11183 17.9772 7.93272 17.9772 6.47822C17.9772 5.02371 16.7954 3.8446 15.3375 3.8446C13.8796 3.8446 12.6978 5.02371 12.6978 6.47822C12.6978 7.93272 13.8796 9.11183 15.3375 9.11183Z" fill="#932AF8"/>
      <path d="M15.3375 9.12648C16.7954 9.12648 17.9772 7.94737 17.9772 6.49287C17.9772 5.03836 16.7954 3.85925 15.3375 3.85925C13.8796 3.85925 12.6978 5.03836 12.6978 6.49287C12.6978 7.94737 13.8796 9.12648 15.3375 9.12648Z" fill="#932AF8"/>
      <path d="M15.3375 9.15736C16.7954 9.15736 17.9772 7.97825 17.9772 6.52375C17.9772 5.06925 16.7954 3.89014 15.3375 3.89014C13.8796 3.89014 12.6978 5.06925 12.6978 6.52375C12.6978 7.97825 13.8796 9.15736 15.3375 9.15736Z" fill="#932AF8"/>
      <path d="M15.3375 9.18751C16.7954 9.18751 17.9772 8.00841 17.9772 6.5539C17.9772 5.0994 16.7954 3.92029 15.3375 3.92029C13.8796 3.92029 12.6978 5.0994 12.6978 6.5539C12.6978 8.00841 13.8796 9.18751 15.3375 9.18751Z" fill="#932AF8"/>
      <path d="M15.3375 9.20265C16.7954 9.20265 17.9772 8.02354 17.9772 6.56904C17.9772 5.11453 16.7954 3.93542 15.3375 3.93542C13.8796 3.93542 12.6978 5.11453 12.6978 6.56904C12.6978 8.02354 13.8796 9.20265 15.3375 9.20265Z" fill="#922AF8"/>
      <path d="M15.3375 9.23305C16.7954 9.23305 17.9772 8.05394 17.9772 6.59943C17.9772 5.14493 16.7954 3.96582 15.3375 3.96582C13.8796 3.96582 12.6978 5.14493 12.6978 6.59943C12.6978 8.05394 13.8796 9.23305 15.3375 9.23305Z" fill="#922AF8"/>
      <path d="M15.3375 9.26283C16.7954 9.26283 17.9772 8.08372 17.9772 6.62922C17.9772 5.17471 16.7954 3.99561 15.3375 3.99561C13.8796 3.99561 12.6978 5.17471 12.6978 6.62922C12.6978 8.08372 13.8796 9.26283 15.3375 9.26283Z" fill="#922AF8"/>
      <path d="M15.3375 9.29372C16.7954 9.29372 17.9772 8.11461 17.9772 6.6601C17.9772 5.2056 16.7954 4.02649 15.3375 4.02649C13.8796 4.02649 12.6978 5.2056 12.6978 6.6601C12.6978 8.11461 13.8796 9.29372 15.3375 9.29372Z" fill="#912BF8"/>
      <path d="M15.3375 9.30836C16.7954 9.30836 17.9772 8.12925 17.9772 6.67475C17.9772 5.22025 16.7954 4.04114 15.3375 4.04114C13.8796 4.04114 12.6978 5.22025 12.6978 6.67475C12.6978 8.12925 13.8796 9.30836 15.3375 9.30836Z" fill="#912BF8"/>
      <path d="M15.3375 9.33961C16.7954 9.33961 17.9772 8.1605 17.9772 6.706C17.9772 5.2515 16.7954 4.07239 15.3375 4.07239C13.8796 4.07239 12.6978 5.2515 12.6978 6.706C12.6978 8.1605 13.8796 9.33961 15.3375 9.33961Z" fill="#912BF8"/>
      <path d="M15.3375 9.3694C16.7954 9.3694 17.9772 8.19029 17.9772 6.73579C17.9772 5.28128 16.7954 4.10217 15.3375 4.10217C13.8796 4.10217 12.6978 5.28128 12.6978 6.73579C12.6978 8.19029 13.8796 9.3694 15.3375 9.3694Z" fill="#902BF8"/>
      <path d="M15.3375 9.38454C16.7954 9.38454 17.9772 8.20543 17.9772 6.75092C17.9772 5.29642 16.7954 4.11731 15.3375 4.11731C13.8796 4.11731 12.6978 5.29642 12.6978 6.75092C12.6978 8.20543 13.8796 9.38454 15.3375 9.38454Z" fill="#902BF8"/>
      <path d="M15.3375 9.41493C16.7954 9.41493 17.9772 8.23582 17.9772 6.78132C17.9772 5.32681 16.7954 4.14771 15.3375 4.14771C13.8796 4.14771 12.6978 5.32681 12.6978 6.78132C12.6978 8.23582 13.8796 9.41493 15.3375 9.41493Z" fill="#902BF8"/>
      <path d="M15.3375 9.44472C16.7954 9.44472 17.9772 8.26561 17.9772 6.8111C17.9772 5.3566 16.7954 4.17749 15.3375 4.17749C13.8796 4.17749 12.6978 5.3566 12.6978 6.8111C12.6978 8.26561 13.8796 9.44472 15.3375 9.44472Z" fill="#902BF8"/>
      <path d="M15.3375 9.47584C16.7954 9.47584 17.9772 8.29674 17.9772 6.84223C17.9772 5.38773 16.7954 4.20862 15.3375 4.20862C13.8796 4.20862 12.6978 5.38773 12.6978 6.84223C12.6978 8.29674 13.8796 9.47584 15.3375 9.47584Z" fill="#8F2BF8"/>
      <path d="M15.3375 9.49025C16.7954 9.49025 17.9772 8.31114 17.9772 6.85664C17.9772 5.40213 16.7954 4.22302 15.3375 4.22302C13.8796 4.22302 12.6978 5.40213 12.6978 6.85664C12.6978 8.31114 13.8796 9.49025 15.3375 9.49025Z" fill="#8F2BF8"/>
      <path d="M15.3375 9.52138C16.7954 9.52138 17.9772 8.34227 17.9772 6.88776C17.9772 5.43326 16.7954 4.25415 15.3375 4.25415C13.8796 4.25415 12.6978 5.43326 12.6978 6.88776C12.6978 8.34227 13.8796 9.52138 15.3375 9.52138Z" fill="#8F2BF8"/>
      <path d="M15.3375 9.55116C16.7954 9.55116 17.9772 8.37205 17.9772 6.91755C17.9772 5.46304 16.7954 4.28394 15.3375 4.28394C13.8796 4.28394 12.6978 5.46304 12.6978 6.91755C12.6978 8.37205 13.8796 9.55116 15.3375 9.55116Z" fill="#8E2BF8"/>
      <path d="M15.3375 9.56581C16.7954 9.56581 17.9772 8.3867 17.9772 6.9322C17.9772 5.47769 16.7954 4.29858 15.3375 4.29858C13.8796 4.29858 12.6978 5.47769 12.6978 6.9322C12.6978 8.3867 13.8796 9.56581 15.3375 9.56581Z" fill="#8E2BF8"/>
      <path d="M15.3375 9.59669C16.7954 9.59669 17.9772 8.41758 17.9772 6.96308C17.9772 5.50858 16.7954 4.32947 15.3375 4.32947C13.8796 4.32947 12.6978 5.50858 12.6978 6.96308C12.6978 8.41758 13.8796 9.59669 15.3375 9.59669Z" fill="#8E2BF8"/>
      <path d="M15.3375 9.62648C16.7954 9.62648 17.9772 8.44737 17.9772 6.99287C17.9772 5.53836 16.7954 4.35925 15.3375 4.35925C13.8796 4.35925 12.6978 5.53836 12.6978 6.99287C12.6978 8.44737 13.8796 9.62648 15.3375 9.62648Z" fill="#8D2BF8"/>
      <path d="M15.3375 9.65712C16.7954 9.65712 17.9772 8.47801 17.9772 7.02351C17.9772 5.569 16.7954 4.38989 15.3375 4.38989C13.8796 4.38989 12.6978 5.569 12.6978 7.02351C12.6978 8.47801 13.8796 9.65712 15.3375 9.65712Z" fill="#8D2BF8"/>
      <path d="M15.3375 9.67238C16.7954 9.67238 17.9772 8.49327 17.9772 7.03876C17.9772 5.58426 16.7954 4.40515 15.3375 4.40515C13.8796 4.40515 12.6978 5.58426 12.6978 7.03876C12.6978 8.49327 13.8796 9.67238 15.3375 9.67238Z" fill="#8D2CF8"/>
      <path d="M15.3375 9.70216C16.7954 9.70216 17.9772 8.52305 17.9772 7.06855C17.9772 5.61405 16.7954 4.43494 15.3375 4.43494C13.8796 4.43494 12.6978 5.61405 12.6978 7.06855C12.6978 8.52305 13.8796 9.70216 15.3375 9.70216Z" fill="#8D2CF8"/>
      <path d="M15.3375 9.73305C16.7954 9.73305 17.9772 8.55394 17.9772 7.09943C17.9772 5.64493 16.7954 4.46582 15.3375 4.46582C13.8796 4.46582 12.6978 5.64493 12.6978 7.09943C12.6978 8.55394 13.8796 9.73305 15.3375 9.73305Z" fill="#8C2CF8"/>
      <path d="M15.3375 9.74769C16.7954 9.74769 17.9772 8.56859 17.9772 7.11408C17.9772 5.65958 16.7954 4.48047 15.3375 4.48047C13.8796 4.48047 12.6978 5.65958 12.6978 7.11408C12.6978 8.56859 13.8796 9.74769 15.3375 9.74769Z" fill="#8C2CF8"/>
      <path d="M15.3375 9.77858C16.7954 9.77858 17.9772 8.59947 17.9772 7.14497C17.9772 5.69046 16.7954 4.51135 15.3375 4.51135C13.8796 4.51135 12.6978 5.69046 12.6978 7.14497C12.6978 8.59947 13.8796 9.77858 15.3375 9.77858Z" fill="#8C2CF8"/>
      <path d="M15.3375 9.80775C16.7954 9.80775 17.9772 8.62864 17.9772 7.17414C17.9772 5.71964 16.7954 4.54053 15.3375 4.54053C13.8796 4.54053 12.6978 5.71964 12.6978 7.17414C12.6978 8.62864 13.8796 9.80775 15.3375 9.80775Z" fill="#8B2CF8"/>
      <path d="M15.3375 9.839C16.7954 9.839 17.9772 8.65989 17.9772 7.20539C17.9772 5.75089 16.7954 4.57178 15.3375 4.57178C13.8796 4.57178 12.6978 5.75089 12.6978 7.20539C12.6978 8.65989 13.8796 9.839 15.3375 9.839Z" fill="#8B2CF8"/>
      <path d="M15.3375 9.85426C16.7954 9.85426 17.9772 8.67515 17.9772 7.22065C17.9772 5.76614 16.7954 4.58704 15.3375 4.58704C13.8796 4.58704 12.6978 5.76614 12.6978 7.22065C12.6978 8.67515 13.8796 9.85426 15.3375 9.85426Z" fill="#8B2CF8"/>
      <path d="M15.3375 9.88405C16.7954 9.88405 17.9772 8.70494 17.9772 7.25043C17.9772 5.79593 16.7954 4.61682 15.3375 4.61682C13.8796 4.61682 12.6978 5.79593 12.6978 7.25043C12.6978 8.70494 13.8796 9.88405 15.3375 9.88405Z" fill="#8A2CF8"/>
      <path d="M15.3375 9.91432C16.7954 9.91432 17.9772 8.73521 17.9772 7.28071C17.9772 5.8262 16.7954 4.64709 15.3375 4.64709C13.8796 4.64709 12.6978 5.8262 12.6978 7.28071C12.6978 8.73521 13.8796 9.91432 15.3375 9.91432Z" fill="#8A2CF8"/>
      <path d="M15.3375 9.94411C16.7954 9.94411 17.9772 8.765 17.9772 7.31049C17.9772 5.85599 16.7954 4.67688 15.3375 4.67688C13.8796 4.67688 12.6978 5.85599 12.6978 7.31049C12.6978 8.765 13.8796 9.94411 15.3375 9.94411Z" fill="#8A2CF8"/>
      <path d="M15.3375 9.95875C16.7954 9.95875 17.9772 8.77965 17.9772 7.32514C17.9772 5.87064 16.7954 4.69153 15.3375 4.69153C13.8796 4.69153 12.6978 5.87064 12.6978 7.32514C12.6978 8.77965 13.8796 9.95875 15.3375 9.95875Z" fill="#8A2CF8"/>
      <path d="M15.3375 9.98964C16.7954 9.98964 17.9772 8.81053 17.9772 7.35603C17.9772 5.90152 16.7954 4.72241 15.3375 4.72241C13.8796 4.72241 12.6978 5.90152 12.6978 7.35603C12.6978 8.81053 13.8796 9.98964 15.3375 9.98964Z" fill="#892CF8"/>
      <path d="M15.3375 10.0194C16.7954 10.0194 17.9772 8.84031 17.9772 7.38581C17.9772 5.93131 16.7954 4.7522 15.3375 4.7522C13.8796 4.7522 12.6978 5.93131 12.6978 7.38581C12.6978 8.84031 13.8796 10.0194 15.3375 10.0194Z" fill="#892CF8"/>
      <path d="M15.3375 10.0355C16.7954 10.0355 17.9772 8.85643 17.9772 7.40192C17.9772 5.94742 16.7954 4.76831 15.3375 4.76831C13.8796 4.76831 12.6978 5.94742 12.6978 7.40192C12.6978 8.85643 13.8796 10.0355 15.3375 10.0355Z" fill="#892CF8"/>
      <path d="M15.3375 10.065C16.7954 10.065 17.9772 8.88585 17.9772 7.43134C17.9772 5.97684 16.7954 4.79773 15.3375 4.79773C13.8796 4.79773 12.6978 5.97684 12.6978 7.43134C12.6978 8.88585 13.8796 10.065 15.3375 10.065Z" fill="#882CF8"/>
      <path d="M15.3375 10.0962C16.7954 10.0962 17.9772 8.9171 17.9772 7.46259C17.9772 6.00809 16.7954 4.82898 15.3375 4.82898C13.8796 4.82898 12.6978 6.00809 12.6978 7.46259C12.6978 8.9171 13.8796 10.0962 15.3375 10.0962Z" fill="#882DF8"/>
      <path d="M15.3375 10.126C16.7954 10.126 17.9772 8.94688 17.9772 7.49238C17.9772 6.03787 16.7954 4.85876 15.3375 4.85876C13.8796 4.85876 12.6978 6.03787 12.6978 7.49238C12.6978 8.94688 13.8796 10.126 15.3375 10.126Z" fill="#882DF8"/>
      <path d="M15.3375 10.1406C16.7954 10.1406 17.9772 8.96153 17.9772 7.50703C17.9772 6.05252 16.7954 4.87341 15.3375 4.87341C13.8796 4.87341 12.6978 6.05252 12.6978 7.50703C12.6978 8.96153 13.8796 10.1406 15.3375 10.1406Z" fill="#882DF8"/>
      <path d="M15.3375 10.1715C16.7954 10.1715 17.9772 8.99241 17.9772 7.53791C17.9772 6.08341 16.7954 4.9043 15.3375 4.9043C13.8796 4.9043 12.6978 6.08341 12.6978 7.53791C12.6978 8.99241 13.8796 10.1715 15.3375 10.1715Z" fill="#872DF8"/>
      <path d="M15.3375 10.2013C16.7954 10.2013 17.9772 9.0222 17.9772 7.56769C17.9772 6.11319 16.7954 4.93408 15.3375 4.93408C13.8796 4.93408 12.6978 6.11319 12.6978 7.56769C12.6978 9.0222 13.8796 10.2013 15.3375 10.2013Z" fill="#872DF8"/>
      <path d="M15.3375 10.2174C16.7954 10.2174 17.9772 9.03831 17.9772 7.58381C17.9772 6.1293 16.7954 4.9502 15.3375 4.9502C13.8796 4.9502 12.6978 6.1293 12.6978 7.58381C12.6978 9.03831 13.8796 10.2174 15.3375 10.2174Z" fill="#872DF8"/>
      <path d="M15.3375 10.2472C16.7954 10.2472 17.9772 9.0681 17.9772 7.61359C17.9772 6.15909 16.7954 4.97998 15.3375 4.97998C13.8796 4.97998 12.6978 6.15909 12.6978 7.61359C12.6978 9.0681 13.8796 10.2472 15.3375 10.2472Z" fill="#862DF8"/>
      <path d="M15.3375 10.2781C16.7954 10.2781 17.9772 9.09898 17.9772 7.64448C17.9772 6.18997 16.7954 5.01086 15.3375 5.01086C13.8796 5.01086 12.6978 6.18997 12.6978 7.64448C12.6978 9.09898 13.8796 10.2781 15.3375 10.2781Z" fill="#862DF8"/>
      <path d="M15.3375 10.3079C16.7954 10.3079 17.9772 9.12877 17.9772 7.67426C17.9772 6.21976 16.7954 5.04065 15.3375 5.04065C13.8796 5.04065 12.6978 6.21976 12.6978 7.67426C12.6978 9.12877 13.8796 10.3079 15.3375 10.3079Z" fill="#862DF8"/>
      <path d="M15.3375 10.3225C16.7954 10.3225 17.9772 9.14341 17.9772 7.68891C17.9772 6.23441 16.7954 5.0553 15.3375 5.0553C13.8796 5.0553 12.6978 6.23441 12.6978 7.68891C12.6978 9.14341 13.8796 10.3225 15.3375 10.3225Z" fill="#852DF8"/>
      <path d="M15.3375 10.3537C16.7954 10.3537 17.9772 9.17454 17.9772 7.72004C17.9772 6.26553 16.7954 5.08643 15.3375 5.08643C13.8796 5.08643 12.6978 6.26553 12.6978 7.72004C12.6978 9.17454 13.8796 10.3537 15.3375 10.3537Z" fill="#852DF8"/>
      <path d="M15.3375 10.3834C16.7954 10.3834 17.9772 9.20433 17.9772 7.74982C17.9772 6.29532 16.7954 5.11621 15.3375 5.11621C13.8796 5.11621 12.6978 6.29532 12.6978 7.74982C12.6978 9.20433 13.8796 10.3834 15.3375 10.3834Z" fill="#852DF8"/>
      <path d="M15.3375 10.3978C16.7954 10.3978 17.9772 9.21873 17.9772 7.76423C17.9772 6.30972 16.7954 5.13062 15.3375 5.13062C13.8796 5.13062 12.6978 6.30972 12.6978 7.76423C12.6978 9.21873 13.8796 10.3978 15.3375 10.3978Z" fill="#852DF8"/>
      <path d="M15.3375 10.429C16.7954 10.429 17.9772 9.24986 17.9772 7.79536C17.9772 6.34085 16.7954 5.16174 15.3375 5.16174C13.8796 5.16174 12.6978 6.34085 12.6978 7.79536C12.6978 9.24986 13.8796 10.429 15.3375 10.429Z" fill="#842DF8"/>
      <path d="M15.3375 10.4588C16.7954 10.4588 17.9772 9.27965 17.9772 7.82514C17.9772 6.37064 16.7954 5.19153 15.3375 5.19153C13.8796 5.19153 12.6978 6.37064 12.6978 7.82514C12.6978 9.27965 13.8796 10.4588 15.3375 10.4588Z" fill="#842DF8"/>
      <path d="M15.3375 10.49C16.7954 10.49 17.9772 9.3109 17.9772 7.85639C17.9772 6.40189 16.7954 5.22278 15.3375 5.22278C13.8796 5.22278 12.6978 6.40189 12.6978 7.85639C12.6978 9.3109 13.8796 10.49 15.3375 10.49Z" fill="#842DF8"/>
      <path d="M15.3375 10.5043C16.7954 10.5043 17.9772 9.32518 17.9772 7.87067C17.9772 6.41617 16.7954 5.23706 15.3375 5.23706C13.8796 5.23706 12.6978 6.41617 12.6978 7.87067C12.6978 9.32518 13.8796 10.5043 15.3375 10.5043Z" fill="#832EF8"/>
      <path d="M15.3375 10.5355C16.7954 10.5355 17.9772 9.35643 17.9772 7.90192C17.9772 6.44742 16.7954 5.26831 15.3375 5.26831C13.8796 5.26831 12.6978 6.44742 12.6978 7.90192C12.6978 9.35643 13.8796 10.5355 15.3375 10.5355Z" fill="#832EF8"/>
      <path d="M15.3375 10.5647C16.7954 10.5647 17.9772 9.3856 17.9772 7.9311C17.9772 6.47659 16.7954 5.29749 15.3375 5.29749C13.8796 5.29749 12.6978 6.47659 12.6978 7.9311C12.6978 9.3856 13.8796 10.5647 15.3375 10.5647Z" fill="#832EF8"/>
      <path d="M15.3375 10.58C16.7954 10.58 17.9772 9.40086 17.9772 7.94636C17.9772 6.49185 16.7954 5.31274 15.3375 5.31274C13.8796 5.31274 12.6978 6.49185 12.6978 7.94636C12.6978 9.40086 13.8796 10.58 15.3375 10.58Z" fill="#822EF8"/>
      <path d="M15.3375 10.6109C16.7954 10.6109 17.9772 9.43175 17.9772 7.97724C17.9772 6.52274 16.7954 5.34363 15.3375 5.34363C13.8796 5.34363 12.6978 6.52274 12.6978 7.97724C12.6978 9.43175 13.8796 10.6109 15.3375 10.6109Z" fill="#822EF8"/>
      <path d="M15.3375 10.6406C16.7954 10.6406 17.9772 9.46153 17.9772 8.00703C17.9772 6.55252 16.7954 5.37341 15.3375 5.37341C13.8796 5.37341 12.6978 6.55252 12.6978 8.00703C12.6978 9.46153 13.8796 10.6406 15.3375 10.6406Z" fill="#822EF8"/>
      <path d="M15.3375 10.6719C16.7954 10.6719 17.9772 9.49278 17.9772 8.03828C17.9772 6.58377 16.7954 5.40466 15.3375 5.40466C13.8796 5.40466 12.6978 6.58377 12.6978 8.03828C12.6978 9.49278 13.8796 10.6719 15.3375 10.6719Z" fill="#822EF8"/>
      <path d="M15.3375 10.6865C16.7954 10.6865 17.9772 9.50743 17.9772 8.05292C17.9772 6.59842 16.7954 5.41931 15.3375 5.41931C13.8796 5.41931 12.6978 6.59842 12.6978 8.05292C12.6978 9.50743 13.8796 10.6865 15.3375 10.6865Z" fill="#812EF8"/>
      <path d="M15.3375 10.7153C16.7954 10.7153 17.9772 9.53624 17.9772 8.08173C17.9772 6.62723 16.7954 5.44812 15.3375 5.44812C13.8796 5.44812 12.6978 6.62723 12.6978 8.08173C12.6978 9.53624 13.8796 10.7153 15.3375 10.7153Z" fill="#812EF8"/>
      <path d="M15.3375 10.7464C16.7954 10.7464 17.9772 9.56724 17.9772 8.11274C17.9772 6.65824 16.7954 5.47913 15.3375 5.47913C13.8796 5.47913 12.6978 6.65824 12.6978 8.11274C12.6978 9.56724 13.8796 10.7464 15.3375 10.7464Z" fill="#812EF8"/>
      <path d="M15.3375 10.7612C16.7954 10.7612 17.9772 9.58213 17.9772 8.12763C17.9772 6.67313 16.7954 5.49402 15.3375 5.49402C13.8796 5.49402 12.6978 6.67313 12.6978 8.12763C12.6978 9.58213 13.8796 10.7612 15.3375 10.7612Z" fill="#802EF8"/>
      <path d="M15.3375 10.7927C16.7954 10.7927 17.9772 9.61363 17.9772 8.15913C17.9772 6.70462 16.7954 5.52551 15.3375 5.52551C13.8796 5.52551 12.6978 6.70462 12.6978 8.15913C12.6978 9.61363 13.8796 10.7927 15.3375 10.7927Z" fill="#802EF8"/>
      <path d="M15.3375 10.8225C16.7954 10.8225 17.9772 9.64341 17.9772 8.18891C17.9772 6.73441 16.7954 5.5553 15.3375 5.5553C13.8796 5.5553 12.6978 6.73441 12.6978 8.18891C12.6978 9.64341 13.8796 10.8225 15.3375 10.8225Z" fill="#802EF8"/>
      <path d="M15.3375 10.8529C16.7954 10.8529 17.9772 9.67381 17.9772 8.21931C17.9772 6.7648 16.7954 5.58569 15.3375 5.58569C13.8796 5.58569 12.6978 6.7648 12.6978 8.21931C12.6978 9.67381 13.8796 10.8529 15.3375 10.8529Z" fill="#7F2EF8"/>
      <path d="M15.3375 10.8681C16.7954 10.8681 17.9772 9.68895 17.9772 8.23444C17.9772 6.77994 16.7954 5.60083 15.3375 5.60083C13.8796 5.60083 12.6978 6.77994 12.6978 8.23444C12.6978 9.68895 13.8796 10.8681 15.3375 10.8681Z" fill="#7F2EF8"/>
      <path d="M15.3375 10.8976C16.7954 10.8976 17.9772 9.71849 17.9772 8.26398C17.9772 6.80948 16.7954 5.63037 15.3375 5.63037C13.8796 5.63037 12.6978 6.80948 12.6978 8.26398C12.6978 9.71849 13.8796 10.8976 15.3375 10.8976Z" fill="#7F2EF8"/>
      <path d="M15.3375 10.9285C16.7954 10.9285 17.9772 9.74937 17.9772 8.29487C17.9772 6.84036 16.7954 5.66125 15.3375 5.66125C13.8796 5.66125 12.6978 6.84036 12.6978 8.29487C12.6978 9.74937 13.8796 10.9285 15.3375 10.9285Z" fill="#7F2FF8"/>
      <path d="M15.3375 10.9431C16.7954 10.9431 17.9772 9.76402 17.9772 8.30952C17.9772 6.85501 16.7954 5.6759 15.3375 5.6759C13.8796 5.6759 12.6978 6.85501 12.6978 8.30952C12.6978 9.76402 13.8796 10.9431 15.3375 10.9431Z" fill="#7E2FF8"/>
      <path d="M15.3375 10.974C16.7954 10.974 17.9772 9.7949 17.9772 8.3404C17.9772 6.8859 16.7954 5.70679 15.3375 5.70679C13.8796 5.70679 12.6978 6.8859 12.6978 8.3404C12.6978 9.7949 13.8796 10.974 15.3375 10.974Z" fill="#7E2FF8"/>
      <path d="M15.3375 11.0038C16.7954 11.0038 17.9772 9.82469 17.9772 8.37019C17.9772 6.91568 16.7954 5.73657 15.3375 5.73657C13.8796 5.73657 12.6978 6.91568 12.6978 8.37019C12.6978 9.82469 13.8796 11.0038 15.3375 11.0038Z" fill="#7E2FF8"/>
      <path d="M15.3375 11.035C16.7954 11.035 17.9772 9.85594 17.9772 8.40143C17.9772 6.94693 16.7954 5.76782 15.3375 5.76782C13.8796 5.76782 12.6978 6.94693 12.6978 8.40143C12.6978 9.85594 13.8796 11.035 15.3375 11.035Z" fill="#7D2FF8"/>
      <path d="M15.3375 11.0502C16.7954 11.0502 17.9772 9.87108 17.9772 8.41657C17.9772 6.96207 16.7954 5.78296 15.3375 5.78296C13.8796 5.78296 12.6978 6.96207 12.6978 8.41657C12.6978 9.87108 13.8796 11.0502 15.3375 11.0502Z" fill="#7D2FF8"/>
      <path d="M15.3375 11.0791C16.7954 11.0791 17.9772 9.90001 17.9772 8.4455C17.9772 6.991 16.7954 5.81189 15.3375 5.81189C13.8796 5.81189 12.6978 6.991 12.6978 8.4455C12.6978 9.90001 13.8796 11.0791 15.3375 11.0791Z" fill="#7D2FF8"/>
      <path d="M15.3375 11.1104C16.7954 11.1104 17.9772 9.93126 17.9772 8.47675C17.9772 7.02225 16.7954 5.84314 15.3375 5.84314C13.8796 5.84314 12.6978 7.02225 12.6978 8.47675C12.6978 9.93126 13.8796 11.1104 15.3375 11.1104Z" fill="#7C2FF8"/>
      <path d="M15.3375 11.125C16.7954 11.125 17.9772 9.94591 17.9772 8.4914C17.9772 7.0369 16.7954 5.85779 15.3375 5.85779C13.8796 5.85779 12.6978 7.0369 12.6978 8.4914C12.6978 9.94591 13.8796 11.125 15.3375 11.125Z" fill="#7C2FF8"/>
      <path d="M15.3375 11.1548C16.7954 11.1548 17.9772 9.97569 17.9772 8.52119C17.9772 7.06668 16.7954 5.88757 15.3375 5.88757C13.8796 5.88757 12.6978 7.06668 12.6978 8.52119C12.6978 9.97569 13.8796 11.1548 15.3375 11.1548Z" fill="#7C2FF8"/>
      <path d="M15.3375 11.1857C16.7954 11.1857 17.9772 10.0066 17.9772 8.55207C17.9772 7.09757 16.7954 5.91846 15.3375 5.91846C13.8796 5.91846 12.6978 7.09757 12.6978 8.55207C12.6978 10.0066 13.8796 11.1857 15.3375 11.1857Z" fill="#7C2FF8"/>
      <path d="M15.3375 11.2155C16.7954 11.2155 17.9772 10.0364 17.9772 8.58186C17.9772 7.12735 16.7954 5.94824 15.3375 5.94824C13.8796 5.94824 12.6978 7.12735 12.6978 8.58186C12.6978 10.0364 13.8796 11.2155 15.3375 11.2155Z" fill="#7B2FF8"/>
      <path d="M15.3375 11.2316C16.7954 11.2316 17.9772 10.0525 17.9772 8.59797C17.9772 7.14346 16.7954 5.96436 15.3375 5.96436C13.8796 5.96436 12.6978 7.14346 12.6978 8.59797C12.6978 10.0525 13.8796 11.2316 15.3375 11.2316Z" fill="#7B2FF8"/>
      <path d="M15.3375 11.2612C16.7954 11.2612 17.9772 10.0821 17.9772 8.62763C17.9772 7.17313 16.7954 5.99402 15.3375 5.99402C13.8796 5.99402 12.6978 7.17313 12.6978 8.62763C12.6978 10.0821 13.8796 11.2612 15.3375 11.2612Z" fill="#7B2FF8"/>
      <path d="M15.3375 11.2923C16.7954 11.2923 17.9772 10.1131 17.9772 8.65864C17.9772 7.20413 16.7954 6.02502 15.3375 6.02502C13.8796 6.02502 12.6978 7.20413 12.6978 8.65864C12.6978 10.1131 13.8796 11.2923 15.3375 11.2923Z" fill="#7A2FF8"/>
      <path d="M15.3375 11.3069C16.7954 11.3069 17.9772 10.1278 17.9772 8.67329C17.9772 7.21878 16.7954 6.03967 15.3375 6.03967C13.8796 6.03967 12.6978 7.21878 12.6978 8.67329C12.6978 10.1278 13.8796 11.3069 15.3375 11.3069Z" fill="#7A30F8"/>
      <path d="M15.3375 11.3366C16.7954 11.3366 17.9772 10.1575 17.9772 8.70295C17.9772 7.24844 16.7954 6.06934 15.3375 6.06934C13.8796 6.06934 12.6978 7.24844 12.6978 8.70295C12.6978 10.1575 13.8796 11.3366 15.3375 11.3366Z" fill="#7A30F8"/>
      <path d="M15.3375 11.3678C16.7954 11.3678 17.9772 10.1887 17.9772 8.7342C17.9772 7.27969 16.7954 6.10059 15.3375 6.10059C13.8796 6.10059 12.6978 7.27969 12.6978 8.7342C12.6978 10.1887 13.8796 11.3678 15.3375 11.3678Z" fill="#7A30F8"/>
      <path d="M15.3375 11.3974C16.7954 11.3974 17.9772 10.2182 17.9772 8.76374C17.9772 7.30924 16.7954 6.13013 15.3375 6.13013C13.8796 6.13013 12.6978 7.30924 12.6978 8.76374C12.6978 10.2182 13.8796 11.3974 15.3375 11.3974Z" fill="#7930F8"/>
      <path d="M15.3375 11.4133C16.7954 11.4133 17.9772 10.2342 17.9772 8.77973C17.9772 7.32523 16.7954 6.14612 15.3375 6.14612C13.8796 6.14612 12.6978 7.32523 12.6978 8.77973C12.6978 10.2342 13.8796 11.4133 15.3375 11.4133Z" fill="#7930F8"/>
      <path d="M15.3375 11.4431C16.7954 11.4431 17.9772 10.264 17.9772 8.80952C17.9772 7.35501 16.7954 6.1759 15.3375 6.1759C13.8796 6.1759 12.6978 7.35501 12.6978 8.80952C12.6978 10.264 13.8796 11.4431 15.3375 11.4431Z" fill="#7930F8"/>
      <path d="M15.3375 11.4723C16.7954 11.4723 17.9772 10.2932 17.9772 8.83869C17.9772 7.38419 16.7954 6.20508 15.3375 6.20508C13.8796 6.20508 12.6978 7.38419 12.6978 8.83869C12.6978 10.2932 13.8796 11.4723 15.3375 11.4723Z" fill="#7830F8"/>
      <path d="M15.3375 11.5033C16.7954 11.5033 17.9772 10.3242 17.9772 8.8697C17.9772 7.41519 16.7954 6.23608 15.3375 6.23608C13.8796 6.23608 12.6978 7.41519 12.6978 8.8697C12.6978 10.3242 13.8796 11.5033 15.3375 11.5033Z" fill="#7830F8"/>
      <path d="M15.3375 11.5184C16.7954 11.5184 17.9772 10.3393 17.9772 8.88483C17.9772 7.43033 16.7954 6.25122 15.3375 6.25122C13.8796 6.25122 12.6978 7.43033 12.6978 8.88483C12.6978 10.3393 13.8796 11.5184 15.3375 11.5184Z" fill="#7830F8"/>
      <path d="M15.3375 11.5495C16.7954 11.5495 17.9772 10.3703 17.9772 8.91584C17.9772 7.46133 16.7954 6.28223 15.3375 6.28223C13.8796 6.28223 12.6978 7.46133 12.6978 8.91584C12.6978 10.3703 13.8796 11.5495 15.3375 11.5495Z" fill="#7730F8"/>
      <path d="M15.3375 11.5795C16.7954 11.5795 17.9772 10.4004 17.9772 8.94587C17.9772 7.49136 16.7954 6.31226 15.3375 6.31226C13.8796 6.31226 12.6978 7.49136 12.6978 8.94587C12.6978 10.4004 13.8796 11.5795 15.3375 11.5795Z" fill="#7730F8"/>
      <path d="M15.3375 11.5941C16.7954 11.5941 17.9772 10.415 17.9772 8.96052C17.9772 7.50601 16.7954 6.3269 15.3375 6.3269C13.8796 6.3269 12.6978 7.50601 12.6978 8.96052C12.6978 10.415 13.8796 11.5941 15.3375 11.5941Z" fill="#7730F8"/>
      <path d="M15.3375 11.625C16.7954 11.625 17.9772 10.4459 17.9772 8.9914C17.9772 7.5369 16.7954 6.35779 15.3375 6.35779C13.8796 6.35779 12.6978 7.5369 12.6978 8.9914C12.6978 10.4459 13.8796 11.625 15.3375 11.625Z" fill="#7730F8"/>
      <path d="M15.3375 11.6542C16.7954 11.6542 17.9772 10.4751 17.9772 9.02058C17.9772 7.56607 16.7954 6.38696 15.3375 6.38696C13.8796 6.38696 12.6978 7.56607 12.6978 9.02058C12.6978 10.4751 13.8796 11.6542 15.3375 11.6542Z" fill="#7630F8"/>
      <path d="M15.3375 11.6852C16.7954 11.6852 17.9772 10.5061 17.9772 9.05158C17.9772 7.59708 16.7954 6.41797 15.3375 6.41797C13.8796 6.41797 12.6978 7.59708 12.6978 9.05158C12.6978 10.5061 13.8796 11.6852 15.3375 11.6852Z" fill="#7630F8"/>
      <path d="M15.3375 11.6997C16.7954 11.6997 17.9772 10.5206 17.9772 9.06611C17.9772 7.6116 16.7954 6.4325 15.3375 6.4325C13.8796 6.4325 12.6978 7.6116 12.6978 9.06611C12.6978 10.5206 13.8796 11.6997 15.3375 11.6997Z" fill="#7630F8"/>
      <path d="M15.3375 11.7316C16.7954 11.7316 17.9772 10.5525 17.9772 9.09797C17.9772 7.64346 16.7954 6.46436 15.3375 6.46436C13.8796 6.46436 12.6978 7.64346 12.6978 9.09797C12.6978 10.5525 13.8796 11.7316 15.3375 11.7316Z" fill="#7531F7"/>
      <path d="M15.3375 11.7605C16.7954 11.7605 17.9772 10.5814 17.9772 9.1269C17.9772 7.67239 16.7954 6.49329 15.3375 6.49329C13.8796 6.49329 12.6978 7.67239 12.6978 9.1269C12.6978 10.5814 13.8796 11.7605 15.3375 11.7605Z" fill="#7531F7"/>
      <path d="M15.3375 11.776C16.7954 11.776 17.9772 10.5969 17.9772 9.1424C17.9772 7.6879 16.7954 6.50879 15.3375 6.50879C13.8796 6.50879 12.6978 7.6879 12.6978 9.1424C12.6978 10.5969 13.8796 11.776 15.3375 11.776Z" fill="#7531F7"/>
      <path d="M15.3375 11.8063C16.7954 11.8063 17.9772 10.6272 17.9772 9.17268C17.9772 7.71817 16.7954 6.53906 15.3375 6.53906C13.8796 6.53906 12.6978 7.71817 12.6978 9.17268C12.6978 10.6272 13.8796 11.8063 15.3375 11.8063Z" fill="#7431F7"/>
      <path d="M15.3375 11.8361C16.7954 11.8361 17.9772 10.657 17.9772 9.20246C17.9772 7.74796 16.7954 6.56885 15.3375 6.56885C13.8796 6.56885 12.6978 7.74796 12.6978 9.20246C12.6978 10.657 13.8796 11.8361 15.3375 11.8361Z" fill="#7431F7"/>
      <path d="M15.3375 11.8671C16.7954 11.8671 17.9772 10.688 17.9772 9.23347C17.9772 7.77896 16.7954 6.59985 15.3375 6.59985C13.8796 6.59985 12.6978 7.77896 12.6978 9.23347C12.6978 10.688 13.8796 11.8671 15.3375 11.8671Z" fill="#7431F7"/>
      <path d="M15.3375 11.8816C16.7954 11.8816 17.9772 10.7025 17.9772 9.24799C17.9772 7.79349 16.7954 6.61438 15.3375 6.61438C13.8796 6.61438 12.6978 7.79349 12.6978 9.24799C12.6978 10.7025 13.8796 11.8816 15.3375 11.8816Z" fill="#7431F7"/>
      <path d="M15.3375 11.9114C16.7954 11.9114 17.9772 10.7323 17.9772 9.27778C17.9772 7.82327 16.7954 6.64417 15.3375 6.64417C13.8796 6.64417 12.6978 7.82327 12.6978 9.27778C12.6978 10.7323 13.8796 11.9114 15.3375 11.9114Z" fill="#7331F7"/>
      <path d="M15.3375 11.9426C16.7954 11.9426 17.9772 10.7635 17.9772 9.30903C17.9772 7.85452 16.7954 6.67542 15.3375 6.67542C13.8796 6.67542 12.6978 7.85452 12.6978 9.30903C12.6978 10.7635 13.8796 11.9426 15.3375 11.9426Z" fill="#7331F7"/>
      <path d="M15.3375 11.9569C16.7954 11.9569 17.9772 10.7778 17.9772 9.32331C17.9772 7.86881 16.7954 6.6897 15.3375 6.6897C13.8796 6.6897 12.6978 7.86881 12.6978 9.32331C12.6978 10.7778 13.8796 11.9569 15.3375 11.9569Z" fill="#7331F7"/>
      <path d="M15.3375 11.9882C16.7954 11.9882 17.9772 10.8091 17.9772 9.35456C17.9772 7.90006 16.7954 6.72095 15.3375 6.72095C13.8796 6.72095 12.6978 7.90006 12.6978 9.35456C12.6978 10.8091 13.8796 11.9882 15.3375 11.9882Z" fill="#7231F7"/>
      <path d="M15.3375 12.018C16.7954 12.018 17.9772 10.8388 17.9772 9.38435C17.9772 7.92984 16.7954 6.75073 15.3375 6.75073C13.8796 6.75073 12.6978 7.92984 12.6978 9.38435C12.6978 10.8388 13.8796 12.018 15.3375 12.018Z" fill="#7231F7"/>
      <path d="M15.3375 12.0492C16.7954 12.0492 17.9772 10.8701 17.9772 9.4156C17.9772 7.96109 16.7954 6.78198 15.3375 6.78198C13.8796 6.78198 12.6978 7.96109 12.6978 9.4156C12.6978 10.8701 13.8796 12.0492 15.3375 12.0492Z" fill="#7231F7"/>
      <path d="M15.3375 12.0635C16.7954 12.0635 17.9772 10.8844 17.9772 9.42988C17.9772 7.97537 16.7954 6.79626 15.3375 6.79626C13.8796 6.79626 12.6978 7.97537 12.6978 9.42988C12.6978 10.8844 13.8796 12.0635 15.3375 12.0635Z" fill="#7131F7"/>
      <path d="M15.3375 12.0933C16.7954 12.0933 17.9772 10.9142 17.9772 9.45966C17.9772 8.00516 16.7954 6.82605 15.3375 6.82605C13.8796 6.82605 12.6978 8.00516 12.6978 9.45966C12.6978 10.9142 13.8796 12.0933 15.3375 12.0933Z" fill="#7131F7"/>
      <path d="M15.3375 12.1245C16.7954 12.1245 17.9772 10.9454 17.9772 9.49091C17.9772 8.03641 16.7954 6.8573 15.3375 6.8573C13.8796 6.8573 12.6978 8.03641 12.6978 9.49091C12.6978 10.9454 13.8796 12.1245 15.3375 12.1245Z" fill="#7131F7"/>
      <path d="M15.3375 12.1392C16.7954 12.1392 17.9772 10.9601 17.9772 9.50556C17.9772 8.05106 16.7954 6.87195 15.3375 6.87195C13.8796 6.87195 12.6978 8.05106 12.6978 9.50556C12.6978 10.9601 13.8796 12.1392 15.3375 12.1392Z" fill="#7132F7"/>
      <path d="M15.3375 12.1701C16.7954 12.1701 17.9772 10.9909 17.9772 9.53644C17.9772 8.08194 16.7954 6.90283 15.3375 6.90283C13.8796 6.90283 12.6978 8.08194 12.6978 9.53644C12.6978 10.9909 13.8796 12.1701 15.3375 12.1701Z" fill="#7032F7"/>
      <path d="M15.3375 12.1998C16.7954 12.1998 17.9772 11.0207 17.9772 9.56623C17.9772 8.11173 16.7954 6.93262 15.3375 6.93262C13.8796 6.93262 12.6978 8.11173 12.6978 9.56623C12.6978 11.0207 13.8796 12.1998 15.3375 12.1998Z" fill="#7032F7"/>
      <path d="M15.3375 12.229C16.7954 12.229 17.9772 11.0499 17.9772 9.59541C17.9772 8.1409 16.7954 6.96179 15.3375 6.96179C13.8796 6.96179 12.6978 8.1409 12.6978 9.59541C12.6978 11.0499 13.8796 12.229 15.3375 12.229Z" fill="#7032F7"/>
      <path d="M15.3375 12.2456C16.7954 12.2456 17.9772 11.0665 17.9772 9.61201C17.9772 8.1575 16.7954 6.97839 15.3375 6.97839C13.8796 6.97839 12.6978 8.1575 12.6978 9.61201C12.6978 11.0665 13.8796 12.2456 15.3375 12.2456Z" fill="#6F32F7"/>
      <path d="M15.3375 12.2754C16.7954 12.2754 17.9772 11.0963 17.9772 9.64179C17.9772 8.18729 16.7954 7.00818 15.3375 7.00818C13.8796 7.00818 12.6978 8.18729 12.6978 9.64179C12.6978 11.0963 13.8796 12.2754 15.3375 12.2754Z" fill="#6F32F7"/>
      <path d="M15.3375 12.3064C16.7954 12.3064 17.9772 11.1273 17.9772 9.6728C17.9772 8.21829 16.7954 7.03918 15.3375 7.03918C13.8796 7.03918 12.6978 8.21829 12.6978 9.6728C12.6978 11.1273 13.8796 12.3064 15.3375 12.3064Z" fill="#6F32F7"/>
      <path d="M15.3375 12.3209C16.7954 12.3209 17.9772 11.1418 17.9772 9.68732C17.9772 8.23282 16.7954 7.05371 15.3375 7.05371C13.8796 7.05371 12.6978 8.23282 12.6978 9.68732C12.6978 11.1418 13.8796 12.3209 15.3375 12.3209Z" fill="#6F32F7"/>
      <path d="M15.3375 12.3507C16.7954 12.3507 17.9772 11.1716 17.9772 9.71711C17.9772 8.26261 16.7954 7.0835 15.3375 7.0835C13.8796 7.0835 12.6978 8.26261 12.6978 9.71711C12.6978 11.1716 13.8796 12.3507 15.3375 12.3507Z" fill="#6E32F7"/>
      <path d="M15.3375 12.3811C16.7954 12.3811 17.9772 11.202 17.9772 9.7475C17.9772 8.293 16.7954 7.11389 15.3375 7.11389C13.8796 7.11389 12.6978 8.293 12.6978 9.7475C12.6978 11.202 13.8796 12.3811 15.3375 12.3811Z" fill="#6E32F7"/>
      <path d="M15.3375 12.4109C16.7954 12.4109 17.9772 11.2318 17.9772 9.77729C17.9772 8.32279 16.7954 7.14368 15.3375 7.14368C13.8796 7.14368 12.6978 8.32279 12.6978 9.77729C12.6978 11.2318 13.8796 12.4109 15.3375 12.4109Z" fill="#6E32F7"/>
      <path d="M15.3375 12.4275C16.7954 12.4275 17.9772 11.2484 17.9772 9.79389C17.9772 8.33939 16.7954 7.16028 15.3375 7.16028C13.8796 7.16028 12.6978 8.33939 12.6978 9.79389C12.6978 11.2484 13.8796 12.4275 15.3375 12.4275Z" fill="#6D32F7"/>
      <path d="M15.3375 12.4573C16.7954 12.4573 17.9772 11.2782 17.9772 9.82368C17.9772 8.36917 16.7954 7.19006 15.3375 7.19006C13.8796 7.19006 12.6978 8.36917 12.6978 9.82368C12.6978 11.2782 13.8796 12.4573 15.3375 12.4573Z" fill="#6D32F7"/>
      <path d="M15.3375 12.4883C16.7954 12.4883 17.9772 11.3092 17.9772 9.85468C17.9772 8.40018 16.7954 7.22107 15.3375 7.22107C13.8796 7.22107 12.6978 8.40018 12.6978 9.85468C12.6978 11.3092 13.8796 12.4883 15.3375 12.4883Z" fill="#6D32F7"/>
      <path d="M15.3375 12.5028C16.7954 12.5028 17.9772 11.3237 17.9772 9.86921C17.9772 8.4147 16.7954 7.2356 15.3375 7.2356C13.8796 7.2356 12.6978 8.4147 12.6978 9.86921C12.6978 11.3237 13.8796 12.5028 15.3375 12.5028Z" fill="#6C32F7"/>
      <path d="M15.3375 12.532C16.7954 12.532 17.9772 11.3529 17.9772 9.89838C17.9772 8.44388 16.7954 7.26477 15.3375 7.26477C13.8796 7.26477 12.6978 8.44388 12.6978 9.89838C12.6978 11.3529 13.8796 12.532 15.3375 12.532Z" fill="#6C33F7"/>
      <path d="M15.3375 12.563C16.7954 12.563 17.9772 11.3839 17.9772 9.92939C17.9772 8.47489 16.7954 7.29578 15.3375 7.29578C13.8796 7.29578 12.6978 8.47489 12.6978 9.92939C12.6978 11.3839 13.8796 12.563 15.3375 12.563Z" fill="#6C33F7"/>
      <path d="M15.3375 12.5928C16.7954 12.5928 17.9772 11.4137 17.9772 9.95917C17.9772 8.50467 16.7954 7.32556 15.3375 7.32556C13.8796 7.32556 12.6978 8.50467 12.6978 9.95917C12.6978 11.4137 13.8796 12.5928 15.3375 12.5928Z" fill="#6C33F7"/>
      <path d="M15.3375 12.6083C16.7954 12.6083 17.9772 11.4292 17.9772 9.97468C17.9772 8.52017 16.7954 7.34106 15.3375 7.34106C13.8796 7.34106 12.6978 8.52017 12.6978 9.97468C12.6978 11.4292 13.8796 12.6083 15.3375 12.6083Z" fill="#6B33F7"/>
      <path d="M15.3375 12.6386C16.7954 12.6386 17.9772 11.4595 17.9772 10.005C17.9772 8.55045 16.7954 7.37134 15.3375 7.37134C13.8796 7.37134 12.6978 8.55045 12.6978 10.005C12.6978 11.4595 13.8796 12.6386 15.3375 12.6386Z" fill="#6B33F7"/>
      <path d="M15.3375 12.6681C16.7954 12.6681 17.9772 11.489 17.9772 10.0345C17.9772 8.57999 16.7954 7.40088 15.3375 7.40088C13.8796 7.40088 12.6978 8.57999 12.6978 10.0345C12.6978 11.489 13.8796 12.6681 15.3375 12.6681Z" fill="#6B33F7"/>
      <path d="M15.3375 12.6847C16.7954 12.6847 17.9772 11.5056 17.9772 10.0511C17.9772 8.59659 16.7954 7.41748 15.3375 7.41748C13.8796 7.41748 12.6978 8.59659 12.6978 10.0511C12.6978 11.5056 13.8796 12.6847 15.3375 12.6847Z" fill="#6A33F7"/>
      <path d="M15.3375 12.7139C16.7954 12.7139 17.9772 11.5348 17.9772 10.0803C17.9772 8.62576 16.7954 7.44666 15.3375 7.44666C13.8796 7.44666 12.6978 8.62576 12.6978 10.0803C12.6978 11.5348 13.8796 12.7139 15.3375 12.7139Z" fill="#6A33F7"/>
      <path d="M15.3375 12.7451C16.7954 12.7451 17.9772 11.566 17.9772 10.1115C17.9772 8.65701 16.7954 7.47791 15.3375 7.47791C13.8796 7.47791 12.6978 8.65701 12.6978 10.1115C12.6978 11.566 13.8796 12.7451 15.3375 12.7451Z" fill="#6A33F7"/>
      <path d="M15.3375 12.7747C16.7954 12.7747 17.9772 11.5956 17.9772 10.1411C17.9772 8.68655 16.7954 7.50745 15.3375 7.50745C13.8796 7.50745 12.6978 8.68655 12.6978 10.1411C12.6978 11.5956 13.8796 12.7747 15.3375 12.7747Z" fill="#6933F7"/>
      <path d="M15.3375 12.7892C16.7954 12.7892 17.9772 11.6101 17.9772 10.1556C17.9772 8.70108 16.7954 7.52197 15.3375 7.52197C13.8796 7.52197 12.6978 8.70108 12.6978 10.1556C12.6978 11.6101 13.8796 12.7892 15.3375 12.7892Z" fill="#6933F7"/>
      <path d="M15.3375 12.8204C16.7954 12.8204 17.9772 11.6413 17.9772 10.1868C17.9772 8.73233 16.7954 7.55322 15.3375 7.55322C13.8796 7.55322 12.6978 8.73233 12.6978 10.1868C12.6978 11.6413 13.8796 12.8204 15.3375 12.8204Z" fill="#6933F7"/>
      <path d="M15.3375 12.8502C16.7954 12.8502 17.9772 11.6711 17.9772 10.2166C17.9772 8.76212 16.7954 7.58301 15.3375 7.58301C13.8796 7.58301 12.6978 8.76212 12.6978 10.2166C12.6978 11.6711 13.8796 12.8502 15.3375 12.8502Z" fill="#6933F7"/>
      <path d="M15.3375 12.8668C16.7954 12.8668 17.9772 11.6877 17.9772 10.2332C17.9772 8.77872 16.7954 7.59961 15.3375 7.59961C13.8796 7.59961 12.6978 8.77872 12.6978 10.2332C12.6978 11.6877 13.8796 12.8668 15.3375 12.8668Z" fill="#6833F7"/>
      <path d="M15.3375 12.8958C16.7954 12.8958 17.9772 11.7167 17.9772 10.2622C17.9772 8.80765 16.7954 7.62854 15.3375 7.62854C13.8796 7.62854 12.6978 8.80765 12.6978 10.2622C12.6978 11.7167 13.8796 12.8958 15.3375 12.8958Z" fill="#6833F7"/>
      <path d="M15.3375 12.927C16.7954 12.927 17.9772 11.7479 17.9772 10.2934C17.9772 8.8389 16.7954 7.65979 15.3375 7.65979C13.8796 7.65979 12.6978 8.8389 12.6978 10.2934C12.6978 11.7479 13.8796 12.927 15.3375 12.927Z" fill="#6833F7"/>
      <path d="M15.3375 12.9568C16.7954 12.9568 17.9772 11.7777 17.9772 10.3232C17.9772 8.86868 16.7954 7.68958 15.3375 7.68958C13.8796 7.68958 12.6978 8.86868 12.6978 10.3232C12.6978 11.7777 13.8796 12.9568 15.3375 12.9568Z" fill="#6734F7"/>
      <path d="M15.3375 12.9711C16.7954 12.9711 17.9772 11.792 17.9772 10.3375C17.9772 8.88297 16.7954 7.70386 15.3375 7.70386C13.8796 7.70386 12.6978 8.88297 12.6978 10.3375C12.6978 11.792 13.8796 12.9711 15.3375 12.9711Z" fill="#6734F7"/>
      <path d="M15.3375 13.0023C16.7954 13.0023 17.9772 11.8232 17.9772 10.3687C17.9772 8.91422 16.7954 7.73511 15.3375 7.73511C13.8796 7.73511 12.6978 8.91422 12.6978 10.3687C12.6978 11.8232 13.8796 13.0023 15.3375 13.0023Z" fill="#6734F7"/>
      <path d="M15.3375 13.0321C16.7954 13.0321 17.9772 11.853 17.9772 10.3985C17.9772 8.944 16.7954 7.76489 15.3375 7.76489C13.8796 7.76489 12.6978 8.944 12.6978 10.3985C12.6978 11.853 13.8796 13.0321 15.3375 13.0321Z" fill="#6634F7"/>
      <path d="M15.3375 13.0468C16.7954 13.0468 17.9772 11.8677 17.9772 10.4132C17.9772 8.95865 16.7954 7.77954 15.3375 7.77954C13.8796 7.77954 12.6978 8.95865 12.6978 10.4132C12.6978 11.8677 13.8796 13.0468 15.3375 13.0468Z" fill="#6634F7"/>
      <path d="M15.3375 13.0777C16.7954 13.0777 17.9772 11.8985 17.9772 10.444C17.9772 8.98953 16.7954 7.81042 15.3375 7.81042C13.8796 7.81042 12.6978 8.98953 12.6978 10.444C12.6978 11.8985 13.8796 13.0777 15.3375 13.0777Z" fill="#6634F7"/>
      <path d="M15.3375 13.1074C16.7954 13.1074 17.9772 11.9283 17.9772 10.4738C17.9772 9.01932 16.7954 7.84021 15.3375 7.84021C13.8796 7.84021 12.6978 9.01932 12.6978 10.4738C12.6978 11.9283 13.8796 13.1074 15.3375 13.1074Z" fill="#6634F7"/>
      <path d="M15.3375 13.1378C16.7954 13.1378 17.9772 11.9587 17.9772 10.5042C17.9772 9.04971 16.7954 7.87061 15.3375 7.87061C13.8796 7.87061 12.6978 9.04971 12.6978 10.5042C12.6978 11.9587 13.8796 13.1378 15.3375 13.1378Z" fill="#6534F7"/>
      <path d="M15.3375 13.1532C16.7954 13.1532 17.9772 11.9741 17.9772 10.5196C17.9772 9.06509 16.7954 7.88599 15.3375 7.88599C13.8796 7.88599 12.6978 9.06509 12.6978 10.5196C12.6978 11.9741 13.8796 13.1532 15.3375 13.1532Z" fill="#6534F7"/>
      <path d="M15.3375 13.1842C16.7954 13.1842 17.9772 12.0051 17.9772 10.5506C17.9772 9.0961 16.7954 7.91699 15.3375 7.91699C13.8796 7.91699 12.6978 9.0961 12.6978 10.5506C12.6978 12.0051 13.8796 13.1842 15.3375 13.1842Z" fill="#6534F7"/>
      <path d="M15.3375 13.214C16.7954 13.214 17.9772 12.0349 17.9772 10.5804C17.9772 9.12589 16.7954 7.94678 15.3375 7.94678C13.8796 7.94678 12.6978 9.12589 12.6978 10.5804C12.6978 12.0349 13.8796 13.214 15.3375 13.214Z" fill="#6434F7"/>
      <path d="M15.3375 13.2449C16.7954 13.2449 17.9772 12.0658 17.9772 10.6113C17.9772 9.15677 16.7954 7.97766 15.3375 7.97766C13.8796 7.97766 12.6978 9.15677 12.6978 10.6113C12.6978 12.0658 13.8796 13.2449 15.3375 13.2449Z" fill="#6434F7"/>
      <path d="M15.3375 13.2595C16.7954 13.2595 17.9772 12.0804 17.9772 10.6259C17.9772 9.17142 16.7954 7.99231 15.3375 7.99231C13.8796 7.99231 12.6978 9.17142 12.6978 10.6259C12.6978 12.0804 13.8796 13.2595 15.3375 13.2595Z" fill="#6434F7"/>
      <path d="M15.3375 13.2887C16.7954 13.2887 17.9772 12.1096 17.9772 10.6551C17.9772 9.20059 16.7954 8.02148 15.3375 8.02148C13.8796 8.02148 12.6978 9.20059 12.6978 10.6551C12.6978 12.1096 13.8796 13.2887 15.3375 13.2887Z" fill="#6334F7"/>
      <path d="M15.3375 13.32C16.7954 13.32 17.9772 12.1409 17.9772 10.6863C17.9772 9.23184 16.7954 8.05273 15.3375 8.05273C13.8796 8.05273 12.6978 9.23184 12.6978 10.6863C12.6978 12.1409 13.8796 13.32 15.3375 13.32Z" fill="#6334F7"/>
      <path d="M15.3375 13.3351C16.7954 13.3351 17.9772 12.156 17.9772 10.7015C17.9772 9.24698 16.7954 8.06787 15.3375 8.06787C13.8796 8.06787 12.6978 9.24698 12.6978 10.7015C12.6978 12.156 13.8796 13.3351 15.3375 13.3351Z" fill="#6334F7"/>
      <path d="M15.3375 13.3649C16.7954 13.3649 17.9772 12.1858 17.9772 10.7313C17.9772 9.27677 16.7954 8.09766 15.3375 8.09766C13.8796 8.09766 12.6978 9.27677 12.6978 10.7313C12.6978 12.1858 13.8796 13.3649 15.3375 13.3649Z" fill="#6335F7"/>
      <path d="M15.3375 13.3959C16.7954 13.3959 17.9772 12.2168 17.9772 10.7623C17.9772 9.30777 16.7954 8.12866 15.3375 8.12866C13.8796 8.12866 12.6978 9.30777 12.6978 10.7623C12.6978 12.2168 13.8796 13.3959 15.3375 13.3959Z" fill="#6235F7"/>
      <path d="M15.3375 13.4251C16.7954 13.4251 17.9772 12.246 17.9772 10.7915C17.9772 9.33695 16.7954 8.15784 15.3375 8.15784C13.8796 8.15784 12.6978 9.33695 12.6978 10.7915C12.6978 12.246 13.8796 13.4251 15.3375 13.4251Z" fill="#6235F7"/>
      <path d="M15.3375 13.4417C16.7954 13.4417 17.9772 12.2626 17.9772 10.8081C17.9772 9.35355 16.7954 8.17444 15.3375 8.17444C13.8796 8.17444 12.6978 9.35355 12.6978 10.8081C12.6978 12.2626 13.8796 13.4417 15.3375 13.4417Z" fill="#6235F7"/>
      <path d="M15.3375 13.4706C16.7954 13.4706 17.9772 12.2915 17.9772 10.837C17.9772 9.38248 16.7954 8.20337 15.3375 8.20337C13.8796 8.20337 12.6978 9.38248 12.6978 10.837C12.6978 12.2915 13.8796 13.4706 15.3375 13.4706Z" fill="#6135F7"/>
      <path d="M15.3375 13.5018C16.7954 13.5018 17.9772 12.3227 17.9772 10.8682C17.9772 9.41373 16.7954 8.23462 15.3375 8.23462C13.8796 8.23462 12.6978 9.41373 12.6978 10.8682C12.6978 12.3227 13.8796 13.5018 15.3375 13.5018Z" fill="#6135F7"/>
      <path d="M15.3375 13.517C16.7954 13.517 17.9772 12.3379 17.9772 10.8834C17.9772 9.42886 16.7954 8.24976 15.3375 8.24976C13.8796 8.24976 12.6978 9.42886 12.6978 10.8834C12.6978 12.3379 13.8796 13.517 15.3375 13.517Z" fill="#6135F7"/>
      <path d="M15.3375 13.5468C16.7954 13.5468 17.9772 12.3677 17.9772 10.9132C17.9772 9.45865 16.7954 8.27954 15.3375 8.27954C13.8796 8.27954 12.6978 9.45865 12.6978 10.9132C12.6978 12.3677 13.8796 13.5468 15.3375 13.5468Z" fill="#6135F7"/>
      <path d="M15.3375 13.5772C16.7954 13.5772 17.9772 12.3981 17.9772 10.9436C17.9772 9.48905 16.7954 8.30994 15.3375 8.30994C13.8796 8.30994 12.6978 9.48905 12.6978 10.9436C12.6978 12.3981 13.8796 13.5772 15.3375 13.5772Z" fill="#6035F7"/>
      <path d="M15.3375 13.6069C16.7954 13.6069 17.9772 12.4278 17.9772 10.9733C17.9772 9.51883 16.7954 8.33972 15.3375 8.33972C13.8796 8.33972 12.6978 9.51883 12.6978 10.9733C12.6978 12.4278 13.8796 13.6069 15.3375 13.6069Z" fill="#6035F7"/>
      <path d="M15.3375 13.6235C16.7954 13.6235 17.9772 12.4444 17.9772 10.9899C17.9772 9.53543 16.7954 8.35632 15.3375 8.35632C13.8796 8.35632 12.6978 9.53543 12.6978 10.9899C12.6978 12.4444 13.8796 13.6235 15.3375 13.6235Z" fill="#6035F7"/>
      <path d="M15.3375 13.6525C16.7954 13.6525 17.9772 12.4734 17.9772 11.0189C17.9772 9.56436 16.7954 8.38525 15.3375 8.38525C13.8796 8.38525 12.6978 9.56436 12.6978 11.0189C12.6978 12.4734 13.8796 13.6525 15.3375 13.6525Z" fill="#5F35F7"/>
      <path d="M15.3375 13.6837C16.7954 13.6837 17.9772 12.5046 17.9772 11.0501C17.9772 9.59561 16.7954 8.4165 15.3375 8.4165C13.8796 8.4165 12.6978 9.59561 12.6978 11.0501C12.6978 12.5046 13.8796 13.6837 15.3375 13.6837Z" fill="#5F35F7"/>
      <path d="M15.3375 13.6983C16.7954 13.6983 17.9772 12.5191 17.9772 11.0646C17.9772 9.61014 16.7954 8.43103 15.3375 8.43103C13.8796 8.43103 12.6978 9.61014 12.6978 11.0646C12.6978 12.5191 13.8796 13.6983 15.3375 13.6983Z" fill="#5F35F7"/>
      <path d="M15.3375 13.728C16.7954 13.728 17.9772 12.5489 17.9772 11.0944C17.9772 9.63992 16.7954 8.46082 15.3375 8.46082C13.8796 8.46082 12.6978 9.63992 12.6978 11.0944C12.6978 12.5489 13.8796 13.728 15.3375 13.728Z" fill="#5E35F7"/>
      <path d="M15.3375 13.759C16.7954 13.759 17.9772 12.5799 17.9772 11.1254C17.9772 9.67093 16.7954 8.49182 15.3375 8.49182C13.8796 8.49182 12.6978 9.67093 12.6978 11.1254C12.6978 12.5799 13.8796 13.759 15.3375 13.759Z" fill="#5E35F7"/>
      <path d="M15.3375 13.7888C16.7954 13.7888 17.9772 12.6097 17.9772 11.1552C17.9772 9.70071 16.7954 8.52161 15.3375 8.52161C13.8796 8.52161 12.6978 9.70071 12.6978 11.1552C12.6978 12.6097 13.8796 13.7888 15.3375 13.7888Z" fill="#5E36F7"/>
      <path d="M15.3375 13.8034C16.7954 13.8034 17.9772 12.6243 17.9772 11.1697C17.9772 9.71524 16.7954 8.53613 15.3375 8.53613C13.8796 8.53613 12.6978 9.71524 12.6978 11.1697C12.6978 12.6243 13.8796 13.8034 15.3375 13.8034Z" fill="#5E36F7"/>
      <path d="M15.3375 13.8346C16.7954 13.8346 17.9772 12.6555 17.9772 11.201C17.9772 9.74649 16.7954 8.56738 15.3375 8.56738C13.8796 8.56738 12.6978 9.74649 12.6978 11.201C12.6978 12.6555 13.8796 13.8346 15.3375 13.8346Z" fill="#5D36F7"/>
      <path d="M15.3375 13.8644C16.7954 13.8644 17.9772 12.6853 17.9772 11.2308C17.9772 9.77628 16.7954 8.59717 15.3375 8.59717C13.8796 8.59717 12.6978 9.77628 12.6978 11.2308C12.6978 12.6853 13.8796 13.8644 15.3375 13.8644Z" fill="#5D36F7"/>
      <path d="M15.3375 13.8801C16.7954 13.8801 17.9772 12.701 17.9772 11.2465C17.9772 9.79202 16.7954 8.61292 15.3375 8.61292C13.8796 8.61292 12.6978 9.79202 12.6978 11.2465C12.6978 12.701 13.8796 13.8801 15.3375 13.8801Z" fill="#5D36F7"/>
      <path d="M15.3375 13.9099C16.7954 13.9099 17.9772 12.7308 17.9772 11.2763C17.9772 9.82181 16.7954 8.6427 15.3375 8.6427C13.8796 8.6427 12.6978 9.82181 12.6978 11.2763C12.6978 12.7308 13.8796 13.9099 15.3375 13.9099Z" fill="#5C36F7"/>
      <path d="M15.3375 13.9409C16.7954 13.9409 17.9772 12.7618 17.9772 11.3073C17.9772 9.85281 16.7954 8.67371 15.3375 8.67371C13.8796 8.67371 12.6978 9.85281 12.6978 11.3073C12.6978 12.7618 13.8796 13.9409 15.3375 13.9409Z" fill="#5C36F7"/>
      <path d="M15.3375 13.971C16.7954 13.971 17.9772 12.7919 17.9772 11.3373C17.9772 9.88284 16.7954 8.70374 15.3375 8.70374C13.8796 8.70374 12.6978 9.88284 12.6978 11.3373C12.6978 12.7919 13.8796 13.971 15.3375 13.971Z" fill="#5C36F7"/>
      <path d="M15.3375 13.9852C16.7954 13.9852 17.9772 12.8061 17.9772 11.3516C17.9772 9.89713 16.7954 8.71802 15.3375 8.71802C13.8796 8.71802 12.6978 9.89713 12.6978 11.3516C12.6978 12.8061 13.8796 13.9852 15.3375 13.9852Z" fill="#5B36F7"/>
      <path d="M15.3375 14.0165C16.7954 14.0165 17.9772 12.8374 17.9772 11.3829C17.9772 9.92838 16.7954 8.74927 15.3375 8.74927C13.8796 8.74927 12.6978 9.92838 12.6978 11.3829C12.6978 12.8374 13.8796 14.0165 15.3375 14.0165Z" fill="#5B36F7"/>
      <path d="M15.3375 14.0463C16.7954 14.0463 17.9772 12.8672 17.9772 11.4127C17.9772 9.95816 16.7954 8.77905 15.3375 8.77905C13.8796 8.77905 12.6978 9.95816 12.6978 11.4127C12.6978 12.8672 13.8796 14.0463 15.3375 14.0463Z" fill="#5B36F7"/>
      <path d="M15.3375 14.062C16.7954 14.062 17.9772 12.8829 17.9772 11.4284C17.9772 9.97391 16.7954 8.7948 15.3375 8.7948C13.8796 8.7948 12.6978 9.97391 12.6978 11.4284C12.6978 12.8829 13.8796 14.062 15.3375 14.062Z" fill="#5B36F7"/>
      <path d="M15.3375 14.0918C16.7954 14.0918 17.9772 12.9127 17.9772 11.4582C17.9772 10.0037 16.7954 8.82458 15.3375 8.82458C13.8796 8.82458 12.6978 10.0037 12.6978 11.4582C12.6978 12.9127 13.8796 14.0918 15.3375 14.0918Z" fill="#5A36F7"/>
      <path d="M15.3375 14.1216C16.7954 14.1216 17.9772 12.9425 17.9772 11.488C17.9772 10.0335 16.7954 8.85437 15.3375 8.85437C13.8796 8.85437 12.6978 10.0335 12.6978 11.488C12.6978 12.9425 13.8796 14.1216 15.3375 14.1216Z" fill="#5A36F7"/>
      <path d="M15.3375 14.1525C16.7954 14.1525 17.9772 12.9734 17.9772 11.5189C17.9772 10.0644 16.7954 8.88525 15.3375 8.88525C13.8796 8.88525 12.6978 10.0644 12.6978 11.5189C12.6978 12.9734 13.8796 14.1525 15.3375 14.1525Z" fill="#5A36F7"/>
      <path d="M15.3375 14.1674C16.7954 14.1674 17.9772 12.9883 17.9772 11.5338C17.9772 10.0793 16.7954 8.90015 15.3375 8.90015C13.8796 8.90015 12.6978 10.0793 12.6978 11.5338C12.6978 12.9883 13.8796 14.1674 15.3375 14.1674Z" fill="#5937F7"/>
      <path d="M15.3375 14.1984C16.7954 14.1984 17.9772 13.0193 17.9772 11.5648C17.9772 10.1103 16.7954 8.93115 15.3375 8.93115C13.8796 8.93115 12.6978 10.1103 12.6978 11.5648C12.6978 13.0193 13.8796 14.1984 15.3375 14.1984Z" fill="#5937F7"/>
      <path d="M15.3375 14.2273C16.7954 14.2273 17.9772 13.0482 17.9772 11.5937C17.9772 10.1392 16.7954 8.96008 15.3375 8.96008C13.8796 8.96008 12.6978 10.1392 12.6978 11.5937C12.6978 13.0482 13.8796 14.2273 15.3375 14.2273Z" fill="#5937F7"/>
      <path d="M15.3375 14.2427C16.7954 14.2427 17.9772 13.0636 17.9772 11.6091C17.9772 10.1546 16.7954 8.97546 15.3375 8.97546C13.8796 8.97546 12.6978 10.1546 12.6978 11.6091C12.6978 13.0636 13.8796 14.2427 15.3375 14.2427Z" fill="#5837F7"/>
      <path d="M15.3375 14.2737C16.7954 14.2737 17.9772 13.0946 17.9772 11.6401C17.9772 10.1856 16.7954 9.00647 15.3375 9.00647C13.8796 9.00647 12.6978 10.1856 12.6978 11.6401C12.6978 13.0946 13.8796 14.2737 15.3375 14.2737Z" fill="#5837F7"/>
      <path d="M15.3375 14.3035C16.7954 14.3035 17.9772 13.1244 17.9772 11.6699C17.9772 10.2154 16.7954 9.03625 15.3375 9.03625C13.8796 9.03625 12.6978 10.2154 12.6978 11.6699C12.6978 13.1244 13.8796 14.3035 15.3375 14.3035Z" fill="#5837F7"/>
      <path d="M15.3375 14.3338C16.7954 14.3338 17.9772 13.1546 17.9772 11.7001C17.9772 10.2456 16.7954 9.06653 15.3375 9.06653C13.8796 9.06653 12.6978 10.2456 12.6978 11.7001C12.6978 13.1546 13.8796 14.3338 15.3375 14.3338Z" fill="#5837F7"/>
      <path d="M15.3375 14.349C16.7954 14.349 17.9772 13.1699 17.9772 11.7154C17.9772 10.2609 16.7954 9.08179 15.3375 9.08179C13.8796 9.08179 12.6978 10.2609 12.6978 11.7154C12.6978 13.1699 13.8796 14.349 15.3375 14.349Z" fill="#5737F7"/>
      <path d="M15.3375 14.3797C16.7954 14.3797 17.9772 13.2005 17.9772 11.746C17.9772 10.2915 16.7954 9.11243 15.3375 9.11243C13.8796 9.11243 12.6978 10.2915 12.6978 11.746C12.6978 13.2005 13.8796 14.3797 15.3375 14.3797Z" fill="#5737F7"/>
      <path d="M15.3375 14.4094C16.7954 14.4094 17.9772 13.2303 17.9772 11.7758C17.9772 10.3213 16.7954 9.14221 15.3375 9.14221C13.8796 9.14221 12.6978 10.3213 12.6978 11.7758C12.6978 13.2303 13.8796 14.4094 15.3375 14.4094Z" fill="#5737F7"/>
      <path d="M15.3375 14.4246C16.7954 14.4246 17.9772 13.2455 17.9772 11.791C17.9772 10.3365 16.7954 9.15735 15.3375 9.15735C13.8796 9.15735 12.6978 10.3365 12.6978 11.791C12.6978 13.2455 13.8796 14.4246 15.3375 14.4246Z" fill="#5637F7"/>
      <path d="M15.3375 14.4556C16.7954 14.4556 17.9772 13.2765 17.9772 11.822C17.9772 10.3675 16.7954 9.18835 15.3375 9.18835C13.8796 9.18835 12.6978 10.3675 12.6978 11.822C12.6978 13.2765 13.8796 14.4556 15.3375 14.4556Z" fill="#5637F7"/>
      <path d="M15.3375 14.4848C16.7954 14.4848 17.9772 13.3056 17.9772 11.8511C17.9772 10.3966 16.7954 9.21753 15.3375 9.21753C13.8796 9.21753 12.6978 10.3966 12.6978 11.8511C12.6978 13.3056 13.8796 14.4848 15.3375 14.4848Z" fill="#5637F7"/>
      <path d="M15.3375 14.516C16.7954 14.516 17.9772 13.3369 17.9772 11.8824C17.9772 10.4279 16.7954 9.24878 15.3375 9.24878C13.8796 9.24878 12.6978 10.4279 12.6978 11.8824C12.6978 13.3369 13.8796 14.516 15.3375 14.516Z" fill="#5537F7"/>
      <path d="M15.3375 14.5305C16.7954 14.5305 17.9772 13.3514 17.9772 11.8969C17.9772 10.4424 16.7954 9.26331 15.3375 9.26331C13.8796 9.26331 12.6978 10.4424 12.6978 11.8969C12.6978 13.3514 13.8796 14.5305 15.3375 14.5305Z" fill="#5537F7"/>
      <path d="M15.3375 14.5601C16.7954 14.5601 17.9772 13.381 17.9772 11.9265C17.9772 10.472 16.7954 9.29285 15.3375 9.29285C13.8796 9.29285 12.6978 10.472 12.6978 11.9265C12.6978 13.381 13.8796 14.5601 15.3375 14.5601Z" fill="#5537F7"/>
      <path d="M15.3375 14.5913C16.7954 14.5913 17.9772 13.4122 17.9772 11.9577C17.9772 10.5032 16.7954 9.3241 15.3375 9.3241C13.8796 9.3241 12.6978 10.5032 12.6978 11.9577C12.6978 13.4122 13.8796 14.5913 15.3375 14.5913Z" fill="#5538F7"/>
      <path d="M15.3375 14.6058C16.7954 14.6058 17.9772 13.4267 17.9772 11.9722C17.9772 10.5177 16.7954 9.33862 15.3375 9.33862C13.8796 9.33862 12.6978 10.5177 12.6978 11.9722C12.6978 13.4267 13.8796 14.6058 15.3375 14.6058Z" fill="#5438F7"/>
      <path d="M15.3375 14.6371C16.7954 14.6371 17.9772 13.458 17.9772 12.0035C17.9772 10.549 16.7954 9.36987 15.3375 9.36987C13.8796 9.36987 12.6978 10.549 12.6978 12.0035C12.6978 13.458 13.8796 14.6371 15.3375 14.6371Z" fill="#5438F7"/>
      <path d="M15.3375 14.6666C16.7954 14.6666 17.9772 13.4875 17.9772 12.033C17.9772 10.5785 16.7954 9.39941 15.3375 9.39941C13.8796 9.39941 12.6978 10.5785 12.6978 12.033C12.6978 13.4875 13.8796 14.6666 15.3375 14.6666Z" fill="#5438F7"/>
      <path d="M15.3375 14.6979C16.7954 14.6979 17.9772 13.5188 17.9772 12.0643C17.9772 10.6098 16.7954 9.43066 15.3375 9.43066C13.8796 9.43066 12.6978 10.6098 12.6978 12.0643C12.6978 13.5188 13.8796 14.6979 15.3375 14.6979Z" fill="#5338F7"/>
      <path d="M15.3375 14.7124C16.7954 14.7124 17.9772 13.5333 17.9772 12.0788C17.9772 10.6243 16.7954 9.44519 15.3375 9.44519C13.8796 9.44519 12.6978 10.6243 12.6978 12.0788C12.6978 13.5333 13.8796 14.7124 15.3375 14.7124Z" fill="#5338F7"/>
      <path d="M15.3375 14.7422C16.7954 14.7422 17.9772 13.5631 17.9772 12.1086C17.9772 10.6541 16.7954 9.47498 15.3375 9.47498C13.8796 9.47498 12.6978 10.6541 12.6978 12.1086C12.6978 13.5631 13.8796 14.7422 15.3375 14.7422Z" fill="#5338F7"/>
      <path d="M15.3375 14.7732C16.7954 14.7732 17.9772 13.5941 17.9772 12.1396C17.9772 10.6851 16.7954 9.50598 15.3375 9.50598C13.8796 9.50598 12.6978 10.6851 12.6978 12.1396C12.6978 13.5941 13.8796 14.7732 15.3375 14.7732Z" fill="#5338F7"/>
      <path d="M15.3375 14.8029C16.7954 14.8029 17.9772 13.6238 17.9772 12.1693C17.9772 10.7148 16.7954 9.53564 15.3375 9.53564C13.8796 9.53564 12.6978 10.7148 12.6978 12.1693C12.6978 13.6238 13.8796 14.8029 15.3375 14.8029Z" fill="#5238F7"/>
      <path d="M15.3375 14.8187C16.7954 14.8187 17.9772 13.6396 17.9772 12.1851C17.9772 10.7306 16.7954 9.55151 15.3375 9.55151C13.8796 9.55151 12.6978 10.7306 12.6978 12.1851C12.6978 13.6396 13.8796 14.8187 15.3375 14.8187Z" fill="#5238F7"/>
      <path d="M15.3375 14.8488C16.7954 14.8488 17.9772 13.6697 17.9772 12.2152C17.9772 10.7607 16.7954 9.58154 15.3375 9.58154C13.8796 9.58154 12.6978 10.7607 12.6978 12.2152C12.6978 13.6697 13.8796 14.8488 15.3375 14.8488Z" fill="#5238F7"/>
      <path d="M15.3375 14.8777C16.7954 14.8777 17.9772 13.6986 17.9772 12.2441C17.9772 10.7896 16.7954 9.61047 15.3375 9.61047C13.8796 9.61047 12.6978 10.7896 12.6978 12.2441C12.6978 13.6986 13.8796 14.8777 15.3375 14.8777Z" fill="#5138F7"/>
      <path d="M15.3375 14.8943C16.7954 14.8943 17.9772 13.7152 17.9772 12.2607C17.9772 10.8062 16.7954 9.62708 15.3375 9.62708C13.8796 9.62708 12.6978 10.8062 12.6978 12.2607C12.6978 13.7152 13.8796 14.8943 15.3375 14.8943Z" fill="#5138F7"/>
      <path d="M15.3375 14.9241C16.7954 14.9241 17.9772 13.745 17.9772 12.2905C17.9772 10.836 16.7954 9.65686 15.3375 9.65686C13.8796 9.65686 12.6978 10.836 12.6978 12.2905C12.6978 13.745 13.8796 14.9241 15.3375 14.9241Z" fill="#5138F7"/>
      <path d="M15.3375 14.955C16.7954 14.955 17.9772 13.7759 17.9772 12.3214C17.9772 10.8669 16.7954 9.68774 15.3375 9.68774C13.8796 9.68774 12.6978 10.8669 12.6978 12.3214C12.6978 13.7759 13.8796 14.955 15.3375 14.955Z" fill="#5038F7"/>
      <path d="M15.3375 14.9851C16.7954 14.9851 17.9772 13.806 17.9772 12.3515C17.9772 10.897 16.7954 9.7179 15.3375 9.7179C13.8796 9.7179 12.6978 10.897 12.6978 12.3515C12.6978 13.806 13.8796 14.9851 15.3375 14.9851Z" fill="#5038F7"/>
      <path d="M15.3375 14.9994C16.7954 14.9994 17.9772 13.8203 17.9772 12.3658C17.9772 10.9113 16.7954 9.73218 15.3375 9.73218C13.8796 9.73218 12.6978 10.9113 12.6978 12.3658C12.6978 13.8203 13.8796 14.9994 15.3375 14.9994Z" fill="#5039F7"/>
      <path d="M15.3375 15.0307C16.7954 15.0307 17.9772 13.8515 17.9772 12.397C17.9772 10.9425 16.7954 9.76343 15.3375 9.76343C13.8796 9.76343 12.6978 10.9425 12.6978 12.397C12.6978 13.8515 13.8796 15.0307 15.3375 15.0307Z" fill="#5039F7"/>
      <path d="M15.3375 15.0598C16.7954 15.0598 17.9772 13.8807 17.9772 12.4262C17.9772 10.9717 16.7954 9.7926 15.3375 9.7926C13.8796 9.7926 12.6978 10.9717 12.6978 12.4262C12.6978 13.8807 13.8796 15.0598 15.3375 15.0598Z" fill="#4F39F7"/>
      <path d="M15.3375 15.0762C16.7954 15.0762 17.9772 13.8971 17.9772 12.4426C17.9772 10.9881 16.7954 9.80896 15.3375 9.80896C13.8796 9.80896 12.6978 10.9881 12.6978 12.4426C12.6978 13.8971 13.8796 15.0762 15.3375 15.0762Z" fill="#4F39F7"/>
      <path d="M15.3375 15.1054C16.7954 15.1054 17.9772 13.9263 17.9772 12.4717C17.9772 11.0172 16.7954 9.83813 15.3375 9.83813C13.8796 9.83813 12.6978 11.0172 12.6978 12.4717C12.6978 13.9263 13.8796 15.1054 15.3375 15.1054Z" fill="#4F39F7"/>
      <path d="M15.3375 15.1362C16.7954 15.1362 17.9772 13.9571 17.9772 12.5026C17.9772 11.0481 16.7954 9.86902 15.3375 9.86902C13.8796 9.86902 12.6978 11.0481 12.6978 12.5026C12.6978 13.9571 13.8796 15.1362 15.3375 15.1362Z" fill="#4E39F7"/>
      <path d="M15.3375 15.166C16.7954 15.166 17.9772 13.9869 17.9772 12.5324C17.9772 11.0779 16.7954 9.8988 15.3375 9.8988C13.8796 9.8988 12.6978 11.0779 12.6978 12.5324C12.6978 13.9869 13.8796 15.166 15.3375 15.166Z" fill="#4E39F7"/>
      <path d="M15.3375 15.1813C16.7954 15.1813 17.9772 14.0022 17.9772 12.5477C17.9772 11.0932 16.7954 9.91406 15.3375 9.91406C13.8796 9.91406 12.6978 11.0932 12.6978 12.5477C12.6978 14.0022 13.8796 15.1813 15.3375 15.1813Z" fill="#4E39F7"/>
      <path d="M15.3375 15.2125C16.7954 15.2125 17.9772 14.0334 17.9772 12.5789C17.9772 11.1244 16.7954 9.94531 15.3375 9.94531C13.8796 9.94531 12.6978 11.1244 12.6978 12.5789C12.6978 14.0334 13.8796 15.2125 15.3375 15.2125Z" fill="#4D39F7"/>
      <path d="M15.3375 15.2413C16.7954 15.2413 17.9772 14.0622 17.9772 12.6077C17.9772 11.1532 16.7954 9.97412 15.3375 9.97412C13.8796 9.97412 12.6978 11.1532 12.6978 12.6077C12.6978 14.0622 13.8796 15.2413 15.3375 15.2413Z" fill="#4D39F7"/>
      <path d="M15.3375 15.256C16.7954 15.256 17.9772 14.0769 17.9772 12.6224C17.9772 11.1679 16.7954 9.98877 15.3375 9.98877C13.8796 9.98877 12.6978 11.1679 12.6978 12.6224C12.6978 14.0769 13.8796 15.256 15.3375 15.256Z" fill="#4D39F7"/>
      <path d="M15.3375 15.2872C16.7954 15.2872 17.9772 14.1081 17.9772 12.6536C17.9772 11.1991 16.7954 10.02 15.3375 10.02C13.8796 10.02 12.6978 11.1991 12.6978 12.6536C12.6978 14.1081 13.8796 15.2872 15.3375 15.2872Z" fill="#4D39F7"/>
      <path d="M15.3375 15.317C16.7954 15.317 17.9772 14.1379 17.9772 12.6834C17.9772 11.2289 16.7954 10.0498 15.3375 10.0498C13.8796 10.0498 12.6978 11.2289 12.6978 12.6834C12.6978 14.1379 13.8796 15.317 15.3375 15.317Z" fill="#4C39F7"/>
      <path d="M15.3375 15.3479C16.7954 15.3479 17.9772 14.1688 17.9772 12.7143C17.9772 11.2598 16.7954 10.0807 15.3375 10.0807C13.8796 10.0807 12.6978 11.2598 12.6978 12.7143C12.6978 14.1688 13.8796 15.3479 15.3375 15.3479Z" fill="#4C39F7"/>
      <path d="M15.3375 15.3632C16.7954 15.3632 17.9772 14.1841 17.9772 12.7296C17.9772 11.2751 16.7954 10.0959 15.3375 10.0959C13.8796 10.0959 12.6978 11.2751 12.6978 12.7296C12.6978 14.1841 13.8796 15.3632 15.3375 15.3632Z" fill="#4C39F7"/>
      <path d="M15.3375 15.3944C16.7954 15.3944 17.9772 14.2153 17.9772 12.7608C17.9772 11.3063 16.7954 10.1272 15.3375 10.1272C13.8796 10.1272 12.6978 11.3063 12.6978 12.7608C12.6978 14.2153 13.8796 15.3944 15.3375 15.3944Z" fill="#4B3AF7"/>
      <path d="M15.3375 15.4236C16.7954 15.4236 17.9772 14.2445 17.9772 12.79C17.9772 11.3355 16.7954 10.1564 15.3375 10.1564C13.8796 10.1564 12.6978 11.3355 12.6978 12.79C12.6978 14.2445 13.8796 15.4236 15.3375 15.4236Z" fill="#4B3AF7"/>
      <path d="M15.3375 15.4381C16.7954 15.4381 17.9772 14.259 17.9772 12.8045C17.9772 11.35 16.7954 10.1709 15.3375 10.1709C13.8796 10.1709 12.6978 11.35 12.6978 12.8045C12.6978 14.259 13.8796 15.4381 15.3375 15.4381Z" fill="#4B3AF7"/>
      <path d="M15.3375 15.4691C16.7954 15.4691 17.9772 14.29 17.9772 12.8355C17.9772 11.381 16.7954 10.2019 15.3375 10.2019C13.8796 10.2019 12.6978 11.381 12.6978 12.8355C12.6978 14.29 13.8796 15.4691 15.3375 15.4691Z" fill="#4A3AF7"/>
      <path d="M15.3375 15.4989C16.7954 15.4989 17.9772 14.3198 17.9772 12.8653C17.9772 11.4108 16.7954 10.2317 15.3375 10.2317C13.8796 10.2317 12.6978 11.4108 12.6978 12.8653C12.6978 14.3198 13.8796 15.4989 15.3375 15.4989Z" fill="#4A3AF7"/>
      <path d="M15.3375 15.5302C16.7954 15.5302 17.9772 14.3511 17.9772 12.8966C17.9772 11.442 16.7954 10.2629 15.3375 10.2629C13.8796 10.2629 12.6978 11.442 12.6978 12.8966C12.6978 14.3511 13.8796 15.5302 15.3375 15.5302Z" fill="#4A3AF7"/>
      <path d="M15.3375 15.5447C16.7954 15.5447 17.9772 14.3656 17.9772 12.9111C17.9772 11.4566 16.7954 10.2775 15.3375 10.2775C13.8796 10.2775 12.6978 11.4566 12.6978 12.9111C12.6978 14.3656 13.8796 15.5447 15.3375 15.5447Z" fill="#4A3AF7"/>
      <path d="M15.3375 15.5757C16.7954 15.5757 17.9772 14.3966 17.9772 12.9421C17.9772 11.4876 16.7954 10.3085 15.3375 10.3085C13.8796 10.3085 12.6978 11.4876 12.6978 12.9421C12.6978 14.3966 13.8796 15.5757 15.3375 15.5757Z" fill="#493AF7"/>
      <path d="M15.3375 15.6055C16.7954 15.6055 17.9772 14.4264 17.9772 12.9719C17.9772 11.5174 16.7954 10.3383 15.3375 10.3383C13.8796 10.3383 12.6978 11.5174 12.6978 12.9719C12.6978 14.4264 13.8796 15.6055 15.3375 15.6055Z" fill="#493AF7"/>
      <path d="M15.3375 15.62C16.7954 15.62 17.9772 14.4409 17.9772 12.9864C17.9772 11.5319 16.7954 10.3528 15.3375 10.3528C13.8796 10.3528 12.6978 11.5319 12.6978 12.9864C12.6978 14.4409 13.8796 15.62 15.3375 15.62Z" fill="#493AF7"/>
      <path d="M15.3375 15.651C16.7954 15.651 17.9772 14.4719 17.9772 13.0174C17.9772 11.5629 16.7954 10.3838 15.3375 10.3838C13.8796 10.3838 12.6978 11.5629 12.6978 13.0174C12.6978 14.4719 13.8796 15.651 15.3375 15.651Z" fill="#483AF7"/>
      <path d="M15.3375 15.6808C16.7954 15.6808 17.9772 14.5017 17.9772 13.0472C17.9772 11.5927 16.7954 10.4136 15.3375 10.4136C13.8796 10.4136 12.6978 11.5927 12.6978 13.0472C12.6978 14.5017 13.8796 15.6808 15.3375 15.6808Z" fill="#483AF7"/>
      <path d="M15.3375 15.7119C16.7954 15.7119 17.9772 14.5328 17.9772 13.0783C17.9772 11.6238 16.7954 10.4447 15.3375 10.4447C13.8796 10.4447 12.6978 11.6238 12.6978 13.0783C12.6978 14.5328 13.8796 15.7119 15.3375 15.7119Z" fill="#483AF7"/>
      <path d="M15.3375 15.7263C16.7954 15.7263 17.9772 14.5472 17.9772 13.0927C17.9772 11.6382 16.7954 10.4591 15.3375 10.4591C13.8796 10.4591 12.6978 11.6382 12.6978 13.0927C12.6978 14.5472 13.8796 15.7263 15.3375 15.7263Z" fill="#473AF7"/>
      <path d="M15.3375 15.7564C16.7954 15.7564 17.9772 14.5773 17.9772 13.1227C17.9772 11.6682 16.7954 10.4891 15.3375 10.4891C13.8796 10.4891 12.6978 11.6682 12.6978 13.1227C12.6978 14.5773 13.8796 15.7564 15.3375 15.7564Z" fill="#473AF7"/>
      <path d="M15.3375 15.7872C16.7954 15.7872 17.9772 14.6081 17.9772 13.1536C17.9772 11.6991 16.7954 10.52 15.3375 10.52C13.8796 10.52 12.6978 11.6991 12.6978 13.1536C12.6978 14.6081 13.8796 15.7872 15.3375 15.7872Z" fill="#473AF7"/>
      <path d="M15.3375 15.8019C16.7954 15.8019 17.9772 14.6228 17.9772 13.1683C17.9772 11.7138 16.7954 10.5347 15.3375 10.5347C13.8796 10.5347 12.6978 11.7138 12.6978 13.1683C12.6978 14.6228 13.8796 15.8019 15.3375 15.8019Z" fill="#473BF7"/>
      <path d="M15.3375 15.8328C16.7954 15.8328 17.9772 14.6537 17.9772 13.1992C17.9772 11.7447 16.7954 10.5656 15.3375 10.5656C13.8796 10.5656 12.6978 11.7447 12.6978 13.1992C12.6978 14.6537 13.8796 15.8328 15.3375 15.8328Z" fill="#463BF7"/>
      <path d="M15.3375 15.8626C16.7954 15.8626 17.9772 14.6835 17.9772 13.2289C17.9772 11.7744 16.7954 10.5953 15.3375 10.5953C13.8796 10.5953 12.6978 11.7744 12.6978 13.2289C12.6978 14.6835 13.8796 15.8626 15.3375 15.8626Z" fill="#463BF7"/>
      <path d="M15.3375 15.8938C16.7954 15.8938 17.9772 14.7147 17.9772 13.2602C17.9772 11.8057 16.7954 10.6266 15.3375 10.6266C13.8796 10.6266 12.6978 11.8057 12.6978 13.2602C12.6978 14.7147 13.8796 15.8938 15.3375 15.8938Z" fill="#463BF7"/>
      <path d="M15.3375 15.9085C16.7954 15.9085 17.9772 14.7294 17.9772 13.2748C17.9772 11.8203 16.7954 10.6412 15.3375 10.6412C13.8796 10.6412 12.6978 11.8203 12.6978 13.2748C12.6978 14.7294 13.8796 15.9085 15.3375 15.9085Z" fill="#453BF7"/>
      <path d="M15.3375 15.9382C16.7954 15.9382 17.9772 14.7591 17.9772 13.3046C17.9772 11.8501 16.7954 10.671 15.3375 10.671C13.8796 10.671 12.6978 11.8501 12.6978 13.3046C12.6978 14.7591 13.8796 15.9382 15.3375 15.9382Z" fill="#453BF6"/>
      <path d="M15.3375 15.9691C16.7954 15.9691 17.9772 14.79 17.9772 13.3355C17.9772 11.881 16.7954 10.7019 15.3375 10.7019C13.8796 10.7019 12.6978 11.881 12.6978 13.3355C12.6978 14.79 13.8796 15.9691 15.3375 15.9691Z" fill="#453BF6"/>
      <path d="M15.3375 15.9838C16.7954 15.9838 17.9772 14.8047 17.9772 13.3502C17.9772 11.8957 16.7954 10.7166 15.3375 10.7166C13.8796 10.7166 12.6978 11.8957 12.6978 13.3502C12.6978 14.8047 13.8796 15.9838 15.3375 15.9838Z" fill="#453BF6"/>
      <path d="M15.3375 16.013C16.7954 16.013 17.9772 14.8338 17.9772 13.3793C17.9772 11.9248 16.7954 10.7457 15.3375 10.7457C13.8796 10.7457 12.6978 11.9248 12.6978 13.3793C12.6978 14.8338 13.8796 16.013 15.3375 16.013Z" fill="#443BF6"/>
      <path d="M15.3375 16.0438C16.7954 16.0438 17.9772 14.8647 17.9772 13.4102C17.9772 11.9557 16.7954 10.7766 15.3375 10.7766C13.8796 10.7766 12.6978 11.9557 12.6978 13.4102C12.6978 14.8647 13.8796 16.0438 15.3375 16.0438Z" fill="#443BF6"/>
      <path d="M15.3375 16.0736C16.7954 16.0736 17.9772 14.8945 17.9772 13.44C17.9772 11.9855 16.7954 10.8064 15.3375 10.8064C13.8796 10.8064 12.6978 11.9855 12.6978 13.44C12.6978 14.8945 13.8796 16.0736 15.3375 16.0736Z" fill="#443BF6"/>
      <path d="M15.3375 16.0903C16.7954 16.0903 17.9772 14.9112 17.9772 13.4567C17.9772 12.0022 16.7954 10.8231 15.3375 10.8231C13.8796 10.8231 12.6978 12.0022 12.6978 13.4567C12.6978 14.9112 13.8796 16.0903 15.3375 16.0903Z" fill="#433BF6"/>
      <path d="M15.3375 16.1201C16.7954 16.1201 17.9772 14.941 17.9772 13.4865C17.9772 12.032 16.7954 10.8529 15.3375 10.8529C13.8796 10.8529 12.6978 12.032 12.6978 13.4865C12.6978 14.941 13.8796 16.1201 15.3375 16.1201Z" fill="#433BF6"/>
      <path d="M15.3375 16.151C16.7954 16.151 17.9772 14.9719 17.9772 13.5174C17.9772 12.0629 16.7954 10.8838 15.3375 10.8838C13.8796 10.8838 12.6978 12.0629 12.6978 13.5174C12.6978 14.9719 13.8796 16.151 15.3375 16.151Z" fill="#433BF6"/>
      <path d="M15.3375 16.1657C16.7954 16.1657 17.9772 14.9866 17.9772 13.5321C17.9772 12.0775 16.7954 10.8984 15.3375 10.8984C13.8796 10.8984 12.6978 12.0775 12.6978 13.5321C12.6978 14.9866 13.8796 16.1657 15.3375 16.1657Z" fill="#423BF6"/>
      <path d="M15.3375 16.1948C16.7954 16.1948 17.9772 15.0157 17.9772 13.5612C17.9772 12.1067 16.7954 10.9276 15.3375 10.9276C13.8796 10.9276 12.6978 12.1067 12.6978 13.5612C12.6978 15.0157 13.8796 16.1948 15.3375 16.1948Z" fill="#423BF6"/>
      <path d="M15.3375 16.2261C16.7954 16.2261 17.9772 15.047 17.9772 13.5925C17.9772 12.138 16.7954 10.9589 15.3375 10.9589C13.8796 10.9589 12.6978 12.138 12.6978 13.5925C12.6978 15.047 13.8796 16.2261 15.3375 16.2261Z" fill="#423CF6"/>
      <path d="M15.3375 16.2555C16.7954 16.2555 17.9772 15.0764 17.9772 13.6219C17.9772 12.1674 16.7954 10.9883 15.3375 10.9883C13.8796 10.9883 12.6978 12.1674 12.6978 13.6219C12.6978 15.0764 13.8796 16.2555 15.3375 16.2555Z" fill="#423CF6"/>
      <path d="M15.3375 16.2722C16.7954 16.2722 17.9772 15.0931 17.9772 13.6386C17.9772 12.1841 16.7954 11.005 15.3375 11.005C13.8796 11.005 12.6978 12.1841 12.6978 13.6386C12.6978 15.0931 13.8796 16.2722 15.3375 16.2722Z" fill="#413CF6"/>
      <path d="M15.3375 16.3014C16.7954 16.3014 17.9772 15.1223 17.9772 13.6678C17.9772 12.2133 16.7954 11.0342 15.3375 11.0342C13.8796 11.0342 12.6978 12.2133 12.6978 13.6678C12.6978 15.1223 13.8796 16.3014 15.3375 16.3014Z" fill="#413CF6"/>
      <path d="M15.3375 16.3323C16.7954 16.3323 17.9772 15.1532 17.9772 13.6987C17.9772 12.2442 16.7954 11.0651 15.3375 11.0651C13.8796 11.0651 12.6978 12.2442 12.6978 13.6987C12.6978 15.1532 13.8796 16.3323 15.3375 16.3323Z" fill="#413CF6"/>
      <path d="M15.3375 16.3478C16.7954 16.3478 17.9772 15.1687 17.9772 13.7142C17.9772 12.2597 16.7954 11.0806 15.3375 11.0806C13.8796 11.0806 12.6978 12.2597 12.6978 13.7142C12.6978 15.1687 13.8796 16.3478 15.3375 16.3478Z" fill="#403CF6"/>
      <path d="M15.3375 16.3767C16.7954 16.3767 17.9772 15.1976 17.9772 13.7431C17.9772 12.2886 16.7954 11.1095 15.3375 11.1095C13.8796 11.1095 12.6978 12.2886 12.6978 13.7431C12.6978 15.1976 13.8796 16.3767 15.3375 16.3767Z" fill="#403CF6"/>
      <path d="M15.3375 16.4076C16.7954 16.4076 17.9772 15.2285 17.9772 13.774C17.9772 12.3195 16.7954 11.1404 15.3375 11.1404C13.8796 11.1404 12.6978 12.3195 12.6978 13.774C12.6978 15.2285 13.8796 16.4076 15.3375 16.4076Z" fill="#403CF6"/>
      <path d="M15.3375 16.4378C16.7954 16.4378 17.9772 15.2586 17.9772 13.8041C17.9772 12.3496 16.7954 11.1705 15.3375 11.1705C13.8796 11.1705 12.6978 12.3496 12.6978 13.8041C12.6978 15.2586 13.8796 16.4378 15.3375 16.4378Z" fill="#3F3CF6"/>
      <path d="M15.3375 16.452C16.7954 16.452 17.9772 15.2729 17.9772 13.8184C17.9772 12.3639 16.7954 11.1848 15.3375 11.1848C13.8796 11.1848 12.6978 12.3639 12.6978 13.8184C12.6978 15.2729 13.8796 16.452 15.3375 16.452Z" fill="#3F3CF6"/>
      <path d="M15.3375 16.4833C16.7954 16.4833 17.9772 15.3042 17.9772 13.8497C17.9772 12.3952 16.7954 11.2161 15.3375 11.2161C13.8796 11.2161 12.6978 12.3952 12.6978 13.8497C12.6978 15.3042 13.8796 16.4833 15.3375 16.4833Z" fill="#3F3CF6"/>
      <path d="M15.3375 16.5131C16.7954 16.5131 17.9772 15.334 17.9772 13.8795C17.9772 12.425 16.7954 11.2458 15.3375 11.2458C13.8796 11.2458 12.6978 12.425 12.6978 13.8795C12.6978 15.334 13.8796 16.5131 15.3375 16.5131Z" fill="#3F3CF6"/>
      <path d="M15.3375 16.5442C16.7954 16.5442 17.9772 15.3651 17.9772 13.9106C17.9772 12.4561 16.7954 11.277 15.3375 11.277C13.8796 11.277 12.6978 12.4561 12.6978 13.9106C12.6978 15.3651 13.8796 16.5442 15.3375 16.5442Z" fill="#3E3CF6"/>
      <path d="M15.3375 16.5586C16.7954 16.5586 17.9772 15.3795 17.9772 13.925C17.9772 12.4705 16.7954 11.2914 15.3375 11.2914C13.8796 11.2914 12.6978 12.4705 12.6978 13.925C12.6978 15.3795 13.8796 16.5586 15.3375 16.5586Z" fill="#3E3CF6"/>
      <path d="M15.3375 16.5897C16.7954 16.5897 17.9772 15.4106 17.9772 13.9561C17.9772 12.5016 16.7954 11.3225 15.3375 11.3225C13.8796 11.3225 12.6978 12.5016 12.6978 13.9561C12.6978 15.4106 13.8796 16.5897 15.3375 16.5897Z" fill="#3E3CF6"/>
      <path d="M15.3375 16.6195C16.7954 16.6195 17.9772 15.4404 17.9772 13.9859C17.9772 12.5314 16.7954 11.3523 15.3375 11.3523C13.8796 11.3523 12.6978 12.5314 12.6978 13.9859C12.6978 15.4404 13.8796 16.6195 15.3375 16.6195Z" fill="#3D3CF6"/>
      <path d="M15.3375 16.6342C16.7954 16.6342 17.9772 15.4551 17.9772 14.0006C17.9772 12.5461 16.7954 11.3669 15.3375 11.3669C13.8796 11.3669 12.6978 12.5461 12.6978 14.0006C12.6978 15.4551 13.8796 16.6342 15.3375 16.6342Z" fill="#3D3DF6"/>
      <path d="M15.3375 16.6651C16.7954 16.6651 17.9772 15.4859 17.9772 14.0314C17.9772 12.5769 16.7954 11.3978 15.3375 11.3978C13.8796 11.3978 12.6978 12.5769 12.6978 14.0314C12.6978 15.4859 13.8796 16.6651 15.3375 16.6651Z" fill="#3D3DF6"/>
      <path d="M15.3375 16.6948C16.7954 16.6948 17.9772 15.5157 17.9772 14.0612C17.9772 12.6067 16.7954 11.4276 15.3375 11.4276C13.8796 11.4276 12.6978 12.6067 12.6978 14.0612C12.6978 15.5157 13.8796 16.6948 15.3375 16.6948Z" fill="#3C3DF6"/>
      <path d="M15.3375 16.7252C16.7954 16.7252 17.9772 15.5461 17.9772 14.0916C17.9772 12.6371 16.7954 11.458 15.3375 11.458C13.8796 11.458 12.6978 12.6371 12.6978 14.0916C12.6978 15.5461 13.8796 16.7252 15.3375 16.7252Z" fill="#3C3DF6"/>
      <path d="M15.3375 16.7404C16.7954 16.7404 17.9772 15.5613 17.9772 14.1068C17.9772 12.6523 16.7954 11.4731 15.3375 11.4731C13.8796 11.4731 12.6978 12.6523 12.6978 14.1068C12.6978 15.5613 13.8796 16.7404 15.3375 16.7404Z" fill="#3C3DF6"/>
      <path d="M15.3375 16.7705C16.7954 16.7705 17.9772 15.5914 17.9772 14.1369C17.9772 12.6824 16.7954 11.5033 15.3375 11.5033C13.8796 11.5033 12.6978 12.6824 12.6978 14.1369C12.6978 15.5914 13.8796 16.7705 15.3375 16.7705Z" fill="#3C3DF6"/>
      <path d="M15.3375 16.8008C16.7954 16.8008 17.9772 15.6217 17.9772 14.1672C17.9772 12.7127 16.7954 11.5336 15.3375 11.5336C13.8796 11.5336 12.6978 12.7127 12.6978 14.1672C12.6978 15.6217 13.8796 16.8008 15.3375 16.8008Z" fill="#3B3DF6"/>
      <path d="M15.3375 16.8161C16.7954 16.8161 17.9772 15.6369 17.9772 14.1824C17.9772 12.7279 16.7954 11.5488 15.3375 11.5488C13.8796 11.5488 12.6978 12.7279 12.6978 14.1824C12.6978 15.6369 13.8796 16.8161 15.3375 16.8161Z" fill="#3B3DF6"/>
      <path d="M15.3375 16.8469C16.7954 16.8469 17.9772 15.6678 17.9772 14.2133C17.9772 12.7588 16.7954 11.5797 15.3375 11.5797C13.8796 11.5797 12.6978 12.7588 12.6978 14.2133C12.6978 15.6678 13.8796 16.8469 15.3375 16.8469Z" fill="#3B3DF6"/>
      <path d="M15.3375 16.8767C16.7954 16.8767 17.9772 15.6976 17.9772 14.2431C17.9772 12.7886 16.7954 11.6095 15.3375 11.6095C13.8796 11.6095 12.6978 12.7886 12.6978 14.2431C12.6978 15.6976 13.8796 16.8767 15.3375 16.8767Z" fill="#3A3DF6"/>
      <path d="M15.3375 16.9074C16.7954 16.9074 17.9772 15.7283 17.9772 14.2737C17.9772 12.8192 16.7954 11.6401 15.3375 11.6401C13.8796 11.6401 12.6978 12.8192 12.6978 14.2737C12.6978 15.7283 13.8796 16.9074 15.3375 16.9074Z" fill="#3A3DF6"/>
      <path d="M15.3375 16.9226C16.7954 16.9226 17.9772 15.7435 17.9772 14.289C17.9772 12.8345 16.7954 11.6554 15.3375 11.6554C13.8796 11.6554 12.6978 12.8345 12.6978 14.289C12.6978 15.7435 13.8796 16.9226 15.3375 16.9226Z" fill="#3A3DF6"/>
      <path d="M15.3375 16.9514C16.7954 16.9514 17.9772 15.7723 17.9772 14.3178C17.9772 12.8633 16.7954 11.6842 15.3375 11.6842C13.8796 11.6842 12.6978 12.8633 12.6978 14.3178C12.6978 15.7723 13.8796 16.9514 15.3375 16.9514Z" fill="#3A3DF6"/>
      <path d="M15.3375 16.9827C16.7954 16.9827 17.9772 15.8036 17.9772 14.3491C17.9772 12.8946 16.7954 11.7155 15.3375 11.7155C13.8796 11.7155 12.6978 12.8946 12.6978 14.3491C12.6978 15.8036 13.8796 16.9827 15.3375 16.9827Z" fill="#393DF6"/>
      <path d="M15.3375 16.9979C16.7954 16.9979 17.9772 15.8188 17.9772 14.3643C17.9772 12.9098 16.7954 11.7307 15.3375 11.7307C13.8796 11.7307 12.6978 12.9098 12.6978 14.3643C12.6978 15.8188 13.8796 16.9979 15.3375 16.9979Z" fill="#393DF6"/>
      <path d="M15.3375 17.0292C16.7954 17.0292 17.9772 15.8501 17.9772 14.3956C17.9772 12.9411 16.7954 11.762 15.3375 11.762C13.8796 11.762 12.6978 12.9411 12.6978 14.3956C12.6978 15.8501 13.8796 17.0292 15.3375 17.0292Z" fill="#393EF6"/>
      <path d="M15.3375 17.058C16.7954 17.058 17.9772 15.8789 17.9772 14.4244C17.9772 12.9699 16.7954 11.7908 15.3375 11.7908C13.8796 11.7908 12.6978 12.9699 12.6978 14.4244C12.6978 15.8789 13.8796 17.058 15.3375 17.058Z" fill="#383EF6"/>
      <path d="M15.3375 17.0892C16.7954 17.0892 17.9772 15.9101 17.9772 14.4556C17.9772 13.0011 16.7954 11.822 15.3375 11.822C13.8796 11.822 12.6978 13.0011 12.6978 14.4556C12.6978 15.9101 13.8796 17.0892 15.3375 17.0892Z" fill="#383EF6"/>
      <path d="M15.3375 17.1039C16.7954 17.1039 17.9772 15.9248 17.9772 14.4703C17.9772 13.0158 16.7954 11.8367 15.3375 11.8367C13.8796 11.8367 12.6978 13.0158 12.6978 14.4703C12.6978 15.9248 13.8796 17.1039 15.3375 17.1039Z" fill="#383EF6"/>
      <path d="M15.3375 17.1337C16.7954 17.1337 17.9772 15.9546 17.9772 14.5001C17.9772 13.0456 16.7954 11.8665 15.3375 11.8665C13.8796 11.8665 12.6978 13.0456 12.6978 14.5001C12.6978 15.9546 13.8796 17.1337 15.3375 17.1337Z" fill="#373EF6"/>
      <path d="M15.3375 17.1646C16.7954 17.1646 17.9772 15.9855 17.9772 14.531C17.9772 13.0764 16.7954 11.8973 15.3375 11.8973C13.8796 11.8973 12.6978 13.0764 12.6978 14.531C12.6978 15.9855 13.8796 17.1646 15.3375 17.1646Z" fill="#373EF6"/>
      <path d="M15.3375 17.1798C16.7954 17.1798 17.9772 16.0007 17.9772 14.5462C17.9772 13.0917 16.7954 11.9126 15.3375 11.9126C13.8796 11.9126 12.6978 13.0917 12.6978 14.5462C12.6978 16.0007 13.8796 17.1798 15.3375 17.1798Z" fill="#373EF6"/>
      <path d="M15.3375 17.209C16.7954 17.209 17.9772 16.0299 17.9772 14.5754C17.9772 13.1209 16.7954 11.9418 15.3375 11.9418C13.8796 11.9418 12.6978 13.1209 12.6978 14.5754C12.6978 16.0299 13.8796 17.209 15.3375 17.209Z" fill="#373EF6"/>
      <path d="M15.3375 17.2402C16.7954 17.2402 17.9772 16.0611 17.9772 14.6066C17.9772 13.1521 16.7954 11.973 15.3375 11.973C13.8796 11.973 12.6978 13.1521 12.6978 14.6066C12.6978 16.0611 13.8796 17.2402 15.3375 17.2402Z" fill="#363EF6"/>
      <path d="M15.3375 17.2697C16.7954 17.2697 17.9772 16.0906 17.9772 14.6361C17.9772 13.1816 16.7954 12.0024 15.3375 12.0024C13.8796 12.0024 12.6978 13.1816 12.6978 14.6361C12.6978 16.0906 13.8796 17.2697 15.3375 17.2697Z" fill="#363EF6"/>
      <path d="M15.3375 17.2858C16.7954 17.2858 17.9772 16.1067 17.9772 14.6522C17.9772 13.1977 16.7954 12.0186 15.3375 12.0186C13.8796 12.0186 12.6978 13.1977 12.6978 14.6522C12.6978 16.1067 13.8796 17.2858 15.3375 17.2858Z" fill="#363EF6"/>
      <path d="M15.3375 17.3156C16.7954 17.3156 17.9772 16.1365 17.9772 14.682C17.9772 13.2274 16.7954 12.0483 15.3375 12.0483C13.8796 12.0483 12.6978 13.2274 12.6978 14.682C12.6978 16.1365 13.8796 17.3156 15.3375 17.3156Z" fill="#353EF6"/>
      <path d="M15.3375 17.3464C16.7954 17.3464 17.9772 16.1673 17.9772 14.7128C17.9772 13.2583 16.7954 12.0792 15.3375 12.0792C13.8796 12.0792 12.6978 13.2583 12.6978 14.7128C12.6978 16.1673 13.8796 17.3464 15.3375 17.3464Z" fill="#353EF6"/>
      <path d="M15.3375 17.3611C16.7954 17.3611 17.9772 16.182 17.9772 14.7275C17.9772 13.273 16.7954 12.0939 15.3375 12.0939C13.8796 12.0939 12.6978 13.273 12.6978 14.7275C12.6978 16.182 13.8796 17.3611 15.3375 17.3611Z" fill="#353EF6"/>
      <path d="M15.3375 17.3909C16.7954 17.3909 17.9772 16.2118 17.9772 14.7573C17.9772 13.3028 16.7954 12.1237 15.3375 12.1237C13.8796 12.1237 12.6978 13.3028 12.6978 14.7573C12.6978 16.2118 13.8796 17.3909 15.3375 17.3909Z" fill="#343EF6"/>
      <path d="M15.3375 17.4218C16.7954 17.4218 17.9772 16.2427 17.9772 14.7882C17.9772 13.3336 16.7954 12.1545 15.3375 12.1545C13.8796 12.1545 12.6978 13.3336 12.6978 14.7882C12.6978 16.2427 13.8796 17.4218 15.3375 17.4218Z" fill="#343EF6"/>
      <path d="M15.3375 17.4509C16.7954 17.4509 17.9772 16.2718 17.9772 14.8173C17.9772 13.3628 16.7954 12.1837 15.3375 12.1837C13.8796 12.1837 12.6978 13.3628 12.6978 14.8173C12.6978 16.2718 13.8796 17.4509 15.3375 17.4509Z" fill="#343FF6"/>
      <path d="M15.3375 17.4677C16.7954 17.4677 17.9772 16.2886 17.9772 14.8341C17.9772 13.3795 16.7954 12.2004 15.3375 12.2004C13.8796 12.2004 12.6978 13.3795 12.6978 14.8341C12.6978 16.2886 13.8796 17.4677 15.3375 17.4677Z" fill="#343FF6"/>
      <path d="M15.3375 17.4973C16.7954 17.4973 17.9772 16.3182 17.9772 14.8637C17.9772 13.4092 16.7954 12.2301 15.3375 12.2301C13.8796 12.2301 12.6978 13.4092 12.6978 14.8637C12.6978 16.3182 13.8796 17.4973 15.3375 17.4973Z" fill="#333FF6"/>
      <path d="M15.3375 17.5271C16.7954 17.5271 17.9772 16.348 17.9772 14.8935C17.9772 13.439 16.7954 12.2599 15.3375 12.2599C13.8796 12.2599 12.6978 13.439 12.6978 14.8935C12.6978 16.348 13.8796 17.5271 15.3375 17.5271Z" fill="#333FF6"/>
      <path d="M15.3375 17.543C16.7954 17.543 17.9772 16.3639 17.9772 14.9094C17.9772 13.4549 16.7954 12.2758 15.3375 12.2758C13.8796 12.2758 12.6978 13.4549 12.6978 14.9094C12.6978 16.3639 13.8796 17.543 15.3375 17.543Z" fill="#333FF6"/>
      <path d="M15.3375 17.5726C16.7954 17.5726 17.9772 16.3935 17.9772 14.939C17.9772 13.4845 16.7954 12.3054 15.3375 12.3054C13.8796 12.3054 12.6978 13.4845 12.6978 14.939C12.6978 16.3935 13.8796 17.5726 15.3375 17.5726Z" fill="#323FF6"/>
      <path d="M15.3375 17.6039C16.7954 17.6039 17.9772 16.4248 17.9772 14.9703C17.9772 13.5158 16.7954 12.3367 15.3375 12.3367C13.8796 12.3367 12.6978 13.5158 12.6978 14.9703C12.6978 16.4248 13.8796 17.6039 15.3375 17.6039Z" fill="#323FF6"/>
      <path d="M15.3375 17.6328C16.7954 17.6328 17.9772 16.4537 17.9772 14.9992C17.9772 13.5447 16.7954 12.3656 15.3375 12.3656C13.8796 12.3656 12.6978 13.5447 12.6978 14.9992C12.6978 16.4537 13.8796 17.6328 15.3375 17.6328Z" fill="#323FF6"/>
      <path d="M15.3375 17.6483C16.7954 17.6483 17.9772 16.4692 17.9772 15.0147C17.9772 13.5602 16.7954 12.3811 15.3375 12.3811C13.8796 12.3811 12.6978 13.5602 12.6978 15.0147C12.6978 16.4692 13.8796 17.6483 15.3375 17.6483Z" fill="#313FF6"/>
      <path d="M15.3375 17.6787C16.7954 17.6787 17.9772 16.4996 17.9772 15.0451C17.9772 13.5906 16.7954 12.4115 15.3375 12.4115C13.8796 12.4115 12.6978 13.5906 12.6978 15.0451C12.6978 16.4996 13.8796 17.6787 15.3375 17.6787Z" fill="#313FF6"/>
      <path d="M15.3375 17.709C16.7954 17.709 17.9772 16.5299 17.9772 15.0754C17.9772 13.6209 16.7954 12.4418 15.3375 12.4418C13.8796 12.4418 12.6978 13.6209 12.6978 15.0754C12.6978 16.5299 13.8796 17.709 15.3375 17.709Z" fill="#313FF6"/>
      <path d="M15.3375 17.7247C16.7954 17.7247 17.9772 16.5456 17.9772 15.0911C17.9772 13.6366 16.7954 12.4575 15.3375 12.4575C13.8796 12.4575 12.6978 13.6366 12.6978 15.0911C12.6978 16.5456 13.8796 17.7247 15.3375 17.7247Z" fill="#313FF6"/>
      <path d="M15.3375 17.7545C16.7954 17.7545 17.9772 16.5754 17.9772 15.1209C17.9772 13.6664 16.7954 12.4873 15.3375 12.4873C13.8796 12.4873 12.6978 13.6664 12.6978 15.1209C12.6978 16.5754 13.8796 17.7545 15.3375 17.7545Z" fill="#303FF6"/>
      <path d="M15.3375 17.7858C16.7954 17.7858 17.9772 16.6067 17.9772 15.1522C17.9772 13.6977 16.7954 12.5186 15.3375 12.5186C13.8796 12.5186 12.6978 13.6977 12.6978 15.1522C12.6978 16.6067 13.8796 17.7858 15.3375 17.7858Z" fill="#303FF6"/>
      <path d="M15.3375 17.815C16.7954 17.815 17.9772 16.6358 17.9772 15.1813C17.9772 13.7268 16.7954 12.5477 15.3375 12.5477C13.8796 12.5477 12.6978 13.7268 12.6978 15.1813C12.6978 16.6358 13.8796 17.815 15.3375 17.815Z" fill="#303FF6"/>
      <path d="M15.3375 17.8294C16.7954 17.8294 17.9772 16.6503 17.9772 15.1957C17.9772 13.7412 16.7954 12.5621 15.3375 12.5621C13.8796 12.5621 12.6978 13.7412 12.6978 15.1957C12.6978 16.6503 13.8796 17.8294 15.3375 17.8294Z" fill="#2F3FF6"/>
      <path d="M15.3375 17.8605C16.7954 17.8605 17.9772 16.6814 17.9772 15.2269C17.9772 13.7724 16.7954 12.5933 15.3375 12.5933C13.8796 12.5933 12.6978 13.7724 12.6978 15.2269C12.6978 16.6814 13.8796 17.8605 15.3375 17.8605Z" fill="#2F40F6"/>
      <path d="M15.3375 17.8903C16.7954 17.8903 17.9772 16.7112 17.9772 15.2567C17.9772 13.8022 16.7954 12.623 15.3375 12.623C13.8796 12.623 12.6978 13.8022 12.6978 15.2567C12.6978 16.7112 13.8796 17.8903 15.3375 17.8903Z" fill="#2F40F6"/>
      <path d="M15.3375 17.9055C16.7954 17.9055 17.9772 16.7264 17.9772 15.2719C17.9772 13.8174 16.7954 12.6383 15.3375 12.6383C13.8796 12.6383 12.6978 13.8174 12.6978 15.2719C12.6978 16.7264 13.8796 17.9055 15.3375 17.9055Z" fill="#2E40F6"/>
      <path d="M15.3375 17.9368C16.7954 17.9368 17.9772 16.7577 17.9772 15.3032C17.9772 13.8487 16.7954 12.6696 15.3375 12.6696C13.8796 12.6696 12.6978 13.8487 12.6978 15.3032C12.6978 16.7577 13.8796 17.9368 15.3375 17.9368Z" fill="#2E40F6"/>
      <path d="M15.3375 17.9656C16.7954 17.9656 17.9772 16.7865 17.9772 15.332C17.9772 13.8775 16.7954 12.6984 15.3375 12.6984C13.8796 12.6984 12.6978 13.8775 12.6978 15.332C12.6978 16.7865 13.8796 17.9656 15.3375 17.9656Z" fill="#2E40F6"/>
      <path d="M15.3375 17.9968C16.7954 17.9968 17.9772 16.8177 17.9772 15.3632C17.9772 13.9087 16.7954 12.7296 15.3375 12.7296C13.8796 12.7296 12.6978 13.9087 12.6978 15.3632C12.6978 16.8177 13.8796 17.9968 15.3375 17.9968Z" fill="#2E40F6"/>
      <path d="M15.3375 18.0115C16.7954 18.0115 17.9772 16.8324 17.9772 15.3779C17.9772 13.9234 16.7954 12.7443 15.3375 12.7443C13.8796 12.7443 12.6978 13.9234 12.6978 15.3779C12.6978 16.8324 13.8796 18.0115 15.3375 18.0115Z" fill="#2D40F6"/>
      <path d="M15.3375 18.0424C16.7954 18.0424 17.9772 16.8633 17.9772 15.4088C17.9772 13.9543 16.7954 12.7751 15.3375 12.7751C13.8796 12.7751 12.6978 13.9543 12.6978 15.4088C12.6978 16.8633 13.8796 18.0424 15.3375 18.0424Z" fill="#2D40F6"/>
      <path d="M15.3067 18.0115C16.7646 18.0115 17.9465 16.8324 17.9465 15.3779C17.9465 13.9234 16.7646 12.7443 15.3067 12.7443C13.8488 12.7443 12.667 13.9234 12.667 15.3779C12.667 16.8324 13.8488 18.0115 15.3067 18.0115Z" fill="#2D40F6"/>
      <path d="M15.2765 17.9656C16.7343 17.9656 17.9162 16.7865 17.9162 15.332C17.9162 13.8775 16.7343 12.6984 15.2765 12.6984C13.8186 12.6984 12.6367 13.8775 12.6367 15.332C12.6367 16.7865 13.8186 17.9656 15.2765 17.9656Z" fill="#2D41F6"/>
      <path d="M15.231 17.9368C16.6889 17.9368 17.8708 16.7577 17.8708 15.3032C17.8708 13.8487 16.6889 12.6696 15.231 12.6696C13.7732 12.6696 12.5913 13.8487 12.5913 15.3032C12.5913 16.7577 13.7732 17.9368 15.231 17.9368Z" fill="#2D41F6"/>
      <path d="M15.2008 17.8903C16.6587 17.8903 17.8405 16.7112 17.8405 15.2567C17.8405 13.8022 16.6587 12.623 15.2008 12.623C13.7429 12.623 12.561 13.8022 12.561 15.2567C12.561 16.7112 13.7429 17.8903 15.2008 17.8903Z" fill="#2D42F6"/>
      <path d="M15.1549 17.8605C16.6128 17.8605 17.7946 16.6814 17.7946 15.2269C17.7946 13.7724 16.6128 12.5933 15.1549 12.5933C13.697 12.5933 12.5151 13.7724 12.5151 15.2269C12.5151 16.6814 13.697 17.8605 15.1549 17.8605Z" fill="#2D42F6"/>
      <path d="M15.1246 17.8294C16.5825 17.8294 17.7643 16.6503 17.7643 15.1957C17.7643 13.7412 16.5825 12.5621 15.1246 12.5621C13.6667 12.5621 12.4849 13.7412 12.4849 15.1957C12.4849 16.6503 13.6667 17.8294 15.1246 17.8294Z" fill="#2D43F6"/>
      <path d="M15.0792 17.7858C16.5371 17.7858 17.7189 16.6067 17.7189 15.1522C17.7189 13.6977 16.5371 12.5186 15.0792 12.5186C13.6213 12.5186 12.4395 13.6977 12.4395 15.1522C12.4395 16.6067 13.6213 17.7858 15.0792 17.7858Z" fill="#2D43F6"/>
      <path d="M15.0489 17.7545C16.5068 17.7545 17.6887 16.5754 17.6887 15.1209C17.6887 13.6664 16.5068 12.4873 15.0489 12.4873C13.591 12.4873 12.4092 13.6664 12.4092 15.1209C12.4092 16.5754 13.591 17.7545 15.0489 17.7545Z" fill="#2D44F5"/>
      <path d="M15.0186 17.709C16.4765 17.709 17.6584 16.5299 17.6584 15.0754C17.6584 13.6209 16.4765 12.4418 15.0186 12.4418C13.5608 12.4418 12.3789 13.6209 12.3789 15.0754C12.3789 16.5299 13.5608 17.709 15.0186 17.709Z" fill="#2D44F5"/>
      <path d="M14.9727 17.6787C16.4306 17.6787 17.6125 16.4996 17.6125 15.0451C17.6125 13.5906 16.4306 12.4115 14.9727 12.4115C13.5149 12.4115 12.333 13.5906 12.333 15.0451C12.333 16.4996 13.5149 17.6787 14.9727 17.6787Z" fill="#2C45F5"/>
      <path d="M14.9439 17.6328C16.4018 17.6328 17.5837 16.4537 17.5837 14.9992C17.5837 13.5447 16.4018 12.3656 14.9439 12.3656C13.4861 12.3656 12.3042 13.5447 12.3042 14.9992C12.3042 16.4537 13.4861 17.6328 14.9439 17.6328Z" fill="#2C45F5"/>
      <path d="M14.8971 17.6039C16.3549 17.6039 17.5368 16.4248 17.5368 14.9703C17.5368 13.5158 16.3549 12.3367 14.8971 12.3367C13.4392 12.3367 12.2573 13.5158 12.2573 14.9703C12.2573 16.4248 13.4392 17.6039 14.8971 17.6039Z" fill="#2C46F5"/>
      <path d="M14.8668 17.5726C16.3247 17.5726 17.5065 16.3935 17.5065 14.939C17.5065 13.4845 16.3247 12.3054 14.8668 12.3054C13.4089 12.3054 12.2271 13.4845 12.2271 14.939C12.2271 16.3935 13.4089 17.5726 14.8668 17.5726Z" fill="#2C46F5"/>
      <path d="M14.8214 17.5271C16.2793 17.5271 17.4611 16.348 17.4611 14.8935C17.4611 13.439 16.2793 12.2599 14.8214 12.2599C13.3635 12.2599 12.1816 13.439 12.1816 14.8935C12.1816 16.348 13.3635 17.5271 14.8214 17.5271Z" fill="#2C47F5"/>
      <path d="M14.7906 17.4973C16.2485 17.4973 17.4304 16.3182 17.4304 14.8637C17.4304 13.4092 16.2485 12.2301 14.7906 12.2301C13.3327 12.2301 12.1509 13.4092 12.1509 14.8637C12.1509 16.3182 13.3327 17.4973 14.7906 17.4973Z" fill="#2C47F5"/>
      <path d="M14.7603 17.4509C16.2182 17.4509 17.4001 16.2718 17.4001 14.8173C17.4001 13.3628 16.2182 12.1837 14.7603 12.1837C13.3025 12.1837 12.1206 13.3628 12.1206 14.8173C12.1206 16.2718 13.3025 17.4509 14.7603 17.4509Z" fill="#2C48F5"/>
      <path d="M14.7149 17.4218C16.1728 17.4218 17.3547 16.2427 17.3547 14.7882C17.3547 13.3336 16.1728 12.1545 14.7149 12.1545C13.257 12.1545 12.0752 13.3336 12.0752 14.7882C12.0752 16.2427 13.257 17.4218 14.7149 17.4218Z" fill="#2C48F5"/>
      <path d="M14.6847 17.3762C16.1425 17.3762 17.3244 16.1971 17.3244 14.7426C17.3244 13.2881 16.1425 12.109 14.6847 12.109C13.2268 12.109 12.0449 13.2881 12.0449 14.7426C12.0449 16.1971 13.2268 17.3762 14.6847 17.3762Z" fill="#2C49F5"/>
      <path d="M14.6388 17.3464C16.0966 17.3464 17.2785 16.1673 17.2785 14.7128C17.2785 13.2583 16.0966 12.0792 14.6388 12.0792C13.1809 12.0792 11.999 13.2583 11.999 14.7128C11.999 16.1673 13.1809 17.3464 14.6388 17.3464Z" fill="#2C49F5"/>
      <path d="M14.6085 17.3156C16.0664 17.3156 17.2482 16.1365 17.2482 14.682C17.2482 13.2274 16.0664 12.0483 14.6085 12.0483C13.1506 12.0483 11.9688 13.2274 11.9688 14.682C11.9688 16.1365 13.1506 17.3156 14.6085 17.3156Z" fill="#2C4AF5"/>
      <path d="M14.5641 17.2697C16.0219 17.2697 17.2038 16.0906 17.2038 14.6361C17.2038 13.1816 16.0219 12.0024 14.5641 12.0024C13.1062 12.0024 11.9243 13.1816 11.9243 14.6361C11.9243 16.0906 13.1062 17.2697 14.5641 17.2697Z" fill="#2C4AF5"/>
      <path d="M14.5338 17.2402C15.9917 17.2402 17.1735 16.0611 17.1735 14.6066C17.1735 13.1521 15.9917 11.973 14.5338 11.973C13.0759 11.973 11.894 13.1521 11.894 14.6066C11.894 16.0611 13.0759 17.2402 14.5338 17.2402Z" fill="#2C4BF5"/>
      <path d="M14.5035 17.1943C15.9614 17.1943 17.1432 16.0152 17.1432 14.5607C17.1432 13.1062 15.9614 11.9271 14.5035 11.9271C13.0456 11.9271 11.8638 13.1062 11.8638 14.5607C11.8638 16.0152 13.0456 17.1943 14.5035 17.1943Z" fill="#2C4BF5"/>
      <path d="M14.4581 17.1646C15.916 17.1646 17.0978 15.9855 17.0978 14.531C17.0978 13.0764 15.916 11.8973 14.4581 11.8973C13.0002 11.8973 11.8184 13.0764 11.8184 14.531C11.8184 15.9855 13.0002 17.1646 14.4581 17.1646Z" fill="#2C4CF4"/>
      <path d="M14.4278 17.1337C15.8857 17.1337 17.0676 15.9546 17.0676 14.5001C17.0676 13.0456 15.8857 11.8665 14.4278 11.8665C12.9699 11.8665 11.7881 13.0456 11.7881 14.5001C11.7881 15.9546 12.9699 17.1337 14.4278 17.1337Z" fill="#2C4CF4"/>
      <path d="M14.3819 17.0892C15.8398 17.0892 17.0217 15.9101 17.0217 14.4556C17.0217 13.0011 15.8398 11.822 14.3819 11.822C12.924 11.822 11.7422 13.0011 11.7422 14.4556C11.7422 15.9101 12.924 17.0892 14.3819 17.0892Z" fill="#2C4DF4"/>
      <path d="M14.3517 17.058C15.8095 17.058 16.9914 15.8789 16.9914 14.4244C16.9914 12.9699 15.8095 11.7908 14.3517 11.7908C12.8938 11.7908 11.7119 12.9699 11.7119 14.4244C11.7119 15.8789 12.8938 17.058 14.3517 17.058Z" fill="#2C4DF4"/>
      <path d="M14.3214 17.0125C15.7793 17.0125 16.9611 15.8334 16.9611 14.3789C16.9611 12.9243 15.7793 11.7452 14.3214 11.7452C12.8635 11.7452 11.6816 12.9243 11.6816 14.3789C11.6816 15.8334 12.8635 17.0125 14.3214 17.0125Z" fill="#2C4DF4"/>
      <path d="M14.2745 16.9827C15.7324 16.9827 16.9142 15.8036 16.9142 14.3491C16.9142 12.8946 15.7324 11.7155 14.2745 11.7155C12.8166 11.7155 11.6348 12.8946 11.6348 14.3491C11.6348 15.8036 12.8166 16.9827 14.2745 16.9827Z" fill="#2B4EF4"/>
      <path d="M14.2457 16.9369C15.7036 16.9369 16.8854 15.7578 16.8854 14.3033C16.8854 12.8488 15.7036 11.6697 14.2457 11.6697C12.7878 11.6697 11.606 12.8488 11.606 14.3033C11.606 15.7578 12.7878 16.9369 14.2457 16.9369Z" fill="#2B4EF4"/>
      <path d="M14.1998 16.9074C15.6577 16.9074 16.8395 15.7283 16.8395 14.2737C16.8395 12.8192 15.6577 11.6401 14.1998 11.6401C12.7419 11.6401 11.5601 12.8192 11.5601 14.2737C11.5601 15.7283 12.7419 16.9074 14.1998 16.9074Z" fill="#2B4FF4"/>
      <path d="M14.1695 16.8767C15.6274 16.8767 16.8093 15.6976 16.8093 14.2431C16.8093 12.7886 15.6274 11.6095 14.1695 11.6095C12.7116 11.6095 11.5298 12.7886 11.5298 14.2431C11.5298 15.6976 12.7116 16.8767 14.1695 16.8767Z" fill="#2B4FF4"/>
      <path d="M14.1241 16.8303C15.582 16.8303 16.7639 15.6512 16.7639 14.1967C16.7639 12.7422 15.582 11.5631 14.1241 11.5631C12.6662 11.5631 11.4844 12.7422 11.4844 14.1967C11.4844 15.6512 12.6662 16.8303 14.1241 16.8303Z" fill="#2B50F4"/>
      <path d="M14.0938 16.8008C15.5517 16.8008 16.7336 15.6217 16.7336 14.1672C16.7336 12.7127 15.5517 11.5336 14.0938 11.5336C12.636 11.5336 11.4541 12.7127 11.4541 14.1672C11.4541 15.6217 12.636 16.8008 14.0938 16.8008Z" fill="#2B50F4"/>
      <path d="M14.0631 16.755C15.521 16.755 16.7028 15.5759 16.7028 14.1214C16.7028 12.6669 15.521 11.4878 14.0631 11.4878C12.6052 11.4878 11.4233 12.6669 11.4233 14.1214C11.4233 15.5759 12.6052 16.755 14.0631 16.755Z" fill="#2B51F4"/>
      <path d="M14.0177 16.7252C15.4756 16.7252 16.6574 15.5461 16.6574 14.0916C16.6574 12.6371 15.4756 11.458 14.0177 11.458C12.5598 11.458 11.3779 12.6371 11.3779 14.0916C11.3779 15.5461 12.5598 16.7252 14.0177 16.7252Z" fill="#2B51F4"/>
      <path d="M13.9874 16.6797C15.4453 16.6797 16.6271 15.5006 16.6271 14.0461C16.6271 12.5916 15.4453 11.4125 13.9874 11.4125C12.5295 11.4125 11.3477 12.5916 11.3477 14.0461C11.3477 15.5006 12.5295 16.6797 13.9874 16.6797Z" fill="#2B52F4"/>
      <path d="M13.942 16.6505C15.3999 16.6505 16.5817 15.4714 16.5817 14.0169C16.5817 12.5624 15.3999 11.3833 13.942 11.3833C12.4841 11.3833 11.3022 12.5624 11.3022 14.0169C11.3022 15.4714 12.4841 16.6505 13.942 16.6505Z" fill="#2B52F4"/>
      <path d="M13.9117 16.6195C15.3696 16.6195 16.5514 15.4404 16.5514 13.9859C16.5514 12.5314 15.3696 11.3523 13.9117 11.3523C12.4538 11.3523 11.272 12.5314 11.272 13.9859C11.272 15.4404 12.4538 16.6195 13.9117 16.6195Z" fill="#2B53F4"/>
      <path d="M13.8658 16.5731C15.3237 16.5731 16.5055 15.394 16.5055 13.9395C16.5055 12.485 15.3237 11.3059 13.8658 11.3059C12.4079 11.3059 11.2261 12.485 11.2261 13.9395C11.2261 15.394 12.4079 16.5731 13.8658 16.5731Z" fill="#2B53F3"/>
      <path d="M13.8355 16.5442C15.2934 16.5442 16.4753 15.3651 16.4753 13.9106C16.4753 12.4561 15.2934 11.277 13.8355 11.277C12.3777 11.277 11.1958 12.4561 11.1958 13.9106C11.1958 15.3651 12.3777 16.5442 13.8355 16.5442Z" fill="#2B54F3"/>
      <path d="M13.8053 16.4984C15.2632 16.4984 16.445 15.3193 16.445 13.8648C16.445 12.4103 15.2632 11.2312 13.8053 11.2312C12.3474 11.2312 11.1655 12.4103 11.1655 13.8648C11.1655 15.3193 12.3474 16.4984 13.8053 16.4984Z" fill="#2B54F3"/>
      <path d="M13.7599 16.4686C15.2177 16.4686 16.3996 15.2895 16.3996 13.835C16.3996 12.3805 15.2177 11.2014 13.7599 11.2014C12.302 11.2014 11.1201 12.3805 11.1201 13.835C11.1201 15.2895 12.302 16.4686 13.7599 16.4686Z" fill="#2B55F3"/>
      <path d="M13.7296 16.4378C15.1875 16.4378 16.3693 15.2586 16.3693 13.8041C16.3693 12.3496 15.1875 11.1705 13.7296 11.1705C12.2717 11.1705 11.0898 12.3496 11.0898 13.8041C11.0898 15.2586 12.2717 16.4378 13.7296 16.4378Z" fill="#2B55F3"/>
      <path d="M13.6837 16.3912C15.1416 16.3912 16.3234 15.2121 16.3234 13.7576C16.3234 12.3031 15.1416 11.124 13.6837 11.124C12.2258 11.124 11.0439 12.3031 11.0439 13.7576C11.0439 15.2121 12.2258 16.3912 13.6837 16.3912Z" fill="#2B56F3"/>
      <path d="M13.6534 16.3621C15.1113 16.3621 16.2931 15.183 16.2931 13.7285C16.2931 12.274 15.1113 11.0948 13.6534 11.0948C12.1955 11.0948 11.0137 12.274 11.0137 13.7285C11.0137 15.183 12.1955 16.3621 13.6534 16.3621Z" fill="#2B56F3"/>
      <path d="M13.608 16.3165C15.0659 16.3165 16.2477 15.1374 16.2477 13.6829C16.2477 12.2284 15.0659 11.0493 13.608 11.0493C12.1501 11.0493 10.9683 12.2284 10.9683 13.6829C10.9683 15.1374 12.1501 16.3165 13.608 16.3165Z" fill="#2B57F3"/>
      <path d="M13.5777 16.2868C15.0356 16.2868 16.2175 15.1076 16.2175 13.6531C16.2175 12.1986 15.0356 11.0195 13.5777 11.0195C12.1198 11.0195 10.938 12.1986 10.938 13.6531C10.938 15.1076 12.1198 16.2868 13.5777 16.2868Z" fill="#2A57F3"/>
      <path d="M13.547 16.2412C15.0049 16.2412 16.1867 15.0621 16.1867 13.6076C16.1867 12.1531 15.0049 10.974 13.547 10.974C12.0891 10.974 10.9072 12.1531 10.9072 13.6076C10.9072 15.0621 12.0891 16.2412 13.547 16.2412Z" fill="#2A58F3"/>
      <path d="M13.5016 16.2114C14.9594 16.2114 16.1413 15.0323 16.1413 13.5778C16.1413 12.1233 14.9594 10.9442 13.5016 10.9442C12.0437 10.9442 10.8618 12.1233 10.8618 13.5778C10.8618 15.0323 12.0437 16.2114 13.5016 16.2114Z" fill="#2A58F3"/>
      <path d="M13.4713 16.1802C14.9292 16.1802 16.111 15.0011 16.111 13.5466C16.111 12.0921 14.9292 10.913 13.4713 10.913C12.0134 10.913 10.8315 12.0921 10.8315 13.5466C10.8315 15.0011 12.0134 16.1802 13.4713 16.1802Z" fill="#2A59F3"/>
      <path d="M13.4259 16.1347C14.8838 16.1347 16.0656 14.9555 16.0656 13.501C16.0656 12.0465 14.8838 10.8674 13.4259 10.8674C11.968 10.8674 10.7861 12.0465 10.7861 13.501C10.7861 14.9555 11.968 16.1347 13.4259 16.1347Z" fill="#2A59F3"/>
      <path d="M13.3956 16.1049C14.8535 16.1049 16.0353 14.9258 16.0353 13.4713C16.0353 12.0168 14.8535 10.8376 13.3956 10.8376C11.9377 10.8376 10.7559 12.0168 10.7559 13.4713C10.7559 14.9258 11.9377 16.1049 13.3956 16.1049Z" fill="#2A5AF3"/>
      <path d="M13.3497 16.0591C14.8076 16.0591 15.9894 14.88 15.9894 13.4255C15.9894 11.971 14.8076 10.7919 13.3497 10.7919C11.8918 10.7919 10.71 11.971 10.71 13.4255C10.71 14.88 11.8918 16.0591 13.3497 16.0591Z" fill="#2A5AF3"/>
      <path d="M13.3194 16.0293C14.7773 16.0293 15.9592 14.8502 15.9592 13.3957C15.9592 11.9412 14.7773 10.7621 13.3194 10.7621C11.8615 10.7621 10.6797 11.9412 10.6797 13.3957C10.6797 14.8502 11.8615 16.0293 13.3194 16.0293Z" fill="#2A5AF2"/>
      <path d="M13.2892 15.9838C14.747 15.9838 15.9289 14.8047 15.9289 13.3502C15.9289 11.8957 14.747 10.7166 13.2892 10.7166C11.8313 10.7166 10.6494 11.8957 10.6494 13.3502C10.6494 14.8047 11.8313 15.9838 13.2892 15.9838Z" fill="#2A5BF2"/>
      <path d="M13.2437 15.954C14.7016 15.954 15.8835 14.7749 15.8835 13.3204C15.8835 11.8659 14.7016 10.6868 13.2437 10.6868C11.7859 10.6868 10.604 11.8659 10.604 13.3204C10.604 14.7749 11.7859 15.954 13.2437 15.954Z" fill="#2A5BF2"/>
      <path d="M13.2135 15.9236C14.6714 15.9236 15.8532 14.7445 15.8532 13.29C15.8532 11.8355 14.6714 10.6564 13.2135 10.6564C11.7556 10.6564 10.5737 11.8355 10.5737 13.29C10.5737 14.7445 11.7556 15.9236 13.2135 15.9236Z" fill="#2A5CF2"/>
      <path d="M13.1676 15.8772C14.6255 15.8772 15.8073 14.6981 15.8073 13.2436C15.8073 11.7891 14.6255 10.61 13.1676 10.61C11.7097 10.61 10.5278 11.7891 10.5278 13.2436C10.5278 14.6981 11.7097 15.8772 13.1676 15.8772Z" fill="#2A5CF2"/>
      <path d="M13.1373 15.8474C14.5952 15.8474 15.777 14.6683 15.777 13.2138C15.777 11.7593 14.5952 10.5802 13.1373 10.5802C11.6794 10.5802 10.4976 11.7593 10.4976 13.2138C10.4976 14.6683 11.6794 15.8474 13.1373 15.8474Z" fill="#2A5DF2"/>
      <path d="M13.107 15.8019C14.5649 15.8019 15.7468 14.6228 15.7468 13.1683C15.7468 11.7138 14.5649 10.5347 13.107 10.5347C11.6491 10.5347 10.4673 11.7138 10.4673 13.1683C10.4673 14.6228 11.6491 15.8019 13.107 15.8019Z" fill="#2A5DF2"/>
      <path d="M13.0616 15.7727C14.5195 15.7727 15.7014 14.5936 15.7014 13.1391C15.7014 11.6846 14.5195 10.5055 13.0616 10.5055C11.6037 10.5055 10.4219 11.6846 10.4219 13.1391C10.4219 14.5936 11.6037 15.7727 13.0616 15.7727Z" fill="#2A5EF2"/>
      <path d="M13.0309 15.7263C14.4887 15.7263 15.6706 14.5472 15.6706 13.0927C15.6706 11.6382 14.4887 10.4591 13.0309 10.4591C11.573 10.4591 10.3911 11.6382 10.3911 13.0927C10.3911 14.5472 11.573 15.7263 13.0309 15.7263Z" fill="#2A5EF2"/>
      <path d="M12.9854 15.6953C14.4433 15.6953 15.6252 14.5162 15.6252 13.0617C15.6252 11.6072 14.4433 10.4281 12.9854 10.4281C11.5276 10.4281 10.3457 11.6072 10.3457 13.0617C10.3457 14.5162 11.5276 15.6953 12.9854 15.6953Z" fill="#2A5FF2"/>
      <path d="M12.9552 15.6655C14.4131 15.6655 15.5949 14.4864 15.5949 13.0319C15.5949 11.5774 14.4131 10.3983 12.9552 10.3983C11.4973 10.3983 10.3154 11.5774 10.3154 13.0319C10.3154 14.4864 11.4973 15.6655 12.9552 15.6655Z" fill="#2A5FF2"/>
      <path d="M12.9098 15.62C14.3676 15.62 15.5495 14.4409 15.5495 12.9864C15.5495 11.5319 14.3676 10.3528 12.9098 10.3528C11.4519 10.3528 10.27 11.5319 10.27 12.9864C10.27 14.4409 11.4519 15.62 12.9098 15.62Z" fill="#2A60F2"/>
      <path d="M12.8795 15.5908C14.3374 15.5908 15.5192 14.4117 15.5192 12.9572C15.5192 11.5027 14.3374 10.3236 12.8795 10.3236C11.4216 10.3236 10.2397 11.5027 10.2397 12.9572C10.2397 14.4117 11.4216 15.5908 12.8795 15.5908Z" fill="#2A60F2"/>
      <path d="M12.8487 15.5447C14.3066 15.5447 15.4885 14.3656 15.4885 12.9111C15.4885 11.4566 14.3066 10.2775 12.8487 10.2775C11.3908 10.2775 10.209 11.4566 10.209 12.9111C10.209 14.3656 11.3908 15.5447 12.8487 15.5447Z" fill="#2961F2"/>
      <path d="M12.8033 15.5147C14.2612 15.5147 15.4431 14.3356 15.4431 12.881C15.4431 11.4265 14.2612 10.2474 12.8033 10.2474C11.3454 10.2474 10.1636 11.4265 10.1636 12.881C10.1636 14.3356 11.3454 15.5147 12.8033 15.5147Z" fill="#2961F2"/>
      <path d="M12.773 15.4837C14.2309 15.4837 15.4128 14.3045 15.4128 12.85C15.4128 11.3955 14.2309 10.2164 12.773 10.2164C11.3152 10.2164 10.1333 11.3955 10.1333 12.85C10.1333 14.3045 11.3152 15.4837 12.773 15.4837Z" fill="#2962F2"/>
      <path d="M12.7276 15.4381C14.1855 15.4381 15.3674 14.259 15.3674 12.8045C15.3674 11.35 14.1855 10.1709 12.7276 10.1709C11.2697 10.1709 10.0879 11.35 10.0879 12.8045C10.0879 14.259 11.2697 15.4381 12.7276 15.4381Z" fill="#2962F1"/>
      <path d="M12.6969 15.4089C14.1548 15.4089 15.3366 14.2298 15.3366 12.7753C15.3366 11.3208 14.1548 10.1417 12.6969 10.1417C11.239 10.1417 10.0571 11.3208 10.0571 12.7753C10.0571 14.2298 11.239 15.4089 12.6969 15.4089Z" fill="#2963F1"/>
      <path d="M12.6529 15.3632C14.1108 15.3632 15.2927 14.1841 15.2927 12.7296C15.2927 11.2751 14.1108 10.0959 12.6529 10.0959C11.195 10.0959 10.0132 11.2751 10.0132 12.7296C10.0132 14.1841 11.195 15.3632 12.6529 15.3632Z" fill="#2963F1"/>
      <path d="M12.6222 15.3336C14.08 15.3336 15.2619 14.1545 15.2619 12.7C15.2619 11.2455 14.08 10.0664 12.6222 10.0664C11.1643 10.0664 9.98242 11.2455 9.98242 12.7C9.98242 14.1545 11.1643 15.3336 12.6222 15.3336Z" fill="#2964F1"/>
      <path d="M12.5919 15.2872C14.0498 15.2872 15.2316 14.1081 15.2316 12.6536C15.2316 11.1991 14.0498 10.02 12.5919 10.02C11.134 10.02 9.95215 11.1991 9.95215 12.6536C9.95215 14.1081 11.134 15.2872 12.5919 15.2872Z" fill="#2964F1"/>
      <path d="M12.5465 15.256C14.0044 15.256 15.1862 14.0769 15.1862 12.6224C15.1862 11.1679 14.0044 9.98877 12.5465 9.98877C11.0886 9.98877 9.90674 11.1679 9.90674 12.6224C9.90674 14.0769 11.0886 15.256 12.5465 15.256Z" fill="#2965F1"/>
      <path d="M12.5162 15.2271C13.9741 15.2271 15.1559 14.048 15.1559 12.5935C15.1559 11.1389 13.9741 9.95984 12.5162 9.95984C11.0583 9.95984 9.87646 11.1389 9.87646 12.5935C9.87646 14.048 11.0583 15.2271 12.5162 15.2271Z" fill="#2965F1"/>
      <path d="M12.4708 15.1813C13.9287 15.1813 15.1105 14.0022 15.1105 12.5477C15.1105 11.0932 13.9287 9.91406 12.4708 9.91406C11.0129 9.91406 9.83105 11.0932 9.83105 12.5477C9.83105 14.0022 11.0129 15.1813 12.4708 15.1813Z" fill="#2966F1"/>
      <path d="M12.44 15.1515C13.8979 15.1515 15.0798 13.9724 15.0798 12.5179C15.0798 11.0634 13.8979 9.88428 12.44 9.88428C10.9821 9.88428 9.80029 11.0634 9.80029 12.5179C9.80029 13.9724 10.9821 15.1515 12.44 15.1515Z" fill="#2966F1"/>
      <path d="M12.3946 15.1054C13.8525 15.1054 15.0344 13.9263 15.0344 12.4717C15.0344 11.0172 13.8525 9.83813 12.3946 9.83813C10.9367 9.83813 9.75488 11.0172 9.75488 12.4717C9.75488 13.9263 10.9367 15.1054 12.3946 15.1054Z" fill="#2966F1"/>
      <path d="M12.3643 15.0762C13.8222 15.0762 15.0041 13.8971 15.0041 12.4426C15.0041 10.9881 13.8222 9.80896 12.3643 9.80896C10.9065 9.80896 9.72461 10.9881 9.72461 12.4426C9.72461 13.8971 10.9065 15.0762 12.3643 15.0762Z" fill="#2967F1"/>
      <path d="M12.3341 15.0307C13.792 15.0307 14.9738 13.8515 14.9738 12.397C14.9738 10.9425 13.792 9.76343 12.3341 9.76343C10.8762 9.76343 9.69434 10.9425 9.69434 12.397C9.69434 13.8515 10.8762 15.0307 12.3341 15.0307Z" fill="#2967F1"/>
      <path d="M12.2882 14.9994C13.7461 14.9994 14.9279 13.8203 14.9279 12.3658C14.9279 10.9113 13.7461 9.73218 12.2882 9.73218C10.8303 9.73218 9.64844 10.9113 9.64844 12.3658C9.64844 13.8203 10.8303 14.9994 12.2882 14.9994Z" fill="#2968F1"/>
      <path d="M12.2579 14.9696C13.7158 14.9696 14.8976 13.7905 14.8976 12.336C14.8976 10.8815 13.7158 9.70239 12.2579 9.70239C10.8 9.70239 9.61816 10.8815 9.61816 12.336C9.61816 13.7905 10.8 14.9696 12.2579 14.9696Z" fill="#2968F1"/>
      <path d="M12.2125 14.9241C13.6704 14.9241 14.8522 13.745 14.8522 12.2905C14.8522 10.836 13.6704 9.65686 12.2125 9.65686C10.7546 9.65686 9.57275 10.836 9.57275 12.2905C9.57275 13.745 10.7546 14.9241 12.2125 14.9241Z" fill="#2969F1"/>
      <path d="M12.1822 14.8943C13.6401 14.8943 14.822 13.7152 14.822 12.2607C14.822 10.8062 13.6401 9.62708 12.1822 9.62708C10.7243 9.62708 9.54248 10.8062 9.54248 12.2607C9.54248 13.7152 10.7243 14.8943 12.1822 14.8943Z" fill="#2969F1"/>
      <path d="M12.1368 14.8488C13.5947 14.8488 14.7765 13.6697 14.7765 12.2152C14.7765 10.7607 13.5947 9.58154 12.1368 9.58154C10.6789 9.58154 9.49707 10.7607 9.49707 12.2152C9.49707 13.6697 10.6789 14.8488 12.1368 14.8488Z" fill="#286AF0"/>
      <path d="M12.106 14.8187C13.5639 14.8187 14.7458 13.6396 14.7458 12.1851C14.7458 10.7306 13.5639 9.55151 12.106 9.55151C10.6482 9.55151 9.46631 10.7306 9.46631 12.1851C9.46631 13.6396 10.6482 14.8187 12.106 14.8187Z" fill="#286AF0"/>
      <path d="M12.0758 14.7877C13.5337 14.7877 14.7155 13.6086 14.7155 12.1541C14.7155 10.6996 13.5337 9.52051 12.0758 9.52051C10.6179 9.52051 9.43604 10.6996 9.43604 12.1541C9.43604 13.6086 10.6179 14.7877 12.0758 14.7877Z" fill="#286BF0"/>
      <path d="M12.0304 14.7422C13.4883 14.7422 14.6701 13.5631 14.6701 12.1086C14.6701 10.6541 13.4883 9.47498 12.0304 9.47498C10.5725 9.47498 9.39062 10.6541 9.39062 12.1086C9.39062 13.5631 10.5725 14.7422 12.0304 14.7422Z" fill="#286BF0"/>
      <path d="M12.0001 14.7124C13.458 14.7124 14.6398 13.5333 14.6398 12.0788C14.6398 10.6243 13.458 9.44519 12.0001 9.44519C10.5422 9.44519 9.36035 10.6243 9.36035 12.0788C9.36035 13.5333 10.5422 14.7124 12.0001 14.7124Z" fill="#286CF0"/>
      <path d="M11.9547 14.6666C13.4126 14.6666 14.5944 13.4875 14.5944 12.033C14.5944 10.5785 13.4126 9.39941 11.9547 9.39941C10.4968 9.39941 9.31494 10.5785 9.31494 12.033C9.31494 13.4875 10.4968 14.6666 11.9547 14.6666Z" fill="#286CF0"/>
      <path d="M11.9239 14.6371C13.3818 14.6371 14.5637 13.458 14.5637 12.0035C14.5637 10.549 13.3818 9.36987 11.9239 9.36987C10.466 9.36987 9.28418 10.549 9.28418 12.0035C9.28418 13.458 10.466 14.6371 11.9239 14.6371Z" fill="#286DF0"/>
      <path d="M11.8936 14.5913C13.3515 14.5913 14.5334 13.4122 14.5334 11.9577C14.5334 10.5032 13.3515 9.3241 11.8936 9.3241C10.4358 9.3241 9.25391 10.5032 9.25391 11.9577C9.25391 13.4122 10.4358 14.5913 11.8936 14.5913Z" fill="#286DF0"/>
      <path d="M11.8482 14.5601C13.3061 14.5601 14.488 13.381 14.488 11.9265C14.488 10.472 13.3061 9.29285 11.8482 9.29285C10.3903 9.29285 9.2085 10.472 9.2085 11.9265C9.2085 13.381 10.3903 14.5601 11.8482 14.5601Z" fill="#286EF0"/>
      <path d="M11.818 14.5305C13.2758 14.5305 14.4577 13.3514 14.4577 11.8969C14.4577 10.4424 13.2758 9.26331 11.818 9.26331C10.3601 9.26331 9.17822 10.4424 9.17822 11.8969C9.17822 13.3514 10.3601 14.5305 11.818 14.5305Z" fill="#286EF0"/>
      <path d="M11.7721 14.4848C13.23 14.4848 14.4118 13.3056 14.4118 11.8511C14.4118 10.3966 13.23 9.21753 11.7721 9.21753C10.3142 9.21753 9.13232 10.3966 9.13232 11.8511C9.13232 13.3056 10.3142 14.4848 11.7721 14.4848Z" fill="#286FF0"/>
      <path d="M11.7418 14.4556C13.1997 14.4556 14.3815 13.2765 14.3815 11.822C14.3815 10.3675 13.1997 9.18835 11.7418 9.18835C10.2839 9.18835 9.10205 10.3675 9.10205 11.822C9.10205 13.2765 10.2839 14.4556 11.7418 14.4556Z" fill="#286FF0"/>
      <path d="M11.6964 14.4094C13.1543 14.4094 14.3361 13.2303 14.3361 11.7758C14.3361 10.3213 13.1543 9.14221 11.6964 9.14221C10.2385 9.14221 9.05664 10.3213 9.05664 11.7758C9.05664 13.2303 10.2385 14.4094 11.6964 14.4094Z" fill="#2870F0"/>
      <path d="M11.6661 14.3797C13.124 14.3797 14.3058 13.2005 14.3058 11.746C14.3058 10.2915 13.124 9.11243 11.6661 9.11243C10.2082 9.11243 9.02637 10.2915 9.02637 11.746C9.02637 13.2005 10.2082 14.3797 11.6661 14.3797Z" fill="#2870F0"/>
      <path d="M11.6358 14.3338C13.0937 14.3338 14.2756 13.1546 14.2756 11.7001C14.2756 10.2456 13.0937 9.06653 11.6358 9.06653C10.1779 9.06653 8.99609 10.2456 8.99609 11.7001C8.99609 13.1546 10.1779 14.3338 11.6358 14.3338Z" fill="#2871F0"/>
      <path d="M11.5899 14.3035C13.0478 14.3035 14.2297 13.1244 14.2297 11.6699C14.2297 10.2154 13.0478 9.03625 11.5899 9.03625C10.132 9.03625 8.9502 10.2154 8.9502 11.6699C8.9502 13.1244 10.132 14.3035 11.5899 14.3035Z" fill="#2871EF"/>
      <path d="M11.5597 14.2737C13.0175 14.2737 14.1994 13.0946 14.1994 11.6401C14.1994 10.1856 13.0175 9.00647 11.5597 9.00647C10.1018 9.00647 8.91992 10.1856 8.91992 11.6401C8.91992 13.0946 10.1018 14.2737 11.5597 14.2737Z" fill="#2872EF"/>
      <path d="M11.5143 14.2273C12.9721 14.2273 14.154 13.0482 14.154 11.5937C14.154 10.1392 12.9721 8.96008 11.5143 8.96008C10.0564 8.96008 8.87451 10.1392 8.87451 11.5937C8.87451 13.0482 10.0564 14.2273 11.5143 14.2273Z" fill="#2872EF"/>
      <path d="M11.484 14.1984C12.9419 14.1984 14.1237 13.0193 14.1237 11.5648C14.1237 10.1103 12.9419 8.93115 11.484 8.93115C10.0261 8.93115 8.84424 10.1103 8.84424 11.5648C8.84424 13.0193 10.0261 14.1984 11.484 14.1984Z" fill="#2873EF"/>
      <path d="M11.4386 14.1525C12.8965 14.1525 14.0783 12.9734 14.0783 11.5189C14.0783 10.0644 12.8965 8.88525 11.4386 8.88525C9.98068 8.88525 8.79883 10.0644 8.79883 11.5189C8.79883 12.9734 9.98068 14.1525 11.4386 14.1525Z" fill="#2773EF"/>
      <path d="M11.4078 14.1216C12.8657 14.1216 14.0475 12.9425 14.0475 11.488C14.0475 10.0335 12.8657 8.85437 11.4078 8.85437C9.94992 8.85437 8.76807 10.0335 8.76807 11.488C8.76807 12.9425 9.94992 14.1216 11.4078 14.1216Z" fill="#2773EF"/>
      <path d="M11.3775 14.0918C12.8354 14.0918 14.0173 12.9127 14.0173 11.4582C14.0173 10.0037 12.8354 8.82458 11.3775 8.82458C9.91964 8.82458 8.73779 10.0037 8.73779 11.4582C8.73779 12.9127 9.91964 14.0918 11.3775 14.0918Z" fill="#2774EF"/>
      <path d="M11.3321 14.0463C12.79 14.0463 13.9719 12.8672 13.9719 11.4127C13.9719 9.95816 12.79 8.77905 11.3321 8.77905C9.87423 8.77905 8.69238 9.95816 8.69238 11.4127C8.69238 12.8672 9.87423 14.0463 11.3321 14.0463Z" fill="#2774EF"/>
      <path d="M11.3018 14.0165C12.7597 14.0165 13.9416 12.8374 13.9416 11.3829C13.9416 9.92838 12.7597 8.74927 11.3018 8.74927C9.84396 8.74927 8.66211 9.92838 8.66211 11.3829C8.66211 12.8374 9.84396 14.0165 11.3018 14.0165Z" fill="#2775EF"/>
      <path d="M11.2559 13.971C12.7138 13.971 13.8957 12.7919 13.8957 11.3373C13.8957 9.88284 12.7138 8.70374 11.2559 8.70374C9.79806 8.70374 8.61621 9.88284 8.61621 11.3373C8.61621 12.7919 9.79806 13.971 11.2559 13.971Z" fill="#2775EF"/>
      <path d="M11.2257 13.9409C12.6836 13.9409 13.8654 12.7618 13.8654 11.3073C13.8654 9.85281 12.6836 8.67371 11.2257 8.67371C9.76779 8.67371 8.58594 9.85281 8.58594 11.3073C8.58594 12.7618 9.76779 13.9409 11.2257 13.9409Z" fill="#2776EF"/>
      <path d="M11.1803 13.8953C12.6382 13.8953 13.82 12.7162 13.82 11.2617C13.82 9.80716 12.6382 8.62805 11.1803 8.62805C9.72238 8.62805 8.54053 9.80716 8.54053 11.2617C8.54053 12.7162 9.72238 13.8953 11.1803 13.8953Z" fill="#2776EF"/>
      <path d="M11.15 13.8644C12.6079 13.8644 13.7897 12.6853 13.7897 11.2308C13.7897 9.77628 12.6079 8.59717 11.15 8.59717C9.6921 8.59717 8.51025 9.77628 8.51025 11.2308C8.51025 12.6853 9.6921 13.8644 11.15 13.8644Z" fill="#2777EF"/>
      <path d="M11.1197 13.8346C12.5776 13.8346 13.7595 12.6555 13.7595 11.201C13.7595 9.74649 12.5776 8.56738 11.1197 8.56738C9.66183 8.56738 8.47998 9.74649 8.47998 11.201C8.47998 12.6555 9.66183 13.8346 11.1197 13.8346Z" fill="#2777EF"/>
      <path d="M11.0738 13.7888C12.5317 13.7888 13.7136 12.6097 13.7136 11.1552C13.7136 9.70071 12.5317 8.52161 11.0738 8.52161C9.61593 8.52161 8.43408 9.70071 8.43408 11.1552C8.43408 12.6097 9.61593 13.7888 11.0738 13.7888Z" fill="#2778EF"/>
      <path d="M11.0435 13.759C12.5014 13.759 13.6833 12.5799 13.6833 11.1254C13.6833 9.67093 12.5014 8.49182 11.0435 8.49182C9.58566 8.49182 8.40381 9.67093 8.40381 11.1254C8.40381 12.5799 9.58566 13.759 11.0435 13.759Z" fill="#2778EF"/>
      <path d="M10.9981 13.7135C12.456 13.7135 13.6379 12.5344 13.6379 11.0799C13.6379 9.6254 12.456 8.44629 10.9981 8.44629C9.54025 8.44629 8.3584 9.6254 8.3584 11.0799C8.3584 12.5344 9.54025 13.7135 10.9981 13.7135Z" fill="#2779EE"/>
      <path d="M10.9679 13.6837C12.4258 13.6837 13.6076 12.5046 13.6076 11.0501C13.6076 9.59561 12.4258 8.4165 10.9679 8.4165C9.50998 8.4165 8.32812 9.59561 8.32812 11.0501C8.32812 12.5046 9.50998 13.6837 10.9679 13.6837Z" fill="#2779EE"/>
      <path d="M10.922 13.6382C12.3799 13.6382 13.5617 12.4591 13.5617 11.0046C13.5617 9.55008 12.3799 8.37097 10.922 8.37097C9.46408 8.37097 8.28223 9.55008 8.28223 11.0046C8.28223 12.4591 9.46408 13.6382 10.922 13.6382Z" fill="#277AEE"/>
      <path d="M10.8917 13.6069C12.3496 13.6069 13.5314 12.4278 13.5314 10.9733C13.5314 9.51883 12.3496 8.33972 10.8917 8.33972C9.4338 8.33972 8.25195 9.51883 8.25195 10.9733C8.25195 12.4278 9.4338 13.6069 10.8917 13.6069Z" fill="#277AEE"/>
      <path d="M10.8614 13.5772C12.3193 13.5772 13.5012 12.3981 13.5012 10.9436C13.5012 9.48905 12.3193 8.30994 10.8614 8.30994C9.40353 8.30994 8.22168 9.48905 8.22168 10.9436C8.22168 12.3981 9.40353 13.5772 10.8614 13.5772Z" fill="#277BEE"/>
      <path d="M10.816 13.5316C12.2739 13.5316 13.4557 12.3525 13.4557 10.898C13.4557 9.44351 12.2739 8.2644 10.816 8.2644C9.35812 8.2644 8.17627 9.44351 8.17627 10.898C8.17627 12.3525 9.35812 13.5316 10.816 13.5316Z" fill="#277BEE"/>
      <path d="M10.7867 13.5018C12.2446 13.5018 13.4264 12.3227 13.4264 10.8682C13.4264 9.41373 12.2446 8.23462 10.7867 8.23462C9.32882 8.23462 8.14697 9.41373 8.14697 10.8682C8.14697 12.3227 9.32882 13.5018 10.7867 13.5018Z" fill="#277CEE"/>
      <path d="M10.7413 13.4559C12.1992 13.4559 13.381 12.2768 13.381 10.8223C13.381 9.36783 12.1992 8.18872 10.7413 8.18872C9.28341 8.18872 8.10156 9.36783 8.10156 10.8223C8.10156 12.2768 9.28341 13.4559 10.7413 13.4559Z" fill="#267CEE"/>
      <path d="M10.711 13.4251C12.1689 13.4251 13.3508 12.246 13.3508 10.7915C13.3508 9.33695 12.1689 8.15784 10.711 8.15784C9.25314 8.15784 8.07129 9.33695 8.07129 10.7915C8.07129 12.246 9.25314 13.4251 10.711 13.4251Z" fill="#267DEE"/>
      <path d="M10.6803 13.3806C12.1382 13.3806 13.32 12.2015 13.32 10.747C13.32 9.29251 12.1382 8.1134 10.6803 8.1134C9.22238 8.1134 8.04053 9.29251 8.04053 10.747C8.04053 12.2015 9.22238 13.3806 10.6803 13.3806Z" fill="#267DEE"/>
      <path d="M10.6349 13.3497C12.0927 13.3497 13.2746 12.1706 13.2746 10.7161C13.2746 9.26163 12.0927 8.08252 10.6349 8.08252C9.17697 8.08252 7.99512 9.26163 7.99512 10.7161C7.99512 12.1706 9.17697 13.3497 10.6349 13.3497Z" fill="#267EEE"/>
      <path d="M10.6046 13.32C12.0625 13.32 13.2443 12.1409 13.2443 10.6863C13.2443 9.23184 12.0625 8.05273 10.6046 8.05273C9.14669 8.05273 7.96484 9.23184 7.96484 10.6863C7.96484 12.1409 9.14669 13.32 10.6046 13.32Z" fill="#267EEE"/>
      <path d="M10.5592 13.2741C12.0171 13.2741 13.1989 12.095 13.1989 10.6404C13.1989 9.18594 12.0171 8.00684 10.5592 8.00684C9.10128 8.00684 7.91943 9.18594 7.91943 10.6404C7.91943 12.095 9.10128 13.2741 10.5592 13.2741Z" fill="#267FEE"/>
      <path d="M10.5289 13.2449C11.9868 13.2449 13.1686 12.0658 13.1686 10.6113C13.1686 9.15677 11.9868 7.97766 10.5289 7.97766C9.07101 7.97766 7.88916 9.15677 7.88916 10.6113C7.88916 12.0658 9.07101 13.2449 10.5289 13.2449Z" fill="#267FEE"/>
      <path d="M10.483 13.1987C11.9409 13.1987 13.1227 12.0196 13.1227 10.5651C13.1227 9.11063 11.9409 7.93152 10.483 7.93152C9.02511 7.93152 7.84326 9.11063 7.84326 10.5651C7.84326 12.0196 9.02511 13.1987 10.483 13.1987Z" fill="#2680EE"/>
      <path d="M10.4517 13.1679C11.9096 13.1679 13.0915 11.9888 13.0915 10.5342C13.0915 9.07974 11.9096 7.90063 10.4517 7.90063C8.99386 7.90063 7.81201 9.07974 7.81201 10.5342C7.81201 11.9888 8.99386 13.1679 10.4517 13.1679Z" fill="#2680EE"/>
      <path d="M10.4225 13.1378C11.8803 13.1378 13.0622 11.9587 13.0622 10.5042C13.0622 9.04971 11.8803 7.87061 10.4225 7.87061C8.96457 7.87061 7.78271 9.04971 7.78271 10.5042C7.78271 11.9587 8.96457 13.1378 10.4225 13.1378Z" fill="#2680ED"/>
      <path d="M10.377 13.0923C11.8349 13.0923 13.0168 11.9132 13.0168 10.4587C13.0168 9.00418 11.8349 7.82507 10.377 7.82507C8.91916 7.82507 7.7373 9.00418 7.7373 10.4587C7.7373 11.9132 8.91916 13.0923 10.377 13.0923Z" fill="#2681ED"/>
      <path d="M10.3468 13.0634C11.8047 13.0634 12.9865 11.8843 12.9865 10.4298C12.9865 8.97525 11.8047 7.79614 10.3468 7.79614C8.88888 7.79614 7.70703 8.97525 7.70703 10.4298C7.70703 11.8843 8.88888 13.0634 10.3468 13.0634Z" fill="#2681ED"/>
      <path d="M10.3009 13.0175C11.7588 13.0175 12.9406 11.8384 12.9406 10.3839C12.9406 8.92935 11.7588 7.75024 10.3009 7.75024C8.84298 7.75024 7.66113 8.92935 7.66113 10.3839C7.66113 11.8384 8.84298 13.0175 10.3009 13.0175Z" fill="#2682ED"/>
      <path d="M10.2706 12.9862C11.7285 12.9862 12.9103 11.8071 12.9103 10.3526C12.9103 8.8981 11.7285 7.71899 10.2706 7.71899C8.81271 7.71899 7.63086 8.8981 7.63086 10.3526C7.63086 11.8071 8.81271 12.9862 10.2706 12.9862Z" fill="#2682ED"/>
      <path d="M10.2252 12.9417C11.6831 12.9417 12.8649 11.7626 12.8649 10.3081C12.8649 8.85355 11.6831 7.67444 10.2252 7.67444C8.7673 7.67444 7.58545 8.85355 7.58545 10.3081C7.58545 11.7626 8.7673 12.9417 10.2252 12.9417Z" fill="#2683ED"/>
      <path d="M10.1949 12.9104C11.6528 12.9104 12.8347 11.7313 12.8347 10.2768C12.8347 8.8223 11.6528 7.64319 10.1949 7.64319C8.73703 7.64319 7.55518 8.8223 7.55518 10.2768C7.55518 11.7313 8.73703 12.9104 10.1949 12.9104Z" fill="#2683ED"/>
      <path d="M10.1642 12.8812C11.622 12.8812 12.8039 11.7021 12.8039 10.2476C12.8039 8.79312 11.622 7.61401 10.1642 7.61401C8.70626 7.61401 7.52441 8.79312 7.52441 10.2476C7.52441 11.7021 8.70626 12.8812 10.1642 12.8812Z" fill="#2684ED"/>
      <path d="M10.1187 12.8357C11.5766 12.8357 12.7585 11.6566 12.7585 10.2021C12.7585 8.74759 11.5766 7.56848 10.1187 7.56848C8.66086 7.56848 7.479 8.74759 7.479 10.2021C7.479 11.6566 8.66086 12.8357 10.1187 12.8357Z" fill="#2684ED"/>
      <path d="M10.0885 12.8059C11.5464 12.8059 12.7282 11.6268 12.7282 10.1723C12.7282 8.7178 11.5464 7.5387 10.0885 7.5387C8.63058 7.5387 7.44873 8.7178 7.44873 10.1723C7.44873 11.6268 8.63058 12.8059 10.0885 12.8059Z" fill="#2685ED"/>
      <path d="M10.0431 12.7594C11.5009 12.7594 12.6828 11.5803 12.6828 10.1258C12.6828 8.6713 11.5009 7.49219 10.0431 7.49219C8.58517 7.49219 7.40332 8.6713 7.40332 10.1258C7.40332 11.5803 8.58517 12.7594 10.0431 12.7594Z" fill="#2585ED"/>
      <path d="M10.0128 12.7285C11.4707 12.7285 12.6525 11.5494 12.6525 10.0949C12.6525 8.64041 11.4707 7.4613 10.0128 7.4613C8.5549 7.4613 7.37305 8.64041 7.37305 10.0949C7.37305 11.5494 8.5549 12.7285 10.0128 12.7285Z" fill="#2586ED"/>
      <path d="M9.96689 12.6847C11.4248 12.6847 12.6066 11.5056 12.6066 10.0511C12.6066 8.59659 11.4248 7.41748 9.96689 7.41748C8.509 7.41748 7.32715 8.59659 7.32715 10.0511C7.32715 11.5056 8.509 12.6847 9.96689 12.6847Z" fill="#2586ED"/>
      <path d="M9.93661 12.6538C11.3945 12.6538 12.5764 11.4747 12.5764 10.0202C12.5764 8.56571 11.3945 7.3866 9.93661 7.3866C8.47873 7.3866 7.29688 8.56571 7.29688 10.0202C7.29688 11.4747 8.47873 12.6538 9.93661 12.6538Z" fill="#2587ED"/>
      <path d="M9.90634 12.624C11.3642 12.624 12.5461 11.4449 12.5461 9.99042C12.5461 8.53592 11.3642 7.35681 9.90634 7.35681C8.44845 7.35681 7.2666 8.53592 7.2666 9.99042C7.2666 11.4449 8.44845 12.624 9.90634 12.624Z" fill="#2587ED"/>
      <path d="M9.86093 12.5781C11.3188 12.5781 12.5007 11.399 12.5007 9.94453C12.5007 8.49002 11.3188 7.31091 9.86093 7.31091C8.40304 7.31091 7.22119 8.49002 7.22119 9.94453C7.22119 11.399 8.40304 12.5781 9.86093 12.5781Z" fill="#2588EC"/>
      <path d="M9.83017 12.5484C11.2881 12.5484 12.4699 11.3692 12.4699 9.91474C12.4699 8.46024 11.2881 7.28113 9.83017 7.28113C8.37228 7.28113 7.19043 8.46024 7.19043 9.91474C7.19043 11.3692 8.37228 12.5484 9.83017 12.5484Z" fill="#2588EC"/>
      <path d="M9.78476 12.5028C11.2426 12.5028 12.4245 11.3237 12.4245 9.86921C12.4245 8.4147 11.2426 7.2356 9.78476 7.2356C8.32687 7.2356 7.14502 8.4147 7.14502 9.86921C7.14502 11.3237 8.32687 12.5028 9.78476 12.5028Z" fill="#2589EC"/>
      <path d="M9.75448 12.4719C11.2124 12.4719 12.3942 11.2928 12.3942 9.83833C12.3942 8.38382 11.2124 7.20471 9.75448 7.20471C8.2966 7.20471 7.11475 8.38382 7.11475 9.83833C7.11475 11.2928 8.2966 12.4719 9.75448 12.4719Z" fill="#2589EC"/>
      <path d="M9.70907 12.4418C11.167 12.4418 12.3488 11.2627 12.3488 9.80817C12.3488 8.35367 11.167 7.17456 9.70907 7.17456C8.25119 7.17456 7.06934 8.35367 7.06934 9.80817C7.06934 11.2627 8.25119 12.4418 9.70907 12.4418Z" fill="#258AEC"/>
      <path d="M9.6788 12.3963C11.1367 12.3963 12.3185 11.2171 12.3185 9.76264C12.3185 8.30814 11.1367 7.12903 9.6788 7.12903C8.22091 7.12903 7.03906 8.30814 7.03906 9.76264C7.03906 11.2171 8.22091 12.3963 9.6788 12.3963Z" fill="#258AEC"/>
      <path d="M9.64804 12.3665C11.1059 12.3665 12.2878 11.1874 12.2878 9.73286C12.2878 8.27835 11.1059 7.09924 9.64804 7.09924C8.19015 7.09924 7.0083 8.27835 7.0083 9.73286C7.0083 11.1874 8.19015 12.3665 9.64804 12.3665Z" fill="#258BEC"/>
      <path d="M9.60263 12.3209C11.0605 12.3209 12.2424 11.1418 12.2424 9.68732C12.2424 8.23282 11.0605 7.05371 9.60263 7.05371C8.14474 7.05371 6.96289 8.23282 6.96289 9.68732C6.96289 11.1418 8.14474 12.3209 9.60263 12.3209Z" fill="#258BEC"/>
      <path d="M9.57236 12.2898C11.0302 12.2898 12.2121 11.1107 12.2121 9.6562C12.2121 8.20169 11.0302 7.02258 9.57236 7.02258C8.11447 7.02258 6.93262 8.20169 6.93262 9.6562C6.93262 11.1107 8.11447 12.2898 9.57236 12.2898Z" fill="#258CEC"/>
      <path d="M9.52695 12.2456C10.9848 12.2456 12.1667 11.0665 12.1667 9.61201C12.1667 8.1575 10.9848 6.97839 9.52695 6.97839C8.06906 6.97839 6.88721 8.1575 6.88721 9.61201C6.88721 11.0665 8.06906 12.2456 9.52695 12.2456Z" fill="#258CEC"/>
      <path d="M9.49667 12.2145C10.9546 12.2145 12.1364 11.0354 12.1364 9.58088C12.1364 8.12637 10.9546 6.94727 9.49667 6.94727C8.03878 6.94727 6.85693 8.12637 6.85693 9.58088C6.85693 11.0354 8.03878 12.2145 9.49667 12.2145Z" fill="#258DEC"/>
      <path d="M9.46591 12.1847C10.9238 12.1847 12.1056 11.0056 12.1056 9.55109C12.1056 8.09659 10.9238 6.91748 9.46591 6.91748C8.00802 6.91748 6.82617 8.09659 6.82617 9.55109C6.82617 11.0056 8.00802 12.1847 9.46591 12.1847Z" fill="#258DEC"/>
      <path d="M9.4205 12.1392C10.8784 12.1392 12.0602 10.9601 12.0602 9.50556C12.0602 8.05106 10.8784 6.87195 9.4205 6.87195C7.96261 6.87195 6.78076 8.05106 6.78076 9.50556C6.78076 10.9601 7.96261 12.1392 9.4205 12.1392Z" fill="#258DEC"/>
      <path d="M9.39023 12.1099C10.8481 12.1099 12.03 10.9308 12.03 9.47626C12.03 8.02176 10.8481 6.84265 9.39023 6.84265C7.93234 6.84265 6.75049 8.02176 6.75049 9.47626C6.75049 10.9308 7.93234 12.1099 9.39023 12.1099Z" fill="#258EEC"/>
      <path d="M9.34482 12.0635C10.8027 12.0635 11.9846 10.8844 11.9846 9.42988C11.9846 7.97537 10.8027 6.79626 9.34482 6.79626C7.88693 6.79626 6.70508 7.97537 6.70508 9.42988C6.70508 10.8844 7.88693 12.0635 9.34482 12.0635Z" fill="#248EEC"/>
      <path d="M9.31405 12.0326C10.7719 12.0326 11.9538 10.8535 11.9538 9.39899C11.9538 7.94449 10.7719 6.76538 9.31405 6.76538C7.85617 6.76538 6.67432 7.94449 6.67432 9.39899C6.67432 10.8535 7.85617 12.0326 9.31405 12.0326Z" fill="#248FEC"/>
      <path d="M9.26864 11.9882C10.7265 11.9882 11.9084 10.8091 11.9084 9.35456C11.9084 7.90006 10.7265 6.72095 9.26864 6.72095C7.81076 6.72095 6.62891 7.90006 6.62891 9.35456C6.62891 10.8091 7.81076 11.9882 9.26864 11.9882Z" fill="#248FEB"/>
      <path d="M9.23837 11.9569C10.6963 11.9569 11.8781 10.7778 11.8781 9.32331C11.8781 7.86881 10.6963 6.6897 9.23837 6.6897C7.78048 6.6897 6.59863 7.86881 6.59863 9.32331C6.59863 10.7778 7.78048 11.9569 9.23837 11.9569Z" fill="#2490EB"/>
      <path d="M9.2081 11.9281C10.666 11.9281 11.8478 10.749 11.8478 9.2945C11.8478 7.84 10.666 6.66089 9.2081 6.66089C7.75021 6.66089 6.56836 7.84 6.56836 9.2945C6.56836 10.749 7.75021 11.9281 9.2081 11.9281Z" fill="#2490EB"/>
      <path d="M9.16269 11.8816C10.6206 11.8816 11.8024 10.7025 11.8024 9.24799C11.8024 7.79349 10.6206 6.61438 9.16269 6.61438C7.7048 6.61438 6.52295 7.79349 6.52295 9.24799C6.52295 10.7025 7.7048 11.8816 9.16269 11.8816Z" fill="#2491EB"/>
      <path d="M9.13193 11.8504C10.5898 11.8504 11.7717 10.6712 11.7717 9.21674C11.7717 7.76224 10.5898 6.58313 9.13193 6.58313C7.67404 6.58313 6.49219 7.76224 6.49219 9.21674C6.49219 10.6712 7.67404 11.8504 9.13193 11.8504Z" fill="#2491EB"/>
      <path d="M9.08652 11.8063C10.5444 11.8063 11.7263 10.6272 11.7263 9.17268C11.7263 7.71817 10.5444 6.53906 9.08652 6.53906C7.62863 6.53906 6.44678 7.71817 6.44678 9.17268C6.44678 10.6272 7.62863 11.8063 9.08652 11.8063Z" fill="#2492EB"/>
      <path d="M9.05624 11.776C10.5141 11.776 11.696 10.5969 11.696 9.1424C11.696 7.6879 10.5141 6.50879 9.05624 6.50879C7.59835 6.50879 6.4165 7.6879 6.4165 9.1424C6.4165 10.5969 7.59835 11.776 9.05624 11.776Z" fill="#2492EB"/>
      <path d="M9.01083 11.7462C10.4687 11.7462 11.6506 10.5671 11.6506 9.11262C11.6506 7.65811 10.4687 6.479 9.01083 6.479C7.55295 6.479 6.37109 7.65811 6.37109 9.11262C6.37109 10.5671 7.55295 11.7462 9.01083 11.7462Z" fill="#2493EB"/>
      <path d="M8.98056 11.6997C10.4384 11.6997 11.6203 10.5206 11.6203 9.06611C11.6203 7.6116 10.4384 6.4325 8.98056 6.4325C7.52267 6.4325 6.34082 7.6116 6.34082 9.06611C6.34082 10.5206 7.52267 11.6997 8.98056 11.6997Z" fill="#2493EB"/>
      <path d="M8.9498 11.6705C10.4077 11.6705 11.5895 10.4914 11.5895 9.03693C11.5895 7.58243 10.4077 6.40332 8.9498 6.40332C7.49191 6.40332 6.31006 7.58243 6.31006 9.03693C6.31006 10.4914 7.49191 11.6705 8.9498 11.6705Z" fill="#2494EB"/>
      <path d="M8.90439 11.625C10.3623 11.625 11.5441 10.4459 11.5441 8.9914C11.5441 7.5369 10.3623 6.35779 8.90439 6.35779C7.4465 6.35779 6.26465 7.5369 6.26465 8.9914C6.26465 10.4459 7.4465 11.625 8.90439 11.625Z" fill="#2494EB"/>
      <path d="M8.87509 11.5941C10.333 11.5941 11.5148 10.415 11.5148 8.96052C11.5148 7.50601 10.333 6.3269 8.87509 6.3269C7.4172 6.3269 6.23535 7.50601 6.23535 8.96052C6.23535 10.415 7.4172 11.5941 8.87509 11.5941Z" fill="#2495EB"/>
      <path d="M8.82968 11.5495C10.2876 11.5495 11.4694 10.3703 11.4694 8.91584C11.4694 7.46133 10.2876 6.28223 8.82968 6.28223C7.37179 6.28223 6.18994 7.46133 6.18994 8.91584C6.18994 10.3703 7.37179 11.5495 8.82968 11.5495Z" fill="#2495EB"/>
      <path d="M8.79941 11.5184C10.2573 11.5184 11.4391 10.3393 11.4391 8.88483C11.4391 7.43033 10.2573 6.25122 8.79941 6.25122C7.34152 6.25122 6.15967 7.43033 6.15967 8.88483C6.15967 10.3393 7.34152 11.5184 8.79941 11.5184Z" fill="#2496EB"/>
      <path d="M8.754 11.4887C10.2119 11.4887 11.3937 10.3096 11.3937 8.85505C11.3937 7.40054 10.2119 6.22144 8.754 6.22144C7.29611 6.22144 6.11426 7.40054 6.11426 8.85505C6.11426 10.3096 7.29611 11.4887 8.754 11.4887Z" fill="#2496EB"/>
      <path d="M8.72323 11.4431C10.1811 11.4431 11.363 10.264 11.363 8.80952C11.363 7.35501 10.1811 6.1759 8.72323 6.1759C7.26535 6.1759 6.0835 7.35501 6.0835 8.80952C6.0835 10.264 7.26535 11.4431 8.72323 11.4431Z" fill="#2497EB"/>
      <path d="M8.69296 11.4133C10.1508 11.4133 11.3327 10.2342 11.3327 8.77973C11.3327 7.32523 10.1508 6.14612 8.69296 6.14612C7.23507 6.14612 6.05322 7.32523 6.05322 8.77973C6.05322 10.2342 7.23507 11.4133 8.69296 11.4133Z" fill="#2497EA"/>
      <path d="M8.64657 11.3678C10.1045 11.3678 11.2863 10.1887 11.2863 8.7342C11.2863 7.27969 10.1045 6.10059 8.64657 6.10059C7.18869 6.10059 6.00684 7.27969 6.00684 8.7342C6.00684 10.1887 7.18869 11.3678 8.64657 11.3678Z" fill="#2498EA"/>
      <path d="M8.61581 11.3366C10.0737 11.3366 11.2556 10.1575 11.2556 8.70295C11.2556 7.24844 10.0737 6.06934 8.61581 6.06934C7.15792 6.06934 5.97607 7.24844 5.97607 8.70295C5.97607 10.1575 7.15792 11.3366 8.61581 11.3366Z" fill="#2398EA"/>
      <path d="M8.57187 11.2923C10.0298 11.2923 11.2116 10.1131 11.2116 8.65864C11.2116 7.20413 10.0298 6.02502 8.57187 6.02502C7.11398 6.02502 5.93213 7.20413 5.93213 8.65864C5.93213 10.1131 7.11398 11.2923 8.57187 11.2923Z" fill="#2399EA"/>
      <path d="M8.54013 11.2612C9.99802 11.2612 11.1799 10.0821 11.1799 8.62763C11.1799 7.17313 9.99802 5.99402 8.54013 5.99402C7.08224 5.99402 5.90039 7.17313 5.90039 8.62763C5.90039 10.0821 7.08224 11.2612 8.54013 11.2612Z" fill="#2399EA"/>
      <path d="M8.4957 11.2316C9.95358 11.2316 11.1354 10.0525 11.1354 8.59797C11.1354 7.14346 9.95358 5.96436 8.4957 5.96436C7.03781 5.96436 5.85596 7.14346 5.85596 8.59797C5.85596 10.0525 7.03781 11.2316 8.4957 11.2316Z" fill="#2399EA"/>
      <path d="M8.46542 11.1857C9.92331 11.1857 11.1052 10.0066 11.1052 8.55207C11.1052 7.09757 9.92331 5.91846 8.46542 5.91846C7.00753 5.91846 5.82568 7.09757 5.82568 8.55207C5.82568 10.0066 7.00753 11.1857 8.46542 11.1857Z" fill="#239AEA"/>
      <path d="M8.43515 11.1548C9.89304 11.1548 11.0749 9.97569 11.0749 8.52119C11.0749 7.06668 9.89304 5.88757 8.43515 5.88757C6.97726 5.88757 5.79541 7.06668 5.79541 8.52119C5.79541 9.97569 6.97726 11.1548 8.43515 11.1548Z" fill="#239AEA"/>
      <path d="M8.38925 11.1104C9.84714 11.1104 11.029 9.93126 11.029 8.47675C11.029 7.02225 9.84714 5.84314 8.38925 5.84314C6.93136 5.84314 5.74951 7.02225 5.74951 8.47675C5.74951 9.93126 6.93136 11.1104 8.38925 11.1104Z" fill="#239BEA"/>
      <path d="M8.35898 11.0791C9.81686 11.0791 10.9987 9.90001 10.9987 8.4455C10.9987 6.991 9.81686 5.81189 8.35898 5.81189C6.90109 5.81189 5.71924 6.991 5.71924 8.4455C5.71924 9.90001 6.90109 11.0791 8.35898 11.0791Z" fill="#239BEA"/>
      <path d="M8.31357 11.035C9.77145 11.035 10.9533 9.85594 10.9533 8.40143C10.9533 6.94693 9.77145 5.76782 8.31357 5.76782C6.85568 5.76782 5.67383 6.94693 5.67383 8.40143C5.67383 9.85594 6.85568 11.035 8.31357 11.035Z" fill="#239CEA"/>
      <path d="M8.28329 11.0038C9.74118 11.0038 10.923 9.82469 10.923 8.37019C10.923 6.91568 9.74118 5.73657 8.28329 5.73657C6.82541 5.73657 5.64355 6.91568 5.64355 8.37019C5.64355 9.82469 6.82541 11.0038 8.28329 11.0038Z" fill="#239CEA"/>
      <path d="M8.25302 10.974C9.71091 10.974 10.8928 9.7949 10.8928 8.3404C10.8928 6.8859 9.71091 5.70679 8.25302 5.70679C6.79513 5.70679 5.61328 6.8859 5.61328 8.3404C5.61328 9.7949 6.79513 10.974 8.25302 10.974Z" fill="#239DEA"/>
      <path d="M8.20712 10.9285C9.66501 10.9285 10.8469 9.74937 10.8469 8.29487C10.8469 6.84036 9.66501 5.66125 8.20712 5.66125C6.74923 5.66125 5.56738 6.84036 5.56738 8.29487C5.56738 9.74937 6.74923 10.9285 8.20712 10.9285Z" fill="#239DEA"/>
      <path d="M8.17685 10.8976C9.63473 10.8976 10.8166 9.71849 10.8166 8.26398C10.8166 6.80948 9.63473 5.63037 8.17685 5.63037C6.71896 5.63037 5.53711 6.80948 5.53711 8.26398C5.53711 9.71849 6.71896 10.8976 8.17685 10.8976Z" fill="#239EEA"/>
      <path d="M8.13144 10.8529C9.58932 10.8529 10.7712 9.67381 10.7712 8.21931C10.7712 6.7648 9.58932 5.58569 8.13144 5.58569C6.67355 5.58569 5.4917 6.7648 5.4917 8.21931C5.4917 9.67381 6.67355 10.8529 8.13144 10.8529Z" fill="#239EEA"/>
      <path d="M8.10116 10.8225C9.55905 10.8225 10.7409 9.64341 10.7409 8.18891C10.7409 6.73441 9.55905 5.5553 8.10116 5.5553C6.64328 5.5553 5.46143 6.73441 5.46143 8.18891C5.46143 9.64341 6.64328 10.8225 8.10116 10.8225Z" fill="#239FE9"/>
      <path d="M8.05575 10.7927C9.51364 10.7927 10.6955 9.61363 10.6955 8.15913C10.6955 6.70462 9.51364 5.52551 8.05575 5.52551C6.59787 5.52551 5.41602 6.70462 5.41602 8.15913C5.41602 9.61363 6.59787 10.7927 8.05575 10.7927Z" fill="#239FE9"/>
      <path d="M8.02499 10.7464C9.48288 10.7464 10.6647 9.56724 10.6647 8.11274C10.6647 6.65824 9.48288 5.47913 8.02499 5.47913C6.5671 5.47913 5.38525 6.65824 5.38525 8.11274C5.38525 9.56724 6.5671 10.7464 8.02499 10.7464Z" fill="#23A0E9"/>
      <path d="M7.99472 10.7153C9.4526 10.7153 10.6345 9.53624 10.6345 8.08173C10.6345 6.62723 9.4526 5.44812 7.99472 5.44812C6.53683 5.44812 5.35498 6.62723 5.35498 8.08173C5.35498 9.53624 6.53683 10.7153 7.99472 10.7153Z" fill="#23A0E9"/>
      <path d="M7.94931 10.6719C9.40719 10.6719 10.589 9.49278 10.589 8.03828C10.589 6.58377 9.40719 5.40466 7.94931 5.40466C6.49142 5.40466 5.30957 6.58377 5.30957 8.03828C5.30957 9.49278 6.49142 10.6719 7.94931 10.6719Z" fill="#23A1E9"/>
      <path d="M7.91903 10.6406C9.37692 10.6406 10.5588 9.46153 10.5588 8.00703C10.5588 6.55252 9.37692 5.37341 7.91903 5.37341C6.46115 5.37341 5.2793 6.55252 5.2793 8.00703C5.2793 9.46153 6.46115 10.6406 7.91903 10.6406Z" fill="#22A1E9"/>
      <path d="M7.87314 10.5957C9.33102 10.5957 10.5129 9.41661 10.5129 7.9621C10.5129 6.5076 9.33102 5.32849 7.87314 5.32849C6.41525 5.32849 5.2334 6.5076 5.2334 7.9621C5.2334 9.41661 6.41525 10.5957 7.87314 10.5957Z" fill="#22A2E9"/>
      <path d="M7.84286 10.5647C9.30075 10.5647 10.4826 9.3856 10.4826 7.9311C10.4826 6.47659 9.30075 5.29749 7.84286 5.29749C6.38498 5.29749 5.20312 6.47659 5.20312 7.9311C5.20312 9.3856 6.38498 10.5647 7.84286 10.5647Z" fill="#22A2E9"/>
      <path d="M7.79745 10.5355C9.25534 10.5355 10.4372 9.35643 10.4372 7.90192C10.4372 6.44742 9.25534 5.26831 7.79745 5.26831C6.33957 5.26831 5.15771 6.44742 5.15771 7.90192C5.15771 9.35643 6.33957 10.5355 7.79745 10.5355Z" fill="#22A3E9"/>
      <path d="M7.76718 10.49C9.22507 10.49 10.4069 9.3109 10.4069 7.85639C10.4069 6.40189 9.22507 5.22278 7.76718 5.22278C6.30929 5.22278 5.12744 6.40189 5.12744 7.85639C5.12744 9.3109 6.30929 10.49 7.76718 10.49Z" fill="#22A3E9"/>
      <path d="M7.73691 10.4588C9.19479 10.4588 10.3766 9.27965 10.3766 7.82514C10.3766 6.37064 9.19479 5.19153 7.73691 5.19153C6.27902 5.19153 5.09717 6.37064 5.09717 7.82514C5.09717 9.27965 6.27902 10.4588 7.73691 10.4588Z" fill="#22A4E9"/>
      <path d="M7.69101 10.4138C9.14889 10.4138 10.3307 9.23472 10.3307 7.78022C10.3307 6.32572 9.14889 5.14661 7.69101 5.14661C6.23312 5.14661 5.05127 6.32572 5.05127 7.78022C5.05127 9.23472 6.23312 10.4138 7.69101 10.4138Z" fill="#22A4E9"/>
      <path d="M7.66073 10.3834C9.11862 10.3834 10.3005 9.20433 10.3005 7.74982C10.3005 6.29532 9.11862 5.11621 7.66073 5.11621C6.20285 5.11621 5.021 6.29532 5.021 7.74982C5.021 9.20433 6.20285 10.3834 7.66073 10.3834Z" fill="#22A5E9"/>
      <path d="M7.61532 10.337C9.07321 10.337 10.2551 9.15794 10.2551 7.70344C10.2551 6.24893 9.07321 5.06982 7.61532 5.06982C6.15744 5.06982 4.97559 6.24893 4.97559 7.70344C4.97559 9.15794 6.15744 10.337 7.61532 10.337Z" fill="#22A5E9"/>
      <path d="M7.58505 10.3079C9.04294 10.3079 10.2248 9.12877 10.2248 7.67426C10.2248 6.21976 9.04294 5.04065 7.58505 5.04065C6.12716 5.04065 4.94531 6.21976 4.94531 7.67426C4.94531 9.12877 6.12716 10.3079 7.58505 10.3079Z" fill="#22A6E9"/>
      <path d="M7.53915 10.2781C8.99704 10.2781 10.1789 9.09898 10.1789 7.64448C10.1789 6.18997 8.99704 5.01086 7.53915 5.01086C6.08126 5.01086 4.89941 6.18997 4.89941 7.64448C4.89941 9.09898 6.08126 10.2781 7.53915 10.2781Z" fill="#22A6E8"/>
      <path d="M7.50888 10.2326C8.96677 10.2326 10.1486 9.05345 10.1486 7.59894C10.1486 6.14444 8.96677 4.96533 7.50888 4.96533C6.05099 4.96533 4.86914 6.14444 4.86914 7.59894C4.86914 9.05345 6.05099 10.2326 7.50888 10.2326Z" fill="#22A6E8"/>
      <path d="M7.4786 10.2013C8.93649 10.2013 10.1183 9.0222 10.1183 7.56769C10.1183 6.11319 8.93649 4.93408 7.4786 4.93408C6.02072 4.93408 4.83887 6.11319 4.83887 7.56769C4.83887 9.0222 6.02072 10.2013 7.4786 10.2013Z" fill="#22A7E8"/>
      <path d="M7.4332 10.1572C8.89108 10.1572 10.0729 8.97813 10.0729 7.52363C10.0729 6.06912 8.89108 4.89001 7.4332 4.89001C5.97531 4.89001 4.79346 6.06912 4.79346 7.52363C4.79346 8.97813 5.97531 10.1572 7.4332 10.1572Z" fill="#22A7E8"/>
      <path d="M7.40292 10.126C8.86081 10.126 10.0427 8.94688 10.0427 7.49238C10.0427 6.03787 8.86081 4.85876 7.40292 4.85876C5.94503 4.85876 4.76318 6.03787 4.76318 7.49238C4.76318 8.94688 5.94503 10.126 7.40292 10.126Z" fill="#22A8E8"/>
      <path d="M7.35702 10.0962C8.81491 10.0962 9.99676 8.9171 9.99676 7.46259C9.99676 6.00809 8.81491 4.82898 7.35702 4.82898C5.89914 4.82898 4.71729 6.00809 4.71729 7.46259C4.71729 8.9171 5.89914 10.0962 7.35702 10.0962Z" fill="#22A8E8"/>
      <path d="M7.32675 10.0507C8.78464 10.0507 9.96649 8.87156 9.96649 7.41706C9.96649 5.96256 8.78464 4.78345 7.32675 4.78345C5.86886 4.78345 4.68701 5.96256 4.68701 7.41706C4.68701 8.87156 5.86886 10.0507 7.32675 10.0507Z" fill="#22A9E8"/>
      <path d="M7.28134 10.0194C8.73923 10.0194 9.92108 8.84031 9.92108 7.38581C9.92108 5.93131 8.73923 4.7522 7.28134 4.7522C5.82345 4.7522 4.6416 5.93131 4.6416 7.38581C4.6416 8.84031 5.82345 10.0194 7.28134 10.0194Z" fill="#22A9E8"/>
      <path d="M7.25107 9.97511C8.70895 9.97511 9.8908 8.796 9.8908 7.3415C9.8908 5.88699 8.70895 4.70789 7.25107 4.70789C5.79318 4.70789 4.61133 5.88699 4.61133 7.3415C4.61133 8.796 5.79318 9.97511 7.25107 9.97511Z" fill="#22AAE8"/>
      <path d="M7.22079 9.94411C8.67868 9.94411 9.86053 8.765 9.86053 7.31049C9.86053 5.85599 8.67868 4.67688 7.22079 4.67688C5.76291 4.67688 4.58105 5.85599 4.58105 7.31049C4.58105 8.765 5.76291 9.94411 7.22079 9.94411Z" fill="#21AAE8"/>
      <path d="M7.17489 9.89979C8.63278 9.89979 9.81463 8.72069 9.81463 7.26618C9.81463 5.81168 8.63278 4.63257 7.17489 4.63257C5.71701 4.63257 4.53516 5.81168 4.53516 7.26618C4.53516 8.72069 5.71701 9.89979 7.17489 9.89979Z" fill="#21ABE8"/>
      <path d="M7.14462 9.86879C8.60251 9.86879 9.78436 8.68968 9.78436 7.23518C9.78436 5.78067 8.60251 4.60156 7.14462 4.60156C5.68673 4.60156 4.50488 5.78067 4.50488 7.23518C4.50488 8.68968 5.68673 9.86879 7.14462 9.86879Z" fill="#21ABE8"/>
      <path d="M7.09921 9.839C8.5571 9.839 9.73895 8.65989 9.73895 7.20539C9.73895 5.75089 8.5571 4.57178 7.09921 4.57178C5.64132 4.57178 4.45947 5.75089 4.45947 7.20539C4.45947 8.65989 5.64132 9.839 7.09921 9.839Z" fill="#21ACE8"/>
      <path d="M7.06894 9.79347C8.52682 9.79347 9.70868 8.61436 9.70868 7.15986C9.70868 5.70535 8.52682 4.52625 7.06894 4.52625C5.61105 4.52625 4.4292 5.70535 4.4292 7.15986C4.4292 8.61436 5.61105 9.79347 7.06894 9.79347Z" fill="#21ACE8"/>
      <path d="M7.03866 9.76222C8.49655 9.76222 9.6784 8.58311 9.6784 7.12861C9.6784 5.6741 8.49655 4.495 7.03866 4.495C5.58078 4.495 4.39893 5.6741 4.39893 7.12861C4.39893 8.58311 5.58078 9.76222 7.03866 9.76222Z" fill="#21ADE8"/>
      <path d="M6.99423 9.71791C8.45212 9.71791 9.63397 8.5388 9.63397 7.0843C9.63397 5.62979 8.45212 4.45068 6.99423 4.45068C5.53634 4.45068 4.35449 5.62979 4.35449 7.0843C4.35449 8.5388 5.53634 9.71791 6.99423 9.71791Z" fill="#21ADE8"/>
      <path d="M6.96396 9.6869C8.42184 9.6869 9.60369 8.50779 9.60369 7.05329C9.60369 5.59879 8.42184 4.41968 6.96396 4.41968C5.50607 4.41968 4.32422 5.59879 4.32422 7.05329C4.32422 8.50779 5.50607 9.6869 6.96396 9.6869Z" fill="#21AEE7"/>
      <path d="M6.91806 9.64113C8.37595 9.64113 9.5578 8.46202 9.5578 7.00751C9.5578 5.55301 8.37595 4.3739 6.91806 4.3739C5.46017 4.3739 4.27832 5.55301 4.27832 7.00751C4.27832 8.46202 5.46017 9.64113 6.91806 9.64113Z" fill="#21AEE7"/>
      <path d="M6.88778 9.61134C8.34567 9.61134 9.52752 8.43223 9.52752 6.97773C9.52752 5.52323 8.34567 4.34412 6.88778 4.34412C5.4299 4.34412 4.24805 5.52323 4.24805 6.97773C4.24805 8.43223 5.4299 9.61134 6.88778 9.61134Z" fill="#21AFE7"/>
      <path d="M6.84091 9.58095C8.2988 9.58095 9.48065 8.40184 9.48065 6.94733C9.48065 5.49283 8.2988 4.31372 6.84091 4.31372C5.38302 4.31372 4.20117 5.49283 4.20117 6.94733C4.20117 8.40184 5.38302 9.58095 6.84091 9.58095Z" fill="#21AFE7"/>
      <path d="M6.81064 9.53602C8.26852 9.53602 9.45037 8.35692 9.45037 6.90241C9.45037 5.44791 8.26852 4.2688 6.81064 4.2688C5.35275 4.2688 4.1709 5.44791 4.1709 6.90241C4.1709 8.35692 5.35275 9.53602 6.81064 9.53602Z" fill="#21B0E7"/>
      <path d="M6.78036 9.50477C8.23825 9.50477 9.4201 8.32567 9.4201 6.87116C9.4201 5.41666 8.23825 4.23755 6.78036 4.23755C5.32248 4.23755 4.14062 5.41666 4.14062 6.87116C4.14062 8.32567 5.32248 9.50477 6.78036 9.50477Z" fill="#21B0E7"/>
      <path d="M6.73495 9.46071C8.19284 9.46071 9.37469 8.2816 9.37469 6.82709C9.37469 5.37259 8.19284 4.19348 6.73495 4.19348C5.27707 4.19348 4.09521 5.37259 4.09521 6.82709C4.09521 8.2816 5.27707 9.46071 6.73495 9.46071Z" fill="#21B1E7"/>
      <path d="M6.70468 9.43007C8.16257 9.43007 9.34442 8.25096 9.34442 6.79645C9.34442 5.34195 8.16257 4.16284 6.70468 4.16284C5.24679 4.16284 4.06494 5.34195 4.06494 6.79645C4.06494 8.25096 5.24679 9.43007 6.70468 9.43007Z" fill="#21B1E7"/>
      <path d="M6.65878 9.38454C8.11667 9.38454 9.29852 8.20543 9.29852 6.75092C9.29852 5.29642 8.11667 4.11731 6.65878 4.11731C5.20089 4.11731 4.01904 5.29642 4.01904 6.75092C4.01904 8.20543 5.20089 9.38454 6.65878 9.38454Z" fill="#21B2E7"/>
      <path d="M6.62997 9.35475C8.08786 9.35475 9.26971 8.17564 9.26971 6.72114C9.26971 5.26663 8.08786 4.08752 6.62997 4.08752C5.17208 4.08752 3.99023 5.26663 3.99023 6.72114C3.99023 8.17564 5.17208 9.35475 6.62997 9.35475Z" fill="#21B2E7"/>
      <path d="M6.58407 9.32374C8.04196 9.32374 9.22381 8.14464 9.22381 6.69013C9.22381 5.23563 8.04196 4.05652 6.58407 4.05652C5.12619 4.05652 3.94434 5.23563 3.94434 6.69013C3.94434 8.14464 5.12619 9.32374 6.58407 9.32374Z" fill="#21B3E7"/>
      <path d="M6.5538 9.27919C8.01169 9.27919 9.19354 8.10008 9.19354 6.64558C9.19354 5.19107 8.01169 4.01196 6.5538 4.01196C5.09591 4.01196 3.91406 5.19107 3.91406 6.64558C3.91406 8.10008 5.09591 9.27919 6.5538 9.27919Z" fill="#21B3E7"/>
      <path d="M6.52353 9.24818C7.98142 9.24818 9.16327 8.06907 9.16327 6.61457C9.16327 5.16007 7.98142 3.98096 6.52353 3.98096C5.06564 3.98096 3.88379 5.16007 3.88379 6.61457C3.88379 8.06907 5.06564 9.24818 6.52353 9.24818Z" fill="#20B3E7"/>
      <path d="M6.47812 9.20265C7.936 9.20265 9.11786 8.02354 9.11786 6.56904C9.11786 5.11453 7.936 3.93542 6.47812 3.93542C5.02023 3.93542 3.83838 5.11453 3.83838 6.56904C3.83838 8.02354 5.02023 9.20265 6.47812 9.20265Z" fill="#20B4E7"/>
      <path d="M6.44736 9.17262C7.90524 9.17262 9.08709 7.99351 9.08709 6.53901C9.08709 5.0845 7.90524 3.9054 6.44736 3.9054C4.98947 3.9054 3.80762 5.0845 3.80762 6.53901C3.80762 7.99351 4.98947 9.17262 6.44736 9.17262Z" fill="#20B4E7"/>
      <path d="M6.40194 9.14308C7.85983 9.14308 9.04168 7.96397 9.04168 6.50947C9.04168 5.05496 7.85983 3.87585 6.40194 3.87585C4.94406 3.87585 3.76221 5.05496 3.76221 6.50947C3.76221 7.96397 4.94406 9.14308 6.40194 9.14308Z" fill="#20B5E7"/>
      <path d="M6.37167 9.0973C7.82956 9.0973 9.01141 7.9182 9.01141 6.46369C9.01141 5.00919 7.82956 3.83008 6.37167 3.83008C4.91378 3.83008 3.73193 5.00919 3.73193 6.46369C3.73193 7.9182 4.91378 9.0973 6.37167 9.0973Z" fill="#20B5E6"/>
      <path d="M6.32626 9.0663C7.78415 9.0663 8.966 7.88719 8.966 6.43269C8.966 4.97818 7.78415 3.79907 6.32626 3.79907C4.86837 3.79907 3.68652 4.97818 3.68652 6.43269C3.68652 7.88719 4.86837 9.0663 6.32626 9.0663Z" fill="#20B6E6"/>
      <path d="M6.29599 9.02199C7.75388 9.02199 8.93573 7.84288 8.93573 6.38837C8.93573 4.93387 7.75388 3.75476 6.29599 3.75476C4.8381 3.75476 3.65625 4.93387 3.65625 6.38837C3.65625 7.84288 4.8381 9.02199 6.29599 9.02199Z" fill="#20B6E6"/>
      <path d="M6.26523 8.99098C7.72311 8.99098 8.90496 7.81187 8.90496 6.35737C8.90496 4.90286 7.72311 3.72375 6.26523 3.72375C4.80734 3.72375 3.62549 4.90286 3.62549 6.35737C3.62549 7.81187 4.80734 8.99098 6.26523 8.99098Z" fill="#20B7E6"/>
      <path d="M6.21982 8.9452C7.6777 8.9452 8.85955 7.7661 8.85955 6.31159C8.85955 4.85709 7.6777 3.67798 6.21982 3.67798C4.76193 3.67798 3.58008 4.85709 3.58008 6.31159C3.58008 7.7661 4.76193 8.9452 6.21982 8.9452Z" fill="#20B7E6"/>
      <path d="M6.18954 8.91542C7.64743 8.91542 8.82928 7.73631 8.82928 6.28181C8.82928 4.8273 7.64743 3.64819 6.18954 3.64819C4.73166 3.64819 3.5498 4.8273 3.5498 6.28181C3.5498 7.73631 4.73166 8.91542 6.18954 8.91542Z" fill="#20B8E6"/>
      <path d="M6.14413 8.88441C7.60202 8.88441 8.78387 7.70531 8.78387 6.2508C8.78387 4.7963 7.60202 3.61719 6.14413 3.61719C4.68625 3.61719 3.50439 4.7963 3.50439 6.2508C3.50439 7.70531 4.68625 8.88441 6.14413 8.88441Z" fill="#20B8E6"/>
      <path d="M6.11386 8.8401C7.57175 8.8401 8.7536 7.66099 8.7536 6.20649C8.7536 4.75198 7.57175 3.57288 6.11386 3.57288C4.65597 3.57288 3.47412 4.75198 3.47412 6.20649C3.47412 7.66099 4.65597 8.8401 6.11386 8.8401Z" fill="#20B9E6"/>
      <path d="M6.06796 8.80885C7.52585 8.80885 8.7077 7.62974 8.7077 6.17524C8.7077 4.72073 7.52585 3.54163 6.06796 3.54163C4.61007 3.54163 3.42822 4.72073 3.42822 6.17524C3.42822 7.62974 4.61007 8.80885 6.06796 8.80885Z" fill="#20B9E6"/>
      <path d="M6.03769 8.76478C7.49557 8.76478 8.67743 7.58568 8.67743 6.13117C8.67743 4.67667 7.49557 3.49756 6.03769 3.49756C4.5798 3.49756 3.39795 4.67667 3.39795 6.13117C3.39795 7.58568 4.5798 8.76478 6.03769 8.76478Z" fill="#20BAE6"/>
      <path d="M6.00741 8.73353C7.4653 8.73353 8.64715 7.55443 8.64715 6.09992C8.64715 4.64542 7.4653 3.46631 6.00741 3.46631C4.54953 3.46631 3.36768 4.64542 3.36768 6.09992C3.36768 7.55443 4.54953 8.73353 6.00741 8.73353Z" fill="#20BAE6"/>
      <path d="M5.962 8.688C7.41989 8.688 8.60174 7.50889 8.60174 6.05439C8.60174 4.59988 7.41989 3.42078 5.962 3.42078C4.50412 3.42078 3.32227 4.59988 3.32227 6.05439C3.32227 7.50889 4.50412 8.688 5.962 8.688Z" fill="#20BBE6"/>
      <path d="M5.93124 8.65822C7.38913 8.65822 8.57098 7.47911 8.57098 6.0246C8.57098 4.5701 7.38913 3.39099 5.93124 3.39099C4.47336 3.39099 3.2915 4.5701 3.2915 6.0246C3.2915 7.47911 4.47336 8.65822 5.93124 8.65822Z" fill="#20BBE6"/>
      <path d="M5.88583 8.62697C7.34372 8.62697 8.52557 7.44786 8.52557 5.99335C8.52557 4.53885 7.34372 3.35974 5.88583 3.35974C4.42794 3.35974 3.24609 4.53885 3.24609 5.99335C3.24609 7.44786 4.42794 8.62697 5.88583 8.62697Z" fill="#20BCE6"/>
      <path d="M5.85556 8.58266C7.31345 8.58266 8.4953 7.40355 8.4953 5.94904C8.4953 4.49454 7.31345 3.31543 5.85556 3.31543C4.39767 3.31543 3.21582 4.49454 3.21582 5.94904C3.21582 7.40355 4.39767 8.58266 5.85556 8.58266Z" fill="#20BCE6"/>
      <path d="M5.82529 8.55165C7.28317 8.55165 8.46502 7.37254 8.46502 5.91804C8.46502 4.46353 7.28317 3.28442 5.82529 3.28442C4.3674 3.28442 3.18555 4.46353 3.18555 5.91804C3.18555 7.37254 4.3674 8.55165 5.82529 8.55165Z" fill="#1FBDE5"/>
      <path d="M5.77988 8.50612C7.23776 8.50612 8.41961 7.32701 8.41961 5.8725C8.41961 4.418 7.23776 3.23889 5.77988 3.23889C4.32199 3.23889 3.14014 4.418 3.14014 5.8725C3.14014 7.32701 4.32199 8.50612 5.77988 8.50612Z" fill="#1FBDE5"/>
      <path d="M5.74911 8.47694C7.207 8.47694 8.38885 7.29783 8.38885 5.84333C8.38885 4.38883 7.207 3.20972 5.74911 3.20972C4.29123 3.20972 3.10938 4.38883 3.10938 5.84333C3.10938 7.29783 4.29123 8.47694 5.74911 8.47694Z" fill="#1FBEE5"/>
      <path d="M5.7037 8.44569C7.16159 8.44569 8.34344 7.26658 8.34344 5.81208C8.34344 4.35758 7.16159 3.17847 5.7037 3.17847C4.24582 3.17847 3.06396 4.35758 3.06396 5.81208C3.06396 7.26658 4.24582 8.44569 5.7037 8.44569Z" fill="#1FBEE5"/>
      <path d="M5.67343 8.40077C7.13132 8.40077 8.31317 7.22166 8.31317 5.76716C8.31317 4.31265 7.13132 3.13354 5.67343 3.13354C4.21554 3.13354 3.03369 4.31265 3.03369 5.76716C3.03369 7.22166 4.21554 8.40077 5.67343 8.40077Z" fill="#1FBFE5"/>
      <path d="M5.62802 8.36952C7.08591 8.36952 8.26776 7.19041 8.26776 5.73591C8.26776 4.2814 7.08591 3.10229 5.62802 3.10229C4.17013 3.10229 2.98828 4.2814 2.98828 5.73591C2.98828 7.19041 4.17013 8.36952 5.62802 8.36952Z" fill="#1FBFE5"/>
      <path d="M5.59775 8.32606C7.05563 8.32606 8.23748 7.14696 8.23748 5.69245C8.23748 4.23795 7.05563 3.05884 5.59775 3.05884C4.13986 3.05884 2.95801 4.23795 2.95801 5.69245C2.95801 7.14696 4.13986 8.32606 5.59775 8.32606Z" fill="#1FC0E5"/>
      <path d="M5.56698 8.29506C7.02487 8.29506 8.20672 7.11595 8.20672 5.66145C8.20672 4.20694 7.02487 3.02783 5.56698 3.02783C4.1091 3.02783 2.92725 4.20694 2.92725 5.66145C2.92725 7.11595 4.1091 8.29506 5.56698 8.29506Z" fill="#1FC0E5"/>
      <path d="M5.52157 8.24867C6.97946 8.24867 8.16131 7.06956 8.16131 5.61506C8.16131 4.16055 6.97946 2.98145 5.52157 2.98145C4.06369 2.98145 2.88184 4.16055 2.88184 5.61506C2.88184 7.06956 4.06369 8.24867 5.52157 8.24867Z" fill="#1FC0E5"/>
      <path d="M5.4913 8.21889C6.94919 8.21889 8.13104 7.03978 8.13104 5.58527C8.13104 4.13077 6.94919 2.95166 5.4913 2.95166C4.03341 2.95166 2.85156 4.13077 2.85156 5.58527C2.85156 7.03978 4.03341 8.21889 5.4913 8.21889Z" fill="#1FC1E5"/>
      <path d="M5.44589 8.18788C6.90378 8.18788 8.08563 7.00877 8.08563 5.55427C8.08563 4.09976 6.90378 2.92065 5.44589 2.92065C3.988 2.92065 2.80615 4.09976 2.80615 5.55427C2.80615 7.00877 3.988 8.18788 5.44589 8.18788Z" fill="#1FC1E5"/>
      <path d="M5.41513 8.14418C6.87302 8.14418 8.05487 6.96507 8.05487 5.51057C8.05487 4.05606 6.87302 2.87695 5.41513 2.87695C3.95724 2.87695 2.77539 4.05606 2.77539 5.51057C2.77539 6.96507 3.95724 8.14418 5.41513 8.14418Z" fill="#1FC2E5"/>
      <path d="M5.36972 8.11317C6.82761 8.11317 8.00946 6.93406 8.00946 5.47956C8.00946 4.02506 6.82761 2.84595 5.36972 2.84595C3.91183 2.84595 2.72998 4.02506 2.72998 5.47956C2.72998 6.93406 3.91183 8.11317 5.36972 8.11317Z" fill="#1FC2E5"/>
      <path d="M5.33945 8.06679C6.79733 8.06679 7.97918 6.88768 7.97918 5.43317C7.97918 3.97867 6.79733 2.79956 5.33945 2.79956C3.88156 2.79956 2.69971 3.97867 2.69971 5.43317C2.69971 6.88768 3.88156 8.06679 5.33945 8.06679Z" fill="#1FC3E5"/>
      <path d="M5.30917 8.037C6.76706 8.037 7.94891 6.85789 7.94891 5.40339C7.94891 3.94888 6.76706 2.76978 5.30917 2.76978C3.85128 2.76978 2.66943 3.94888 2.66943 5.40339C2.66943 6.85789 3.85128 8.037 5.30917 8.037Z" fill="#1FC3E5"/>
      <path d="M5.26376 7.99147C6.72165 7.99147 7.9035 6.81236 7.9035 5.35786C7.9035 3.90335 6.72165 2.72424 5.26376 2.72424C3.80587 2.72424 2.62402 3.90335 2.62402 5.35786C2.62402 6.81236 3.80587 7.99147 5.26376 7.99147Z" fill="#1FC4E5"/>
      <path d="M5.233 7.96229C6.69089 7.96229 7.87274 6.78319 7.87274 5.32868C7.87274 3.87418 6.69089 2.69507 5.233 2.69507C3.77511 2.69507 2.59326 3.87418 2.59326 5.32868C2.59326 6.78319 3.77511 7.96229 5.233 7.96229Z" fill="#1FC4E4"/>
      <path d="M5.18759 7.93104C6.64548 7.93104 7.82733 6.75194 7.82733 5.29743C7.82733 3.84293 6.64548 2.66382 5.18759 2.66382C3.7297 2.66382 2.54785 3.84293 2.54785 5.29743C2.54785 6.75194 3.7297 7.93104 5.18759 7.93104Z" fill="#1FC5E4"/>
      <path d="M5.15732 7.88698C6.6152 7.88698 7.79705 6.70787 7.79705 5.25336C7.79705 3.79886 6.6152 2.61975 5.15732 2.61975C3.69943 2.61975 2.51758 3.79886 2.51758 5.25336C2.51758 6.70787 3.69943 7.88698 5.15732 7.88698Z" fill="#1FC5E4"/>
      <path d="M5.11191 7.85573C6.56979 7.85573 7.75164 6.67662 7.75164 5.22211C7.75164 3.76761 6.56979 2.5885 5.11191 2.5885C3.65402 2.5885 2.47217 3.76761 2.47217 5.22211C2.47217 6.67662 3.65402 7.85573 5.11191 7.85573Z" fill="#1EC6E4"/>
      <path d="M5.08261 7.80934C6.5405 7.80934 7.72235 6.63023 7.72235 5.17573C7.72235 3.72122 6.5405 2.54211 5.08261 2.54211C3.62472 2.54211 2.44287 3.72122 2.44287 5.17573C2.44287 6.63023 3.62472 7.80934 5.08261 7.80934Z" fill="#1EC6E4"/>
      <path d="M5.05234 7.78041C6.51022 7.78041 7.69207 6.6013 7.69207 5.1468C7.69207 3.69229 6.51022 2.51318 5.05234 2.51318C3.59445 2.51318 2.4126 3.69229 2.4126 5.1468C2.4126 6.6013 3.59445 7.78041 5.05234 7.78041Z" fill="#1EC7E4"/>
      <path d="M5.00546 7.74916C6.46335 7.74916 7.6452 6.57005 7.6452 5.11555C7.6452 3.66104 6.46335 2.48193 5.00546 2.48193C3.54757 2.48193 2.36572 3.66104 2.36572 5.11555C2.36572 6.57005 3.54757 7.74916 5.00546 7.74916Z" fill="#1EC7E4"/>
      <path d="M4.97519 7.70485C6.43307 7.70485 7.61493 6.52574 7.61493 5.07123C7.61493 3.61673 6.43307 2.43762 4.97519 2.43762C3.5173 2.43762 2.33545 3.61673 2.33545 5.07123C2.33545 6.52574 3.5173 7.70485 4.97519 7.70485Z" fill="#1EC8E4"/>
      <path d="M4.93075 7.67384C6.38864 7.67384 7.57049 6.49473 7.57049 5.04023C7.57049 3.58572 6.38864 2.40662 4.93075 2.40662C3.47287 2.40662 2.29102 3.58572 2.29102 5.04023C2.29102 6.49473 3.47287 7.67384 4.93075 7.67384Z" fill="#1EC8E4"/>
      <path d="M4.89902 7.62953C6.3569 7.62953 7.53875 6.45042 7.53875 4.99592C7.53875 3.54141 6.3569 2.3623 4.89902 2.3623C3.44113 2.3623 2.25928 3.54141 2.25928 4.99592C2.25928 6.45042 3.44113 7.62953 4.89902 7.62953Z" fill="#1EC9E4"/>
      <path d="M4.85507 7.59828C6.31296 7.59828 7.49481 6.41917 7.49481 4.96467C7.49481 3.51016 6.31296 2.33105 4.85507 2.33105C3.39718 2.33105 2.21533 3.51016 2.21533 4.96467C2.21533 6.41917 3.39718 7.59828 4.85507 7.59828Z" fill="#1EC9E4"/>
      <path d="M4.82431 7.55275C6.2822 7.55275 7.46405 6.37364 7.46405 4.91914C7.46405 3.46463 6.2822 2.28552 4.82431 2.28552C3.36642 2.28552 2.18457 3.46463 2.18457 4.91914C2.18457 6.37364 3.36642 7.55275 4.82431 7.55275Z" fill="#1ECAE4"/>
      <path d="M4.79306 7.52296C6.25095 7.52296 7.4328 6.34385 7.4328 4.88935C7.4328 3.43485 6.25095 2.25574 4.79306 2.25574C3.33517 2.25574 2.15332 3.43485 2.15332 4.88935C2.15332 6.34385 3.33517 7.52296 4.79306 7.52296Z" fill="#1ECAE4"/>
      <path d="M4.74765 7.49196C6.20554 7.49196 7.38739 6.31285 7.38739 4.85834C7.38739 3.40384 6.20554 2.22473 4.74765 2.22473C3.28976 2.22473 2.10791 3.40384 2.10791 4.85834C2.10791 6.31285 3.28976 7.49196 4.74765 7.49196Z" fill="#1ECBE4"/>
      <path d="M4.71835 7.44765C6.17624 7.44765 7.35809 6.26854 7.35809 4.81403C7.35809 3.35953 6.17624 2.18042 4.71835 2.18042C3.26046 2.18042 2.07861 3.35953 2.07861 4.81403C2.07861 6.26854 3.26046 7.44765 4.71835 7.44765Z" fill="#1ECBE4"/>
      <path d="M4.67294 7.41664C6.13083 7.41664 7.31268 6.23753 7.31268 4.78303C7.31268 3.32852 6.13083 2.14941 4.67294 2.14941C3.21505 2.14941 2.0332 3.32852 2.0332 4.78303C2.0332 6.23753 3.21505 7.41664 4.67294 7.41664Z" fill="#1ECCE4"/>
      <path d="M4.64218 7.37086C6.10007 7.37086 7.28192 6.19176 7.28192 4.73725C7.28192 3.28275 6.10007 2.10364 4.64218 2.10364C3.18429 2.10364 2.00244 3.28275 2.00244 4.73725C2.00244 6.19176 3.18429 7.37086 4.64218 7.37086Z" fill="#1ECCE3"/>
      <path d="M4.61191 7.34108C6.06979 7.34108 7.25164 6.16197 7.25164 4.70747C7.25164 3.25296 6.06979 2.07385 4.61191 2.07385C3.15402 2.07385 1.97217 3.25296 1.97217 4.70747C1.97217 6.16197 3.15402 7.34108 4.61191 7.34108Z" fill="#1ECCE3"/>
      <path d="M4.5665 7.29555C6.02438 7.29555 7.20623 6.11644 7.20623 4.66193C7.20623 3.20743 6.02438 2.02832 4.5665 2.02832C3.10861 2.02832 1.92676 3.20743 1.92676 4.66193C1.92676 6.11644 3.10861 7.29555 4.5665 7.29555Z" fill="#1ECDE3"/>
      <path d="M4.53622 7.26539C5.99411 7.26539 7.17596 6.08629 7.17596 4.63178C7.17596 3.17728 5.99411 1.99817 4.53622 1.99817C3.07834 1.99817 1.89648 3.17728 1.89648 4.63178C1.89648 6.08629 3.07834 7.26539 4.53622 7.26539Z" fill="#1ECDE3"/>
      <path d="M4.49032 7.23451C5.94821 7.23451 7.13006 6.0554 7.13006 4.6009C7.13006 3.14639 5.94821 1.96729 4.49032 1.96729C3.03244 1.96729 1.85059 3.14639 1.85059 4.6009C1.85059 6.0554 3.03244 7.23451 4.49032 7.23451Z" fill="#1ECEE3"/>
      <path d="M4.46005 7.19105C5.91794 7.19105 7.09979 6.01195 7.09979 4.55744C7.09979 3.10294 5.91794 1.92383 4.46005 1.92383C3.00216 1.92383 1.82031 3.10294 1.82031 4.55744C1.82031 6.01195 3.00216 7.19105 4.46005 7.19105Z" fill="#1ECEE3"/>
      <path d="M4.41464 7.15919C5.87253 7.15919 7.05438 5.98009 7.05438 4.52558C7.05438 3.07108 5.87253 1.89197 4.41464 1.89197C2.95675 1.89197 1.7749 3.07108 1.7749 4.52558C1.7749 5.98009 2.95675 7.15919 4.41464 7.15919Z" fill="#1ECFE3"/>
      <path d="M4.38437 7.1133C5.84225 7.1133 7.02411 5.93419 7.02411 4.47968C7.02411 3.02518 5.84225 1.84607 4.38437 1.84607C2.92648 1.84607 1.74463 3.02518 1.74463 4.47968C1.74463 5.93419 2.92648 7.1133 4.38437 7.1133Z" fill="#1DCFE3"/>
      <path d="M4.35409 7.08388C5.81198 7.08388 6.99383 5.90477 6.99383 4.45026C6.99383 2.99576 5.81198 1.81665 4.35409 1.81665C2.89621 1.81665 1.71436 2.99576 1.71436 4.45026C1.71436 5.90477 2.89621 7.08388 4.35409 7.08388Z" fill="#1DD0E3"/>
      <path d="M4.30819 7.03798C5.76608 7.03798 6.94793 5.85887 6.94793 4.40437C6.94793 2.94986 5.76608 1.77075 4.30819 1.77075C2.85031 1.77075 1.66846 2.94986 1.66846 4.40437C1.66846 5.85887 2.85031 7.03798 4.30819 7.03798Z" fill="#1DD0E3"/>
      <path d="M4.27792 7.0088C5.73581 7.0088 6.91766 5.82969 6.91766 4.37519C6.91766 2.92069 5.73581 1.74158 4.27792 1.74158C2.82003 1.74158 1.63818 2.92069 1.63818 4.37519C1.63818 5.82969 2.82003 7.0088 4.27792 7.0088Z" fill="#1DD1E3"/>
      <path d="M4.23251 6.97792C5.6904 6.97792 6.87225 5.79881 6.87225 4.34431C6.87225 2.8898 5.6904 1.71069 4.23251 1.71069C2.77462 1.71069 1.59277 2.8898 1.59277 4.34431C1.59277 5.79881 2.77462 6.97792 4.23251 6.97792Z" fill="#1DD1E3"/>
      <path d="M4.20224 6.93153C5.66013 6.93153 6.84198 5.75242 6.84198 4.29792C6.84198 2.84342 5.66013 1.66431 4.20224 1.66431C2.74435 1.66431 1.5625 2.84342 1.5625 4.29792C1.5625 5.75242 2.74435 6.93153 4.20224 6.93153Z" fill="#1DD2E3"/>
      <path d="M4.15634 6.90224C5.61423 6.90224 6.79608 5.72313 6.79608 4.26862C6.79608 2.81412 5.61423 1.63501 4.15634 1.63501C2.69845 1.63501 1.5166 2.81412 1.5166 4.26862C1.5166 5.72313 2.69845 6.90224 4.15634 6.90224Z" fill="#1DD2E3"/>
      <path d="M4.12607 6.8567C5.58395 6.8567 6.7658 5.67759 6.7658 4.22309C6.7658 2.76859 5.58395 1.58948 4.12607 1.58948C2.66818 1.58948 1.48633 2.76859 1.48633 4.22309C1.48633 5.67759 2.66818 6.8567 4.12607 6.8567Z" fill="#1DD3E3"/>
      <path d="M4.09579 6.82692C5.55368 6.82692 6.73553 5.64781 6.73553 4.19331C6.73553 2.7388 5.55368 1.55969 4.09579 1.55969C2.63791 1.55969 1.45605 2.7388 1.45605 4.19331C1.45605 5.64781 2.63791 6.82692 4.09579 6.82692Z" fill="#1DD3E2"/>
      <path d="M4.05038 6.79603C5.50827 6.79603 6.69012 5.61693 6.69012 4.16242C6.69012 2.70792 5.50827 1.52881 4.05038 1.52881C2.5925 1.52881 1.41064 2.70792 1.41064 4.16242C1.41064 5.61693 2.5925 6.79603 4.05038 6.79603Z" fill="#1DD4E2"/>
      <path d="M4.02011 6.7516C5.478 6.7516 6.65985 5.57249 6.65985 4.11799C6.65985 2.66348 5.478 1.48438 4.02011 1.48438C2.56222 1.48438 1.38037 2.66348 1.38037 4.11799C1.38037 5.57249 2.56222 6.7516 4.02011 6.7516Z" fill="#1DD4E2"/>
      <path d="M3.97421 6.72047C5.4321 6.72047 6.61395 5.54136 6.61395 4.08686C6.61395 2.63236 5.4321 1.45325 3.97421 1.45325C2.51632 1.45325 1.33447 2.63236 1.33447 4.08686C1.33447 5.54136 2.51632 6.72047 3.97421 6.72047Z" fill="#1DD5E2"/>
      <path d="M3.94394 6.67494C5.40182 6.67494 6.58368 5.49583 6.58368 4.04133C6.58368 2.58682 5.40182 1.40771 3.94394 1.40771C2.48605 1.40771 1.3042 2.58682 1.3042 4.04133C1.3042 5.49583 2.48605 6.67494 3.94394 6.67494Z" fill="#1DD5E2"/>
      <path d="M3.89853 6.64516C5.35641 6.64516 6.53827 5.46605 6.53827 4.01154C6.53827 2.55704 5.35641 1.37793 3.89853 1.37793C2.44064 1.37793 1.25879 2.55704 1.25879 4.01154C1.25879 5.46605 2.44064 6.64516 3.89853 6.64516Z" fill="#1DD6E2"/>
      <path d="M3.86825 6.59962C5.32614 6.59962 6.50799 5.42051 6.50799 3.96601C6.50799 2.51151 5.32614 1.3324 3.86825 1.3324C2.41037 1.3324 1.22852 2.51151 1.22852 3.96601C1.22852 5.42051 2.41037 6.59962 3.86825 6.59962Z" fill="#1DD6E2"/>
      <path d="M3.83798 6.56984C5.29587 6.56984 6.47772 5.39073 6.47772 3.93623C6.47772 2.48172 5.29587 1.30261 3.83798 1.30261C2.38009 1.30261 1.19824 2.48172 1.19824 3.93623C1.19824 5.39073 2.38009 6.56984 3.83798 6.56984Z" fill="#1DD7E2"/>
      <path d="M3.79208 6.53859C5.24997 6.53859 6.43182 5.35948 6.43182 3.90498C6.43182 2.45047 5.24997 1.27136 3.79208 1.27136C2.33419 1.27136 1.15234 2.45047 1.15234 3.90498C1.15234 5.35948 2.33419 6.53859 3.79208 6.53859Z" fill="#1DD7E2"/>
      <path d="M3.76181 6.49415C5.2197 6.49415 6.40155 5.31505 6.40155 3.86054C6.40155 2.40604 5.2197 1.22693 3.76181 1.22693C2.30392 1.22693 1.12207 2.40604 1.12207 3.86054C1.12207 5.31505 2.30392 6.49415 3.76181 6.49415Z" fill="#1DD8E2"/>
      <path d="M3.7164 6.46327C5.17429 6.46327 6.35614 5.28416 6.35614 3.82966C6.35614 2.37515 5.17429 1.19604 3.7164 1.19604C2.25851 1.19604 1.07666 2.37515 1.07666 3.82966C1.07666 5.28416 2.25851 6.46327 3.7164 6.46327Z" fill="#1DD8E2"/>
      <path d="M3.68612 6.41774C5.14401 6.41774 6.32586 5.23863 6.32586 3.78413C6.32586 2.32962 5.14401 1.15051 3.68612 1.15051C2.22824 1.15051 1.04639 2.32962 1.04639 3.78413C1.04639 5.23863 2.22824 6.41774 3.68612 6.41774Z" fill="#1CD9E2"/>
      <path d="M3.64023 6.38795C5.09811 6.38795 6.27996 5.20884 6.27996 3.75434C6.27996 2.29984 5.09811 1.12073 3.64023 1.12073C2.18234 1.12073 1.00049 2.29984 1.00049 3.75434C1.00049 5.20884 2.18234 6.38795 3.64023 6.38795Z" fill="#1CD9E2"/>
      <path d="M3.60995 6.34206C5.06784 6.34206 6.24969 5.16295 6.24969 3.70844C6.24969 2.25394 5.06784 1.07483 3.60995 1.07483C2.15207 1.07483 0.970215 2.25394 0.970215 3.70844C0.970215 5.16295 2.15207 6.34206 3.60995 6.34206Z" fill="#1CD9E2"/>
      <path d="M3.57968 6.31227C5.03757 6.31227 6.21942 5.13316 6.21942 3.67866C6.21942 2.22415 5.03757 1.04504 3.57968 1.04504C2.12179 1.04504 0.939941 2.22415 0.939941 3.67866C0.939941 5.13316 2.12179 6.31227 3.57968 6.31227Z" fill="#1CDAE2"/>
      <path d="M3.53427 6.282C4.99216 6.282 6.17401 5.10289 6.17401 3.64838C6.17401 2.19388 4.99216 1.01477 3.53427 1.01477C2.07638 1.01477 0.894531 2.19388 0.894531 3.64838C0.894531 5.10289 2.07638 6.282 3.53427 6.282Z" fill="#1CDAE2"/>
      <path d="M3.504 6.23549C4.96188 6.23549 6.14373 5.05638 6.14373 3.60187C6.14373 2.14737 4.96188 0.968262 3.504 0.968262C2.04611 0.968262 0.864258 2.14737 0.864258 3.60187C0.864258 5.05638 2.04611 6.23549 3.504 6.23549Z" fill="#1CDBE1"/>
      <path d="M3.4581 6.2057C4.91598 6.2057 6.09784 5.02659 6.09784 3.57209C6.09784 2.11759 4.91598 0.938477 3.4581 0.938477C2.00021 0.938477 0.818359 2.11759 0.818359 3.57209C0.818359 5.02659 2.00021 6.2057 3.4581 6.2057Z" fill="#1CDBE1"/>
      <path d="M3.42782 6.16017C4.88571 6.16017 6.06756 4.98106 6.06756 3.52656C6.06756 2.07205 4.88571 0.892944 3.42782 0.892944C1.96994 0.892944 0.788086 2.07205 0.788086 3.52656C0.788086 4.98106 1.96994 6.16017 3.42782 6.16017Z" fill="#1CDCE1"/>
      <path d="M3.38241 6.131C4.8403 6.131 6.02215 4.95189 6.02215 3.49738C6.02215 2.04288 4.8403 0.86377 3.38241 0.86377C1.92453 0.86377 0.742676 2.04288 0.742676 3.49738C0.742676 4.95189 1.92453 6.131 3.38241 6.131Z" fill="#1CDCE1"/>
      <path d="M3.35214 6.10011C4.81003 6.10011 5.99188 4.921 5.99188 3.4665C5.99188 2.01199 4.81003 0.832886 3.35214 0.832886C1.89425 0.832886 0.712402 2.01199 0.712402 3.4665C0.712402 4.921 1.89425 6.10011 3.35214 6.10011Z" fill="#1CDDE1"/>
      <path d="M3.32187 6.05519C4.77975 6.05519 5.96161 4.87608 5.96161 3.42158C5.96161 1.96707 4.77975 0.787964 3.32187 0.787964C1.86398 0.787964 0.682129 1.96707 0.682129 3.42158C0.682129 4.87608 1.86398 6.05519 3.32187 6.05519Z" fill="#1CDDE1"/>
      <path d="M3.27597 6.02394C4.73386 6.02394 5.91571 4.84483 5.91571 3.39033C5.91571 1.93582 4.73386 0.756714 3.27597 0.756714C1.81808 0.756714 0.63623 1.93582 0.63623 3.39033C0.63623 4.84483 1.81808 6.02394 3.27597 6.02394Z" fill="#1CDEE1"/>
      <path d="M3.2457 5.97841C4.70358 5.97841 5.88543 4.7993 5.88543 3.34479C5.88543 1.89029 4.70358 0.711182 3.2457 0.711182C1.78781 0.711182 0.605957 1.89029 0.605957 3.34479C0.605957 4.7993 1.78781 5.97841 3.2457 5.97841Z" fill="#1CDEE1"/>
      <path d="M3.20126 5.94911C4.65915 5.94911 5.841 4.77 5.841 3.3155C5.841 1.86099 4.65915 0.681885 3.20126 0.681885C1.74337 0.681885 0.561523 1.86099 0.561523 3.3155C0.561523 4.77 1.74337 5.94911 3.20126 5.94911Z" fill="#1CDFE1"/>
      <path d="M3.17001 5.90272C4.6279 5.90272 5.80975 4.72362 5.80975 3.26911C5.80975 1.81461 4.6279 0.635498 3.17001 0.635498C1.71212 0.635498 0.530273 1.81461 0.530273 3.26911C0.530273 4.72362 1.71212 5.90272 3.17001 5.90272Z" fill="#1CDFE1"/>
      <path d="M3.13974 5.87331C4.59762 5.87331 5.77948 4.6942 5.77948 3.23969C5.77948 1.78519 4.59762 0.606079 3.13974 0.606079C1.68185 0.606079 0.5 1.78519 0.5 3.23969C0.5 4.6942 1.68185 5.87331 3.13974 5.87331Z" fill="#1CE0E1"/>
      <path d="M3.0953 5.84205C4.55319 5.84205 5.73504 4.66295 5.73504 3.20844C5.73504 1.75394 4.55319 0.574829 3.0953 0.574829C1.63742 0.574829 0.455566 1.75394 0.455566 3.20844C0.455566 4.66295 1.63742 5.84205 3.0953 5.84205Z" fill="#1CE0E1"/>
      <path d="M3.06454 5.79652C4.52243 5.79652 5.70428 4.61741 5.70428 3.16291C5.70428 1.70841 4.52243 0.529297 3.06454 0.529297C1.60666 0.529297 0.424805 1.70841 0.424805 3.16291C0.424805 4.61741 1.60666 5.79652 3.06454 5.79652Z" fill="#1CE1E1"/>
      <path d="M3.01913 5.76735C4.47702 5.76735 5.65887 4.58824 5.65887 3.13374C5.65887 1.67923 4.47702 0.500122 3.01913 0.500122C1.56125 0.500122 0.379395 1.67923 0.379395 3.13374C0.379395 4.58824 1.56125 5.76735 3.01913 5.76735Z" fill="#1CE1E1"/>
      <path d="M2.98886 5.72169C4.44675 5.72169 5.6286 4.54259 5.6286 3.08808C5.6286 1.63358 4.44675 0.454468 2.98886 0.454468C1.53097 0.454468 0.349121 1.63358 0.349121 3.08808C0.349121 4.54259 1.53097 5.72169 2.98886 5.72169Z" fill="#1BE2E1"/>
      <path d="M2.94198 5.69166C4.39987 5.69166 5.58172 4.51256 5.58172 3.05805C5.58172 1.60355 4.39987 0.424438 2.94198 0.424438C1.4841 0.424438 0.302246 1.60355 0.302246 3.05805C0.302246 4.51256 1.4841 5.69166 2.94198 5.69166Z" fill="#1BE2E1"/>
      <path d="M2.91171 5.64552C4.3696 5.64552 5.55145 4.46641 5.55145 3.01191C5.55145 1.5574 4.3696 0.378296 2.91171 0.378296C1.45382 0.378296 0.271973 1.5574 0.271973 3.01191C0.271973 4.46641 1.45382 5.64552 2.91171 5.64552Z" fill="#1BE3E0"/>
      <path d="M2.88241 5.61635C4.3403 5.61635 5.52215 4.43724 5.52215 2.98273C5.52215 1.52823 4.3403 0.349121 2.88241 0.349121C1.42453 0.349121 0.242676 1.52823 0.242676 2.98273C0.242676 4.43724 1.42453 5.61635 2.88241 5.61635Z" fill="#1BE3E0"/>
      <path d="M2.83603 5.58546C4.29391 5.58546 5.47577 4.40635 5.47577 2.95185C5.47577 1.49735 4.29391 0.318237 2.83603 0.318237C1.37814 0.318237 0.196289 1.49735 0.196289 2.95185C0.196289 4.40635 1.37814 5.58546 2.83603 5.58546Z" fill="#1BE4E0"/>
      <path d="M2.80673 5.53956C4.26462 5.53956 5.44647 4.36046 5.44647 2.90595C5.44647 1.45145 4.26462 0.272339 2.80673 0.272339C1.34884 0.272339 0.166992 1.45145 0.166992 2.90595C0.166992 4.36046 1.34884 5.53956 2.80673 5.53956Z" fill="#1BE4E0"/>
      <path d="M2.76132 5.51015C4.21921 5.51015 5.40106 4.33104 5.40106 2.87653C5.40106 1.42203 4.21921 0.24292 2.76132 0.24292C1.30343 0.24292 0.121582 1.42203 0.121582 2.87653C0.121582 4.33104 1.30343 5.51015 2.76132 5.51015Z" fill="#1BE5E0"/>
      <path d="M2.73105 5.46364C4.18893 5.46364 5.37078 4.28453 5.37078 2.83002C5.37078 1.37552 4.18893 0.196411 2.73105 0.196411C1.27316 0.196411 0.0913086 1.37552 0.0913086 2.83002C0.0913086 4.28453 1.27316 5.46364 2.73105 5.46364Z" fill="#1BE5E0"/>
      <path d="M2.68515 5.43446C4.14304 5.43446 5.32489 4.25535 5.32489 2.80085C5.32489 1.34635 4.14304 0.167236 2.68515 0.167236C1.22726 0.167236 0.0454102 1.34635 0.0454102 2.80085C0.0454102 4.25535 1.22726 5.43446 2.68515 5.43446Z" fill="#1BE6E0"/>
      <path d="M2.65487 5.40358C4.11276 5.40358 5.29461 4.22447 5.29461 2.76997C5.29461 1.31546 4.11276 0.136353 2.65487 0.136353C1.19699 0.136353 0.0151367 1.31546 0.0151367 2.76997C0.0151367 4.22447 1.19699 5.40358 2.65487 5.40358Z" fill="#1BE6E0"/>
      <path d="M2.62803 4.44104C2.14509 4.44104 1.74089 4.27868 1.41543 3.95398C1.08998 3.62928 0.927246 3.22602 0.927246 2.7442C0.927246 2.26238 1.08998 1.85912 1.41543 1.53442C1.74089 1.20971 2.14509 1.04736 2.62803 1.04736C3.12147 1.04736 3.52566 1.20971 3.84062 1.53442C4.16608 1.85912 4.32881 2.26238 4.32881 2.7442C4.32881 3.22602 4.16608 3.62928 3.84062 3.95398C3.52566 4.27868 3.12147 4.44104 2.62803 4.44104Z" fill="white"/>
      <path d="M5.30982 11.2308C5.30982 9.76792 4.12117 8.58203 2.65491 8.58203C1.18864 8.58203 0 9.76792 0 11.2308V15.4082C0 16.8711 1.18864 18.057 2.65491 18.057C4.12117 18.057 5.30982 16.8711 5.30982 15.4082V11.2308Z" fill="url(#paint0_linear_3224_199596)"/>
      </g>
      <defs>
      <linearGradient id="paint0_linear_3224_199596" x1="2.65491" y1="18.057" x2="2.65491" y2="8.58203" gradientUnits="userSpaceOnUse">
      <stop stop-color="#2A5CF2"/>
      <stop offset="1" stop-color="#1BE6E0"/>
      </linearGradient>
      <clipPath id="clip0_3224_199596">
      <rect width="17.9927" height="17.9358" fill="white" transform="translate(0 0.121704)"/>
      </clipPath>
      </defs>
      </svg>
      <div class="simplyin-banner-logo-after"></div>
      </div>
      `;

      if (isBlockCheckout) {
        $("#contact").prepend(`
            <div class="simplyin-logo-container">
        <div class="simplyin-logo-inner">
          <div class="simplyin-logo-svg-wrap">
            ${logoBigEl}
          </div>
        </div>
      </div>
        `);
      } else {
        $(email_field).parent().parent().prepend(`
            <div class="simplyin-logo-container">
        <div class="simplyin-logo-inner">
          <div class="simplyin-logo-svg-wrap">
            ${logoBigEl}
          </div>
        </div>
      </div>
        `);
      }
    },
    initEventListeners: function () {
      const self = this;

      $(document).on(
        "click",
        ".simplyin-popup-close-button, .simplyin-popup-overlay",
        function () {
          self.hidePopup();
        }
      );

      if (isBlockCheckout) {
        $(document).on("click", ".simplyin-show-popup", function () {
          self.showLastPopup();
          self.updateDeliveryCosts();
        });
      } else {
        $(".simplyin-show-popup").on("click", function () {
          self.showLastPopup();
          self.updateDeliveryCosts();
        });
      }

      $(document).on("input", this.email_field, function () {
        let logout = false;
        if (self.is_login && self.customer_email != $(this).val()) {
          logout = true;
        }
        self.customer_email = $.trim($(this).val());
        self.submitEmail(logout);

        if (isBlockCheckout && logout) {
          self.getBlocksPaymentMethods();
        }

        if (!isBlockCheckout && logout) {
          self.forceUpdateClassicCheckout();
        }
      });
      $(document).on("click", "#simplyin-button-send-sms", function () {
        self.sendSmsCode();
        self.stopPushNotifications();
      });
      $(document).on("click", "#simplyin-button-send-email", function () {
        self.sendEmailCode();
        self.stopPushNotifications();
      });
    },
    toggleElement: function (selector, target, show) {
      let element = $("#" + target + " " + selector);
      if (show) {
        $(element).slideDown({ duration: 150 });
      } else {
        $(element).slideUp({ duration: 150 });
      }
    },
    positionMenu: function (button, menu) {
      let offset = button.offset();
      let buttonHeight = button.outerHeight();
      let isMobile = window.innerWidth <= 768;

      if (isMobile) {
        menu.css({
          top: offset.top + buttonHeight + "px",
          right: "0px",
          zIndex: 20009999,
        });
      } else {
        menu.css({
          top: offset.top + buttonHeight + "px",
          left: offset.left + "px",
          zIndex: 20009999,
        });
      }
    },
    toggleDeliveryAddress: function (btn) {
      const self = this;
      let target = $(btn).data("target");
      let expanded = $(btn).is(".expanded");
      let checked = $(
        '.popup-address-select-label-group input[type="checkbox"]'
      ).is(":checked");
      self.toggleElement(".popup-address-select-group", target, expanded);
      self.toggleElement(
        ".popup-selected-address-group",
        target,
        !expanded && !checked
      );
    },
    initEventListenersPin: function () {
      const self = this;
      var selector = '#simplyin-input-code input[type="text"]';
      $(document).on("keypress", selector, function (e) {
        if (!/[0-9]/.test(e.key)) e.preventDefault();
      });
      $(document).on("input", selector, function () {
        var $all = $(selector),
          idx = $all.index(this),
          val = this.value;

        val = val.replace(/\D/g, "");

        if (val.length > 1) {
          for (let i = 0; i < val.length && idx + i < $all.length; i++) {
            $all.eq(idx + i).val(val[i]);
          }
          let nextFocus =
            idx + val.length < $all.length ? idx + val.length : $all.length - 1;
          $all.eq(nextFocus).focus().select();
        } else {
          this.value = val;

          if (val.length === 1 && idx < $all.length - 1) {
            $all
              .eq(idx + 1)
              .focus()
              .select();
          }
        }
        self.validatePinCode();
      });

      $(document).on("keydown", selector, function (e) {
        var $all = $(selector),
          idx = $all.index(this);

        switch (e.key) {
          case "Backspace":
            e.preventDefault();

            this.value = "";
            if (idx > 0) {
              var $prev = $all.eq(idx - 1);
              $prev.focus().select();
            }
            break;

          case "ArrowLeft":
            if (idx > 0) {
              e.preventDefault();
              var $prev = $all.eq(idx - 1);
              $prev.focus().select();
            }
            break;

          case "ArrowRight":
            if (idx < $all.length - 1) {
              e.preventDefault();
              var $next = $all.eq(idx + 1);
              $next.focus().select();
            }
            break;
        }
      });

      $(document).on("paste", selector, function (e) {
        e.preventDefault();

        const clip =
          (e.originalEvent || e).clipboardData || window.clipboardData;
        if (!clip) return;

        const digits = (clip.getData("text") || "").replace(/\D/g, "");
        if (!digits) return;

        const $all = $(selector);
        let idx = $all.index(this);

        for (let i = 0; i < digits.length && idx < $all.length; i++, idx++) {
          $all.eq(idx).val(digits[i]);
        }

        const $empties = $all.filter((_, el) => el.value === "");

        self.validatePinCode();
      });

      $(document).on("keyup", selector, self.validatePinCode);
    },
    removeContextMenu: function () {
      $(".dropdown-actions-menu").remove();
      $(".simplyin-popup-overlay-context").remove();
    },
    deleteAddress: function (id) {
      const self = this;
      self.removeContextMenu();
      const callback = function () {
        let params = {
          action: "simplyin_delete_address",
          ajax: 1,
          ajax_token: simplyin.ajax_token,
          id: id,
        };
        $.ajax({
          url: self.ajax,
          method: "POST",
          data: params,
          dataType: "json",
        }).done((data) => {
          if (data.success) {
            const el = $(`.popup-address-select[data-id="${id}"]`);

            if (el.parent().hasClass("popup-address-select-group-invoice")) {
              el.parent().remove();
            } else {
              el.remove();
            }

            self.removeContextMenu();
            self.checkSelectedAddress();
            self.last_popup = "";
          }
        });
      };
      self.confirmationPopup(
        simplyin.labels.delete_header,
        simplyin.labels.confirm_delete,
        callback
      );
    },
    initEventListenersDelivery: function () {
      const self = this;

      $(document).on(
        "change",
        '#simplyin-parcel-lockers input[name="simplyin-parcel-locker-selected"],#simplyin-delivery-points input[name="simplyin-delivery-point-selected"]',
        function () {
          $(
            "#popup-delivery-parcel-locker-address .popup-selected-address .popup-address-label-line-1"
          ).html($(this).data("address-1"));
          if ($(this).attr("name") == "simplyin-delivery-point-selected") {
            $('input[name="simplyin-parcel-locker-selected"]').prop(
              "checked",
              false
            );
          } else {
            $('input[name="simplyin-delivery-point-selected"]').prop(
              "checked",
              false
            );
          }
        }
      );

      $(document).on(
        "change",
        'input[name="simplyin-invoice-address"]',
        function () {
          $(
            "#popup-invoice-address .popup-selected-address .popup-selected-address-line-1"
          ).html($(this).data("address-1"));
          $(
            "#popup-invoice-address .popup-selected-address .popup-selected-address-line-2"
          ).html($(this).data("address-2"));
        }
      );

      $(document).on(
        "change",
        'input[name="simplyin-delivery-address"]',
        function () {
          $(
            "#popup-delivery-address .popup-selected-address .popup-selected-address-line-1"
          ).html($(this).data("address-1"));
          $(
            "#popup-delivery-address .popup-selected-address .popup-selected-address-line-2"
          ).html($(this).data("address-2"));
        }
      );

      $(document).on("click", function () {
        self.removeContextMenu();
      });

      $(document).on("click", ".simplyin-button-edit", function (e) {
        e.stopPropagation();
        self.removeContextMenu();
        self.editAddress($(this).data("id"));
      });

      $(document).on("click", ".simplyin-button-delete", function (e) {
        e.stopPropagation();
        let id = $(this).data("id");
        self.deleteAddress(id);
      });

      // show menu actions
      $(document).on("click", ".popup-address-actions", function (e) {
        e.stopPropagation();
        self.removeContextMenu();
        let items_count = $(this)
          .parents(".popup-address-selector")
          .find(".popup-address-select").length;
        let action_edit = parseInt(
          $(this).parents(".popup-address-selector").data("edit")
        );
        let action_delete = parseInt(
          $(this).parents(".popup-address-selector").data("delete")
        );
        let force_delete = parseInt(
          $(this).parents(".popup-address-selector").data("force-delete")
        );
        let edit_label = simplyin.labels.edit;
        let delete_label = simplyin.labels.delete;
        let menu = $(`<div class="dropdown-actions-menu"><ul></ul></div>`);
        let item_id = $(this).parents(".popup-address-select").data("id");
        if (!action_edit && !action_delete) {
          return;
        }
        if (action_edit) {
          $(menu).find("ul").append(`
                      <li class="simplyin-button-edit edit-action" data-id="${item_id}">
                          <img width="23" height="24"  src="${simplyin.files_url}/public/img/edit_icon.svg" alt="${edit_label}" />
                          ${edit_label}
                      </li>
                  `);
        }
        if ((items_count > 1 && action_delete) || force_delete) {
          $(menu).find("ul").append(`
                      <li class="simplyin-button-delete delete-action" data-id="${item_id}">
                          <img width="24" height="24" src="${simplyin.files_url}/public/img/trash_icon.svg" alt="Usuń" />
                          Usuń
                      </li>
                  `);
        }
        if (items_count >= 1 && (action_edit || action_delete)) {
          if ($(menu).find("li").length > 0) {
            $(".simplyin-popup").parent().append(menu);
            SimplyIn.positionMenu($(this), menu);
          }
        }
      });

      // addresses invoice neq delivery
      $(document).on(
        "change",
        '.popup-address-select-label-group input[type="checkbox"]',
        function (e) {
          e.preventDefault();
          const btn = $(
            '.popup-button-expand[data-target="popup-delivery-address"]'
          )[0];
          let checked = $(this)
            .parents(".popup-address-select-label-group")
            .find('input[type="checkbox"]')
            .is(":checked");
          let button_label = $(
            '.popup-button-expand[data-target="popup-delivery-address"]'
          );
          if (!checked && !button_label.is(".expanded")) {
            button_label.addClass("expanded");
          } else {
            button_label.removeClass("expanded");
          }
          if (!checked) {
            $("#popup-delivery-address")
              .find('input[type="radio"]:first')
              .prop("checked", true);
          } else {
            $("#popup-delivery-address")
              .find('input[type="radio"]')
              .prop("checked", false);
          }
          self.toggleDeliveryAddress(btn);
          return false;
        }
      );

      // hide context menu on resize
      $(window).on("resize", function () {
        self.removeContextMenu();
      });

      // select carrier delivery or parcel
      $(document).on("change", ".simplyin-delivery-type", function (e) {
        e.preventDefault();
        if ($(this).val() == "address") {
          $(".popup-delivery-address-box").show();
          $(".popup-delivery-parcel-locker-box").hide();
        } else {
          $(".popup-delivery-parcel-locker-box .popup-button-expand").addClass(
            "expanded"
          );
          $(".popup-delivery-address-box").hide();
          $(".popup-delivery-parcel-locker-box").show();
        }
      });

      // toggle invoice address
      $(document).on(
        "click",
        '.popup-button-expand[data-target="popup-invoice-address"]',
        function (e) {
          e.preventDefault();
          let target = $(this).data("target");
          let expanded = $(this).is(".expanded");

          $(this).toggleClass("expanded");
          self.toggleElement(".popup-address-select-group", target, !expanded);
          self.toggleElement(".popup-selected-address-group", target, expanded);
        }
      );

      // toggle parcel locker
      $(document).on(
        "click",
        '.popup-button-expand[data-target="popup-delivery-parcel-locker-address"]',
        function (e) {
          e.preventDefault();
          let target = $(this).data("target");
          let fields_to_show = $(
            ".popup-address-selector-header button.active"
          ).data("target");
          let fields_to_hide = $(
            ".popup-address-selector-header button:not(.active)"
          ).data("target");
          $(this).toggleClass("expanded");
          let expanded = $(this).is(".expanded");
          self.toggleElement(".popup-address-select-group", target, expanded);
          self.toggleElement(
            ".popup-selected-address-group",
            target,
            !expanded
          );
          $("#" + fields_to_show).show();
          $("#" + fields_to_hide).hide();
        }
      );

      // toggle delivery address
      $(document).on(
        "click",
        '.popup-button-expand[data-target="popup-delivery-address"]',
        function (e) {
          e.preventDefault();
          $(this).toggleClass("expanded");
          self.toggleDeliveryAddress(this);
        }
      );

      // remove checkbox delivery eq invoice
      $(document).on(
        "change",
        '#popup-delivery-address input[type="radio"]',
        function (e) {
          e.preventDefault();
          $('.popup-address-select-label-group input[type="checkbox"]').prop(
            "checked",
            false
          );
        }
      );

      // switch parcel / delivery point
      $(document).on(
        "click",
        ".popup-address-selector-header button",
        function (e) {
          e.preventDefault();
          $(".popup-delivery-parcel-locker-box .popup-button-expand").addClass(
            "expanded"
          );
          let target = $(this).data("target");
          $(this).addClass("active").siblings().removeClass("active");
          $("#" + target)
            .show()
            .siblings()
            .hide();
        }
      );

      $(document).on("click", ".popup-address-actions-add", function (e) {
        e.preventDefault();
        let target = $(this).data("type");
        self.storeDeliveryPopup();
        var params = {
          action: "simplyin_add_address",
          ajax: 1,
          ajax_token: simplyin.ajax_token,
          address_type: target,
        };

        $.ajax({
          url: self.ajax,
          method: "POST",
          data: params,
          dataType: "json",
        }).done((data) => {
          if (data.success) {
            self.showPopupByContent(data.html);
            self.initAutocomplete();
            $("#pickup-search").focus();
          }
        });
      });

      $(document).on("click", ".popup-select-address", function () {
        self.selectAddress();
      });
    },
    initAutocomplete: function () {
      const self = this;
      const input = $(".simplyin-autocomplete #pickup-search");

      input.autocomplete({
        source: function (request, response) {
          self.fetchAddressSuggestions(request, response);
        },
        minLength: 3,
        select: function (event, ui) {
          self.handleSelect(event, ui);
        },
        focus: function (event, ui) {
          event.preventDefault();
        },
        open: function () {
          const $autocompleteList = input.autocomplete("widget");
          $autocompleteList.addClass("autocomplete-dropdown");
          $autocompleteList.css("z-index", 20009999);
          $autocompleteList.css("width", input.outerWidth());
        },
      });
    },

    fetchAddressSuggestions: function (request, response) {
      const self = this;

      $.ajax({
        url: self.ajax,
        method: "POST",
        data: {
          action: "simplyin_search_address",
          ajax: 1,
          ajax_token: simplyin.ajax_token,
          address: request.term,
        },
        dataType: "json",
        success: function (data) {
          if (data && data.addresses) {
            const suggestions = self.mapAddressData(data.addresses);
            response(suggestions);
          }
        },
      });
    },

    mapAddressData: function (data) {
      return data.map(function (item) {
        return {
          label: item.formatted_address,
          value: item.formatted_address,
          place_id: item.place_id,
          geometry: item.geometry,
        };
      });
    },
    handleSelect: function (event, ui) {
      const self = this;
      $('.simplyin-pickup-list-item input[name="pickup-option"]').val(
        ui.item.value
      );
      let lat = ui.item.geometry.location.lat;
      let lng = ui.item.geometry.location.lng;

      let params = {
        action: "simplyin_get_closest_parcel_lockers",
        ajax: 1,
        ajax_token: simplyin.ajax_token,
        coordinates: {
          lat: lat,
          lng: lng,
        },
      };

      $.ajax({
        url: SimplyIn.ajax,
        method: "POST",
        data: params,
        dataType: "json",
      }).done((data) => {
        if (data.success) {
          self.fillParcelsList(data);
        }
      });
    },
    initEventListenersEditAddress: function () {
      const self = this;
      $(document).on(
        "click",
        ".simplyin-popup-addres-form button.simplyin-cancel",
        function (e) {
          e.preventDefault();
          self.retrieveDeliveryPopup();
        }
      );

      $(document).on(
        "click",
        ".simplyin-popup-addres-form button.simplyin-submit",
        function (e) {
          e.preventDefault();
          self.submitAddress();
        }
      );
    },
    clearParcelsList: function () {
      $(".pickup-placeholder").show();
      $(".pickup-list-container").empty().hide();
    },
    fillParcelsList: function (data) {
      const self = this;
      if (data.data.parcels.length > 0) {
        let html = "";
        $.each(data.data.parcels, function (index, item) {
          let locker = item.locker;
          let info = item.info;
          let address = locker.address;
          let distance = Math.round(info.distance * 1000);
          let provider = info.provider;
          let desc = locker.desc;
          html += `
                      <div class="simplyin-pickup-list-item">
                          <label class="pickup-item">
                              <input
                                  type="radio"
                                  name="pickup-option"
                                  value="${locker._id}"
                                  data-id="${locker.lockerId}"
                                  data-address="${address}"
                                  data-desc="${desc}"
                                  data-locker-id="${locker.lockerId}"
                                  data-logo-url="${provider.logoUrl}"
                                  data-label="${provider.name}"
                                  data-provider-id="${locker.providerId}"
                                  data-service-type="${locker.service_type}"
                              >
                              <div class="pickup-info">
                                  <img src="${provider.logoUrl}" alt="${provider.name}">
                                  <div class="pickup-details">
                                      <strong>${locker.lockerId}</strong>
                                      <span>${address}</span>
                                      <span>${simplyin.labels.distance}: ${distance} m</span>
                                  </div>
                              </div>
                          </label>
                      </div>
                  `;
        });
        self.clearParcelsList();
        $(".pickup-list-container").html(html);
        $(".pickup-placeholder").hide();
        $(".pickup-list-container").show();
      } else {
        self.clearParcelsList();
      }
    },
    selectNewParcel: function (el) {
      const self = this;
      let locker = $(el).data("id");
      let address = $(el).data("address");
      let desc = $(el).data("desc");
      $("#simplyin-pickup-number").html(locker);
      $("#simplyin-pickup-address").html(address);
      $("#simplyin-pickup-info").html(desc);
    },
    initEventListenersAddParcelLocker: function () {
      const self = this;
      $(document).on(
        "change",
        '.simplyin-pickup-list-item input[name="pickup-option"]',
        function () {
          self.selectNewParcel(this);
        }
      );

      $(document).on(
        "click",
        ".simplyin-autocomplete button.simplyin-cancel",
        function (e) {
          e.preventDefault();
          self.retrieveDeliveryPopup();
          $('input[name="simplyin-delivery-type"][value="parcel_locker"]').prop(
            "checked",
            true
          );
        }
      );

      $(document).on(
        "click",
        ".simplyin-autocomplete button.simplyin-submit",
        function (e) {
          e.preventDefault();
          const $checked_option = $('input[name="pickup-option"]:checked');
          if ($checked_option.length) {
            self.addNewParcelLocker($checked_option);
            $(
              'input[name="simplyin-delivery-type"][value="parcel_locker"]'
            ).prop("checked", true);
          }
        }
      );

      $(document).on(
        "enter",
        '.simplyin-popup input[name="pickup-name"]',
        function (e) {
          const $checked_option = $('input[name="pickup-option"]:checked');
          if ($checked_option.length) {
            self.addNewParcelLocker($checked_option);
          }
        }
      );
    },
    addNewParcelLocker: function (obj) {
      const self = this;
      let params = {
        action: "simplyin_submit_address",
        ajax: 1,
        ajax_token: simplyin.ajax_token,
        parcel: {
          address_type: "parcelLockers",
          _id: $(obj).val(),
          logoUrl: $(obj).data("logoUrl"),
          addressName: $.trim($("#pickup-name").val())
            ? $.trim($("#pickup-name").val())
            : obj.data("id"),
          lockerId: obj.data("id"),
          address: obj.data("address"),
          label: obj.data("label"),
          providerId: obj.data("providerId"),
          service_type: obj.data("service-type"),
        },
      };

      $.ajax({
        url: SimplyIn.ajax,
        method: "POST",
        data: params,
        dataType: "json",
      }).done((data) => {
        if (data.success) {
          if (typeof data.html != "undefined") {
            let html = $(data.html);
            let points = html.find("#simplyin-delivery-points").html();
            let lockers = html.find("#simplyin-parcel-lockers").html();
            self.retrieveDeliveryPopup();
            $("#simplyin-parcel-lockers").html(lockers);
            $("#simplyin-delivery-points").html(points);
            self.filterAvailableProvidersInPopup();
            self.updateDeliveryCosts();
          }
        }
      });
    },
    submitAddress: function (e) {
      const self = this;
      let form = $("form.simplyin-popup-addres-form");
      let required_fields = form.find("input[required]");
      let is_valid = true;
      $.each(required_fields, function (index, field) {
        if ($(field).val() == "") {
          $(field).parents(".form-group").addClass("error");
          is_valid = false;
        } else {
          $(field).parents(".form-group").removeClass("error");
        }
      });
      if (!is_valid) {
        return false;
      }

      let params = {
        action: "simplyin_submit_address",
        ajax: 1,
        ajax_token: simplyin.ajax_token,
      };
      var form_data = new FormData();
      $.each(params, function (key, value) {
        form_data.append(key, value);
      });
      $.each(form[0].elements, function (index, field) {
        if (field.name != "") {
          form_data.append("address[" + field.name + "]", field.value);
        }
      });

      $.ajax({
        url: this.ajax,
        method: "POST",
        data: form_data,
        processData: false,
        contentType: false,
        dataType: "json",
      }).done((data) => {
        if (data.success) {
          if (data.is_valid !== true && typeof data.is_valid == "object") {
            form.find(".form-group").removeClass("error");
            $.each(data.is_valid, function (index, field) {
              form
                .find('input[name="' + index + '"]')
                .parents(".form-group")
                .addClass("error");
              form
                .find('input[name="' + index + '"]')
                .parents(".form-group")
                .find(".error-message")
                .html(data.is_valid[index]);
            });
          } else if (
            data.is_valid === true &&
            typeof data.address != "undefined"
          ) {
            self.retrieveDeliveryPopup();
            self.upgradeAddress(data.address);
          } else if (
            data.is_valid === true &&
            typeof data.add_address != "undefined"
          ) {
            self.retrieveDeliveryPopup();
            self.addAddress(data.address, data.address_type, data.html);
          }
          self.checkSelectedAddress();
          self.updateDeliveryCosts();
        }
      });
    },
    checkSelectedAddress: function () {
      if ($('input[name="simplyin-invoice-address"]:checked').length == 0) {
        $('input[name="simplyin-invoice-address"]:first').prop("checked", true);
      }
      if (
        $(".popup-address-checkbox .checkbox:checked") &&
        $('input[name="simplyin-delivery-address"]:checked').length == 0
      ) {
        $('input[name="simplyin-delivery-address"]:first').prop(
          "checked",
          true
        );
      }
    },
    upgradeAddress: function (address) {
      let address_element = $('div[data-id="' + address._id + '"]');
      let address_name = address.addressName;
      let address_line2 = address.street;
      if (address.appartmentNumber != "") {
        address_line2 = address.street + "/" + address.appartmentNumber;
      }
      address_line2 = address_line2 + ", " + address.city;
      address_element.find(".popup-address-label-line-1").html(address_name);
      address_element.find(".popup-address-label-line-2").html(address_line2);
    },
    addAddress: function (address, address_type, html) {
      let add_place = "";
      let new_form = $(html);
      let to_add = false;
      let address_name = "";
      if (address_type == "billingAddresses") {
        to_add = new_form.find(
          "#popup-invoice-address .popup-address-select-group:last"
        );
        add_place = $("#popup-invoice-address");
        address_name = 'input[name="simplyin-invoice-address"]:last';
      } else if (address_type == "shippingAddresses") {
        to_add = new_form.find(
          "#popup-delivery-address .popup-address-select:last"
        );
        add_place = $("#popup-delivery-address").find(
          ".popup-address-select-group"
        );
        address_name = 'input[name="simplyin-delivery-address"]:last';
        $('.popup-address-select-label-group input[type="checkbox"]')
          .prop("checked", false)
          .trigger("change");
      } else if (address_type == "parcelLockers") {
        to_add = false;
      }
      if (add_place.length && to_add !== false) {
        add_place.append(to_add);
        $(address_name).prop("checked", true);
      }
    },
    setNativeValue: function (element, value) {
      const prototype = Object.getPrototypeOf(element);
      const prototypeValueSetter = Object.getOwnPropertyDescriptor(
        prototype,
        "value"
      )?.set;

      if (prototypeValueSetter) {
        prototypeValueSetter.call(element, value);
        element.dispatchEvent(new Event("input", { bubbles: true }));
        element.dispatchEvent(new Event("change", { bubbles: true }));
      } else {
        element.value = value;
      }
    },
    updateField: function (addressField, elementId, data) {
      const self = this;

      if (addressField in data) {
        const element = document.getElementById(elementId);
        let addressFieldConverted;

        // Block checkout fields mapping
        switch (addressField) {
          case "billing-first_name":
            addressFieldConverted = "billing_first_name";
            break;
          case "last_name":
            addressFieldConverted = "billing_last_name";
            break;
          case "billing-city":
            addressFieldConverted = "billing_city";
            break;
          case "billing-company":
            addressFieldConverted = "billing_company";
            break;
          case "billing-postcode":
            addressFieldConverted = "billing_postcode";
            break;
          case "billing-address_1":
            addressFieldConverted = "billing_address_1";
            break;
          case "billing-address_2":
            addressFieldConverted = "billing_address_2";
            break;
          case "shipping-first_name":
            addressFieldConverted = "shipping_first_name";
            break;
          case "shipping-last_name":
            addressFieldConverted = "shipping_last_name";
            break;
          case "shipping-city":
            addressFieldConverted = "shipping_city";
            break;
          case "shipping-company":
            addressFieldConverted = "shipping_company";
            break;
          case "shipping-address_1":
            addressFieldConverted = "shipping_address_1";
            break;
          case "shipping-address_2":
            addressFieldConverted = "shipping_address_2";
            break;
          case "shipping-postcode":
            addressFieldConverted = "shipping_postcode";
            break;
          case "shipping-state":
            addressFieldConverted = "shipping_state";
            break;
          case "shipping-phone":
            addressFieldConverted = "shipping_phone";
            break;
          case "billing-phone":
            addressFieldConverted = "billing_phone";
            break;
          default:
            addressFieldConverted = addressField;
        }

        if (element) {
          try {
            if (isBlockCheckout) {
              self.setNativeValue(element, data[addressFieldConverted] || "");

              if (addressField == "postalCode") {
                setTimeout(() => {
                  self.setNativeValue(
                    element,
                    data[addressFieldConverted] || ""
                  );
                }, 100);
              }
            } else {
              element.value = data[addressFieldConverted] || "";
            }
          } catch (err) {
            console.log(err);
          }
        }
      }
    },
    updateShippingFields: function (shippingAddress, isBlockCheckout) {
      const self = this;
      if (isBlockCheckout) {
        self.updateField("name", "shipping-first_name", shippingAddress);
        self.updateField("surname", "shipping-last_name", shippingAddress);
        self.updateField("city", "shipping-city", shippingAddress);
        self.updateField("companyName", "shipping-company", shippingAddress);
        self.updateField("street", "shipping-address_1", shippingAddress);
        self.updateField(
          "appartmentNumber",
          "shipping-address_2",
          shippingAddress
        );
        self.updateField("postalCode", "shipping-postcode", shippingAddress);
      } else {
        self.updateField("name", "shipping_first_name", shippingAddress);
        self.updateField("surname", "shipping_last_name", shippingAddress);
        self.updateField("city", "shipping_city", shippingAddress);
        self.updateField("companyName", "shipping_company", shippingAddress);
        self.updateField("street", "shipping_address_1", shippingAddress);
        self.updateField(
          "appartmentNumber",
          "shipping_address_2",
          shippingAddress
        );
        self.updateField("postalCode", "shipping_postcode", shippingAddress);
      }
    },
    fillBillingData: function (userData, shopDefaultNipField) {
      const self = this;
      const address = userData?.invoice_address;
      const companyCheckbox =
        document.querySelector("[value='company' i]") ??
        document.querySelector("[value='firma' i]") ??
        null;

      const radioNodeList = companyCheckbox?.parentNode?.querySelectorAll(
        'input[type="radio"]'
      );
      const radioInputsArray = Array.from(radioNodeList ?? []);
      const filteredRadioInputs = radioInputsArray.filter(
        (input) => input !== companyCheckbox
      );

      const notFirma = document.getElementById(filteredRadioInputs[0]?.id);

      if (address?.taxId || address?.companyName) {
        if (companyCheckbox) {
          notFirma?.removeAttribute("checked");
          companyCheckbox?.setAttribute("checked", "checked");
          const changeEvent = new Event("change", { bubbles: true });
          companyCheckbox?.dispatchEvent(changeEvent);
        }
      } else {
        companyCheckbox?.removeAttribute("checked");
        notFirma?.setAttribute("checked", "checked");
        const changeEvent = new Event("change", { bubbles: true });
        notFirma?.dispatchEvent(changeEvent);
      }

      if ("taxId" in address) {
        const billing_tax_id_simply =
          shopDefaultNipField ??
          document.getElementById("billing_tax_id_simply");
        if (billing_tax_id_simply) {
          try {
            billing_tax_id_simply.value = address.taxId || "";
            if (isBlockCheckout) {
              const checkoutTaxIdField = document.querySelector(
                ".wc-block-components-address-form__simplyin-billing_tax_id_simply input"
              );
              self.setNativeValue(checkoutTaxIdField, address.taxId || "");
            }
          } catch (err) {
            console.log(err);
          }
        }
      }

      if (isBlockCheckout) {
        self.updateField("name", "billing-first_name", address);
        self.updateField("surname", "billing-last_name", address);
        self.updateField("city", "billing-city", address);
        self.updateField("postalCode", "billing-postcode", address);
        self.updateField("street", "billing-address_1", address);
        self.updateField("appartmentNumber", "billing-address_2", address);
      } else {
        self.updateField("name", "billing_first_name", address);
        self.updateField("surname", "billing_last_name", address);
        self.updateField("city", "billing_city", address);
        self.updateField("appartmentNumber", "billing_address_2", address);
        self.updateField("companyName", "billing_company", address);
        self.updateField("postalCode", "billing_postcode", address);
      }

      if (isBlockCheckout) {
        const countrySelect = document.getElementById("billing-country");
        if (countrySelect) {
          self.setNativeValue(countrySelect, address.country || "");
        }
      } else {
        try {
          if ("country" in address) {
            const savedCountryCode = address.country;
            const countrySelect = document.getElementById("billing_country");
            const countrySpan = document.getElementById(
              "select2-billing_country-container"
            );

            if (countrySelect?.options) {
              for (let i = 0; i < countrySelect?.options.length; i++) {
                if (countrySelect?.options[i].value === savedCountryCode) {
                  countrySelect.selectedIndex = i;

                  if (countrySpan?.innerText) {
                    countrySpan.innerText =
                      countrySelect?.options[i].innerText || "";
                  }

                  const changeEvent = new Event("change", {
                    bubbles: true,
                  });
                  countrySelect.dispatchEvent(changeEvent);
                  break;
                }
              }
            }
          }
        } catch (err) {
          console.log(err);
        }
      }

      if ("street" in address) {
        const billing_address_1 = document.getElementById("billing_address_1");
        if (billing_address_1) {
          try {
            billing_address_1.value = `${address.street} ${
              address.streetNumber ? address.streetNumber : ""
            }`;
          } catch (err) {
            console.log(err);
          }
        }
      }

      if ("state" in address) {
        const stateElement = document.getElementById("billing_state");

        if (stateElement?.nodeName) {
          const stateElementType = stateElement?.nodeName;

          if (
            stateElementType === "INPUT" &&
            stateElement instanceof HTMLInputElement
          ) {
            stateElement.value = address.state;
          } else if (
            stateElementType === "SELECT" &&
            stateElement instanceof HTMLSelectElement
          ) {
            const stateSpan = document.getElementById(
              "select2-billing_state-container"
            );
            for (let i = 0; i < stateElement.options.length; i++) {
              if (stateElement.options[i].value === address.state) {
                stateElement.selectedIndex = i;
                if (stateSpan?.innerText) {
                  stateSpan.innerText = stateElement.options[i].innerText || "";
                }
                break;
              }
            }
          }
        }
      }
    },
    fillShippingData: function (userData, fillWithBilling = false) {
      const self = this;
      const checkbox = document.getElementById(
        "ship-to-different-address-checkbox"
      );

      const shippingAddress = fillWithBilling
        ? userData?.invoice_address
        : userData?.delivery_address;

      if (!shippingAddress && !Object.keys(shippingAddress || []).length) {
        return;
      }

      if (fillWithBilling) {
        try {
          if (checkbox) {
            checkbox.checked = false;
            const changeEvent = new Event("change", { bubbles: true });
            checkbox.dispatchEvent(changeEvent);
          }
        } catch (err) {
          console.log(err);
        }
      }

      self.updateShippingFields(shippingAddress, isBlockCheckout);

      if (isBlockCheckout) {
        const countrySelect = document.getElementById("shipping-country");
        if (countrySelect) {
          self.setNativeValue(countrySelect, shippingAddress.country || "");
        }
      } else {
        try {
          if ("country" in shippingAddress) {
            const savedCountryCode = shippingAddress.country || "";
            const countrySelect = document.getElementById("shipping_country");
            const countrySpan = document.getElementById(
              "select2-shipping_country-container"
            );

            if (countrySelect?.options) {
              for (let i = 0; i < countrySelect.options.length; i++) {
                if (countrySelect.options[i].value === savedCountryCode) {
                  countrySelect.selectedIndex = i;

                  if (countrySpan?.innerText) {
                    countrySpan.innerText =
                      countrySelect.options[i].innerText || "";
                  }
                  const changeEvent = new Event("change", {
                    bubbles: true,
                  });
                  countrySelect.dispatchEvent(changeEvent);
                  break;
                }
              }
            }
          }
        } catch (err) {
          console.log(err);
        }
      }

      if (fillWithBilling) {
        return;
      }

      try {
        if (checkbox) {
          checkbox.checked = true;
          const changeEvent = new Event("change", { bubbles: true });
          checkbox.dispatchEvent(changeEvent);
        }
      } catch (err) {
        console.log(err);
      }
      document.querySelector(".shipping_address")?.removeAttribute("style");
    },

    insertFormData: function (userData, init = false) {
      const self = this;

      const shopDefaultNipField = document.querySelector(
        '[placeholder*="nip" i]:not([id="billing_tax_id_simply" i], [id*="nip" i]:not([id="billing_tax_id_simply" i]'
      );

      if (userData?.invoice_address?._id && !isBlockCheckout) {
        const billingIdField = document.getElementById("simply_billing_id");
        if (billingIdField) {
          billingIdField.value = userData?.invoice_address?._id || "";
        }
      }

      if (userData?.invoice_address?._id && isBlockCheckout) {
        const checkoutBillingIdField = document.querySelector(
          ".wc-block-components-address-form__simplyin-simply_billing_id input"
        );

        try {
          if (checkoutBillingIdField) {
            self.setNativeValue(
              checkoutBillingIdField,
              userData?.invoice_address?._id
            );
          }
        } catch (err) {
          console.log(err);
        }
      }

      if (userData?.delivery_address?._id && !isBlockCheckout) {
        const shippingIdField = document.getElementById("simply_shipping_id");
        if (shippingIdField) {
          shippingIdField.value = userData?.delivery_address?._id || "";
        }
      }

      if (userData?.delivery_address?._id && isBlockCheckout) {
        const checkoutShippingIdField = document.querySelector(
          ".wc-block-components-address-form__simplyin-simply_shipping_id input"
        );

        try {
          if (checkoutShippingIdField) {
            self.setNativeValue(
              checkoutShippingIdField,
              userData?.delivery_address?._id
            );
          }
        } catch (err) {
          console.log(err);
        }
      }

      if (!Object.keys(userData).length) {
        return;
      }

      if (isBlockCheckout) {
        const billingCheckbox = document.querySelector(
          ".wc-block-checkout__use-address-for-billing input[type='checkbox']"
        );
        if (billingCheckbox && billingCheckbox.checked) {
          billingCheckbox.click();
        }
      }

      if (userData?.phone_number && !isBlockCheckout) {
        const billingPhone = document.getElementById("billing_phone");
        try {
          if (billingPhone) {
            billingPhone.value = userData.phone_number;
          }
        } catch (err) {
          console.log(err);
        }
      }

      if (userData?.phone_number && isBlockCheckout) {
        const billingPhone = document.querySelector("#billing-phone");
        const shippingPhone = document.querySelector("#shipping-phone");

        try {
          if (billingPhone) {
            self.setNativeValue(billingPhone, userData.phone_number);
          }
          if (shippingPhone) {
            self.setNativeValue(shippingPhone, userData.phone_number);
          }
        } catch (err) {
          console.log(err);
        }
      }

      if (userData?.invoice_address) {
        self.fillBillingData(userData, shopDefaultNipField);
      }

      if (userData?.delivery_address === null) {
        const checkbox = isBlockCheckout
          ? document.querySelector(
              ".wc-block-checkout__use-address-for-billing input"
            )
          : document.getElementById("ship-to-different-address-checkbox");

        if (checkbox?.checked && !isBlockCheckout) {
          checkbox?.click();
        } else {
          if (userData?.invoice_address) {
            self.fillShippingData(userData, true);
          }
        }
      }

      if (userData?.delivery_address) {
        self.fillShippingData(userData);

        if (!init) {
          self.selectCourier();
        }
      }

      if (
        (userData?.invoice_address && !userData?.delivery_address) ||
        userData?.invoice_address._id === userData?.delivery_address._id
      ) {
        if (isBlockCheckout) {
          const billingCheckbox = document.querySelector(
            ".wc-block-checkout__use-address-for-billing input[type='checkbox']"
          );
          if (billingCheckbox && !billingCheckbox.checked) {
            billingCheckbox.click();
          }
        } else {
          const checkbox = document.getElementById(
            "ship-to-different-address-checkbox"
          );
          if (checkbox && checkbox.checked) {
            checkbox.click();
          }
        }
      }

      if (userData?.parcel_address) {
        self.selectParcelLocker(userData.parcel_address);
      }
    },
    selectAddress: function () {
      const self = this;
      let invoice_address = $(
        'input[name="simplyin-invoice-address"]:checked'
      ).data("id");
      let delivery_address = "";
      let selected_point = "";
      let service_type = "";
      const checkoutDeliveryCheckbox = document.querySelector(
        "#ship-to-different-address-checkbox"
      );
      if (
        $('.simplyin-delivery-type[type="radio"]:checked').val() == "address"
      ) {
        if (
          $('.popup-address-checkbox input[type="checkbox"]').is(":checked")
        ) {
          delivery_address = $(
            'input[name="simplyin-invoice-address"]:checked'
          ).data("id");

          if (checkoutDeliveryCheckbox && checkoutDeliveryCheckbox.checked) {
            checkoutDeliveryCheckbox.click();
          }
        } else {
          delivery_address = $(
            'input[name="simplyin-delivery-address"]:checked'
          ).data("id");

          if (checkoutDeliveryCheckbox && !checkoutDeliveryCheckbox.checked) {
            checkoutDeliveryCheckbox.click();
          }
        }
      } else {
        if ($('input[name="simplyin-parcel-locker-selected"]:checked').length) {
          service_type = "parcel";
          selected_point = $(
            'input[name="simplyin-parcel-locker-selected"]:checked'
          ).data("id");
        } else if (
          $('input[name="simplyin-delivery-point-selected"]:checked').length
        ) {
          service_type = "delivery";
          selected_point = $(
            'input[name="simplyin-delivery-point-selected"]:checked'
          ).data("id");
        }
      }

      if (service_type === "parcel" || service_type === "delivery") {
        delivery_address = "";
      }

      let params = {
        action: "simplyin_select_address",
        ajax: 1,
        ajax_token: simplyin.ajax_token,
        invoice_address: invoice_address,
        service_type: service_type,
        delivery_address: delivery_address,
        selected_point: selected_point,
      };

      $.ajax({
        url: this.ajax,
        method: "POST",
        data: params,
        dataType: "json",
      }).done((data) => {
        if (data) {
          const popup = $(".simplyin-popup-box");
          popup
            .find('input[type="checkbox"], input[type="radio"]')
            .each(function () {
              this.checked
                ? $(this).attr("checked", "checked")
                : $(this).removeAttr("checked");
            });
          popup
            .find('input:not([type="checkbox"]):not([type="radio"]), textarea')
            .each(function () {
              $(this).attr("value", this.value);
            });
          popup.find("select option").each(function () {
            this.selected
              ? $(this).attr("selected", "selected")
              : $(this).removeAttr("selected");
          });
          this.last_popup = popup.html();
          self.hidePopup();

          let response = data;

          if (
            response.service_type === "parcel" ||
            response.service_type === "delivery"
          ) {
            response = {
              ...data,
              delivery_address: null,
            };
          }

          self.insertFormData(response);
        }
      });
    },
    submitEmail: function (logout) {
      this.last_popup = "";
      const self = this;
      if (this.is_login == false || logout) {
        this.is_login = false;
        var email = this.customer_email;
        if (!this.isValidEmailAddress(email)) {
          return;
        }

        var params = {
          action: "simplyin_submit_email",
          ajax: 1,
          ajax_token: simplyin.ajax_token,
          email: email,
          logout: logout,
        };

        $.ajax({
          url: self.ajax,
          method: "POST",
          data: params,
          dataType: "json",
        }).done((data) => {
          if (data.success && data.show_popup) {
            self.userUsedPushNotifications = data.userUsedPushNotifications;
            self.showPopupByContent(data.html);
            self.focusOnCode();
            self.showIcon();
            if (data.userUsedPushNotifications) {
              self.checkPushNotification();
            } else {
              self.codeStartCounting();
            }
          }

          if (data.error == "NOT_FOUND") {
            self.hideIcon();
          }

          if (data.error == "UNAUTHORIZED") {
            self.is_login = false;
            self.submitEmail(false);

            setTimeout(() => {
              window.location.href = window.location.href;
            }, 1000);
          }

          if (isBlockCheckout) {
            document
              .querySelector(".wc-block-components-address-form__email")
              .classList.add("simplyin-display-flex");
          }
        });
      }
    },
    showLastPopup: function () {
      if (
        this.customer_email == "" &&
        simplyin.customer.logged == true &&
        typeof simplyin.customer.email != "undefined"
      ) {
        this.customer_email = simplyin.customer.email;
        this.submitEmail(false);
      }
      if (this.is_login) {
        if (this.last_popup) {
          this.showPopupByContent(this.last_popup);
        }
      } else {
        this.submitEmail(false);
      }

      this.filterAvailableProvidersInPopup();
    },
    filterAvailableProvidersInPopup: function () {
      const self = this;
      const availableProviders = self.filterAvailableProviders();
      const parcelLockers = $(self.popup).find("#simplyin-parcel-lockers");
      const deliveryPoints = $(self.popup).find("#simplyin-delivery-points");

      if (!availableProviders) {
        return;
      }

      let visibleParcelLockers = 0;
      let visibleDeliveryPoints = 0;

      parcelLockers.find(".popup-address-select").each(function () {
        const elProvider = $(this).data("provider");
        const providerMapping = availableProviders.find((provider) =>
          provider.includes(elProvider)
        );

        if (!providerMapping) {
          $(this).css("display", "none");
        } else {
          $(this).css("display", "");
          visibleParcelLockers++;
        }
      });

      deliveryPoints.find(".popup-address-select").each(function () {
        const elProvider = $(this).data("provider");
        const providerMapping = availableProviders.find((provider) =>
          provider.includes(elProvider)
        );

        if (!providerMapping) {
          $(this).css("display", "none");
        } else {
          $(this).css("display", "");
          visibleDeliveryPoints++;
        }
      });

      parcelLockers.find(".simplyin-no-data-message").remove();
      deliveryPoints.find(".simplyin-no-data-message").remove();

      if (visibleParcelLockers === 0) {
        const noDataMessage = `
          <div class="simplyin-no-data-message">
            <p>${simplyin.labels.no_parcel_lockers}</p>
          </div>
        `;
        parcelLockers.append(noDataMessage);
      }

      if (visibleDeliveryPoints === 0) {
        const noDataMessage = `
          <div class="simplyin-no-data-message">
            <p>${simplyin.labels.no_delivery_points}</p>
          </div>
        `;
        deliveryPoints.append(noDataMessage);
      }

      self.checkAndHideParcelLockerSection();
    },
    checkAndHideParcelLockerSection: function () {
      const parcelLockerSection = $(".popup-address-select-parcel-locker");

      if (parcelLockerSection.length === 0) {
        return;
      }

      const availableProviders = this.getCookie("simply_available_providers");

      if (
        availableProviders &&
        Array.isArray(availableProviders) &&
        availableProviders.length > 0
      ) {
        const hasOtherProviders = availableProviders.some(
          (provider) => provider !== "door_delivery"
        );
        if (hasOtherProviders) {
          parcelLockerSection.css("display", "");
          return;
        }
      }

      const parcelLockers = $("#simplyin-parcel-lockers");
      const deliveryPoints = $("#simplyin-delivery-points");

      let visibleParcelLockers = 0;
      let visibleDeliveryPoints = 0;

      if (parcelLockers.length > 0) {
        const lockerElements = parcelLockers.find(".popup-address-select");
        if (lockerElements.length === 0) {
          visibleParcelLockers = 0;
        } else {
          lockerElements.each(function () {
            if ($(this).css("display") !== "none") {
              visibleParcelLockers++;
            }
          });
        }
      }

      if (deliveryPoints.length > 0) {
        const pointElements = deliveryPoints.find(".popup-address-select");
        if (pointElements.length === 0) {
          visibleDeliveryPoints = 0;
        } else {
          pointElements.each(function () {
            if ($(this).css("display") !== "none") {
              visibleDeliveryPoints++;
            }
          });
        }
      }

      if (visibleParcelLockers === 0 && visibleDeliveryPoints === 0) {
        parcelLockerSection.css("display", "none");
      } else {
        parcelLockerSection.css("display", "");
      }
    },
    showPopupByContent: function (content) {
      let contentHtml = content;
      const availableDeliveryMethods = this.getCookie(
        "simply_available_delivery"
      );

      if (
        availableDeliveryMethods !== null &&
        availableDeliveryMethods.length === 0
      ) {
        contentHtml = contentHtml.replace(
          `class="popup-address-label-header to-hide-1"`,
          `class="popup-address-label-header to-hide-1" style="display: none;"`
        );

        contentHtml = contentHtml.replace(
          `class="popup-address-label-header to-hide-2"`,
          `class="popup-address-label-header to-hide-2" style="display: none;"`
        );

        contentHtml = contentHtml.replace(
          `class="popup-address-label-header to-hide-3"`,
          `class="popup-address-label-header to-hide-3" style="display: none;"`
        );

        contentHtml = contentHtml.replace(
          `class="popup-address-selector popup-type-delivery-selector"`,
          `class="popup-address-selector popup-type-delivery-selector" style="display: none;"`
        );

        contentHtml = contentHtml.replace(
          `class="popup-delivery-address-box"`,
          `class="popup-delivery-address-box" style="display: none;"`
        );

        contentHtml = contentHtml.replace(
          `class="popup-delivery-parcel-locker-box"`,
          `class="popup-delivery-parcel-locker-box" style="display: none;"`
        );
      } else {
        this.last_popup = contentHtml;
      }

      if ($(".simplyin-popup-box").length === 0) {
        this.popup = $("<div>")
          .addClass("simplyin-popup-box")
          .appendTo("body")[0];
      } else {
        this.popup = document.querySelector(".simplyin-popup-box");
      }
      $(".simplyin-popup-box").html(contentHtml);
      setTimeout(() => {
        $(".simplyin-popup-box").addClass("visible");
      }, 100);
    },
    showPopupByType: function (type, other_params = {}) {
      const self = this;
      var params = {
        action: "simplyin_get_form",
        type: type,
        ajax: 1,
        ajax_token: simplyin.ajax_token,
      };
      var form_data = new FormData();
      $.each(params, function (key, value) {
        form_data.append(key, value);
      });
      $.each(other_params, function (key, value) {
        form_data.append(key, value);
      });
      $.ajax({
        url: self.ajax,
        method: "POST",
        data: form_data,
        processData: false,
        contentType: false,
        dataType: "json",
      }).done((data) => {
        if (data.success) {
          self.showPopupByContent(data.html);
        } else if (data.error == "Session expired") {
          self.is_login = false;
          self.submitEmail(false);
        }
      });
    },
    hidePopup: function () {
      const self = this;
      var $popup = $(".simplyin-popup-box");
      if ($popup.length) {
        $popup.removeClass("visible");
        setTimeout(() => {
          $popup.remove();
          if (self.on_close_refresh_page) {
            window.location.reload();
          }
        }, 300);
      }
    },
    sendSmsCode: function () {
      const self = this;
      var params = {
        action: "simplyin_send_sms_code",
        ajax: 1,
        ajax_token: simplyin.ajax_token,
        email: this.customer_email,
      };

      $.ajax({
        url: self.ajax,
        method: "POST",
        data: params,
        dataType: "json",
      }).done((data) => {
        if (data.success) {
          self.showPopupByContent(data.html);
          self.codeStartCounting();
          self.focusOnCode();
        }
      });
    },
    sendEmailCode: function () {
      const self = this;
      var params = {
        action: "simplyin_send_email_code",
        ajax: 1,
        ajax_token: simplyin.ajax_token,
        email: this.customer_email,
      };

      $.ajax({
        url: self.ajax,
        method: "POST",
        data: params,
        dataType: "json",
      }).done((data) => {
        if (data.success) {
          self.showPopupByContent(data.html);
          self.codeStartCounting();
          self.focusOnCode();
        }
      });
    },
    showCardSaveCheckbox: function () {
      const cardNameExists = document.querySelector("#card-name");
      if (!cardNameExists) {
        const firstFormGroup = document.querySelector(
          ".simplyin-add-card-iframe .form-group"
        );

        if (firstFormGroup) {
          const wrapper = document.querySelector(
            ".simplyin-payment-methods-wrapper"
          );
          const cardName = wrapper
            ? wrapper.dataset.cardName || "Nazwa karty"
            : "Nazwa karty";
          const cardNamePlaceholder = wrapper
            ? wrapper.dataset.cardNamePlaceholder || "Moja karta"
            : "Moja karta";

          const cardNameHtml = `
            <div class="form-group card-name-group card-name-group-hidden">
              <label for="card-name">${cardName}</label>
              <input type="text" 
                  id="card-name" 
                  name="card-name"
                  class="card-input"
                  placeholder="${cardNamePlaceholder}" />
            </div>
          `;

          firstFormGroup.insertAdjacentHTML("beforebegin", cardNameHtml);
        }
      }

      const isExists = document.querySelector(
        ".simplyin-add-card-iframe .simplyin-card-save-checkbox"
      );

      if (isExists) {
        return;
      }

      const saveCardLabel = document.querySelector(
        ".simplyin-payment-methods-wrapper"
      ).dataset.saveCard;

      const el = `
        <div class="simplyin-card-save-checkbox">
          <input type="checkbox" name="simplyin_card_save_visible" id="simplyin_card_save_visible" />
          <label for="simplyin_card_save_visible">${saveCardLabel}</label>
        </div>
      `;

      const saveCardForm = document.querySelector(
        ".simplyin-add-card-iframe .form-row"
      );

      if (saveCardForm) {
        saveCardForm.insertAdjacentHTML("afterend", el);
      }
    },
    removeNewAccountCheckbox: function () {
      const newAccountEl = $("#simplyin-phone-checkbox");
      this.changeStateBlockCheckoutSaveCheckbox(false);
      newAccountEl.remove();
      this.changeSubmitButtonState(false);
    },
    validatePinCode: function () {
      const self = window.SimplyIn;
      if (self.validate_code_sended) {
        return;
      }
      if (self.validate_code_timeout) {
        clearTimeout(self.validate_code_timeout);
      }
      self.validate_code_timeout = setTimeout(() => {
        var selector = '#simplyin-input-code input[type="text"]';
        var code = "";
        $(selector).each(function () {
          code += this.value;
        });

        if (code.length == 4) {
          self.validate_code_sended = true;
          var params = {
            action: "simplyin_check_code",
            ajax: 1,
            ajax_token: simplyin.ajax_token,
            email: SimplyIn.customer_email,
            code: code,
          };

          if (code == self.last_code) {
            self.validate_code_sended = false;
            return;
          }

          $.ajax({
            url: self.ajax,
            method: "POST",
            data: params,
            dataType: "json",
          }).done((data) => {
            self.validate_code_sended = false;
            if (data.isCodeValid == false) {
              $(".simplyin-popup-content .code-error-message").show();
              $(".simplyin-popup-content .code-error-message").text(
                simplyin.labels.code_invalid
              );
              $(selector).addClass("invalid").removeClass("valid");
            } else if (data.code == "TOO_MANY_REQUESTS") {
              $(".simplyin-popup-content .code-error-message").show();
              var message = data.message.split("\n");
              if (message.length > 1) {
                self.startCountingMessage(message);
              } else {
                $(".simplyin-popup-content .code-error-message").html(
                  message[0]
                );
              }
            } else if (data.success) {
              self.stopCounting();
              if (self.is_login_page) {
                window.location.reload();
              } else {
                if (data?.invoice_address?._id) {
                  self.insertFormData(
                    {
                      ...data,
                      delivery_address: data.invoice_address,
                    },
                    true
                  );
                }
                self.showPopupByContent(data.html);
                self.removeNewAccountCheckbox();

                if (!data?.invoice_address?._id) {
                  self.filterAvailableProvidersInPopup();
                }
                self.updateDeliveryCosts();
              }
              if (isBlockCheckout) {
                try {
                  self.getBlocksPaymentMethods();
                } catch (error) {
                  console.error("Failed to get payment methods:", error);
                }
              }
              self.loginCustomer(self.customer_email);
              if (data.login_result.is_guest) {
                $("#field-firstname").val(data.login_result.firstname);
                $("#field-lastname").val(data.login_result.lastname);
                self.selectCheckbox();
              } else {
                self.on_close_refresh_page = true;
              }
            }
          });
        } else {
          $(".simplyin-popup-content .code-error-message").hide();
          $(selector).addClass("valid").removeClass("invalid");
        }
      }, 300);
    },
    isValidEmailAddress: function (email) {
      var pattern =
        /^(?!\.)(?!.*\.\.)([a-z0-9_'+\-\.]*)[a-z0-9_+-]@([a-z0-9][a-z0-9\-]*\.)+[a-z]{2,}$/i;
      return pattern.test(email);
    },
    codeStartCounting: function () {
      const self = this;
      var buttons_selector = ".simplyin-popup-footer .buttons";
      var time_selector = ".simplyin-popup-footer .time";
      var send_messages_selector = ".simplyin-popup-footer .sent-messages";
      if (this.counting_interval) {
        clearInterval(this.counting_interval);
      }
      this.counting_value = 30;
      $(buttons_selector).hide();
      $(send_messages_selector).show();
      this.counting_interval = setInterval(() => {
        this.counting_value--;
        if (this.counting_value <= 0) {
          clearInterval(this.counting_interval);
          this.counting_value = 0;
          $(buttons_selector).show();
          $(send_messages_selector).hide();
        }
        $(time_selector).text(self.formatTime(this.counting_value));
      }, 1000);
    },
    stopPushNotifications: function () {
      if (this.push_notification_interval) {
        clearInterval(this.push_notification_interval);
        this.push_notification_interval = false;
      }
      if (this.push_notification_controller) {
        this.push_notification_controller.abort();
        this.push_notification_controller = null;
      }
    },
    stopCounting: function () {
      if (this.counting_interval) {
        clearInterval(this.counting_interval);
        this.counting_interval = false;
      }
    },
    checkPushNotification: function () {
      const self = this;
      if (this.push_notification_interval) {
        clearInterval(this.push_notification_interval);
      }

      if (this.push_notification_controller) {
        this.push_notification_controller.abort();
      }

      this.push_notification_controller = new AbortController();

      let i = 0;
      let isRequestInProgress = false;

      const makeRequest = () => {
        if (i++ > 60) {
          self.stopPushNotifications();
          return;
        }

        if (isRequestInProgress) {
          return;
        }

        isRequestInProgress = true;

        var params = {
          action: "simplyin_check_push_notification",
          ajax: 1,
          ajax_token: simplyin.ajax_token,
          email: this.customer_email,
        };

        fetch(self.ajax, {
          method: "POST",
          headers: {
            "Content-Type": "application/x-www-form-urlencoded",
          },
          body: new URLSearchParams(params),
          signal: self.push_notification_controller.signal,
        })
          .then((response) => response.json())
          .then((data) => {
            isRequestInProgress = false;
            if (data.success) {
              self.push_notification_controller.abort();
              self.stopPushNotifications();
              self.loginCustomer(this.customer_email);
              if (this.is_login_page) {
                window.location.reload();
              } else {
                if (data?.invoice_address?._id) {
                  self.insertFormData(
                    {
                      ...data,
                      delivery_address: data.invoice_address,
                    },
                    true
                  );
                }
                self.showPopupByContent(data.html);
                self.removeNewAccountCheckbox();

                if (!data?.invoice_address?._id) {
                  self.filterAvailableProvidersInPopup();
                }
                self.updateDeliveryCosts();

                if (isBlockCheckout) {
                  try {
                    self.getBlocksPaymentMethods();
                  } catch (error) {
                    console.error("Failed to get payment methods:", error);
                  }
                }
              }
              if (data.login_result.is_guest) {
                $("#field-firstname").val(data.login_result.firstname);
                $("#field-lastname").val(data.login_result.lastname);
              }
            }
          })
          .catch((error) => {
            isRequestInProgress = false;
            if (error.name !== "AbortError") {
              console.error("Push notification request failed:", error);
            }
          });
      };

      this.push_notification_interval = setInterval(makeRequest, 1000);
    },
    startCountingMessage: function (message) {
      const self = this;
      if (this.counting_message_interval) {
        clearInterval(this.counting_message_interval);
      }
      this.counting_value_message = parseInt(message[1]);
      var message_selector = ".simplyin-popup-content .code-error-message";
      $(message_selector).html(
        message[0] + "<br />" + self.formatTime(this.counting_value_message)
      );
      this.counting_message_interval = setInterval(() => {
        this.counting_value_message--;
        if (this.counting_value_message <= 0) {
          clearInterval(this.counting_message_interval);
          this.counting_value_message = 0;
          $(message_selector).html("");
          $(message_selector).hide();
        }
        $(message_selector).html(
          message[0] + "<br />" + self.formatTime(this.counting_value_message)
        );
      }, 1000);
    },
    formatTime: function (seconds) {
      if (seconds < 10) {
        return "00:0" + seconds.toString();
      } else {
        return "00:" + seconds.toString();
      }
    },
    loginCustomer: function (email) {
      this.customer_email = email;
      this.is_login = true;
    },
    storeDeliveryPopup: function () {
      const self = this;
      self.delivery_popup = $(".simplyin-popup-box").html();
      self.delivery_popup_scroll = $(".simplyin-popup").scrollTop();
    },
    retrieveDeliveryPopup: function () {
      const self = this;
      if (self.delivery_popup) {
        self.showPopupByContent(self.delivery_popup);
        if ($(".simplyin-popup").length && self.delivery_popup_scroll) {
          $(".simplyin-popup").scrollTop(self.delivery_popup_scroll);
        }
      }
    },
    editAddress: function (id) {
      const self = this;
      self.storeDeliveryPopup();
      var params = {
        action: "simplyin_edit_address",
        ajax: 1,
        ajax_token: simplyin.ajax_token,
        id: id,
      };

      $.ajax({
        url: self.ajax,
        method: "POST",
        data: params,
        dataType: "json",
      }).done((data) => {
        if (data.success) {
          self.showPopupByContent(data.html);
        }
      });
    },
    insertPhoneNumber: async function () {
      const billingPhoneField = isBlockCheckout
        ? document.querySelector("#billing-phone")
        : document.querySelector("#billing_phone");

      const simplyInPhoneField = document.querySelector(
        "#simplyin-phone-input"
      );

      if (simplyInPhoneField && billingPhoneField) {
        simplyInPhoneField.value = billingPhoneField.value;
      }
    },
    confirmationPopup: function (title, message, callback) {
      const self = this;
      const $overlay = $(
        '<div class="simplyin-popup-overlay-confirmation"><div>'
      );
      const $popup = $(`
              <div class="simplyin-confirmation-popup">
                  <div class="simplyin-popup-header-confirmation">
                      <span class="simplyin-title">
                          ${title}
                      </span>
                      <div class="simplyin-popup-close-button-confirmation">
                          <img width="20" height="21"
                               src="${simplyin.files_url}/public/img/close_icon.svg"
                               alt=""
                               class="simplyin-close">
                      </div>
                  </div>
                  <div class="simplyin-message">
                      ${message}
                  </div>
                  <div class="simplyin-actions">
                      <button type="button"
                              class="simplyin-btn simplyin-btn-secondary">
                          ${simplyin.labels.cancel}
                      </button>
                      <button type="button"
                              class="simplyin-btn simplyin-btn-danger">
                          ${simplyin.labels.delete}
                      </button>
                  </div>
              </div>
          `);

      $("body").append($popup);
      $("body").append($overlay);
      const closePopup = () => {
        $popup.remove();
        $overlay.remove();
        $(document).off("keydown.simplyinConfirm");
      };
      $overlay.on("click", function () {
        closePopup();
      });

      $(document).on("keydown.simplyinConfirm", function (e) {
        if (e.key === "Escape") {
          closePopup();
        } else if (e.key === "Enter") {
          closePopup();
          if ($.isFunction(callback)) callback();
        }
      });

      $popup
        .on("click", ".simplyin-popup-close-button-confirmation", closePopup)
        .on("click", ".simplyin-btn-secondary", closePopup)
        .on("click", ".simplyin-btn-danger", function () {
          closePopup();
          if ($.isFunction(callback)) callback();
        });
    },
    logout: function () {
      self.is_login = false;
      const self = this;
      var params = {
        action: "logout",
        ajax: 1,
        ajax_token: simplyin.ajax_token,
      };

      $.ajax({
        url: self.ajax,
        method: "POST",
        data: params,
        dataType: "json",
      }).done((data) => {
        self.hidePopup();
      });
    },
    hideIcon: function () {
      $(".simplyin-show-popup").hide();
    },
    showIcon: function () {
      $(".simplyin-show-popup").show();
    },
    focusOnCode: function () {
      if ($('#simplyin-input-code input[type="text"]:first').length) {
        $('#simplyin-input-code input[type="text"]:first').focus();
      }
    },

    placeOrder: function () {
      $.ajax({
        url: SimplyIn.ajax,
        method: "POST",
        data: {
          action: "placeOrder",
          ajax: 1,
          ajax_token: simplyin.ajax_token,
          order_token: simplyin.order.order_token,
          id_cart: simplyin.order.id_cart,
        },
        dataType: "json",
      }).done((data) => {
        if (data.success) {
          // window.location.reload();
        }
      });
    },
    loadPhoneCountries: function () {
      const self = this;
      $.getJSON(
        simplyin.files_url + "public/widget/json/phones.json",
        function (data) {
          self.phones = data;
        }
      );
    },
    validatePhoneNumber: function () {
      const self = this;
      const phoneInput = $("#simplyin-phone-checkbox .phone-input input");

      if (!phoneInput?.length) {
        return;
      }

      const phoneNumberRaw = phoneInput.val().replace(/\D/g, "");

      const prefix = $("#simplyin-phone-checkbox #simplyin-phone-country")
        .find("option:selected")
        .data("prefix");

      const country = self?.phones?.find((c) => c.country_code === prefix);

      const isEmpty = phoneNumberRaw.length === 0;

      const isValidLength = country.phone_number_lengths.includes(
        phoneNumberRaw.length
      );

      const isMobile = country.mobile_begin_with.some((start) =>
        phoneNumberRaw.startsWith(start)
      );

      const isChecked = $(
        "#simplyin-phone-checkbox #simply-save-checkbox"
      ).prop("checked");

      const fullNumber = prefix + phoneNumberRaw;

      let formatted = "";
      if (isMobile) {
        formatted = phoneNumberRaw.replace(/(\d{3})(\d{3})(\d{3})/, "$1 $2 $3");
      } else {
        formatted = phoneNumberRaw.replace(
          /(\d{2})(\d{3})(\d{2})(\d{2})/,
          "$1 $2 $3 $4"
        );
      }

      $(phoneInput).val(formatted);

      if (!isValidLength || !country || !isMobile) {
        if (isEmpty) {
          self.showValidateWarningMessage("empty");
        } else {
          self.showValidateWarningMessage("invalid");
        }
        self.confirmationButtonEnable(false);

        if (isChecked) {
          self.changeSubmitButtonState(true);
        }

        return false;
      }

      self.hideValidateWarningMessage();
      self.confirmationButtonEnable(true);
      self.changeSubmitButtonState(false);
      self.validateSimplyInPayments();
      return true;
    },
    validateSimplyInPayments: function () {
      const self = this;

      const isSimplyInMainSelected = window.SimplyinIsMainPaymentMethodSelected
        ? window.SimplyinIsMainPaymentMethodSelected()
        : false;

      if (isSimplyInMainSelected) {
        const selectedPaymentMethod = window.SimplyinGetSelectedPaymentMethod
          ? window.SimplyinGetSelectedPaymentMethod()
          : null;

        if (!selectedPaymentMethod) {
          self.hideValidateWarningMessage();
          self.confirmationButtonEnable(true);
          self.changeSubmitButtonState(true);
          return false;
        }

        const isBlikValid = window.SimplyinValidateBlikCode
          ? window.SimplyinValidateBlikCode()
          : true;

        if (!isBlikValid) {
          self.hideValidateWarningMessage();
          self.confirmationButtonEnable(true);
          self.changeSubmitButtonState(true);
          return false;
        }
      }
    },
    changeSubmitButtonState: function (isChecked) {
      const submitBtn = isBlockCheckout
        ? document.querySelector(
            ".wc-block-components-checkout-place-order-button"
          )
        : document.querySelector("#place_order");

      submitBtn.disabled = isChecked;
    },
    showValidateWarningMessage: function (type) {
      $("#simplyin-phone-checkbox .phone-input-warning").show();
      if (type === "empty") {
        $("#simplyin-phone-checkbox .phone-input-warning").html(
          $("#simplyin-phone-checkbox .phone-input-warning").data("empty")
        );
      } else if (type === "invalid") {
        $("#simplyin-phone-checkbox .phone-input-warning").html(
          $("#simplyin-phone-checkbox .phone-input-warning").data("invalid")
        );
      }
    },
    hideValidateWarningMessage: function () {
      $("#simplyin-phone-checkbox .phone-input-warning").hide();
    },
    confirmationButtonEnable: function (enable) {
      const button = document.querySelector("#payment-confirmation button");
      if (enable) {
        button?.removeAttribute("disabled");
        button?.classList.remove("disabled");
      } else {
        button?.setAttribute("disabled", "disabled");
        button?.classList.add("disabled");
      }
    },
    getNewAccountForm: async function () {
      const isExists = document.querySelector("#simplyin-phone-checkbox");

      if (isExists) {
        return;
      }

      const self = this;
      var params = {
        action: "simplyin_get_new_account_form",
        ajax: 1,
        ajax_token: simplyin.ajax_token,
      };

      return new Promise((resolve, reject) => {
        $.ajax({
          url: self.ajax,
          method: "POST",
          data: params,
          dataType: "json",
        })
          .done((data) => {
            if (data.success) {
              const phoneAppInputField = $("#phoneAppInputField_field");

              if (phoneAppInputField) {
                phoneAppInputField.remove();
              }

              let phoneContainer = isBlockCheckout
                ? $(
                    "form.wc-block-components-form.wc-block-checkout__form .wc-block-checkout__terms"
                  )
                : $("#payment");

              const phoneAppContainer = $(data.html)[0];
              const referenceNode = isBlockCheckout
                ? phoneContainer[0]
                : phoneContainer[0].childNodes[1];

              if (referenceNode) {
                referenceNode.after(phoneAppContainer);
              }

              const phoneFormEl = document.querySelector(
                "#simplyin-phone-checkbox"
              );

              if (!isBlockCheckout) {
                if (phoneFormEl) {
                  phoneFormEl.style.marginTop = "20px";
                }
              } else {
                phoneFormEl.style.marginBottom = "20px";
              }

              $(document).on(
                "change",
                "#simplyin-phone-checkbox #simply-save-checkbox",
                function () {
                  const handleSaveCheckboxChange = () => {
                    const isChecked = $(
                      "#simplyin-phone-checkbox #simply-save-checkbox"
                    ).prop("checked");

                    if (isChecked !== undefined) {
                      self.saveCheckboxState = isChecked;
                    }

                    if (isChecked) {
                      self.changeSubmitButtonState(true);
                      self.changeStateBlockCheckoutSaveCheckbox(true);
                      return;
                    }

                    self.changeSubmitButtonState(false);
                    self.changeStateBlockCheckoutSaveCheckbox(false);
                  };

                  handleSaveCheckboxChange();
                  self.validateSimplyInPayments();

                  $(document.body).one("updated_checkout", function () {
                    handleSaveCheckboxChange();
                    self.validateSimplyInPayments();
                  });
                }
              );

              const shouldBeChecked =
                typeof self.saveCheckboxState !== "undefined"
                  ? self.saveCheckboxState
                  : simplyin.save_checkbox !== "0";

              if (shouldBeChecked) {
                $("#simplyin-phone-checkbox #simply-save-checkbox").click();
                $("#simplyin-phone-checkbox .simplyin-phone-input").show();
                $("#simplyin-phone-checkbox .simplyin-terms").show();
                $("#simplyin-phone-checkbox .simplyin-checkbox-row").addClass(
                  "show"
                );
              }

              if (isBlockCheckout) {
                const blockCheckoutPhoneAppInputPrefix = document.querySelector(
                  ".wc-block-components-address-form__simplyin-phoneAppInputPrefix input"
                );

                const prefix = document.querySelector(
                  ".simplyin-phone-input span.prefix"
                ).textContent;

                if (blockCheckoutPhoneAppInputPrefix) {
                  self.setNativeValue(blockCheckoutPhoneAppInputPrefix, prefix);
                }
              }
            }

            resolve();
          })
          .fail(() => {
            reject();
          });
      });
    },
    initEventListenersNewAccount: async function () {
      const self = this;
      const billingPhoneField = isBlockCheckout
        ? "#billing-phone"
        : "#billing_phone";

      const shippingPhoneField = "#shipping-phone";
      const shippingCheckboxSelector =
        ".wc-block-checkout__shipping-fields input[type='checkbox'].wc-block-components-checkbox__input";

      await self.getNewAccountForm();
      if (self.phones === false) {
        self.loadPhoneCountries();
      }

      $(document).on(
        "change",
        "#conditions_to_approve[terms-and-conditions]",
        function () {
          self.validatePhoneNumber();
        }
      );

      $(document).on("updated_checkout", async function () {
        if (self.is_login) {
          self.removeNewAccountCheckbox();
          return;
        }
        await self.getNewAccountForm();

        await self.insertPhoneNumber();

        self.validatePhoneNumber();

        setTimeout(() => {
          self.checkAndHideParcelLockerSection();
        }, 100);
      });

      $(document).on("input", billingPhoneField, function () {
        if (self.is_login) {
          return;
        }

        const currentShippingCheckbox = document.querySelector(
          shippingCheckboxSelector
        );
        if (
          isBlockCheckout &&
          currentShippingCheckbox &&
          currentShippingCheckbox.checked
        ) {
          return;
        }

        const phoneValue = $(this).val();
        const digits = phoneValue.replace(/\D/g, "");
        const first9Digits = digits.substring(0, 9);

        $("#simplyin-phone-checkbox .phone-input input").val(first9Digits);
        self.validatePhoneNumber();

        if (isBlockCheckout) {
          const blockCheckoutPhoneAppInput = document.querySelector(
            ".wc-block-components-address-form__simplyin-phoneAppInputField input"
          );

          self.setNativeValue(blockCheckoutPhoneAppInput, phoneValue);
        }
      });

      if (isBlockCheckout) {
        $(document).on("input", shippingPhoneField, function () {
          if (self.is_login) {
            return;
          }

          const currentShippingCheckbox = document.querySelector(
            shippingCheckboxSelector
          );
          if (currentShippingCheckbox && !currentShippingCheckbox.checked) {
            return;
          }

          const phoneValue = $(this).val();
          const digits = phoneValue.replace(/\D/g, "");
          const first9Digits = digits.substring(0, 9);

          $("#simplyin-phone-checkbox .phone-input input").val(first9Digits);
          self.validatePhoneNumber();

          if (isBlockCheckout) {
            const blockCheckoutPhoneAppInput = document.querySelector(
              ".wc-block-components-address-form__simplyin-phoneAppInputField input"
            );

            self.setNativeValue(blockCheckoutPhoneAppInput, phoneValue);
          }
        });

        $(document).on("change", shippingCheckboxSelector, function () {
          if (self.is_login) {
            return;
          }

          if (!this.checked) {
            return;
          }

          const phoneValue = $(shippingPhoneField).val();
          const digits = phoneValue.replace(/\D/g, "");
          const first9Digits = digits.substring(0, 9);

          $("#simplyin-phone-checkbox .phone-input input").val(first9Digits);
          self.validatePhoneNumber();

          if (isBlockCheckout) {
            const blockCheckoutPhoneAppInput = document.querySelector(
              ".wc-block-components-address-form__simplyin-phoneAppInputField input"
            );

            self.setNativeValue(blockCheckoutPhoneAppInput, phoneValue);
          }
        });
      }

      $(document).on(
        "change",
        "#simplyin-phone-checkbox #simplyin-phone-country",
        function () {
          const flag = $(this).find("option:selected").data("flag");
          const prefix = $(this).find("option:selected").data("prefix");
          $(".simplyin-flag-display img").attr(
            "src",
            `https://purecatamphetamine.github.io/country-flag-icons/3x2/${flag}.svg`
          );
          $("#simplyin-phone-checkbox .prefix").html(prefix);
          $("#simplyin-phone-checkbox .phone-input input").focus();
          self.validatePhoneNumber();

          if (isBlockCheckout) {
            const blockCheckoutPhoneAppInputPrefix = document.querySelector(
              ".wc-block-components-address-form__simplyin-phoneAppInputPrefix input"
            );

            if (blockCheckoutPhoneAppInputPrefix) {
              blockCheckoutPhoneAppInputPrefix.value = prefix;
            }

            return;
          }

          const prefixInput = document.querySelector(
            "input[name='simplyin-phone-prefix']"
          );

          if (prefixInput) {
            prefixInput.value = prefix;
          }
        }
      );

      $(document).on(
        "click",
        "#simplyin-phone-checkbox .phone-input",
        function () {
          $("#simplyin-phone-checkbox .phone-input input").focus();
        }
      );

      $(document).on(
        "keypress",
        "#simplyin-phone-checkbox .phone-input input",
        function (e) {
          if (e.which < 48 || e.which > 57) {
            e.preventDefault();
          }
          if (e.which == 86 && e.ctrlKey) {
            e.preventDefault();
          }
        }
      );

      $(document).on(
        "input",
        "#simplyin-phone-checkbox .phone-input input",
        function (e) {
          $(this).val(
            $(this)
              .val()
              .replace(/[^\d\s]/g, "")
          );

          const phoneNumber = $(this)
            .val()
            .replace(/[^\d\s]/g, "");

          if (isBlockCheckout) {
            const blockCheckoutPhoneAppInput = document.querySelector(
              ".wc-block-components-address-form__simplyin-phoneAppInputField input"
            );

            self.setNativeValue(blockCheckoutPhoneAppInput, phoneNumber);
          }

          self.validatePhoneNumber();
        }
      );

      $(document).on(
        "change",
        "#simplyin-phone-checkbox #simply-save-checkbox",
        function () {
          if ($(this).is(":checked")) {
            $("#simplyin-phone-checkbox .simplyin-phone-input").show();
            $("#simplyin-phone-checkbox .simplyin-terms").show();
            $("#simplyin-phone-checkbox .simplyin-checkbox-row").addClass(
              "show"
            );
            if ($("#simplyin-phone-checkbox .phone-input input").val() == "") {
              self.confirmationButtonEnable(false);
            } else {
              self.validatePhoneNumber();
            }
          } else {
            $("#simplyin-phone-checkbox .simplyin-phone-input").hide();
            $("#simplyin-phone-checkbox .simplyin-terms").hide();
            $("#simplyin-phone-checkbox .simplyin-checkbox-row").removeClass(
              "show"
            );
            self.confirmationButtonEnable(true);
            self.hideValidateWarningMessage();
          }
        }
      );

      $(document).on("change", "#simply-save-checkbox", () => {
        for (let i = 100; i > 0; i -= 50) {
          setTimeout(() => {
            self.validatePhoneNumber();
          }, i);
        }
      });

      if (simplyin.save_checkbox !== "0") {
        $("#simplyin-phone-checkbox #simply-save-checkbox").prop(
          "checked",
          true
        );
      }

      $(document).on("input", "#simplyin-phone-input", (e) => {
        if (isBlockCheckout) {
          const blockCheckoutPhoneAppInput = document.querySelector(
            ".wc-block-components-address-form__simplyin-phoneAppInputField input"
          );

          const blockCheckoutPhoneAppInputPrefix = document.querySelector(
            ".wc-block-components-address-form__simplyin-phoneAppInputPrefix input"
          );

          if (blockCheckoutPhoneAppInput) {
            this.setNativeValue(blockCheckoutPhoneAppInput, e.target.value);
          }

          if (blockCheckoutPhoneAppInputPrefix) {
            const prefix = document.querySelector(
              ".simplyin-phone-input span.prefix"
            ).textContent;
            this.setNativeValue(blockCheckoutPhoneAppInputPrefix, prefix);
          }
          return;
        }

        const prefixInput = document.querySelector(
          "input[name='simplyin-phone-prefix']"
        );

        const prefix = document.querySelector(
          ".simplyin-phone-input span.prefix"
        ).textContent;

        if (prefixInput) {
          prefixInput.value = prefix;
        }
      });
    },
    checkoutUpdateListener: function () {
      const self = this;
      if (isBlockCheckout && window.wp && window.wp.data) {
        const { CHECKOUT_STORE_KEY } = window.wc.wcBlocksData;

        window.wp.data.subscribe(() => {
          const isProcessing = window.wp.data
            .select(CHECKOUT_STORE_KEY)
            .isProcessing();

          if (!isProcessing) {
            self.filterAvailableProvidersInPopup();
          }
        });
      } else {
        $(document.body).on("updated_checkout", function () {
          self.filterAvailableProvidersInPopup();
        });
      }
    },
    getCookie: function (name) {
      const value = `; ${document.cookie}`;
      const parts = value.split(`; ${name}=`);
      if (parts.length === 2) {
        const decoded = decodeURIComponent(
          parts.pop()?.split(";").shift() ?? ""
        );
        return JSON.parse(decoded);
      }
      return null;
    },
    deleteCookie: function (name) {
      const hostname = window.location.hostname;
      const path = "/";

      document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=${path};`;

      document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=${path}; domain=${hostname};`;

      if (hostname.includes(".")) {
        const rootDomain = "." + hostname.split(".").slice(-2).join(".");
        document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=${path}; domain=${rootDomain};`;
      }

      document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/;`;

      document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 GMT;`;
    },
    forceUpdateClassicCheckout: function () {
      const self = this;
      self.deleteCookie("simplyin_session");

      $(document.body).trigger("update_checkout");
    },
    getInpostPointData: async function (deliveryPointID) {
      try {
        const res = await fetch(
          `https://api-pl-points.easypack24.net/v1/points/${deliveryPointID}`
        );
        const pointData = await res.json();

        return pointData;
      } catch (error) {
        console.error("Error:", error);
        return false;
      }
    },
    selectInpostPoint: async function (deliveryPointID) {
      const self = this;
      let isFunctionCalled = false;
      const inpostPointData = await self.getInpostPointData(deliveryPointID);

      if (!inpostPointData.name) {
        return;
      }

      const selectShippingMethod = () => {
        const shippingMethod = self.getCookie("simply_shipping_mapping");
        const availableDevliveryMethods = self.getCookie(
          "simply_available_delivery"
        );

        const shippingElInfo =
          availableDevliveryMethods.inpost_parcel_locker[
            shippingMethod?.inpost_parcel_locker
          ];

        const shippingEl = document.querySelector(
          `input[value^="${shippingElInfo.methodId}:${shippingElInfo.instanceId}"]`
        );

        if (isBlockCheckout) {
          if (shippingEl) {
            shippingEl.click();
            setTimeout(() => {
              if (
                window.inpost_pl_select_point_callback_blocks &&
                typeof window.inpost_pl_select_point_callback_blocks ===
                  "function"
              )
                window.inpost_pl_select_point_callback_blocks(inpostPointData);
            }, 500);

            setTimeout(() => {
              if (
                window.inpost_pl_select_point_callback_blocks &&
                typeof window.inpost_pl_select_point_callback_blocks ===
                  "function"
              )
                window.inpost_pl_select_point_callback_blocks(inpostPointData);
            }, 1200);
          }

          return;
        }

        if (shippingEl) {
          const inpostLabel = shippingEl?.parentNode?.querySelector("label");

          inpostLabel?.click();
          const event = new Event("label", { bubbles: true });
          inpostLabel?.dispatchEvent(event);
        }
      };

      const completeInpostPointSelection = () => {
        if (
          window.inpost_pl_select_point_callback &&
          typeof window.inpost_pl_select_point_callback === "function"
        ) {
          window.inpost_pl_select_point_callback(inpostPointData);
        }

        if (
          window.inpost_pl_select_point_callback_js_mode &&
          typeof window.inpost_pl_select_point_callback_js_mode === "function"
        ) {
          window.inpost_pl_select_point_callback_js_mode(inpostPointData);
        }

        if (
          window.inpost_pl_select_point_callback_blocks &&
          typeof window.inpost_pl_select_point_callback_blocks === "function"
        ) {
          window.inpost_pl_select_point_callback_blocks(inpostPointData);
        }
      };

      const checkIfMethodSelectedAndRetry = () => {
        if (isBlockCheckout) return;

        const shippingMethod = self.getCookie("simply_shipping_mapping");
        const availableDevliveryMethods = self.getCookie(
          "simply_available_delivery"
        );

        const shippingElInfo =
          availableDevliveryMethods.inpost_parcel_locker[
            shippingMethod?.inpost_parcel_locker
          ];

        const shippingEl = document.querySelector(
          `input[value^="${shippingElInfo.methodId}:${shippingElInfo.instanceId}"]`
        );

        if (shippingEl && shippingEl.checked) {
          setTimeout(() => {
            completeInpostPointSelection();

            setTimeout(() => {
              const inpostPointField = document.querySelector(
                '#inpost_parcel_locker_id, [name*="inpost"], [id*="inpost"]'
              );
              if (
                !inpostPointField ||
                !inpostPointField.value ||
                inpostPointField.value !== deliveryPointID
              ) {
                completeInpostPointSelection();
              }
            }, 1000);
          }, 300);
        }
      };

      if (isBlockCheckout && window.wp && window.wp.data) {
        const { CHECKOUT_STORE_KEY } = window.wc.wcBlocksData;

        window.wp.data.subscribe(() => {
          const isProcessing = window.wp.data
            .select(CHECKOUT_STORE_KEY)
            .isProcessing();

          if (!isProcessing && !isFunctionCalled) {
            isFunctionCalled = true;

            setTimeout(() => {
              selectShippingMethod();

              setTimeout(() => {
                completeInpostPointSelection();
              }, 500);
            }, 500);
          }
        });
      } else {
        $(document.body).on("updated_checkout", function () {
          if (isFunctionCalled) {
            return;
          }
          isFunctionCalled = true;

          setTimeout(() => {
            selectShippingMethod();

            setTimeout(() => {
              completeInpostPointSelection();
              checkIfMethodSelectedAndRetry();
            }, 500);
          }, 500);
        });
      }

      selectShippingMethod();

      if (!isBlockCheckout) {
        setTimeout(() => {
          checkIfMethodSelectedAndRetry();
        }, 2000);
      }
    },
    selectCourier: function () {
      let isFunctionCalled = false;
      const self = this;

      const selectShippingMethod = () => {
        const shippingMethod = self.getCookie("simply_shipping_mapping");
        const availableDevliveryMethods = self.getCookie(
          "simply_available_delivery"
        );
        const shippingElInfo =
          availableDevliveryMethods.door_delivery[
            shippingMethod?.door_delivery
          ];

        const shippingEl = document.querySelector(
          `input[value^="${shippingElInfo.methodId}:${shippingElInfo.instanceId}"]`
        );

        if (isBlockCheckout) {
          if (shippingEl) {
            shippingEl.click();
          }
          return;
        }

        if (shippingEl) {
          const dpdLabel = shippingEl?.parentNode?.querySelector("label");
          dpdLabel?.click();
          const event = new Event("label", { bubbles: true });
          dpdLabel?.dispatchEvent(event);
        }
      };

      const executeSelection = async () => {
        if (isFunctionCalled) return;
        isFunctionCalled = true;

        selectShippingMethod();
      };

      if (isBlockCheckout && window.wp && window.wp.data) {
        const { CHECKOUT_STORE_KEY } = window.wc.wcBlocksData;

        window.wp.data.subscribe(() => {
          const isProcessing = window.wp.data
            .select(CHECKOUT_STORE_KEY)
            .isProcessing();

          if (!isProcessing) {
            executeSelection();
          }
        });
      } else {
        $(document.body).one("updated_checkout", () => {
          executeSelection();
        });
      }
    },
    selectDhlPoint: function (deliveryPointID) {
      const self = this;

      const selectShippingMethod = () => {
        const shippingMethod = self.getCookie("simply_shipping_mapping");
        const availableDevliveryMethods = self.getCookie(
          "simply_available_delivery"
        );
        const shippingElInfo =
          availableDevliveryMethods.dhl_parcelshop[
            shippingMethod?.dhl_parcelshop
          ];

        const shippingEl = document.querySelector(
          `input[value^="${shippingElInfo.methodId}:${shippingElInfo.instanceId}"]`
        );

        if (isBlockCheckout) {
          if (shippingEl) {
            shippingEl.click();
          }
          return;
        }

        if (shippingEl) {
          const dhlLabel = shippingEl?.parentNode?.querySelector("label");
          dhlLabel?.click();
        }
      };

      const waitForCheckoutUpdate = () => {
        return new Promise((resolve) => {
          let countUpdatedCheckout = 0;

          const actualHandler = () => {
            countUpdatedCheckout++;

            if (countUpdatedCheckout >= 1) {
              if (!isBlockCheckout) {
                $(document.body).off("updated_checkout", actualHandler);
              }
              countUpdatedCheckout = 0;
              resolve();
            }
          };

          if (!isBlockCheckout) {
            $(document.body).on("updated_checkout", actualHandler);
          }

          const isDhlExpanded = document.querySelector("#dhl_parcelshop");
          const isDhlBlockCheckoutExpanded = document.querySelector(
            ".wp-block-woocommerce-dhl-point-selection-block"
          );

          if (isDhlExpanded || isDhlBlockCheckoutExpanded) {
            setTimeout(() => {
              countUpdatedCheckout = 0;
              if (!isBlockCheckout) {
                $(document.body).off("updated_checkout", actualHandler);
              }
              resolve();
            }, 1500);
          }
        });
      };

      const completeDhlPointSelection = async () => {
        if (isBlockCheckout) {
          const input = document.querySelector(
            ".wc-block-components-combobox input[type='text'][id^='components-form-token-input-combobox-control-']"
          );

          const nativeInputValueSetter = Object.getOwnPropertyDescriptor(
            window.HTMLInputElement.prototype,
            "value"
          ).set;

          const pointData = await self.getDhlPointData(deliveryPointID);
          const pointDataString = `${pointData.city} ${pointData.zip}, ${pointData.street}`;

          nativeInputValueSetter.call(input, pointDataString);

          const event = new Event("input", { bubbles: true });
          input.dispatchEvent(event);

          input.click();

          const observer = new MutationObserver((mutations) => {
            mutations.forEach((mutation) => {
              if (mutation.type === "childList") {
                const suggestionsList = document.querySelector(
                  ".components-form-token-field__suggestions-list"
                );

                if (suggestionsList) {
                  const targetSuggestion = Array.from(
                    suggestionsList.querySelectorAll("li")
                  ).find((li) => {
                    const text = li.textContent || li.innerText || "";
                    return text.includes(pointDataString);
                  });

                  if (targetSuggestion) {
                    setTimeout(() => {
                      targetSuggestion.click();
                      observer.disconnect();
                    }, 100);
                  }
                }
              }
            });
          });

          observer.observe(document.body, {
            childList: true,
            subtree: true,
          });

          setTimeout(() => {
            observer.disconnect();
          }, 5000);
          return;
        }

        if (
          window.dhl_set_dhl_parcelshop &&
          typeof window.dhl_set_dhl_parcelshop === "function"
        ) {
          const pointData = await self.getDhlPointData(deliveryPointID);
          window.dhl_set_dhl_parcelshop(pointData);
        }
      };

      const executeSelection = async () => {
        selectShippingMethod();
        waitForCheckoutUpdate().then(() => {
          completeDhlPointSelection();
        });
      };

      if (isBlockCheckout) {
        executeSelection();
      } else {
        $(document.body).one("updated_checkout", () => {
          executeSelection();
        });
      }
    },
    getDhlPointData: async function (deliveryPointID) {
      try {
        const res = await fetch(
          `https://pos.bliskapaczka.pl/api/v1/pos/dhl/${deliveryPointID}`,
          {
            method: "GET",
            headers: {
              Accept: "application/json",
            },
          }
        );
        const pointData = await res.json();

        if (isBlockCheckout) {
          return {
            sap: deliveryPointID,
            zip: pointData.postalCode,
            city: pointData.city,
            street: pointData.street,
          };
        } else {
          return {
            sap: deliveryPointID,
            zip: pointData.postalCode,
            city: pointData.city,
          };
        }
      } catch (error) {
        console.error("Error:", error);
        return false;
      }
    },
    getApaczkaPointData: async function (deliveryPointID, providerName) {
      let convertedProviderName = "";
      let convertedDeliveryPointID = "";

      switch (providerName) {
        case "inpost":
          convertedProviderName = "INPOST";
          break;
        case "dpd":
          convertedProviderName = "DPD";
          break;
        case "dhl":
          convertedProviderName = "DHL";
          break;
        case "orlen":
          convertedProviderName = "RUCH";
          convertedDeliveryPointID = deliveryPointID.split("-")[1];
          break;
        case "ups":
          convertedProviderName = "UPS";
          break;
      }

      try {
        const res = await fetch(
          `https://pos.bliskapaczka.pl/api/v1/pos/${convertedProviderName}/${
            convertedDeliveryPointID || deliveryPointID
          }`,
          {
            method: "GET",
            headers: {
              Accept: "application/json",
            },
          }
        );
        const pointData = await res.json();

        return pointData;
      } catch (error) {
        console.error("Error:", error);
        return false;
      }
    },
    selectApaczkaPoint: function (deliveryPointID, providerName) {
      let isFunctionCalled = false;
      const self = this;

      const selectShippingMethod = () => {
        const shippingMethod = self.getCookie("simply_shipping_mapping");
        const availableDevliveryMethods = self.getCookie(
          "simply_available_delivery"
        );
        let shippingElInfo;

        switch (providerName) {
          case "inpost":
            shippingElInfo =
              availableDevliveryMethods.inpost_parcel_locker[
                shippingMethod?.inpost_parcel_locker
              ];
            break;
          case "dpd":
            shippingElInfo =
              availableDevliveryMethods.dpd_point[shippingMethod?.dpd_point];
            break;
          case "dhl":
            shippingElInfo =
              availableDevliveryMethods.dhl_parcelshop[
                shippingMethod?.dhl_parcelshop
              ];
            break;
          case "orlen":
            shippingElInfo =
              availableDevliveryMethods.orlen_parcel_locker[
                shippingMethod?.orlen_parcel_locker
              ];
            break;
          case "ups":
            shippingElInfo =
              availableDevliveryMethods.ups_access_point[
                shippingMethod?.ups_access_point
              ];
            break;
        }

        const shippingEl = document.querySelector(
          `input[value^="${shippingElInfo.methodId}:${shippingElInfo.instanceId}"]`
        );

        if (isBlockCheckout) {
          if (shippingEl) {
            shippingEl.click();
          }
          return;
        }

        if (shippingEl) {
          const dpdLabel = shippingEl?.parentNode?.querySelector("label");
          dpdLabel?.click();
          const event = new Event("label", { bubbles: true });
          dpdLabel?.dispatchEvent(event);
        }
      };

      const waitForCheckoutUpdate = () => {
        return new Promise((resolve) => {
          if (isBlockCheckout && window.wp && window.wp.data) {
            const { CHECKOUT_STORE_KEY } = window.wc.wcBlocksData;
            let isWaiting = false;

            const unsubscribe = window.wp.data.subscribe(() => {
              const isProcessing = window.wp.data
                .select(CHECKOUT_STORE_KEY)
                .isProcessing();

              if (isProcessing && !isWaiting) {
                isWaiting = true;
              } else if (!isProcessing && isWaiting) {
                unsubscribe();
                resolve();
              }
            });

            setTimeout(() => {
              unsubscribe();
              resolve();
            }, 2200);
          } else {
            const checkoutUpdateHandler = () => {
              $(document.body).off("updated_checkout", checkoutUpdateHandler);
              resolve();
            };

            $(document.body).one("updated_checkout", checkoutUpdateHandler);

            setTimeout(() => {
              $(document.body).off("updated_checkout", checkoutUpdateHandler);
              resolve();
            }, 2200);
          }
        });
      };

      const completeApaczkaPointSelection = async (providerName) => {
        const pointData = await self.getApaczkaPointData(
          deliveryPointID,
          providerName
        );

        if (
          !isBlockCheckout &&
          window.apaczka_mp_map_callback &&
          typeof window.apaczka_mp_map_callback === "function" &&
          !document.querySelector("#amp-delivery-point-desc")
        ) {
          window.apaczka_mp_map_callback(pointData);
        }

        if (
          !isBlockCheckout &&
          window.simplyin_apaczka_mp_map_callback &&
          typeof window.simplyin_apaczka_mp_map_callback === "function" &&
          document.querySelector("#amp-delivery-point-desc")
        ) {
          window.simplyin_apaczka_mp_map_callback(pointData);
        }

        if (
          isBlockCheckout &&
          window.simplyin_apaczka_mp_map_callback_blocks &&
          typeof window.simplyin_apaczka_mp_map_callback_blocks === "function"
        ) {
          window.simplyin_apaczka_mp_map_callback_blocks(pointData);
        }
      };

      const executeSelection = async () => {
        if (isFunctionCalled) return;
        isFunctionCalled = true;

        selectShippingMethod();
        await waitForCheckoutUpdate();
        await completeApaczkaPointSelection(providerName);

        setTimeout(async () => {
          await completeApaczkaPointSelection(providerName);
        }, 1500);
      };

      if (isBlockCheckout && window.wp && window.wp.data) {
        const { CHECKOUT_STORE_KEY } = window.wc.wcBlocksData;

        window.wp.data.subscribe(() => {
          const isProcessing = window.wp.data
            .select(CHECKOUT_STORE_KEY)
            .isProcessing();

          if (!isProcessing) {
            executeSelection();
          }
        });
      } else {
        $(document.body).one("updated_checkout", () => {
          executeSelection();
        });
      }
    },
    selectDpdPoint: function (deliveryPointID) {
      const self = this;

      const selectShippingMethod = () => {
        const shippingMethod = self.getCookie("simply_shipping_mapping");
        const availableDevliveryMethods = self.getCookie(
          "simply_available_delivery"
        );
        const shippingElInfo =
          availableDevliveryMethods.dpd_point[shippingMethod?.dpd_point];

        const shippingEl = document.querySelector(
          `input[value^="${shippingElInfo.methodId}:${shippingElInfo.instanceId}"]`
        );

        if (isBlockCheckout) {
          if (shippingEl) {
            shippingEl.click();
          }
          return;
        }

        if (shippingEl) {
          const dpdLabel = shippingEl?.parentNode?.querySelector("label");
          dpdLabel?.click();
        }
      };

      const waitForCheckoutUpdate = () => {
        return new Promise((resolve) => {
          let countUpdatedCheckout = 0;

          const actualHandler = () => {
            countUpdatedCheckout++;

            if (countUpdatedCheckout >= 1) {
              if (!isBlockCheckout) {
                $(document.body).off("updated_checkout", actualHandler);
              }
              countUpdatedCheckout = 0;
              resolve();
            }
          };

          if (!isBlockCheckout) {
            $(document.body).on("updated_checkout", actualHandler);
          }

          const isDpdExpanded = document.querySelector(
            "#dpd_pickup_point_id_field"
          );

          const isDpdBlockCheckoutExpanded = document.querySelector(
            ".wp-block-woocommerce-dpd-point-selection-block"
          );

          if (isDpdExpanded || isDpdBlockCheckoutExpanded) {
            setTimeout(() => {
              countUpdatedCheckout = 0;
              if (!isBlockCheckout) {
                $(document.body).off("updated_checkout", actualHandler);
              }
              resolve();
            }, 1500);
          }
        });
      };

      const completeDpdPointSelection = () => {
        if (isBlockCheckout) {
          const input = document.querySelector(
            ".wc-block-components-combobox input[type='text'][id^='components-form-token-input-combobox-control-']"
          );

          const nativeInputValueSetter = Object.getOwnPropertyDescriptor(
            window.HTMLInputElement.prototype,
            "value"
          ).set;

          nativeInputValueSetter.call(input, deliveryPointID);

          const event = new Event("input", { bubbles: true });
          input.dispatchEvent(event);

          input.click();

          const observer = new MutationObserver((mutations) => {
            mutations.forEach((mutation) => {
              if (mutation.type === "childList") {
                const suggestionsList = document.querySelector(
                  ".components-form-token-field__suggestions-list"
                );

                if (suggestionsList) {
                  const targetSuggestion = Array.from(
                    suggestionsList.querySelectorAll("li")
                  ).find((li) => {
                    const text = li.textContent || li.innerText || "";
                    return text.includes(deliveryPointID);
                  });

                  if (targetSuggestion) {
                    setTimeout(() => {
                      targetSuggestion.click();
                      observer.disconnect();
                    }, 100);
                  }
                }
              }
            });
          });

          observer.observe(document.body, {
            childList: true,
            subtree: true,
          });

          setTimeout(() => {
            observer.disconnect();
          }, 5000);
          return;
        }

        if (
          window.dpd_choosen_point &&
          typeof window.dpd_choosen_point === "function"
        ) {
          window.dpd_choosen_point(deliveryPointID);
        }
      };

      const executeSelection = async () => {
        selectShippingMethod();
        waitForCheckoutUpdate().then(() => {
          completeDpdPointSelection();
        });
      };

      if (isBlockCheckout) {
        executeSelection();
      } else {
        $(document.body).one("updated_checkout", () => {
          executeSelection();
        });
      }
    },
    submitEmailLogin: function (logout) {
      this.last_popup = "";
      const self = this;
      if (this.is_login == false || logout) {
        this.is_login = false;
        var email = this.customer_email;
        if (!this.isValidEmailAddress(email)) {
          return;
        }
        self.is_login_page = true;

        var params = {
          action: "simplyin_submit_email",
          login: 1,
          ajax: 1,
          ajax_token: simplyin.ajax_token,
          email: email,
          logout: logout,
        };

        $.ajax({
          url: self.ajax,
          method: "POST",
          data: params,
          dataType: "json",
        }).done((data) => {
          if (data.success && data.show_popup) {
            self.userUsedPushNotifications = data.userUsedPushNotifications;
            self.showPopupByContent(data.html);
            self.focusOnCode();
            self.showIconLogin();
            if (data.userUsedPushNotifications) {
              self.checkPushNotification();
            } else {
              self.codeStartCounting();
            }
          }

          if (data.error == "NOT_FOUND") {
            self.hideIconLogin();
          }

          if (data.error == "UNAUTHORIZED") {
            self.is_login = false;
            self.submitEmail(false);

            setTimeout(() => {
              window.location.href = window.location.href;
            }, 1000);
          }
        });
      }
    },
    hideIconLogin: function () {
      $(".simplyin-show-popup-login").hide();
    },
    showIconLogin: function () {
      $(".simplyin-show-popup-login").show();
    },
    filterAvailableProviders: function () {
      const self = this;
      const availableProviders = self.getCookie("simply_available_providers");
      const shippingMapping = self.getCookie("simply_shipping_mapping");

      if (!availableProviders) {
        return;
      }

      const filteredProviders = availableProviders.filter((provider) => {
        switch (provider) {
          case "inpost":
            return !(
              shippingMapping?.inpost_parcel_locker === "none" ||
              !shippingMapping?.inpost_parcel_locker
            );
          case "dpd":
            return !(
              shippingMapping?.dpd_point === "none" ||
              !shippingMapping?.dpd_point
            );
          case "dhl":
            return !(
              shippingMapping?.dhl_parcelshop === "none" ||
              !shippingMapping?.dhl_parcelshop
            );
          case "orlen":
            return !(
              shippingMapping?.orlen_parcel_locker === "none" ||
              !shippingMapping?.orlen_parcel_locker
            );
          case "ups":
            return !(
              shippingMapping?.ups_access_point === "none" ||
              !shippingMapping?.ups_access_point
            );
          default:
            return true;
        }
      });

      return filteredProviders;
    },
    selectCheckbox: function () {
      const self = this;
      if (self.select_customer_privacy) {
        if ($('input[name="customer_privacy"]').length) {
          $('input[name="customer_privacy"]').prop("checked", true);
        }
      }
      if (self.select_psgdpr) {
        if ($('input[name="psgdpr"]').length) {
          $('input[name="psgdpr"]').prop("checked", true);
        }
      }
      if (self.submit_guest_form) {
        $("#customer-form").find('button[type="submit"]').trigger("click");
      } else {
        return false;
      }
    },
    getShippingMethodPluginProviderName: function (providerName) {
      const availableDeliveryMethods = this.getCookie(
        "simply_available_delivery"
      );

      switch (providerName) {
        case "inpost":
          const inpostData = availableDeliveryMethods.inpost_parcel_locker;
          return Object.values(inpostData)[0]?.logisticPlugin;
        case "dpd":
          const dpdData = availableDeliveryMethods.dpd_point;
          return Object.values(dpdData)[0]?.logisticPlugin;
        case "dhl":
          const dhlData = availableDeliveryMethods.dhl_parcelshop;
          return Object.values(dhlData)[0]?.logisticPlugin;
        case "orlen":
          const orlenData = availableDeliveryMethods.orlen_parcel_locker;
          return Object.values(orlenData)[0]?.logisticPlugin;
        case "ups":
          const upsData = availableDeliveryMethods.ups_access_point;
          return Object.values(upsData)[0]?.logisticPlugin;
      }
    },
    selectParcelLocker: function (parcelData) {
      const self = this;

      if (!parcelData || !parcelData.lockerId) {
        return;
      }

      const providerName = parcelData.providerName || "inpost";
      const lockerId = parcelData.lockerId;
      const pluginProviderName =
        self.getShippingMethodPluginProviderName(providerName);

      switch (providerName) {
        case "inpost":
          if (pluginProviderName === "inpost-ilabs") {
            self.selectInpostPoint(lockerId);
          }

          if (pluginProviderName === "apaczka") {
            self.selectApaczkaPoint(lockerId, "inpost");
          }
          break;
        case "dpd":
          if (pluginProviderName === "wp-desk") {
            self.selectDpdPoint(lockerId);
          }

          if (pluginProviderName === "apaczka") {
            self.selectApaczkaPoint(lockerId, "dpd");
          }
          break;
        case "dhl":
          if (pluginProviderName === "wp-desk") {
            self.selectDhlPoint(lockerId);
          }

          if (pluginProviderName === "apaczka") {
            self.selectApaczkaPoint(lockerId, "dhl");
          }
          break;
        case "orlen":
          if (pluginProviderName === "apaczka") {
            self.selectApaczkaPoint(lockerId, "orlen");
          }
          break;
        case "ups":
          if (pluginProviderName === "apaczka") {
            self.selectApaczkaPoint(lockerId, "ups");
          }
          break;
        default:
          console.warn("Nieobsługiwany dostawca paczkomatów:", providerName);
          break;
      }
    },
    changeStateBlockCheckoutSaveCheckbox: function () {
      const checkoutBlockSaveCheckbox = document.querySelector(
        ".wc-block-components-address-form__simplyin-simply-save-checkbox input"
      );

      if (checkoutBlockSaveCheckbox) {
        checkoutBlockSaveCheckbox.click();
      }
    },
    createBlockCheckoutFields: function () {
      const checkoutForm = document.querySelector(
        "form.wc-block-components-form.wc-block-checkout__form"
      );

      const billingPhoneElement = document.querySelector(
        ".wc-block-components-text-input.wc-block-components-address-form__phone"
      );

      const taxIdField = document.createElement("input");
      taxIdField.id = "billing_tax_id_simply";
      taxIdField.type = "text";
      taxIdField.classList.add("form-row-wide");
      taxIdField.required = false;

      if (billingPhoneElement) {
        const taxIdContainer = document.createElement("div");
        taxIdContainer.className =
          "wc-block-components-text-input wc-block-components-address-form__tax-id is-active";

        if (billingPhoneElement.className) {
          taxIdContainer.className = billingPhoneElement.className.replace(
            "address-form__phone",
            "address-form__tax-id"
          );
        }

        const taxIdLabel = document.createElement("label");
        taxIdLabel.htmlFor = "billing_tax_id_simply";
        taxIdLabel.textContent = "NIP";
        taxIdContainer.appendChild(taxIdLabel);
        taxIdContainer.appendChild(taxIdField);

        if (billingPhoneElement.parentNode) {
          billingPhoneElement.parentNode.insertBefore(
            taxIdContainer,
            billingPhoneElement.nextSibling
          );
        }

        taxIdContainer.classList.add("is-active");
      } else {
        checkoutForm?.appendChild(taxIdField);
      }

      taxIdField.addEventListener("input", (e) => {
        const blockCheckoutTaxIdField = document.querySelector(
          ".wc-block-components-address-form__simplyin-billing_tax_id_simply input"
        );

        if (blockCheckoutTaxIdField) {
          this.setNativeValue(blockCheckoutTaxIdField, e.target.value);
        }
      });

      const checkoutBlockBillingTaxIdField = document.querySelector(
        ".wc-block-components-address-form__simplyin-billing_tax_id_simply input"
      );

      if (checkoutBlockBillingTaxIdField) {
        this.setNativeValue(checkoutBlockBillingTaxIdField, "");
      }
    },
    updateDeliveryCosts: function (retryCount = 0) {
      const self = this;
      const deliveryData = self.getCookie("simply_available_delivery");

      if (!deliveryData || Object.keys(deliveryData).length === 0) {
        if (retryCount >= 10) {
          return;
        }

        setTimeout(() => {
          self.updateDeliveryCosts(retryCount + 1);
        }, 300);
        return;
      }

      const providerMapping = {
        inpost: "inpost_parcel_locker",
        dpd: "dpd_point",
        dhl: "dhl_parcelshop",
        orlen: "orlen_parcel_locker",
        ups: "ups_access_point",
      };

      const deliveryTypeAddressElement = document.querySelector(
        "#simplyin-delivery-type-address"
      );

      if (deliveryTypeAddressElement) {
        deliveryTypeAddressElement.innerHTML = ` - ${
          Object.values(deliveryData.door_delivery)[0].cost
        }`;
      }

      const deliveryTypeParcelLockerElement = document.querySelector(
        "#simplyin-delivery-type-parcel-locker"
      );

      if (deliveryTypeParcelLockerElement) {
        const allParcelLockerCosts = [];

        Object.keys(providerMapping).forEach((provider) => {
          const deliveryKey = providerMapping[provider];
          const deliveryMethods = deliveryData[deliveryKey];

          if (deliveryMethods) {
            Object.values(deliveryMethods).forEach((method) => {
              if (method && method.cost) {
                const numericCost = parseFloat(
                  method.cost
                    .toString()
                    .replace(/[^\d.,]/g, "")
                    .replace(",", ".")
                );
                if (!isNaN(numericCost)) {
                  allParcelLockerCosts.push(numericCost);
                }
              }
            });
          }
        });

        const minCost = Math.min(...allParcelLockerCosts);
        const formatCost = minCost.toFixed(2).replace(".", ",");

        if (!deliveryTypeParcelLockerElement.textContent.includes(" - ")) {
          deliveryTypeParcelLockerElement.textContent += ` - ${window.simplyin.labels.from} ${formatCost} ${window.simplyin.currency}`;
        }
      }

      $("#popup-delivery-parcel-locker-address .popup-address-select").each(
        function () {
          const provider = $(this).data("provider");
          const costElement = $(this).find(".popup-cost");

          if (provider && providerMapping[provider]) {
            const deliveryKey = providerMapping[provider];
            const deliveryMethods = deliveryData[deliveryKey];

            if (deliveryMethods) {
              const firstMethod = Object.values(deliveryMethods)[0];
              if (firstMethod && firstMethod.cost) {
                costElement.html(firstMethod.cost);
              }
            }
          }
        }
      );
    },
  };

  window.SimplyIn.init();
});
