import { PaymentMethodData } from "../models/PaymentMethodData";
import { ChannelsFromServerFactory } from "./ChannelsFromServerFactory";

export class PaymentMethodDataFactory {
	public static create({
		title,
		description,
		icon_src,
		supports,
		place_order_button_label,
		channels,
		messages,
		adminAjaxUrl,
		nonce,
	}): PaymentMethodData {
		try {
			return {
				label: title,
				description: description,
				iconSrc: icon_src,
				placeOrderButtonLabel: place_order_button_label,
				supports: supports,
				channels:
					ChannelsFromServerFactory.createChannelsFromServer(
						channels,
					),
				messages,
				adminAjaxUrl,
				nonce,
			};
		} catch (Exception) {
			throw Exception("Create PaymentMethodData failed");
		}
	}
}
