import {ChannelsFromServer} from '../models/ChannelsFromServer'
import {ChannelFromServer} from "../models/ChannelFromServer";


export class ChannelsFromServerFactory {

	static readonly APPLE_PAY_CHANNEL_ID: number = 1513

	private static processItem({
								   simplyinPaymentOptionId,
								   value,
								   name,
								   label,
								   icon,
								   id,
								   block_description,
								   items,
								   data
							   }): ChannelFromServer {

		let channel: ChannelFromServer = {
			simplyinOptionId: simplyinPaymentOptionId,
			key: simplyinPaymentOptionId,
			value: value,
			name: name,
			label: label,
			icon: icon,
			description: block_description,
			items: [],
			data: data
		};

		if (items && items.length > 0) {
			for (const subItem of items) {
				channel.items.push(ChannelsFromServerFactory.processItem(subItem));
			}
		}

		return channel;
	}

	static createChannelsFromServer(list: any[]): ChannelsFromServer {
		let channels: ChannelsFromServer = {
			items: []
		}

		for (const item of list) {

			let channelValueObject: ChannelFromServer = ChannelsFromServerFactory.processItem(item)

			if (!this.validateItem(channelValueObject)) {
				continue
			}

			channels.items.push(channelValueObject);
		}

		return channels;
	}


	private static validateItem(channel: ChannelFromServer): boolean {

		if (channel.simplyinOptionId === this.APPLE_PAY_CHANNEL_ID && !this.isApplePay()) {
			return false
		}
		return true
	}

	private static isApplePay(): boolean {
		return window.ApplePaySession
	}
}
